
#ifndef _INET_ICMP
#define _INET_ICMP


#ifndef _INET_PKT
#include "pktdrv.h"
#endif

#ifndef _INET_IP
#include "ip.h"
#endif

#define MAXICMP	300
#define ECHO_TIMEOUT	6
								/* icmp_types */
#define ICMP_ECHOREP	0		/* ICMP Echo reply */
#define ICMP_DESTIN		3		/* Destination Unreachable */
#define ICMP_SOURCEQ	4		/* Source quench */
#define ICMP_REDIR		5		/* Redirect */
#define ICMP_ECHOREQ	8		/* ICMP Echo request */
#define ICMP_TIMEX		11		/* Time exceeded */
#define ICMP_PARAM		12		/* Parameter problem */
#define ICMP_TIMEREQ	13		/* Timestamp request */
#define ICMP_TIMEREP	14
#define ICMP_INFO		15		/* Information request */
#define ICMP_SUBNETREQ	17		/* subnet mask request */
#define ICMP_SUBNETREP	18		/* subnet mask reply   */


#define	ICMP_DSTNET		0		/* icmp codes */
#define	ICMP_DSTHOST	1
#define	ICMP_DSTPROT	2
#define	ICMP_DSTPORT	3
#define	ICMP_DSTFRAG	4
#define	ICMP_DSTSRC		5

#define REDIRTABLEN		10

struct redent
{
	INADDR	dst_inaddr;
	INADDR	gw_inaddr;
};

extern struct redent redtab[];

typedef struct
{
	u_char	type;				/* ICMP type field */
	u_char	code;				/* ICMP code field */
	u_short chksum;				/* checksum */
	u_short	part1;
	u_short part2;		/* depends on type and code */
}ICMP;



struct ping 
{				/* ICMP Echo request/reply header */
	u_char	ptype;
	u_char	pcode;
	u_short pchksum;
	u_short pid;
	u_short pseq;
};


#define	PGNOSND		0	/* Couldn't send pkt */
#define	PGTMO		1	/* timedout */
#define	PGBADDATA	2	/* rcved bad data back */
#define	PGWAITING	3	/* waiting for rcpt of packet */
#define	PGSUCCESS	4	/* success */


/* structure of an icmp destination unreachable packet */

struct destun  
{
	u_char	dtype;
	u_char	dcode;
	u_short dchksum;
	u_short dno1;
	u_short dno2;
	IP		dip;
	char	ddata[8];
};

/* structure of an icmp time exceeded packet */

struct timex  
{
	u_char	ttype;
	u_char	tcode;
	u_short tchksum;
	u_short tno1;
	u_short tno2;
	IP		tip;
	char	tdata[8];
};

/* structure of a timestamp reply */

struct tstamp 
{
	u_char	ttype;
	u_char	tcode;
	u_short txsum;
	u_short tid;
	u_short tseq;
	long	tstamp[3];
};

/* structure of an icmp redirect */

struct redirect
{
	u_char	rdtype;
	u_char	rdcode;
	u_short rdchksum;
	INADDR	rdgw;
	IP		rdip;
	char	rddata[8];
};

/* structure of netmask lookup */

struct netmask
{
	u_char	nmtype;
	u_char	nmcode;
	u_short nmchksum;
	u_short nmid;
	u_short	nmseq;
	INADDR	nmmask;
};


typedef struct
{
	ETH		et;
	IP		ip;
	ICMP	icmp;
	char	icmp_data[MAXICMP];
} ICMP_PACKET;

#define ICMP_PKTSIZE	(int)(sizeof(ETH)+sizeof(IP)+sizeof(ICMP))



int icmp_init(void);
int icmp_handler(PACKET *,int,INADDR);
int icmp_dstun(INADDR,IP *,int);
int icmp_ping(INADDR,int);

#endif
