/*     ANS compatible Telnet in AES windows     */
/*         compiled with TURBO-C/PURE-C         */
/*   P. Mayer & H. Wieser TU Vienna  6.3.1992   */

#ifndef NULL
#define NULL ((char *) 0)
#endif

#ifndef TRUE
#define TRUE 1
#define FALSE 0
#endif
#define SYSBASE ((SYSHDR*)0x4f2L)
/* constants */

#define ALTINDICATOR '\05'
#define MAXSCROLLED 8
#define WOFFSET 10
#define WI_WITHSLD (INFO|SIZER|UPARROW|DNARROW|VSLIDE|LFARROW|RTARROW|HSLIDE)
#define WI_WITHTITLE (INFO|NAME|MOVER|CLOSER|FULLER)
#define MAXCOL 132
#define MAXROW 99
#define MAXPARLEN 	80
#define MINMAX(x, y, z) ( x<y ? y : (x>z ? z :x) )

#define FM_INVERT 12			/* logic parameter to copy_fm */
#define FM_COPY   3			/* copy source to dest */
#define FM_CLEAR  0			/* zero dest */

#define X0 1			/* X border in bits around text in window */
#define Y0 1			/* Y border in bits around text in window */

/* emulation FSM states */

#define ESC		0x1b
#define RETURN		0x0d
#define CAN	    	0x18
#define ENQ		0x05
#define SI		0x0f
#define SO		0x0e

#define S_NORMAL	0
#define S_ESC		1
#define S_QUE		2
#define S_CSI		4
#define S_STATUS	5
#define S_NOP		6
#define S_NUM1		7
#define S_NUM2		8
#define S_CHS0		9
#define S_CHS1		10
#define S_ALIGN    	11

#define min(a,b) ( a < b ? a : b )
#define max(a,b) ( a > b ? a : b )

/* data types used */

typedef struct mfdb 
{
  short *ptr;			/* ptr to memory holding the image */
  short wpix;			/* width in pixels */
  short hpix;			/* height in pixels */
  short wwords;			/* width in words */
  short format;			/* 0 for machine-dependent */
  short planes;			/* 1 for hires screen */
} WIN_MFDB;

/*
 * Fonts are all byte-wide, 16 bits high.  Not all of that is actually
 * used, necessarily: when narrower, the less-significant bits are used.
 * When shorter, the top rows are used.  The fonts from UW are 128 chars
 * long, which is a lose for non-USAians.  The built-up system fonts
 * are 256 chars long.
 */

typedef struct fnt 
{
  int inc_x, inc_y;		/* real size of one char */
  int nchars;			/* number of chars in this font */
  char f_data[4096];		/* character data */
} FNT;

typedef struct wi_str 
{
  struct wi_str *prev, *next;	/* list links */
  int fd;			/* the pipe */
  int pid;			/* the PID & PG of the process started here */
  int aes_handle;		/* the AES hande number */

  unsigned int	sliders:1,		/* sliders? */
  		titles:1,		/* title bar? */
  		fulled:1,		/* fulled */
  		inverse:1,		/* inverse mode on */
  		insmode:1,		/* insert mode on */
  		curstate:1,		/* state of the cursor */
		cursor_hidden:1,	/* cursor enabled?*/
		discard:1,		/* wrap vs discard at last column */
		curskey:1,
		keypad:1,
		origmode:1,
        	colwidth:1,
        	smooth:1,
        	repeat:1,
        	lfmode:1;
  int fgbg[2];				/* text bg and fg (last arg to vrt_cpyfm) */
  int slotno;				/* shrunk slot number in the dock */
  int x, y, w, h;			/* work area on screen */
  int save_x, save_y;			/* saved cursor location for ESC j/k */
  int px, py, pw, ph;			/* previous location of entire window */
  int x_off, y_off;			/* offset for visible part */
  int px_off, py_off;			/* previous offset */
  int m_off;				/* memory offset */
  int wi_w, wi_h;			/* max w,h */
  int cur_x, cur_y;			/* current cursor position */
  int top_y;				/* position of top of circular window buffer */
  int state;				/* state for the emulation FSM */
  short vspos, vssiz;			/* pos & size of vertical slider */
  short hspos, hssiz;			/* ditto horiz (saves unnec. redraws) */
  FNT *font;				/* the font in use */
  WIN_MFDB wi_mf;			/* memory form for this window */
  char name[80];			/* name of this window */
  char info[80];			/* info line of this window */
/*  char nuname[80];*/			/* new name under construction */
/*  int nuptr;*/			/* curr. len of new name */
  int x_chrs, y_chrs;			/* size of terminal emulation */
  int wi_style;				/* style of window (see WI_*SLD) */
  int wi_mainstyle;			/* the style requested originally */
  int topline, bottomline;		/* margins for scrolling region */
  int markx1,marky1,markx2,marky2,lastx2,lasty2,direct;
  int app;
  int recv_flag;
  int ftp_data;
  unsigned char val1,val2,val[8],valcnt;
  char G0,G1,chset;
} WI_STR;

#define TN_SE		240
#define TN_NOP		241
#define TN_DM		242
#define TN_BRK		243
#define TN_IP		244
#define TN_AO		245
#define TN_AYT		246
#define TN_EC		247
#define TN_EL		248
#define TN_GA		249
#define TN_SB		250
#define TN_WILL		251
#define TN_WONT		252
#define TN_DO		253
#define TN_DONT		254
#define TN_IAC		255 
