#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <aes.h>
#include <tos.h>
#include <stdlib.h>
#include <ctype.h>
#include <time.h>
#include "tcpdef.h"

#define SYSBASE ((SYSHDR*)0x4f2L)

static BASPAG **oldpd;
long set_pd(void);
long restore_pd(void);

int connect(char * host, int tcp_id);
void output(char *);
void output1(int, char*);
void printfile(FILE *fin);
int get_response(void);

#define min(a,b) (((a) < (b)) ? (a) : (b))
#define INBUFSIZE 4096
#define TRUE 1
#define FALSE 0

#define FILE_BUF_SIZE      4096
#define noDEBUG

DESTI desti;
TCPSTAT tstat;

char *myid = "@(#)ANS-LPR 1.0 pm/hw";

char *term;
int tcp_buff = 1024;
char data[INBUFSIZE];

long number,timev;
char o_str[100];
int tcp_ok;
char file_buffer[FILE_BUF_SIZE];
char filename[50];
char printer[50];
char printhost[50];
char hostname[50];
char user[30];
int o_len;
long lendata;
long lensent;
char *term;
int tcp;
char response;
long filelength;
char * file_to_print;
FILE * fin;
static int error;

#define LPR_PORT    515

main(int argc, char *argv[])
{
char *arg;
long i;

 term = (char *)getenv("PRINTER");
 if(!term)
   strcpy(printer,"lp");
 else
   strcpy(printer,term);

 term = (char *)getenv("USER");
 if(!term)
   strcpy(user,"user@ST");
 else
   strcpy(user,term);

 term = (char *)getenv("HOSTNAME");
 if(!term)
   strcpy(hostname,"someST");
 else
   strcpy(hostname,term);
 strtok(hostname,".");      /* cut off domainname */

 term = (char *)getenv("PRINTHOST");
 if(!term)
   printhost[0]=0;
 else
   strcpy(printhost,term);

 while (argc > 1 && argv[1][0] == '-')
 {
     i = 1;  /* start on argument just past - sign */
      argc--;
       arg = *++argv;

        do switch(arg[i]) 
        {
     case 'S':
       if (arg[2]) /* get print server name */
    {
        strcpy(printhost,arg+2);
        i = strlen(printhost) + 1;
      }
      else if (argc > 1)
      {
        argc--;
        strcpy(printhost,*++argv);
      }
      break;

    case 'P':       /* specify printer name */
      if (arg[2])
      {
        strcpy(printer, &arg[2]);
        i = strlen(printer)+ 1;
      }
      else if (argc > 1)
      {
        argc--;
        strcpy(printer, *++argv);
      }
      break;
    }
    while(arg[++i]);

  }

 error = 0;
 while(argc > 1)
 {
   file_to_print = argv[1];
   fin = fopen(file_to_print, "rb");
   if(fin == NULL) 
   {
      printf("\r\n<\033pError: can't open file '%s'\033q>\r\n", file_to_print);
      error++;
   }
   else
   {
    printf("\r\nTrying print server %s, device %s, file %s ...\n",printhost,printer,file_to_print);
    timev = clock();
    number = (((timev >> 24) & 0xff) + ((timev >> 16) & 0xff))*15 +
          ((timev >> 10) );
  fseek(fin, 0L,SEEK_END);
  filelength = ftell(fin);
  fseek(fin, 0L, 0);
  lensent = 0;    
    if((tcp = connect(printhost,LPR_PORT)) > 0)
    {
    tcp_ok = TRUE;
      printfile(fin); 
      tcp_close(tcp);
  }
  else
  {
    printf("\r\n<\033pError: no response from %s\033q>\r\n",printhost);
    error++;
    tcp_ok = FALSE;
    }
    fclose(fin);
   }
   argv++;
   argc--;
 }
 if(error)
 {
  printf("\r\n<\033pCR\033q>\r\n");
  Cconin();
 }
 return(0);
}
/* open a connection and return tcp handle, 0 if error */

int connect(char * host, int port)
{
  int tcp_id, state;
  
  term = (char *)getenv("TCPWND");
  if(term) tcp_buff = atoi(term);

  desti.Port = port;

  if(GetIPAddr(host,desti.IPAddr))
  {
    unsigned int tmp1,tmp2,tmp3,tmp4;
    
    if(sscanf(host,"%d.%d.%d.%d",&tmp1,&tmp2,&tmp3,&tmp4) != 4)
    {
      printf("\r\n<\033pError: unknown host.\033q>\r\n");
      return 0;
    }
    desti.IPAddr[0] = tmp1;
    desti.IPAddr[1] = tmp2;
    desti.IPAddr[2] = tmp3;
    desti.IPAddr[3] = tmp4;
  }
  
  tcp_id = (unsigned)tcp_open(721+(int)(Random() % 10),&desti,AKTIV,60,(long)tcp_buff);

  if(tcp_id == 0)
  {
    printf("\r\n<\033pError: could not open connection.\033q>\r\n");
    return 0;
  }

  do
  {
    state = (int)tcp_stat(tcp_id,&tstat);
    if((state > ESTABLISHED) || (state <= CLOSED)) break;
  }
  while(state < ESTABLISHED);

  if(state != ESTABLISHED)
  {
    printf("\r\n<\033pError: connection refused.\033q>\r\n");
    return 0;
  }
  return(tcp_id);
}

void printfile(FILE *fin)
{
    /* connection is open, start the lprd protocol */
    sprintf(o_str, "\2%s\n",printer);
    output(o_str);
    if(get_response() > 1)
    {
       printf("%s",data);
    }
      if(response == '\1') 
      {
        printf("\r\n<\033pError: printer server didn't accept printer\033q>\r\n");
        tcp_ok = FALSE;
        return;
      }
      else if(response != '\0') 
      {
        tcp_ok = FALSE;
        return;
      }
      sprintf(filename, "fA%03ld%s",(number++) % 999,hostname);
                /* get file length */
      sprintf(o_str, "\3%ld d%s\n", filelength, filename);
#ifdef DEBUG
      printf("######### file %s %ld bytes \n",filename,filelength);
#endif
      output(o_str);
    if(get_response() > 1)
    {
       printf("%s",data);
    }
      if(response == '\1') 
      {
        printf("\r\n<\033pError: connection messed up, try again\033q>\r\n");
        tcp_ok = FALSE;
        return;
      }
      else if(response == '\2') 
      {
        printf("\r\n<\033pError: server out of storage space\033q>\r\n");
        tcp_ok = FALSE;
        return;
      }
      else if(response != '\0') 
      {
        tcp_ok = FALSE;
        return;
      }

      do
      {
      lendata = fread(file_buffer, 1, min((long)FILE_BUF_SIZE,filelength),fin);
#ifdef DEBUG
      printf("read %ld bytes\n",lendata);
#endif
      if(lendata <= 0)
      {
       file_buffer[0] = 0;
       output1(1,file_buffer);
      }
      if(lendata < 0)
      {
        return;
      }
      lensent += lendata;
      printf("\r%ld %%",(lensent * 100) / filelength);
      output1((int)lendata,file_buffer);
      }while(lendata > 0);      

    if(get_response() > 1)
    {
       printf("%s",data);
    }
      if(response != '\0') 
      {
        printf("\r\n<\033pError: data file not properly transferred, aborting\033q>\r\n");
        tcp_ok = FALSE;
        return;
      }
#ifdef DEBUG
      printf("file closed\n");
#endif
      /* build the control file */
      sprintf(file_buffer, "H%s\n",hostname);
      sprintf(file_buffer+strlen(file_buffer), "P%s\n", user);
      sprintf(file_buffer+strlen(file_buffer), "J%s\n", file_to_print);
      sprintf(file_buffer+strlen(file_buffer), "C%s\n", hostname);
      sprintf(file_buffer+strlen(file_buffer), "L%s\n", user);
      sprintf(file_buffer+strlen(file_buffer), "fd%s\n", filename);
      sprintf(file_buffer+strlen(file_buffer), "Ud%s\n", filename);
      sprintf(file_buffer+strlen(file_buffer), "N%s\n", file_to_print);
      sprintf(o_str, "\2%ld c%s\n", strlen(file_buffer), filename);
      output(o_str);
    if(get_response() > 1)
    {
       printf("%s",data);
    }
      if(response == '\1') 
      {
        printf("\r\n<\033pError: connection messed up, try again\033q>\r\n");
        tcp_ok = FALSE;
        return;
      }
      else if(response == '\2') 
      {
        printf("\r\n<\033pError: server out of storage space\033q>\r\n");
        tcp_ok = FALSE;
        return;
      }
      else if(response != '\0') 
      {
        tcp_ok = FALSE;
        return;
      }
      output1((int)strlen(file_buffer)+1,file_buffer);
    if(get_response() > 1)
    {
       printf("%s",data);
    }
      if(response != '\0') 
      {
        printf("\r\n<\033pError: control file not properly transferred, aborting\033q>\r\n");
        tcp_ok = FALSE;
        return;
      }
}

void output(char *o_str)
{
  int o_len;

    o_len = (int)strlen(o_str);
    output1(o_len, o_str);
}

void output1(int o_len, char *o_str)
{
  int i,j;
 
    for(i=0; i < o_len;)
  {
    j = (int)tcp_write(tcp,o_str+i,o_len-i,PUSH,NO_URGENT);
    if(j>=0) i += j;
    else
    {
      printf("connection broken\n");
      tcp_ok = FALSE;
      break;
    }
#ifdef DEBUG
printf("send %d bytes\n",j);
#endif
  }
}

int get_response(void)
{
  int length;

  do
  {
  length = (int)tcp_read(tcp,data,INBUFSIZE);
  } while(!length);
  if(length < 0) return length;
  response = data[0];
  return length;
}

long set_pd(void)
{
  oldpd = SYSBASE->_run;
  SYSBASE->_run = &_BasPag;
  return 0;
}

long restore_pd(void)
{
  SYSBASE->_run = oldpd;
  return 0;
}

