/********************************************************************/
/*																	*/
/*	Packet driver for D-LINK DE600 ethernet controller				*/
/*																	*/
/*	Copyleft by P. Mayer, 1993 TU-Vienna IAEE						*/
/*	All rights reserved												*/
/*																	*/
/********************************************************************/

#define LOCKMEM  0x1
#define LOCKALLO 0x2
#define LOCKFREE 0x4
#define LOCKMAIN 0x8
#define LOCKRES  0x10
#define LOCKREC  0x20
#define LOCKNET  0x40

#include <stdio.h>
#include <stddef.h>
#include <string.h>
#include <tos.h>
#include <time.h>
#include "nicmem.h"
#include "nicdrv.h"
#include "pktqueue.h"
#include "pktdrv.h"

#define noDEBUG
#define noDEBUGINTR
#define noDEBUGPKT
#define NORMAL

#define Bconws(x) dpy = x;while(*dpy)(Bconout(2,*dpy++))

char str[80];
char *dpy;

extern long dclock(void);

PKTBUF PPKT[MAXPKT];

PKTPOOL PPOOL;

extern char nic_locked;
extern procref old_intr;

int  retval;
int	 term = 0;
int good = 0;
et_hdr		header;
int mode;

#define CENBUSY_vectornum 64
#define SPUR_vectornum 24

void (*ihandler)(void) = NULL;
extern void dlink_200interrupt(void);
extern void dlink_interrupt(void);
extern void vbl_loop(void);
extern void nic_install(void);
extern long *old200;
extern long disablirq(void);
extern long enablirq(void);
extern long quitirq(void);
int resetNIC(void);  /* reset dlink, init datastructures  */

PKTPOOL			*p_free;  				/* queue of free packets */
u_short			freecnt;  				/* number of free packets */

PROTOCOL protos[MAXPROTOCOLS];  /* protocols to serve */
int protocols = 0;              /* number of active protocols */

et_stat stat;                   /* statistics block */

#define NIC_BASE 0xfa0201L

typedef unsigned char byte;

byte CurTxPage, Mode_RxPg;
int RxPktLen, RxStartAdd, TxStartAdd, CurRxPage, our_type;
byte our_address[6];
int last, LastTxStartAdd;

#define WRITE		(0x00 << 1)
#define READ		(0x01 << 1)
#define STATUS		(0x02 << 1)
#define COMMAND		(0x03 << 1)
#define NUL_CMD 	(0x0c << 1)
#define RX_LEN		(0x05 << 1)
#define TX_ADR		(0x06 << 1)
#define RW_ADR		(0x07 << 1)

#define WRITE_STROBE	(0x08 << 1)

#define RXEN		(0x08)
#define TXEN		(0x04)
#define LOOPBACK	(0x0c)
#define RX_NONE		(0x00)
#define RX_ALL		(0x01)
#define RX_BP		(0x02)
#define RX_MBP		(0x03)

#define RESET		(0x80)
#define STOP_RESET	(0x00)

#define RXBUSY		0x80
#define GOOD		0x40
#define RESET_FLAG	0x20
#define T16		    0x10
#define TXBUSY		0x08

#define BFRSIZ		2048
#define RUNT		60
#define EADDR_LEN	6
#define HA13		0x20
#define PAGE_0		0x00
#define PAGE_1		0x08
#define PAGE_2		0x10
#define PAGE_3		0x18

static int ix;
#define delay()    {ix = ix +9;} /* no delay needed for ST */
#define pause()
/* defines for access to DE600 */

#define WRITE_SUPER_FAST(value, cmd) \
	x = *(byte*)(base + (int)((((((int)value) << 5) & 0x1e0)) + cmd)); \
	x = *(byte*)(base + (int)((((((int)value) << 5) & 0x1e0)) + cmd)); \
	delay(); \
	x = *(byte*)(base + (int)((((((int)value) << 1) & 0x1e0) + ((cmd) ^ WRITE_STROBE)))); \
	x = *(byte*)(base + (int)((((((int)value) << 1) & 0x1e0) + ((cmd) ^ WRITE_STROBE)))); \

#define WRITE_S_FAST(value, cmd) \
	x = *(byte*)(base + (int)((((((int)value) << 5) & 0x1e0)) + cmd)); \
	delay(); \
	x = *(byte*)(base + (int)((((((int)value) << 1) & 0x1e0) + ((cmd) ^ WRITE_STROBE)))); \

#define READ_STAT \
	x = *(byte*)(base + (int)STATUS); \
	y = (*(byte*)(base + (int)NUL_CMD)/* & 0xf0*/)/* ^ 0x80*/; \

#define READ_STAT1 \
	x = *(byte*)(base + (int)NUL_CMD); \
	x = *(byte*)(base + (int)STATUS); \
	x = *(byte*)(base + (int)STATUS); \
	delay(); \
	y = (*(byte*)(base + (int)NUL_CMD) /*& 0xf0*/) /*^ 0x80*/; \
	y = (*(byte*)(base + (int)NUL_CMD) /*& 0xf0*/) /*^ 0x80*/; \

#define READ_STAT2 \
	x = *(byte*)(base + (int)STATUS + 0x200); \
/*	y = *(byte*)(base + (int)STATUS + 0x200); \*/

#define READ_SUB_FAST(cmd) \
	x = *(byte*)(base + (int)(cmd)); \
	delay(); \
	x = (*(byte*)(base + (int)(cmd))) /*& 0xf0*/; \
x >>= 4; \
	y = *(byte*)(base + (int)(cmd + WRITE_STROBE)); \
	delay(); \
	y = (((*(byte*)(base + (cmd | WRITE_STROBE)) /*& 0xf0*/)) | x); \
/*y ^= 0x88; */\

#define READ_FIRST(cmd) \
	x = *(byte*)(base + (int)(cmd)); \
	x = (((*(byte*)(base + (cmd | WRITE_STROBE)) /*& 0xf0*/))); \
x >>= 4; \

#define READ_LOOP(cmd) \
	y = (((*(byte*)(base + cmd) /*& 0xf0*/)) | x); \
/*    y ^= 0x88;*/ \
	x = (((*(byte*)(base + (cmd | WRITE_STROBE)) /*& 0xf0*/))); \
x >>= 4; \

#define READ_LAST(cmd) \
	y = (((*(byte*)(base + (cmd | WRITE_STROBE)) /*& 0xf0*/)) | x); \
/*    y ^= 0x88; \*/

int rcv_pkt(void)
{
}

int rcv_check(void)
{
}

int copyEAD()
{
  register byte *base = (byte*)NIC_BASE;
  register byte x,y;
  int i;
  
  WRITE_SUPER_FAST(0,RW_ADR);
  WRITE_SUPER_FAST(HA13,RW_ADR);
  
  for(i = 0; i < EADDR_LEN;i++) 
  {
    READ_SUB_FAST(READ);
    our_address[i] = y;
  }
  if(   our_address[0] == 0x00 
  && our_address[1] == 0xde 
  && our_address[2] == 0x15)
  {
    our_address[1] = 0x80;
    our_address[2] = 0xc8;
    
    /* our_address[3] &= 0x0f;
    our_address[3] |= 0x70; */
  }
  else
  {
    printf("\nDE600 could not get ethernet address!!\n");
    return -1;
  }
  
  WRITE_SUPER_FAST(0,RW_ADR);
  WRITE_SUPER_FAST(HA13,RW_ADR);
  
  for(i = 0;i < EADDR_LEN;i++) 
  {
    WRITE_SUPER_FAST(our_address[i],WRITE);
  }
  x++;
  printf("\nDE600 ethernet address got.\n");
  return 0;
}

/***************************************************
test for de600 ethernetadapter on cartridge port
***************************************************/

int Check_DE600()
{
  register byte *base = (byte*)NIC_BASE;
  register byte x,y;
  
  x = *(byte*)(base + NUL_CMD);
  x = *(byte*)(base + NUL_CMD);
  delay();
  WRITE_S_FAST(RESET,COMMAND);
  delay();
  WRITE_S_FAST(STOP_RESET,COMMAND);
  delay();
  READ_STAT1;
  x++; 	
  if(y == 0)
  {
   printf("\nDE600 detected.\n");
   return 0;
  }
  else
  {
    printf("\nDE600 not detected!! (status = %x)\n",y&0xff);
    return -1;
  }
}

int test_mem()
{
  register byte *base = (byte*)NIC_BASE;
  register byte x,y;
  register int i;
  
  nic_locked |= LOCKMEM;
  
  WRITE_SUPER_FAST(0,RW_ADR);
  WRITE_SUPER_FAST(0,RW_ADR);
  for(i = 0;i < 0x800;i++)
  {
 /*   ix = *(byte*)(NIC_BASE+(i<<1));
    ix = *(byte*)(NIC_BASE+(i<<1));
    printf("%x - (%x)\n",i,ix);
    Cconin();*/
    WRITE_SUPER_FAST(i & 0xff,WRITE);
  }
  WRITE_SUPER_FAST(0,RW_ADR);
  WRITE_SUPER_FAST(0,RW_ADR);
  for(i=0;i<0x800;i++)
  {
    READ_SUB_FAST(READ);
    if((i & 0xff) != y)
    {
      printf("\nDE600 memory test error!!(at %x=%x)\n",i,y&0xff);
 /*     nic_locked &= ~LOCKMEM;
      return -1;*/
    }
  }
  x++;
  nic_locked &= ~LOCKMEM;
  printf("\nDE600 memory test ok.\n");
  return 0;
}

int resetNIC(void)
{
  int copyEAD(void);
  int test_mem(void);
  int Check_DE600(void);
  
  CurRxPage = 0x20;
  Mode_RxPg = RX_BP | 0x20;
  CurTxPage = 0;
  
  if(Check_DE600()) return -1;
  if(test_mem()) return -2;
  if(copyEAD()) return -3;
  printf("\nDE600 test completed - no errors.\n");
  return 0; 
}

int main()
{
  
  Cconws("\nTest V1.1b for Dlink DE600, fortec pm93 -\n");
  Supexec(disablirq);
  Supexec((long (*)())resetNIC);
  return 0;
}

