/********************************************************************/
/*																	*/
/*	Packet driver for D-LINK DE600 ethernet controller				*/
/*																	*/
/*	Copyleft by P. Mayer, 1993 TU-Vienna IAEE						*/
/*	All rights reserved												*/
/*																	*/
/********************************************************************/

#define NOTTVERSION
#define NOIRQVERSION

#define LOCKMEM  0x1
#define LOCKALLO 0x2
#define LOCKFREE 0x4
#define LOCKMAIN 0x8
#define LOCKRES  0x10
#define LOCKREC  0x20
#define LOCKNET  0x40

#include <stdio.h>
#include <stddef.h>
#include <string.h>
#include <tos.h>
#include <time.h>
#include "nicmem.h"
#include "nicdrv.h"
#include "pktqueue.h"
#include "pktdrv.h"
#include "cookie.h"
#include "inetcust.h"

#define noDEBUG
#define noDEBUGINTR
#define noDEBUGPKT
#define NORMAL

#define Bconws(x) dpy = x;while(*dpy)(Bconout(2,*dpy++))

char str[80];
char *dpy;

extern long dclock(void);

PKTBUF PPKT[MAXPKT];

PKTPOOL PPOOL;

extern char nic_locked;
extern procref old_intr;

int  retval;
int	 term = 0;
int good = 0;
et_hdr		header;
int mode;

#define CENBUSY_vectornum 64
#define SPUR_vectornum 24

void (*ihandler)(void) = NULL;
extern void dlink_200interrupt(void);
extern void dlink_interrupt(void);
extern void vbl_loop(void);
extern void nic_install(void);
extern long *old200;
extern long disablirq(void);
extern long enablirq(void);
extern long quitirq(void);
int resetNIC(void);  /* reset dlink, init datastructures  */

PKTPOOL			*p_free;  				/* queue of free packets */
u_short			freecnt;  				/* number of free packets */

procref ext_tab[8] =					/* subfunction table */
{
  net_reset,
  net_open,
  net_release,
  net_send,
  net_getadr,
  (procref)net_info,
  (procref)net_pktalloc,
  net_pktfree
};

PROTOCOL protos[MAXPROTOCOLS];  /* protocols to serve */
int protocols = 0;              /* number of active protocols */

et_stat stat;                   /* statistics block */

#define NIC_BASE 0xfa0201L

typedef unsigned char byte;

byte CurTxPage, Mode_RxPg;
int RxPktLen, RxStartAdd, TxStartAdd, CurRxPage, our_type;
byte our_address[6];
int last, LastTxStartAdd;
int ix;

#define WRITE		(0x00 << 1)
#define READ		(0x01 << 1)
#define STATUS		(0x02 << 1)
#define COMMAND		(0x03 << 1)
#define NUL_CMD 	(0x0c << 1)
#define RX_LEN		(0x05 << 1)
#define TX_ADR		(0x06 << 1)
#define RW_ADR		(0x07 << 1)

#define WRITE_STROBE	(0x08 << 1)

#define RXEN		(0x08)
#define TXEN		(0x04)
#define LOOPBACK	(0x0c)
#define RX_NONE		(0x00)
#define RX_ALL		(0x01)
#define RX_BP		(0x02)
#define RX_MBP		(0x03)

#define RESET		(0x80)
#define STOP_RESET	(0x00)

#define RXBUSY		0x80
#define GOOD		0x40
#define RESET_FLAG	0x20
#define T16		    0x10
#define TXBUSY		0x08

#define BFRSIZ		2048
#define RUNT		60
#define EADDR_LEN	6
#define HA13		0x20
#define PAGE_0		0x00
#define PAGE_1		0x08
#define PAGE_2		0x10
#define PAGE_3		0x18

#ifdef TTVERSION
#define delay()     {ix = ix +9;} /* no delay needed for ST */
#else
#define delay()
#endif
#define pause()

/* defines for access to DE600 */

#define WRITE_SUPER_FAST(value, cmd) \
	x = *(byte*)(base + (int)((((((int)value) << 5) & 0x1e0)) + cmd)); \
	x = *(byte*)(base + (int)((((((int)value) << 1) & 0x1e0) + ((cmd) ^ WRITE_STROBE)))); \

#define WRITE_S_FAST(value, cmd) \
	x = *(byte*)(base + (int)((((((int)value) << 5) & 0x1e0)) + cmd)); \
	x = *(byte*)(base + (int)((((((int)value) << 5) & 0x1e0)) + cmd)); \
	x = *(byte*)(base + (int)((((((int)value) << 1) & 0x1e0) + ((cmd) ^ WRITE_STROBE)))); \
	x = *(byte*)(base + (int)((((((int)value) << 1) & 0x1e0) + ((cmd) ^ WRITE_STROBE)))); \

#define READ_STAT \
	x = *(byte*)(base + (int)STATUS); \
	y = (*(byte*)(base + (int)NUL_CMD)/* & 0xf0*/)/* ^ 0x80*/; \

#define READ_STAT1 \
	x = *(byte*)(base + (int)NUL_CMD); \
	x = *(byte*)(base + (int)STATUS); \
	x = *(byte*)(base + (int)STATUS); \
	delay();\
	y = (*(byte*)(base + (int)NUL_CMD) /*& 0xf0*/) /*^ 0x80*/; \

#define READ_STAT2 \
	x = *(byte*)(base + (int)STATUS + 0x200); \
/*	y = *(byte*)(base + (int)STATUS + 0x200); \*/

#define READ_SUB_FAST(cmd) \
	x = *(byte*)(base + (int)(cmd)); \
    delay(); \
	x = (*(byte*)(base + (int)(cmd))) /*& 0xf0*/; \
    x >>= 4; \
   	y = *(byte*)(base + (int)(cmd + WRITE_STROBE)); \
   	delay(); \
 	y = (((*(byte*)(base + (cmd | WRITE_STROBE)) /*& 0xf0*/)) | x); \
    /*y ^= 0x88; */\

#define READ_FIRST(cmd) \
	x = *(byte*)(base + (int)(cmd)); \
	delay(); \
 	x = (((*(byte*)(base + (cmd | WRITE_STROBE)) /*& 0xf0*/))); \
    x >>= 4; \

#define READ_LOOP(cmd) \
 	y = (((*(byte*)(base + cmd) /*& 0xf0*/)) | x); \
    delay(); \
 	y = (((*(byte*)(base + cmd) /*& 0xf0*/)) | x); \
/*    y ^= 0x88;*/ \
 	x = (((*(byte*)(base + (cmd | WRITE_STROBE)) /*& 0xf0*/))); \
    delay(); \
 	x = (((*(byte*)(base + (cmd | WRITE_STROBE)) /*& 0xf0*/))); \
    x >>= 4; \

#define READ_LAST(cmd) \
 	y = (((*(byte*)(base + (cmd | WRITE_STROBE)) /*& 0xf0*/)) | x); \
    delay(); \
 	y = (((*(byte*)(base + (cmd | WRITE_STROBE)) /*& 0xf0*/)) | x); \
/*    y ^= 0x88; \*/

int copyEAD()
{
  register byte *base = (byte*)NIC_BASE;
  register byte x,y;
  int i;

  WRITE_SUPER_FAST(0,RW_ADR);
  WRITE_SUPER_FAST(HA13,RW_ADR);

  for(i = 0; i < EADDR_LEN;i++) 
  {
    READ_SUB_FAST(READ);
    our_address[i] = y;
  }
  if(   our_address[0] == 0x00 
     && our_address[1] == 0xde 
     && our_address[2] == 0x15)
  {
    our_address[1] = 0x80;
    our_address[2] = 0xc8;

    /* our_address[3] &= 0x0f;
       our_address[3] |= 0x70; */
  }
  else
  {
    Cconws("\r\nDE600 no address!!\r\n");
    return -1;
  }

  WRITE_SUPER_FAST(0,RW_ADR);
  WRITE_SUPER_FAST(HA13,RW_ADR);

  for(i = 0;i < EADDR_LEN;i++) 
  {
    WRITE_SUPER_FAST(our_address[i],WRITE);
  }
  x++;
  return 0;
}

/***************************************************
  test for de600 ethernetadapter on cartridge port
 ***************************************************/

int Check_DE600()
{
  register byte *base = (byte*)NIC_BASE;
  register byte x,y;

  x = *(byte*)(base + NUL_CMD);
  x = *(byte*)(base + NUL_CMD);
  delay();
  WRITE_SUPER_FAST(RESET,COMMAND);
  delay();
  WRITE_SUPER_FAST(STOP_RESET,COMMAND);
  delay();
  READ_STAT1;
  x++; 	
  if(y == 0) return 0;
  else
  {
    Cconws("\r\nDE600 not detected!!\r\n");
    return -1;
  }
}

int send_packet(byte *p_pkt, int pkt_len)
{
  register byte *base = (byte*)NIC_BASE;
  register byte x,y;
  register int TxStartAdd,val;
  void rcv_pkt(void);

  if(pkt_len < RUNT) pkt_len = RUNT;
  pkt_len = (pkt_len+1) & ~1;  /* make sure min. size */

  READ_STAT1;
  CurTxPage ^= 0x8;		/* next free buffer */

  TxStartAdd = (BFRSIZ - pkt_len) | ((int)CurTxPage << 8);
  WRITE_SUPER_FAST(TxStartAdd & 0xff, RW_ADR);  
  WRITE_SUPER_FAST(TxStartAdd >> 8, RW_ADR);  

  while(pkt_len--)
  {
    val = *p_pkt++;
    WRITE_SUPER_FAST(val,WRITE);
  }
  last = ( ( ( (int)(*(p_pkt-1)) << 1) & 0x1e0) + ((WRITE) ^ WRITE_STROBE));
/*
  for(loop_cnt = 0x4000;loop_cnt--;)
  {
    y = (*(byte*)(base + (int)last)) ^ 0x80;
    if((y & TXBUSY) == 0)
    {
     /*Bconws("s");*/
     break;
    }
  }
*/
  LastTxStartAdd = TxStartAdd;
  WRITE_SUPER_FAST(TxStartAdd & 0xff, TX_ADR);
  WRITE_SUPER_FAST(TxStartAdd >> 8, TX_ADR);
  WRITE_SUPER_FAST(Mode_RxPg, COMMAND);
  WRITE_SUPER_FAST(Mode_RxPg | TXEN, COMMAND);
  mode = RXEN;

  stat.st_sent++;
  READ_STAT2;
  x++;y++;
  return pkt_len;
}

int test_mem()
{
  register byte *base = (byte*)NIC_BASE;
  register byte x,y;
  register int i;

  nic_locked |= LOCKMEM;
  
  WRITE_SUPER_FAST(0,RW_ADR);
  WRITE_SUPER_FAST(0,RW_ADR);
  for(i = 0;i < 0x800;i++)
  {
    WRITE_SUPER_FAST(i & 0xff,WRITE);
  }
  WRITE_SUPER_FAST(0,RW_ADR);
  WRITE_SUPER_FAST(0,RW_ADR);
  for(i=0;i<0x800;i++)
  {
    READ_SUB_FAST(READ);
    if((i & 0xff) != y)
    {
      Cconws("\r\nDE600 memory test error!!\r\n");
      nic_locked &= ~LOCKMEM;
      return -1;
    }
  }
  x++;
  nic_locked &= ~LOCKMEM;
  return 0;
}

int resetNIC(void)
{
  int copyEAD(void);
  int test_mem(void);
  void enable_rcv(void);
  int Check_DE600(void);

  CurRxPage = 0x20;
  Mode_RxPg = RX_BP | 0x20;
  CurTxPage = 0;

  if(Check_DE600()) return -1;
  if(test_mem()) return -2;
  if(copyEAD()) return -3;
  enable_rcv();
  return 0; 
}

void stopNIC(void)
{
  register byte *base = (byte*)NIC_BASE;
  register byte x,y;

  READ_STAT1;
  WRITE_SUPER_FAST(Mode_RxPg, COMMAND);
  x++;y++; 
}

byte NICstatus()
{
  register byte *base = (byte*)NIC_BASE;
  register byte x,y;

  READ_STAT;
  x++;
  return y;
}

void enable_rcv()
{
  register byte *base = (byte*)NIC_BASE;
  register byte x,y;

  READ_STAT1;
  WRITE_SUPER_FAST(Mode_RxPg, COMMAND);
  WRITE_SUPER_FAST(Mode_RxPg | RXEN, COMMAND);
  mode = RXEN;
  READ_STAT2;
  x++;y++;
}

int read_inf(void)
{
  COOKIE *cookie;

  cookie = get_cookie(INETCUSTCOOKIE);
  if(!cookie || !cookie->val) return(0);
  return(1);
}

long net_info(int len, char *buf)
{

  nic_locked |= LOCKNET;

  if(buf == (char *)0L) 
  {
    Mode_RxPg = (Mode_RxPg & 0xfc) | len;
    nic_locked &= ~LOCKNET;
    return(0);
  }
  if(buf == (char *)1L) 
  {
    resetNIC();
    nic_locked &= ~LOCKNET;
    return(0);
  }
  if(buf == (char *)2L) 
  {
    nic_locked &= ~LOCKNET;
    return((long)&PPOOL);
  }
  if(buf == (char *)3L) 
  {
    nic_locked &= ~LOCKNET;
    return((long)protos);
  }
  stat.st_free = freecnt;
  memcpy(buf,(char *)&stat,(size_t)len<sizeof(stat)?len:(int)sizeof(stat));

  nic_locked &= ~LOCKNET;
  return(len);
}

int net_open(int type, int (*handler)(int,char *))
{
  int i,new;

  if(!handler) return(EPARAM);
  if(protocols >= MAXPROTOCOLS) return(EPROTAVAIL);
  new = -1;
  nic_locked |= LOCKNET;
  if(!protocols)
  {
    if(net_reset() < 0)
    {
      nic_locked &= ~LOCKNET;
      return(EINIT);
    }
  }
  for(i = 0; i < MAXPROTOCOLS; i++)
  {
    /* protocol already used */
    if(protos[i].type == type)
    {
      nic_locked &= ~LOCKNET;
      return(EPROTUSED);
    }
    if(protos[i].type == ET_UNUSED &&  new<0 ) new = i;  /* find first free entry */
  }
  if(new < 0) new = protocols;
  protocols++;
  protos[new].handler = handler;
  protos[new].recvd = 0;
  protos[new].sent = 0;
  protos[new].type = type;
  nic_locked &= ~LOCKNET;
  return(new);
}

int net_release(int type)
{
  int i;
  void stopNIC(void);

  if(!protocols) return(EPROTUSED);
  if(type == ET_UNUSED) return(EPROTUSED);

  for(i=0; i < MAXPROTOCOLS; i++)
    if(protos[i].type == type) break;
  if(i==MAXPROTOCOLS)
  {
    return(EPROTUSED);
  }
  nic_locked |= LOCKNET;
  protocols--;
  if(!protocols)
  {
    stopNIC();
  }
  protos[i].type = ET_UNUSED;
  protos[i].handler = NULL;
  nic_locked &= ~LOCKNET;
  return(protocols);
}

int net_send(int len, char *buf)
{
  void rcv_pkt(void);
  byte NICstatus(void);
  void enable_rcv(void);
#ifdef DEBI
  printf("netsend %lx length %d good = %d mode = %x\n",buf,len,good,mode);
#endif

  if(!buf || !len || (buf < (char *)PPKT) || (buf > (char *)&PPOOL)) return(EPARAM);
  if(len < 60) len = 60;
  if(len > (int)sizeof(PACKET)) return(EPKTLEN);
  disablirq();
  nic_locked |= LOCKNET;
  len = send_packet((byte*)buf,len);

#ifdef DEBI	
  printf("send done\n");
#endif
  nic_locked &= ~LOCKNET;
  enablirq();
  return(0);
}

int	net_getadr(int len, char *buf)
{
  if(len >= (int)sizeof(HADDR))
  {
    buf[0] = our_address[0];
    buf[1] = our_address[1];
    buf[2] = our_address[2];
    buf[3] = our_address[3];
    buf[4] = our_address[4];
    buf[5] = our_address[5];
    return((int)sizeof(HADDR));
  }
  return(0);
}

int net_reset(void)
{
  int i,tmp;

  disablirq();
  nic_locked |= LOCKRES;
  for(i=0;i<MAXPROTOCOLS;i++)  /* init protocol table */
  {
    protos[i].type = ET_UNUSED;
    protos[i].handler = NULL;
    protos[i].recvd = 0;
    protos[i].sent = 0;
  }
  protocols = 0;

  p_free = p_init(MAXPKT,&PPOOL,PPKT);  /* init free packets */
  freecnt = MAXPKT;

  tmp = resetNIC();
  nic_locked &= ~LOCKRES;
  enablirq();
  return tmp;
}

PKTBUF *net_pktalloc(protocol)
u_short protocol;
{
  PKTBUF * tmp;

  if(!p_free) net_reset();

  nic_locked |= LOCKALLO;
  if(freecnt <= 1)
  {
Bconws("DLINKDRV: no packet free\r");
    nic_locked &= ~LOCKALLO;
    return(NULL);
  }
  tmp = ap_getpkt(protocol,p_free);
  if(tmp) freecnt--;
  else
  {
   Bconws("DLINKDRV: get packet failed\r");
  }
#ifdef DEBUGPKT
  sprintf(str,"netpktalloc at %lx\r",tmp);
  Bconws(str);
#endif
  nic_locked &= ~LOCKALLO;
  return tmp;
}

int net_pktfree(p_pkt)
PKTBUF *p_pkt;
{
  nic_locked |= LOCKFREE;
#ifdef DEBUGPKT
  sprintf(str,"netpktfree at %lx\r",p_pkt);
  Bconws(str);
#endif
  if(!p_free || !p_pkt || (p_pkt < PPKT) || (p_pkt > &PPKT[MAXPKT-1]))
  {
    Bconws("DLINKDRV: free packet out of bounds\r");
    nic_locked &= ~LOCKFREE;
    return(FALSE);
  }
  if(((long)p_pkt - (long)PPKT) % sizeof(PKTBUF))
  {
    Bconws("DLINKDRV: free misaligned packet\r");
    nic_locked &= ~LOCKFREE;
    return(FALSE);
  }
  if(ap_putpkt(p_free,p_pkt))
  {
    freecnt++;
    nic_locked &= ~LOCKFREE;
    return(TRUE);
  }
  Bconws("DLINKDRV: free packet failed\r");
  nic_locked &= ~LOCKFREE;
  return(FALSE);
}

void rcv_check(void)
{
 register byte *base = (byte*)NIC_BASE;
 register byte x;
 void rcv_pkt(void);

 READ_STAT2;
 if(x & GOOD) rcv_pkt();
 stat.st_intr--;
}

/*******************************************************************/
/* read D-LINK function                                            */
/*******************************************************************/

void rcv_pkt(void)
{
  register byte *base = (byte*)NIC_BASE;
  register byte x,y,NICstate;
  register int i,ii;
  int	   type, RxPktLen;

  extern void fastread(void);
  
  et_stat	*et_stat;
  PKTBUF		*pkt;
  byte * pb;

  nic_locked |= LOCKREC;
  et_stat = &stat;
  et_stat->st_intr++;

  READ_STAT1;
  NICstate = y;

do
{
    if(NICstate & GOOD)
    {
      et_stat->st_got++;

      READ_SUB_FAST(RX_LEN);
      RxPktLen = y;
      READ_SUB_FAST(RX_LEN);
      RxPktLen += (y << 8);
      RxPktLen -= 4;

      Mode_RxPg ^= 0x10;
      WRITE_SUPER_FAST(Mode_RxPg, COMMAND);
      WRITE_SUPER_FAST(Mode_RxPg | RXEN, COMMAND);
      mode = RXEN;
      WRITE_SUPER_FAST(0,RW_ADR);
      WRITE_SUPER_FAST(CurRxPage >> 1,RW_ADR);
      CurRxPage ^= 0x10;

      pb = (byte*)&header;
      for(i=0; i < 14;i++)
      {
        READ_SUB_FAST(READ);
        *pb++ = y;
      }
      type = header.et_type;

      /*if(header.et_dest[0] != 0xff)*/
      {
          for(i = 0;i < MAXPROTOCOLS; i++)
          {
            if(protos[i].type == type)
            {
              /* must have one packet free */
              if(freecnt > 3 && (pkt = ap_getpkt(type,p_free)) != 0)
              {
                freecnt--;
                memcpy((byte*)pkt,(byte*)&header,sizeof(et_hdr));
                pb = pkt->et_data;

				READ_FIRST(READ);

				ii = RxPktLen - 15;
				fastread();
                ii++;
                
				READ_LAST(READ);
                if(protos[i].handler)
                { 
                 if(protos[i].handler(RxPktLen,(char *)pkt))
                 {
                  et_stat->st_received++;
                  protos[i].recvd++;
                 }
                 else
                 {
                 /* free unused packet */
                  if(ap_putpkt(p_free,pkt)) freecnt++;
                  break;
                 }
                }
                else
                {
                /* free unused packet */
                  if(ap_putpkt(p_free,pkt)) freecnt++;
                  break;
                }
              }
              else
              {
/*		        Bconws("DLINKDRV: no free packet to recv\r");*/
              }
            }
          }
      }
    }
    else if(!(NICstate & RXBUSY))
    {
/*Bconws("R");    */
      WRITE_SUPER_FAST(Mode_RxPg, COMMAND);
      WRITE_SUPER_FAST(Mode_RxPg | RXEN, COMMAND);
      et_stat->st_missed++;
    }
    if(!(NICstate & TXBUSY))
    {
      WRITE_SUPER_FAST(Mode_RxPg, COMMAND);
      WRITE_SUPER_FAST(Mode_RxPg | RXEN, COMMAND);
    }
    if(NICstate & T16)
    {
      et_stat->st_xmiterr++;
      et_stat->st_collision++;
      WRITE_SUPER_FAST(TxStartAdd & 0xff, TX_ADR);
      WRITE_SUPER_FAST(TxStartAdd >> 8, TX_ADR);
      WRITE_SUPER_FAST(Mode_RxPg, COMMAND);
      WRITE_SUPER_FAST(Mode_RxPg | TXEN, COMMAND);
      WRITE_SUPER_FAST(Mode_RxPg, COMMAND);
      WRITE_SUPER_FAST(Mode_RxPg | RXEN, COMMAND);
    }
    et_stat->st_err = NICstate;

  READ_STAT1;
  NICstate = y;
}while(NICstate & GOOD);
  READ_STAT2;
  x++;
  nic_locked &= ~LOCKREC;
}

long vbl_install()
{
  long **vblqueue = *(long***)0x456L;
  int vblnum = *(int*)0x454L;
  int i;

  for(i=1; i< vblnum;i++) if (*(vblqueue+i) == 0L) break;

  if(i< vblnum) 
  {
    *(vblqueue+i) = (long*)vbl_loop;
    return 0;
  }
  else return -1;
}

int main()
{
  COOKIE *cookie;
  int (*call)(void);

  Supexec(disablirq);
#ifdef IRQVERSION	
  Cconws("\r\nPacket driver V1.1b for Dlink DE600 ");
#else
  Cconws("\r\nPacket driver V1.1bp for Dlink DE600 ");
#endif
  cookie = get_cookie(PKTCOOKIE);
  if(cookie)
  {
    (long)call = ((long *)cookie->val)[NETRESET];
    if(Supexec((long (*)())call) == 0)  /* reset network */
    {
      Cconws("\r\nexisting driver reset\r\n");
      enable_rcv();
      Supexec(enablirq);
    }
    else 
      Cconws("\r\ncould not reset existing driver\r\n");
    return 0;
    
  }
  
  if(!read_inf())
  {
    Cconws("INETCUST not installed !!\r\n");
    return 1;
  }
  else
  {
	ihandler = NULL;
	nic_locked = TRUE;
#ifdef IRQVERSION	
	old_intr = (procref)Setexc(SPUR_vectornum, (void (*)())dlink_interrupt);
	old_intr = (procref)Setexc(CENBUSY_vectornum, (void (*)())dlink_interrupt);
    Supexec((long (*)())nic_install);
#endif
    if(Supexec((long (*)())net_reset) < 0)
    {
#ifdef IRQVERSION	
   	  Setexc(CENBUSY_vectornum, (void (*)())old_intr);
#endif
      Cconws("\r\nno DE600 detected !!\r\n");
      return 0;
    }
    Supexec(vbl_install);
    enable_rcv();
    ihandler = rcv_pkt;
    nic_locked = 0;
    add_cookie(PKTCOOKIE,(long)ext_tab);
    Cconws("installed\r\n(c) pm FORTec 1993\r\n");
    Ptermres(_PgmSize,0);
  }
  return 0;
}

