#include <types.h>
#include <unistd.h>
#include <osbind.h>
#include <mintbind.h>
#include <errno.h>

extern int __mint;

int
setregid(rgid,egid)
  int rgid, egid;
{
  long r;

  if (__mint) {
    if (__mint >= 0x10B) {
      r = Psetregid(rgid, egid);
      if (r < 0) {
	errno = (int) -r;
	return -1;
      }
    } else {
      return (setuid (rgid));
    }
  }
  return 0;
}

