;# NAME
;#    elapsed.pl - convert seconds to elapsed time format
;#
;# AUTHOR
;#    Michael S. Muegel <mmuegel@mot.com>
;#
;# RCS INFORMATION
;#    mmuegel
;#    /usr/local/ustart/src/mail-tools/dist/foo/libs/elapsed.pl,v
;#    1.1 of 1993/07/28 08:07:19

package elapsed;

# Time field types
$DAYS		= 1;
$HOURS		= 2;
$MINUTES	= 3;
$SECONDS	= 4;

# The array contains four records each with four fields. The fields are,
# in order:
#
#    Type		Specifies what kind of time field this is. Once of
#			$DAYS, $HOURS, $MINUTES, or $SECONDS.
#
#    Multiplier		Specifies what time field this is via the minimum
#			number of seconds this time field may specify. For
#			example, the minutes field would be non-zero
#			when there are 60 or more seconds.
#			
#    Separator		How to separate this time field from the next
#			*greater* field.
#
#    Format		sprintf() format specifier on how to print this
#			time field.
@MULT_AND_SEPS = ($DAYS, 60 * 60 * 24, "+", "%d",
                  $HOURS, 60 * 60, ":", "%d",
                  $MINUTES, 60, ":", "%02d",
                  $SECONDS, 1, "", "%02d"
                 );

;###############################################################################
;# Seconds_To_Elapsed
;#
;# Coverts a seconds count to form [d+]h:mm:ss. If $Collapse
;# is true then the result is compacted somewhat. The string returned
;# will be of the form [d+][[h:]mm]:ss.
;#
;# Arguments:
;#    $Seconds, $Collapse
;#
;# Examples:
;#    &Seconds_To_Elapsed (0, 0) 	-> 0:00:00
;#    &Seconds_To_Elapsed (0, 1) 	-> :00
;#
;#    &Seconds_To_Elapsed (119, 0) 	-> 0:01:59
;#    &Seconds_To_Elapsed (119, 1) 	-> 01:59
;#
;#    &Seconds_To_Elapsed (3601, 0) 	-> 1:00:01
;#    &Seconds_To_Elapsed (3601, 1) 	-> 1:00:01
;#
;#    &Seconds_To_Elapsed (86401, 0) 	-> 1+0:00:01
;#    &Seconds_To_Elapsed (86401, 1) 	-> 1+:01
;#
;# Returns:
;#    $Elapsed
;###############################################################################
sub main'Seconds_To_Elapsed
{
   local ($Seconds, $Collapse) = @_;
   local ($Type, $Multiplier, @Multipliers, $Separator, $DHMS_Used, 
          $Elapsed, @Mult_And_Seps, $Print_Field);

   $Multiplier = 1;
   @Mult_And_Seps = @MULT_AND_SEPS;

   # Keep subtracting the number of seconds corresponding to a time field
   # from the number of seconds passed to the function.
   while (1)
   {
      ($Type, $Multiplier, $Separator, $Format) = splice (@Mult_And_Seps, 0, 4);
      last if (! $Multiplier);
      $Seconds -= $DHMS_Used * $Multiplier 
         if ($DHMS_Used = int ($Seconds / $Multiplier));

      # Figure out if we should print this field
      if ($Type == $DAYS)
      {
	 $Print_Field = $DHMS_Used;
      }

      elsif ($Collapse)
      {
	 if ($Type == $HOURS)
	 {
	    $Print_Field = $DHMS_Used;
	 }
	 elsif ($Type == $MINUTES)
	 {
	    $Print_Field = $DHMS_Used || $Printed_Field {$HOURS};
	 }
	 else
	 {
	    $Format = ":%02d" 
	       if (! $Printed_Field {$MINUTES});
	    $Print_Field = 1;
	 };
      }

      else
      {
	 $Print_Field = 1;
      };

      $Printed_Field {$Type} = $Print_Field;
      $Elapsed .= sprintf ("$Format%s", $DHMS_Used, $Separator) 
	 if ($Print_Field);
   };

   return ($Elapsed);
};

1;
