#include <unistd.h>
#include <errno.h>
#include <sys/time.h>
#include <mintbind.h>

/* in getrusage.c */
__EXTERN void _ms2tval __PROTO ((unsigned long, struct timeval *));

int
getitimer (which, old)
     int which;
     struct itimerval *old;
{
  long r;
  long interval, value;

  r = Tsetitimer (which, 0, 0, &interval, &value);
  if (r < 0)
    {
      errno = -r;
      return -1;
    }
  _ms2tval (interval, &old->it_interval);
  _ms2tval (value, &old->it_value);
  return 0;
}
