/*
 * XaAES - XaAES Ain't the AES
 *
 * A multitasking AES replacement for MiNT
 *
 */

#include <stdlib.h>
#include <osbind.h>
#ifdef LATTICE
#undef abs		/* MiNTlib (PL46) #define is buggy! */
#define abs(i)	__builtin_abs(i)
#endif
#include "XA_DEFS.H"
#include "XA_TYPES.H"
#include "XA_GLOBL.H"
#include "K_DEFS.H"
#include "RECTLIST.H"
#include "BOX3D.H"
#include "objects.h"

extern short global_clip[4];	/* Bloody progdefs need to know the clip rectangle */

void d_g_progdef(ODC_PARM *odc_p)
{
	OBJECT *ob=odc_p->tree + odc_p->object;
	APPLBLK *ab;
	PARMBLK p;
	
	ab=(APPLBLK*)ob->ob_spec;
	p.pb_tree=odc_p->tree;
	p.pb_obj=odc_p->object;

	p.pb_prevstate=p.pb_currstate=ob->ob_state;
				
	p.pb_x=odc_p->parent_x+ob->ob_x;
	p.pb_y=odc_p->parent_y+ob->ob_y;
	p.pb_w=ob->ob_width;
	p.pb_h=ob->ob_height;
				
	p.pb_xc=global_clip[0];
	p.pb_yc=global_clip[1];
	p.pb_wc=global_clip[2]-global_clip[0]+1;
	p.pb_hc=global_clip[3]-global_clip[1]+1;
	
	p.pb_parm=ab->ab_parm;
		
		/* The PROGDEF function returns the ob_state bits that
			remain to be handled by the AES: */
	*odc_p->state_mask = (short)(*(ab->ab_code))(&p);
		/* BUG: SELECTED bit only handled in non-color mode!!! */
		/* (Not too serious I believe... <mk>) */

}