/*
 * XaAES - XaAES Ain't the AES
 *
 * A multitasking AES replacement for MiNT
 *
 */

#include <stdlib.h>
#include <osbind.h>
#ifdef LATTICE
#undef abs		/* MiNTlib (PL46) #define is buggy! */
#define abs(i)	__builtin_abs(i)
#endif
#include "XA_DEFS.H"
#include "XA_TYPES.H"
#include "XA_GLOBL.H"
#include "K_DEFS.H"
#include "RECTLIST.H"
#include "BOX3D.H"
#include "objects.h"

void d_g_image(ODC_PARM *odc_p)
{
	OBJECT *ob=odc_p->tree + odc_p->object;
	OBJC_COLORWORD *colourword;
	BITBLK *bitblk;
	MFDB Mscreen;
	MFDB Micon;
	unsigned short zap;
	short coords[8],cols[2],icx,icy;

	bitblk=(BITBLK*)ob->ob_spec;
	colourword=(OBJC_COLORWORD*)&zap;
	zap=(unsigned short)bitblk->bi_color;
	colourword->pattern=7;
	set_colours(ob, colourword);

	icx=odc_p->parent_x+ob->ob_x;
	icy=odc_p->parent_y+ob->ob_y;

	Micon.fd_w=(bitblk->bi_wb)<<3;
	Micon.fd_h=bitblk->bi_hl;
	Micon.fd_wdwidth=(Micon.fd_w+15)>>4;
	Micon.fd_nplanes=1;
	Micon.fd_stand=0;
	Mscreen.fd_addr=NULL;
			
	Micon.fd_addr=bitblk->bi_pdata;
	cols[0]=colourword->fillc;
	cols[1]=0;
			
	coords[0]=bitblk->bi_x;
	coords[1]=bitblk->bi_y;
	coords[2]=Micon.fd_w-1-coords[0]; coords[3]=Micon.fd_h-1-coords[1];
	coords[4]=icx; coords[5]=icy;
	coords[6]=icx+Micon.fd_w-1-coords[0]; coords[7]=icy+Micon.fd_h-1-coords[1];
	vrt_cpyfm(V_handle, MD_TRANS, coords, &Micon, &Mscreen, cols);

}
