/*
 * XaAES - XaAES Ain't the AES
 *
 * A multitasking AES replacement for MiNT
 *
 */

#include <stdlib.h>
#include <osbind.h>
#ifdef LATTICE
#undef abs		/* MiNTlib (PL46) #define is buggy! */
#define abs(i)	__builtin_abs(i)
#endif
#include "XA_DEFS.H"
#include "XA_TYPES.H"
#include "XA_GLOBL.H"
#include "K_DEFS.H"
#include "RECTLIST.H"
#include "BOX3D.H"
#include "objects.h"

void d_g_button(ODC_PARM *odc_p)
{
	OBJECT *ob=odc_p->tree + odc_p->object;
	OBJC_COLORWORD *colourword;
	unsigned short zap=0x11f8;
	short border_thick=-1;
	short parent_x=odc_p->parent_x, parent_y=odc_p->parent_y;
	short coords[4],temp,tx,ty,selected;
	
	selected=ob->ob_state&SELECTED;

	colourword=(OBJC_COLORWORD*)&zap;
	
	if (ob->ob_flags&EXIT)
		border_thick--;
	if (ob->ob_flags&DEFAULT)
		border_thick--;
	ty=parent_y + ob->ob_y + ((ob->ob_height-display.c_max_h)/2);

	shadow_object(ob, parent_x, parent_y, colourword, border_thick);
	set_colours(ob, colourword);

	tx=parent_x+ob->ob_x+(ob->ob_width/2);

	if (ob->ob_flags&FLD3DANY)
	{
		XA_3D_pushbutton(parent_x+ob->ob_x-1, parent_y+ob->ob_y-1, ob->ob_width+1, ob->ob_height+1, selected);
		if (selected)
		{
			tx+=PUSH3D_DISTANCE; ty+=PUSH3D_DISTANCE;
		}
	}else{
		
		if ((display.colours>=16) && selected)
		{
			coords[0]=parent_x+ob->ob_x+border_thick;
			coords[1]=parent_y+ob->ob_y+border_thick;
			coords[2]=coords[0]+ob->ob_width-border_thick*2-1;
			coords[3]=coords[1]+ob->ob_height-border_thick*2-1;
			vswr_mode(V_handle, MD_REPLACE);
			vsf_color(V_handle,BLACK);
			vsf_interior(V_handle,FIS_SOLID);
			v_bar(V_handle, coords);
			vst_color(V_handle,WHITE);			
		}else{
			coords[0]=parent_x+ob->ob_x+border_thick;
			coords[1]=parent_y+ob->ob_y+border_thick;
			coords[2]=coords[0]+ob->ob_width-border_thick*2-1;
			coords[3]=coords[1]+ob->ob_height-border_thick*2-1;
			vswr_mode(V_handle, MD_REPLACE);
			vsf_color(V_handle,WHITE);
			vsf_interior(V_handle,FIS_SOLID);
			v_bar(V_handle, coords);
				
			draw_2d_box(parent_x+ob->ob_x, parent_y+ob->ob_y,
						ob->ob_width, ob->ob_height,
						border_thick, BLACK);
			vst_color(V_handle,BLACK);
				
		}
	}

	vst_font(V_handle,display.standard_font_id);
	vst_point(V_handle,display.standard_font_point,&temp,&temp,&temp,&temp);
	vswr_mode(V_handle, MD_TRANS);
	vst_alignment(V_handle,1,5,&temp,&temp);
	v_gtext(V_handle,tx,ty,(char*)ob->ob_spec);

}
