/*
 * XaAES - XaAES Ain't the AES
 *
 * A multitasking AES replacement for MiNT
 *
 */

#include <VDI.H>
#include "XA_DEFS.H"
#include "XA_TYPES.H"
#include "K_DEFS.H"
#include "XA_GLOBL.H"
#include "GRAF_MOU.H"

/* Mouse definition block - standard GEM arrow */

MFORM M_ARROW_MOUSE =
{	0x0000,0x0000,0x0001,0x0000,0x0001,
/* Mask data */
	0xC000,0xE000,0xF000,0xF800,
	0xFC00,0xFE00,0xFF00,0xFF80,
	0xFFC0,0xFFE0,0xFE00,0xEF00,
	0xCF00,0x8780,0x0780,0x0380,
/* Cursor data */
	0x0000,0x4000,0x6000,0x7000,
	0x7800,0x7C00,0x7E00,0x7F00,
	0x7F80,0x7C00,0x6C00,0x4600,
	0x0600,0x0300,0x0300,0x0000
};

/* Mouse definition block - standard GEM busy bee*/

MFORM M_BEE_MOUSE =
{	0x0008,0x0008,0x0001,0x0000,0x0001,
/* Mask data */
	0x1C7E,0x1CFF,0x1CFF,0xEFFF,
	0xFFFF,0xFFFF,0x3FFE,0x3FFC,
	0x7FFE,0xFFFE,0xFFFF,0xFFFF,
	0xFFFF,0xFFFF,0xFEFF,0x7C3E,
/* Cursor data */
	0x0800,0x083C,0x0062,0x06C2,
	0xC684,0x198A,0x1B54,0x06E0,
	0x1D58,0x33FC,0x6160,0x42DE,
	0x44D8,0x4A56,0x3414,0x0000
};

/* Mouse definition block standard GEM open hand */

MFORM M_HAND_MOUSE =
{	0x0008,0x0008,0x0001,0x0000,0x0001,
/* Mask data */
	0x0300,0x1FB0,0x3FF8,0x3FFC,
	0x7FFE,0xFFFE,0xFFFE,0x7FFF,
	0x7FFF,0xFFFF,0xFFFF,0x7FFF,
	0x3FFF,0x0FFF,0x01FF,0x003F,
/* Cursor data */
	0x0300,0x1CB0,0x2448,0x2224,
	0x7112,0x9882,0x8402,0x4201,
	0x7001,0x9801,0x8401,0x4000,
	0x3000,0x0E00,0x01C0,0x0030
};

/* Mouse definition block - standard GEM outlined cross*/

MFORM M_OCRS_MOUSE =
{	0x0007,0x0007,0x0001,0x0000,0x0001,
/* Mask data */
	0x07C0,0x07C0,0x06C0,0x06C0,
	0x06C0,0xFEFE,0xFEFE,0xC006,
	0xFEFE,0xFEFE,0x06C0,0x06C0,
	0x06C0,0x07C0,0x07C0,0x0000,
/* Cursor data */
	0x0000,0x0380,0x0280,0x0280,
	0x0280,0x0280,0x7EFC,0x4004,
	0x7EFC,0x0280,0x0280,0x0280,
	0x0280,0x0380,0x0000,0x0000
};

/* Mouse definition block - standard GEM pointing finger */

MFORM M_POINT_MOUSE =
{	0x0000,0x0000,0x0001,0x0000,0x0001,
/* Mask data */
	0x3000,0x7C00,0x7E00,0x1F80,
	0x0FC0,0x3FF8,0x3FFC,0x7FFC,
	0xFFFE,0xFFFE,0x7FFF,0x3FFF,
	0x1FFF,0x0FFF,0x03FF,0x00FF,
/* Cursor data */
	0x3000,0x4C00,0x6200,0x1980,
	0x0C40,0x32F8,0x2904,0x6624,
	0x93C2,0xCF42,0x7C43,0x2021,
	0x1001,0x0C41,0x0380,0x00C0
};

/* Mouse definition block - standard GEM thin cross */

MFORM M_TCRS_MOUSE =
{	0x0007,0x0007,0x0001,0x0000,0x0001,
/* Mask data */
	0x0380,0x0380,0x0380,0x0380,
	0x0280,0x0280,0xFEFE,0xF01E,
	0xFEFE,0x0280,0x0280,0x0380,
	0x0380,0x0380,0x0380,0x0000,
/* Cursor data */
	0x0000,0x0100,0x0100,0x0100,
	0x0100,0x0100,0x0100,0x7FFC,
	0x0100,0x0100,0x0100,0x0100,
	0x0100,0x0100,0x0000,0x0000
};

/* Mouse definition block - standard GEM thick cross */

MFORM M_THKCRS_MOUSE =
{	0x0007,0x0007,0x0001,0x0000,0x0001,
/* Mask data */
	0x07C0,0x07C0,0x07C0,0x07C0,
	0x07C0,0xFFFE,0xFFFE,0xFFFE,
	0xFFFE,0xFFFE,0x07C0,0x07C0,
	0x07C0,0x07C0,0x07C0,0x0000,
/* Cursor data */
	0x0000,0x0380,0x0380,0x0380,
	0x0380,0x0380,0x7FFC,0x7FFC,
	0x7FFC,0x0380,0x0380,0x0380,
	0x0380,0x0380,0x0000,0x0000
};

/* Mouse definition block - standard GEM text cursor*/

MFORM M_TXT_MOUSE =
{	0x0007,0x0007,0x0001,0x0000,0x0001,
/* Mask data */
	0x7E7E,0x7FFE,0x07E0,0x03C0,
	0x03C0,0x03C0,0x03C0,0x03C0,
	0x03C0,0x03C0,0x03C0,0x03C0,
	0x03C0,0x07E0,0x7FFE,0x7E7E,
/* Cursor data */
	0x3C3C,0x0660,0x03C0,0x0180,
	0x0180,0x0180,0x0180,0x0180,
	0x0180,0x0180,0x0180,0x0180,
	0x0180,0x03C0,0x0660,0x3C3C
};

/* Mouse definition block - XaAES Data Uncertain logo cursor */

MFORM M_BUBD_MOUSE =
{	0x0007,0x0008,0x0002,0x0000,0x0001,
/* Mask data */
	0x07C0,0x1FF0,0x3FF8,0x7FFC,
	0x7FFC,0xFFFE,0xFFFE,0xFFFE,
	0xFFFE,0xFFFE,0x7FFC,0x7FFC,
	0x3FF8,0x1FF0,0x07C0,0x0000,
/* Cursor data */
	0x07C0,0x1930,0x2AA8,0x5094,
	0x7114,0x9012,0x9112,0x9FF2,
	0x8002,0x8FE2,0x4A24,0x4B24,
	0x2B28,0x1A30,0x07C0,0x0000
};

/* Mouse definition block - XaAES re-sizer cursor */

MFORM M_SIZER_MOUSE =
{	0x0007,0x0008,0x0002,0x0000,0x0001,
/* Mask data */
	0x0000,0xFE00,0x8100,0x8E00,
	0x8400,0xA200,0xB100,0xA888,
	0x4454,0x0234,0x0114,0x0084,
	0x01C4,0x0204,0x01FC,0x0000,
/* Cursor data */
	0x0000,0x0000,0x7E00,0x7000,
	0x7800,0x5C00,0x4E00,0x4700,
	0x0388,0x01C8,0x00E8,0x0078,
	0x0038,0x01F8,0x0000,0x0000
};

/* Mouse definition block - XaAES mover cursor */

MFORM M_MOVER_MOUSE =
{	0x0008,0x0007,0x0001,0x0000,0x0001,
/* Mask data */
	0x0000,0x0080,0x01C0,0x0080,
	0x0080,0x0080,0x1084,0x3FFE,
	0x1084,0x0080,0x0080,0x0080,
	0x01C0,0x0080,0x0000,0x0000,
/* Cursor data */
	0x0080,0x0140,0x0220,0x0140,
	0x0140,0x1144,0x2F7A,0x4001,
	0x2F7A,0x1144,0x0140,0x0140,
	0x0220,0x0140,0x0080,0x0000
};

/*
	AES graf_mouse() routines
	Small extension to give a couple of extra cursor shapes
	(Data Uncertain logo, mover & resizer)
*/

void graf_mouse(short m_shape, MFORM *mf)
{
	switch(m_shape)
	{
		case M_ON:
			v_show_c(V_handle, 1);
			return;
		case M_OFF:
			v_hide_c(V_handle);
			return;
		case ARROW:
			vsc_form(V_handle, &M_ARROW_MOUSE);
			break;
		case TEXT_CRSR:
			vsc_form(V_handle, &M_TXT_MOUSE);
			break;
		case HOURGLASS:
			vsc_form(V_handle, &M_BEE_MOUSE);
			break;
		case POINT_HAND:
			vsc_form(V_handle, &M_POINT_MOUSE);
			break;
		case FLAT_HAND:
			vsc_form(V_handle, &M_HAND_MOUSE);
			break;
		case THIN_CROSS:
			vsc_form(V_handle, &M_TCRS_MOUSE);
			break;
		case THICK_CROSS:
			vsc_form(V_handle, &M_THKCRS_MOUSE);
			break;
		case OUTLN_CROSS:
			vsc_form(V_handle, &M_OCRS_MOUSE);
			break;
		case USER_DEF:
			vsc_form(V_handle, mf);
			break;
		case XACRS_BUBBLE_DISC:		/* The Data Uncertain logo */
			vsc_form(V_handle, &M_BUBD_MOUSE);
			break;
		case XACRS_RESIZER:			/* The 'resize window' cursor */
			vsc_form(V_handle, &M_SIZER_MOUSE);
			break;
		case XACRS_MOVER:			/* The 'move window' cursor */
			vsc_form(V_handle, &M_MOVER_MOUSE);
			break;
	}
	v_hide_c(V_handle);				/* Hide/reveal cursor to update on screen image immediately */
	v_show_c(V_handle,1);
}

/* Slight differance from GEM here - each application can have a different mouse form, */
/* and the one that is used is for the client with the top window. */
/* A non-top application can still hide & show the mouse though, to ensure that redraws */
/* are done correctly */
unsigned long XA_graf_mouse(short clnt_pid, AESPB *pb)
{
	short m=pb->intin[0];

/* Store the mouse shape requested if this isn't a turn on/off request. */
	if ((m!=M_OFF)&&(m!=M_ON))
	{
		clients[clnt_pid].client_mouse=m;
		clients[clnt_pid].client_mouse_form=(MFORM*)(pb->addrin[0]);	
/* Only actually set the cursor shape if the top window is our client's  */
/* or there are no windows open at all */
		if ((window_list==root_window)||(window_list->owner==clnt_pid))
			graf_mouse(m, (MFORM*)(pb->addrin[0]));
	}else{
		graf_mouse(m, NULL);	/* Any client can hide the mouse (required for redraws by clients */
								/* that aren't top) */
	}

/* Always return no error */
	pb->intout[0]=1;

	return XAC_DONE;
}

unsigned long XA_graf_handle(short clnt_pid, AESPB *pb)
{
	pb->intout[0]=P_handle;		/* graf_handle returns the physical workstation handle */
	pb->intout[1]=display.c_max_w;
	pb->intout[2]=display.c_max_h;
	pb->intout[3]=display.c_max_w+2;
	pb->intout[4]=display.c_max_h+2;
	
	return XAC_DONE;
}

unsigned long XA_graf_mkstate(short clnt_pid, AESPB *pb)
{
	short x,y,mb,k;
	
	vq_mouse(V_handle, &mb, &x, &y);
	vq_key_s(V_handle, &k);
	pb->intout[0]=1;
	pb->intout[1]=x;
	pb->intout[2]=y;
	pb->intout[3]=mb;
	pb->intout[4]=k;
	return TRUE;
}
	