/*
 * XaAES - XaAES Ain't the AES
 *
 * A multitasking AES replacement for MiNT
 *
 */

#include <OSBIND.H>
#include <MINTBIND.H>
#include <SIGNAL.H>
#include <FILESYS.H>
#include <VDI.H>
#include <unistd.h>			/* getcwd() */
#include <stdlib.h>			/* free() */
#include <stdio.h>
#include <string.h>
#include <limits.h>			/* PATH/NAME_MAX */
#include "XA_TYPES.H"
#include "XA_DEFS.H"
#include "XA_GLOBL.H"
#include "K_DEFS.H"
#include "FSELECT.H"

XA_CLIENT *fsel_owner;
AESPB *fsel_pb;

void handle_fsel(char *path,char *file)
{
	unsigned long rtn=XAC_DONE;
	char *t;

	for(t=path; *t; t++)
	{
		if(*t=='/')
			*t='\\';
	}

	if (path[0]!='u')
		sprintf((char*)fsel_pb->addrin[0],"u:%s\\",path);
	else
		sprintf((char*)fsel_pb->addrin[0],"%s\\",path);
		
	strcpy((char*)fsel_pb->addrin[1],file);

	DIAGS(("handle_fsel:path=%s,file=%s\n",(char*)fsel_pb->addrin[0],file));
	
	fsel_pb->intout[0]=1;
	fsel_pb->intout[1]=1;
	
	Fwrite(fsel_owner->clnt_pipe_wr,sizeof(unsigned long),&rtn);
}

void cancel_fsel(char *path, char *file)
{
	unsigned long rtn=XAC_DONE;
	
	fsel_pb->intout[0]=1;
	fsel_pb->intout[1]=0;

	Fwrite(fsel_owner->clnt_pipe_wr,sizeof(unsigned long),&rtn);
}

/*
	File selector interface routines
*/
unsigned long XA_fsel_input(short clnt_pid, AESPB *pb)
{
	XA_CLIENT *client=Pid2Client(clnt_pid);
	char *t;
	unsigned long dummy_rtn;

/* Loads of programs lock the screen and the mouse before doing fsel_
   so we've got to unlock them again to allow the XaAES windowed file selector
   to work.
*/
	
	if (update_lock==clnt_pid)
	{
		update_cnt=0;
		update_lock=FALSE;
		Psemaphore(3,UPDATE_LOCK,0L);
	}

	if (mouse_lock==clnt_pid)
	{
		mouse_cnt=0;
		mouse_lock=FALSE;
		Psemaphore(3,MOUSE_LOCK,0L);
	}

	Psemaphore(2,FSELECT_SEMAPHORE,-1L);	/* Wait for access to the fileselector */	

	DIAGS(("fsel_input:path=%s,file=%s\n",(char*)pb->addrin[0],(char*)pb->addrin[1]));

	t=(char*)pb->addrin[0];
	if((t[0]|32)!='u')
	{		
		if (t[1]==':')
		{
	 		while(*t)
				t[3]=*t++;
			t=(char*)pb->addrin[0];
			t[3]=t[3]|32;
		}else{
			while(*t)
				t[5]=*t++;
			t=(char*)pb->addrin[0];
			t[1]=':';
			t[2]='/';
			t[3]=(char)Dgetdrv()+'a';
		}
		t[0]='u';
	}

	for(; *t; t++)
	{
		if(*t=='\\')
			*t='/';
	}

	if (!Pdomain(-1))			/* For TOS domain programs, convert path to lower case */
	{
		for(t=(char*)pb->addrin[0]; *t; t++)
		{
			if((*t>='A')&&(*t<='Z'))
				*t|=32;
		}
		for(t=(char*)pb->addrin[1]; *t; t++)
		{
			if((*t>='A')&&(*t<='Z'))
				*t|=32;
		}
	}
	DIAGS(("modified path=%s\n",(char*)pb->addrin[0]));
	
	fsel_owner=client;
	fsel_pb=pb;
	
	open_fileselector((char*)pb->addrin[0], "", &handle_fsel, &cancel_fsel);
	
	Fread(client->clnt_pipe_rd,sizeof(unsigned long),&dummy_rtn);

	Psemaphore(3,FSELECT_SEMAPHORE,0L);		/* Release the file selector */

	return XAC_DONE;
}

unsigned long XA_fsel_exinput(short clnt_pid, AESPB *pb)
{
	XA_CLIENT *client=Pid2Client(clnt_pid);
	unsigned long dummy_rtn;
	char *t;
	
	if (update_lock==clnt_pid)
	{
		update_cnt=0;
		update_lock=FALSE;
		Psemaphore(3,UPDATE_LOCK,0L);
	}

	if (mouse_lock==clnt_pid)
	{
		mouse_cnt=0;
		mouse_lock=FALSE;
		Psemaphore(3,MOUSE_LOCK,0L);
	}
	
	Psemaphore(2,FSELECT_SEMAPHORE,-1L);

	DIAGS(("fsel_exinput:title=%s,path=%s,file=%s\n",(char*)pb->addrin[2],(char*)pb->addrin[0],(char*)pb->addrin[1]));

	t=(char*)pb->addrin[0];
	if ((t[1]==':')&&((t[0]|32)!='u'))
	{
		t[1]=t[0]|32;
		t[0]='/';
	}
	
	for(; *t; t++)
	{
		if(*t=='\\')
			*t='/';
	}

	if (!Pdomain(-1))			/* For TOS domain programs, convert path to lower case */
	{
		for(t=(char*)pb->addrin[0]; *t; t++)
		{
			if((*t>='A')&&(*t<='Z'))
				*t|=32;
		}
		for(t=(char*)pb->addrin[1]; *t; t++)
		{
			if((*t>='A')&&(*t<='Z'))
				*t|=32;
		}
	}

	DIAGS(("modified path=%s\n",(char*)pb->addrin[0]));
	
	fsel_owner=client;
	fsel_pb=pb;
	
	open_fileselector((char*)pb->addrin[0], (char*)pb->addrin[2], &handle_fsel, &cancel_fsel);
	
	Fread(client->clnt_pipe_rd,sizeof(unsigned long),&dummy_rtn);

	Psemaphore(3,FSELECT_SEMAPHORE,-1L);

	return XAC_DONE;
}
