//WestCoast Sunset by Blane Bizzaro

#include "colors.inc"


camera {
   location  <0, 10, 200>
   direction <0,  0,  -1>/*This seems to make the spherical shape of the
                           sky more noticable.*/
   up        <0,  1,   0>  
   right   <4/3,  0,   0>
   look_at   <0, 130, -300>/*I like the clouds at this location*/
}

//The water
plane { y, -10 
   pigment {color red 0.2 green 0.3 blue 1 }
   normal {
      waves 0.05
      frequency 5000
      scale 3000     
   }
   finish {reflection 0.7}
}
//Errant wave catcher
plane { y, -11 
   pigment { color red 0.2 green 0.3 blue 1 }
   finish { crand 0.05 ambient 1 diffuse 0 }
}


//The upper atmosphere
sphere { <0, 0, 0>, 700
   pigment {
      gradient y
      color_map {
         [0.0 color Orange ]//The sky at the horizon
         [0.5 color Blue ]//Mid-sky
         [1.0 color red 0.4 green 0 blue 0.4 ]//Top, sort of dark purple.           
      }
      scale <700, 700, 700>
      quick_color red 0.7  green 0.7 blue 1.0
   }
   finish {
      ambient 0.7 
      diffuse 0//This is so the clouds don't cast any shadows on the sky.   
   }
}

//Upper cloud layer
sphere { <0, 0, 0>, 650
   pigment {
      bozo
      turbulence 0.5
      color_map {
         [0,   0.6   color Clear
                     color Clear]
         [0.6, 0.8   color Clear
                     color White]
         [0.8, 1.001 color White
                     color red 0.9 green 0.8 blue 0.8]
      }
      quick_color red 0.7 green 0.7 blue 1
      scale <100, 20, 100>
   }
   finish {ambient 0.6 diffuse 0.2}/*Just a slightly higher ambient value
                                     than the lower cloud layer.*/
}
//lower cloud layer
sphere { <0, 0, 0> 600
   pigment {
     bozo 
     turbulence 0.9
     color_map {
       [ 0  0.3  color Clear
                 color Clear ]
       [ 0.3 0.7 color Clear
                 color White ]
       [ 0.7 1   color White
                 color red 0.9 green 0.8 blue 0.8 ]  
                 }
        quick_color red 0.7 green 0.7 blue 1
        scale <180, 120, 180>
            }
    finish { ambient 0.4 diffuse 0.3 }
         }
  
light_source { <0, -10, 210> color Red }/*This makes the clouds look
                                          orange.*/   

light_source { <0, 0, 100> color Orange/*This gives the clouds that are 
   spotlight                             in the center of the picture and
   point_at <0, 130, -300>               close to the horizon a slightly
   tightness 12                          brighter glow than the rest of 
   radius 1000                           the clouds.*/ 
   falloff 2000
}


