#declare Green_Phong = texture {
	pigment { color rgb <0.0,0.5,0.5> }
	normal { ripples 0.5 scale 0.1 }
	finish { phong 1.0 phong_size 5.0 }
}

#declare xmin  = 0
#declare xmax  = pi
#declare ymin  = 0  
#declare ymax  = 6*pi
#declare xiter = 11
#declare yiter = 61
#declare ix    = (xmax-xmin)/(xiter-1.0)
#declare iy    = (ymax-ymin)/(yiter-1.0)
#declare deltax = (xmax-xmin)/((xiter-1.0)*4.0) 
#declare deltay = (ymax-ymin)/((yiter-1.0)*4.0) 
#declare seashell = mesh {
  #declare xx = xmin    
  #while (xx<xmax)                        //outer loop
    #declare yy = ymin
    #while (yy<ymax)                      //inner loop
//POINTS
    #declare zn=-yy/18*sin(xx)*cos(yy)
    #declare xn=yy/18*sin(xx)*sin(yy)
    #declare yn=yy/18*cos(xx)+yy/6
    #declare xx=xx+deltax
    #declare zp=-yy/18*sin(xx)*cos(yy)
    #declare xp=yy/18*sin(xx)*sin(yy)
    #declare yp=yy/18*cos(xx)+yy/6
    #declare xx=xx-deltax
    #declare yy=yy+deltay
    #declare zq=-yy/18*sin(xx)*cos(yy)
    #declare xq=yy/18*sin(xx)*sin(yy)
    #declare yq=yy/18*cos(xx)+yy/6
    #declare yy=yy-deltay
    #declare vn=vcross(<xp-xn,yp-yn,zp-zn>,<xq-xn,yq-yn,zq-zn>)
    #declare n1=vnormalize(vn)
    #declare p1=<xn,yn,zn>


    #declare yy=yy+iy
    #declare zn=-yy/18*sin(xx)*cos(yy)
    #declare xn=yy/18*sin(xx)*sin(yy)
    #declare yn=yy/18*cos(xx)+yy/6
    #declare xx=xx+deltax
    #declare zp=-yy/18*sin(xx)*cos(yy)
    #declare xp=yy/18*sin(xx)*sin(yy)
    #declare yp=yy/18*cos(xx)+yy/6
    #declare xx=xx-deltax
    #declare yy=yy+deltay
    #declare zq=-yy/18*sin(xx)*cos(yy)
    #declare xq=yy/18*sin(xx)*sin(yy)
    #declare yq=yy/18*cos(xx)+yy/6
    #declare yy=yy-deltay
    #declare vn=vcross(<xp-xn,yp-yn,zp-zn>,<xq-xn,yq-yn,zq-zn>)
    #declare n2=vnormalize(vn)
    #declare p2=<xn,yn,zn>
    
    #declare xx=xx+ix
    #declare zn=-yy/18*sin(xx)*cos(yy)
    #declare xn=yy/18*sin(xx)*sin(yy)
    #declare yn=yy/18*cos(xx)+yy/6
    #declare xx=xx+deltax
    #declare zp=-yy/18*sin(xx)*cos(yy)
    #declare xp=yy/18*sin(xx)*sin(yy)
    #declare yp=yy/18*cos(xx)+yy/6
    #declare xx=xx-deltax
    #declare yy=yy+deltay
    #declare zq=-yy/18*sin(xx)*cos(yy)
    #declare xq=yy/18*sin(xx)*sin(yy)
    #declare yq=yy/18*cos(xx)+yy/6
    #declare yy=yy-deltay
    #declare vn=vcross(<xp-xn,yp-yn,zp-zn>,<xq-xn,yq-yn,zq-zn>)
    #declare n3=vnormalize(vn)
    #declare p3=<xn,yn,zn>
    
    #declare yy=yy-iy
    #declare zn=-yy/18*sin(xx)*cos(yy)
    #declare xn=yy/18*sin(xx)*sin(yy)
    #declare yn=yy/18*cos(xx)+yy/6
    #declare xx=xx+deltax
    #declare zp=-yy/18*sin(xx)*cos(yy)
    #declare xp=yy/18*sin(xx)*sin(yy)
    #declare yp=yy/18*cos(xx)+yy/6
    #declare xx=xx-deltax
    #declare yy=yy+deltay
    #declare zq=-yy/18*sin(xx)*cos(yy)
    #declare xq=yy/18*sin(xx)*sin(yy)
    #declare yq=yy/18*cos(xx)+yy/6
    #declare yy=yy-deltay
    #declare vn=vcross(<xp-xn,yp-yn,zp-zn>,<xq-xn,yq-yn,zq-zn>)
    #declare n4=vnormalize(vn)
    #declare p4=<xn,yn,zn>
    
    #declare xx=xx-ix
#if(!(p1.x=p2.x&p1.y=p2.y&p1.z=p2.z)|(p2.x=p3.x&p2.y=p3.y&p2.z=p3.z)|(p1.x=p3.x&p1.y=p3.y&p1.z=p3.z))
        smooth_triangle {
          p1,n1,
          p2,n2,
          p3,n3
         }
          
#end
#if(!(p1.x=p3.x&p1.y=p3.y&p1.z=p3.z)|(p3.x=p4.x&p3.y=p4.y&p3.z=p4.z)|(p1.x=p4.x&p1.y=p4.y&p1.z=p4.z))
        smooth_triangle{
          p1,n1,  
          p3,n3,   
          p4,n4 
         }
#end

      #declare yy = yy+iy
   #end                 //inner loop
   #declare xx = xx+ix
 #end                   //outer loop
 translate <0,-2,0>
 scale 1/2
}

object {
 seashell
 no_shadow
 texture { Green_Phong }
 }
 
//Lights, camera, action
camera
{ location  < 1, 1.25, -1>
  direction  1*z
  look_at   < 0, 0, 0>
} 

light_source { < 0, 1.25, -1> color rgb 1 }
light_source { < 1, 1.25, -1> color rgb 1 }

object { box{-2,2 inverse} pigment{color rgb 0.8} }
