/**************************************************************
	LZSS.C -- A Data Compression Program
	(tab = 4 spaces)
***************************************************************
	4/6/1989 Haruhiko Okumura
	Use, distribute, and modify this program freely.
	Please send me your improved versions.
		PC-VAN		SCIENCE
		NIFTY-Serve	PAF01022
		CompuServe	74050,1022
**************************************************************/

/*
 * Very slightly modified by A.D.Webber (e-mail: adw@ukc.ac.uk)
 * for use with LPAK (and compilation with HSC v1.40).
 *
 * Version 0.5(beta)
 * ** Only just works - could do with some proper fixing. **
 *
 *					Lloyd. (28/9/1993)
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <gemfast.h>
#include <osbind.h>

#define EXIT_SUCCESS 0
#define EXIT_FAILURE 1

#define N 4096			/* size of ring buffer */
#define F 18			/* upper limit for match_length */
#define THRESHOLD 2		/* encode string into position and length
				   if match_length is greater than this */
#define NIL N			/* index for root of binary search trees */

unsigned long int
	textsize = 0,		/* text size counter */
	codesize = 0,		/* code size counter */
	printcount = 0;		/* counter for reporting progress every 1K bytes */

/*
 * ring buffer of size N, with extra F-1 bytes to facilitate string
 * comparison
 */
unsigned char text_buf[N + F - 1];
/*
 * of longest match.  These are set by the InsertNode() procedure.
 */
int match_position, match_length,
/*
 * left & right children & parents -- These constitute binary search trees.
 */
    lson[N + 1], rson[N + 257], dad[N + 1];
FILE *infile, *outfile;		/* input & output files */
char inname[128], outname[128];

void
InitTree ()			/* initialize trees */
{
    int  i;

/*
 * For i = 0 to N - 1, rson[i] and lson[i] will be the right and left
 * children of node i.  These nodes need not be initialized.Also, dad[i]
 * is the parent of node i.  These are initialized to NIL (= N), which
 * stands for 'not used.' For i = 0 to 255, rson[N + i + 1] is the root of
 * the tree for strings that begin with character i.  These are initialized
 * to NIL.  Note there are 256 trees.
 */
    for (i = N + 1; i <= N + 256; i++)
    {
	rson[i] = NIL;
    }
    for (i = 0; i < N; i++)
    {
	dad[i] = NIL;
    }
}

/*
 * Inserts string of length F, text_buf[r..r+F-1], into one of the trees
 * (text_buf[r]'th tree) and returns the longest-match position and length
 * via the global variables match_position and match_length.  If
 * match_length = F, then removes the old node in favor of the new one,
 * because the old one will be deleted sooner.  Note r plays double role,
 * as tree node and position in buffer.
 */
void
InsertNode (r)
int r;
{
    int  i, p, cmp;
    unsigned char *key;

    cmp = 1;
    key = &text_buf[r];
    p = N + 1 + key[0];
    rson[r] = lson[r] = NIL;
    match_length = 0;
    for ( ; ; )
    {
	if (cmp >= 0)
	{
	    if (rson[p] != NIL)
	    {
		p = rson[p];
	    }
	    else
	    {
		rson[p] = r;
		dad[r] = p;
		return;
	    }
	}
	else
	{
	    if (lson[p] != NIL)
	    {
		p = lson[p];
	    }
	    else
	    {
		lson[p] = r;
		dad[r] = p;
		return;
	    }
	}
	for (i = 1; i < F; i++)
	{
	    if ((cmp = key[i] - text_buf[p + i]) != 0)
	    {
		break;
	    }
	}
	if (i > match_length)
	{
	    match_position = p;
	    if ((match_length = i) >= F)
	    {
		break;
	    }
	}
    }
    dad[r] = dad[p];
    lson[r] = lson[p];
    rson[r] = rson[p];
    dad[lson[p]] = r;
    dad[rson[p]] = r;
    if (rson[dad[p]] == p)
    {
	rson[dad[p]] = r;
    }
    else
    {
	lson[dad[p]] = r;
    }
    dad[p] = NIL;	/* remove p */
}

void
DeleteNode (p)		/* deletes node p from tree */
int p;
{
    int  q;
	
    if (dad[p] == NIL)
    {
	return;  /* not in tree */
    }
    if (rson[p] == NIL)
    {
	q = lson[p];
    }
    else
    {
	if (lson[p] == NIL)
	{
	    q = rson[p];
	}
	else
	{
	    q = lson[p];
	    if (rson[q] != NIL)
	    {
		do
		{
		    q = rson[q];
		}
		while (rson[q] != NIL);
		rson[dad[q]] = lson[q];
		dad[lson[q]] = dad[q];
		lson[q] = lson[p];
		dad[lson[p]] = q;
	    }
	    rson[q] = rson[p];
	    dad[rson[p]] = q;
	}
    }
    dad[q] = dad[p];
    if (rson[dad[p]] == p)
    {
	rson[dad[p]] = q;
    }
    else
    {
	lson[dad[p]] = q;
    }
    dad[p] = NIL;
}

void
Encode ()
{
    unsigned long ilen;
    int  i, c, len, r, s, last_match_length, code_buf_ptr;
    unsigned char code_buf[17], mask;
	
    InitTree();		/* initialize trees */
/*
 * code_buf[1..16] saves eight units of code, and
 * code_buf[0] works as eight flags, "1" representing that the unit
 * is an unencoded letter (1 byte), "0" a position-and-length pair
 * (2 bytes).  Thus, eight units require at most 16 bytes of code.
 */
    code_buf[0] = 0;
    code_buf_ptr = mask = 1;
    s = 0;
    r = N - F;
/*
 * Clear the buffer with any character that will appear often.
 */
    for (i = s; i < r; i++)
    {
	text_buf[i] = ' ';
    }
    for (ilen = 0L; (c = fgetc(infile)) != EOF; ilen++);
    fclose(infile);
    infile = fopen(inname, "rb");
    if (infile == NULL)
    {
	frm_qtext("Cannot load 3%s3", inname);
	return;
    }
    printf("Original = %ld\n", ilen);
    fputc('L', outfile);	/* save I.D */
    fputc('P', outfile);
    fputc('A', outfile);
    fputc('K', outfile);
    fputc((int) ((ilen >> 24) & 0xff), outfile);	/* save Length */
    fputc((int) ((ilen >> 16) & 0xff), outfile);
    fputc((int) ((ilen >> 8) & 0xff), outfile);
    fputc((int) (ilen & 0xff), outfile);
/*
 * Read F bytes into the last F bytes of the buffer
 */
    for (len = 0; len < F && (c = getc(infile)) != EOF; len++)
    {
	text_buf[r + len] = c;
    }
    if ((textsize = len) == 0)
    {
	return;  /* text of size zero */
    }
/*
 * Insert the F strings, each of which begins with one or more 'space'
 * characters.  Note the order in which these strings are inserted.  This
 * way, degenerate trees will be less likely to occur.
 */
    for (i = 1; i <= F; i++)
    {
	InsertNode(r - i);
    }
/*
 * Finally, insert the whole string just read.  The global variables
 * match_length and match_position are set.
 */
    InsertNode(r);
    do
    {
	if (match_length > len)
	{
	    match_length = len;	/* match_length may be spuriously long near the end of text. */
	}
	if (match_length <= THRESHOLD)
	{
	    match_length = 1;	/* Not long enough match.  Send one byte. */
	    code_buf[0] |= mask;	/* 'send one byte' flag */
	    code_buf[code_buf_ptr++] = text_buf[r];	/* Send uncoded. */
	}
	else
	{
	    code_buf[code_buf_ptr++] = (unsigned char) match_position;
	    code_buf[code_buf_ptr++] = (unsigned char)
/*
 * Send position and length pair. Note match_length > THRESHOLD.
 */
	    (((match_position >> 4) & 0xf0) | (match_length - (THRESHOLD + 1)));
	}
	if ((mask <<= 1) == 0)	/* Shift mask left one bit. */
	{
	    for (i = 0; i < code_buf_ptr; i++)  /* Send at most 8 units of */
	    {
		putc(code_buf[i], outfile);     /* code together */
	    }
	    codesize += code_buf_ptr;
	    code_buf[0] = 0;
	    code_buf_ptr = mask = 1;
	}
	last_match_length = match_length;
	for (i = 0; i < last_match_length && (c = getc(infile)) != EOF; i++)
	{
	    DeleteNode(s);			/* Delete old strings and */
	    text_buf[s] = c;			/* read new bytes */
/*
 * If the position is near the end of buffer, extend the buffer to make
 * string comparison easier.
 */
	    if (s < F - 1)
	    {
		text_buf[s + N] = c;
	    }
	    s = (s + 1) & (N - 1);
/*
 * Since this is a ring buffer, increment the position modulo N.
 */
	    r = (r + 1) & (N - 1);
	    InsertNode(r);	/* Register the string in text_buf[r..r+F-1] */
	}
	if ((textsize += i) > printcount)
	{
/*
 * Reports progress each time the textsize exceeds multiples of 1024.
 */
	    printf("%12ld\r", textsize);
	    printcount += 1024;
	}
	while (i++ < last_match_length)
	{			/* After the end of text, */
	    DeleteNode(s);	/* no need to read, but */
	    s = (s + 1) & (N - 1);
	    r = (r + 1) & (N - 1);
	    if (--len)
	    {
		InsertNode(r);	/* buffer may not be empty. */
	    }
	}
    }
    while (len > 0);	/* until length of string to be processed is zero */
    if (code_buf_ptr > 1)
    {			/* Send remaining code. */
	for (i = 0; i < code_buf_ptr; i++)
	{
	    putc(code_buf[i], outfile);
	}
	codesize += code_buf_ptr;
    }
    printf("In : %ld bytes\n", textsize);	/* Encoding is done. */
    printf("Out: %ld bytes\n", codesize);
    printf("Saved: %ld bytes\n", textsize - codesize);
}

void
Decode ()	/* Just the reverse of Encode(). */
{
    unsigned long olen;
    int  i, j, k, r, c;
    int c1, c2, c3, c4;
    unsigned int  flags;
	
    c1 = fgetc(infile); 
    c2 = fgetc(infile); 
    c3 = fgetc(infile); 
    c4 = fgetc(infile); 
    if (c1 != 'L' || c2 != 'P' || c3 != 'A' || c4 != 'K')
    {
	fseek(infile, 0L, 0);
	return;
    }
    c1 = fgetc(infile); 
    c2 = fgetc(infile); 
    c3 = fgetc(infile); 
    c4 = fgetc(infile); 
    olen = ((c1 & 0xff) << 24) | ((c2 & 0xff) << 16) | ((c3 & 0xff) << 8) | (c4 & 0xff); 
    printf("O/P length should be %ld\n", olen);
    for (i = 0; i < N - F; i++)
    {
	text_buf[i] = ' ';
    }
    r = N - F;
    flags = 0;
    for ( ; ; )
    {
	if (((flags >>= 1) & 256) == 0)
	{
	    if ((c = getc(infile)) == EOF)
	    {
		break;
	    }
	    flags = c | 0xff00;		/* uses higher byte cleverly */
	}							/* to count eight */
	if (flags & 1)
	{
	    if ((c = getc(infile)) == EOF)
	    {
		break;
	    }
	    putc(c, outfile);
	    text_buf[r++] = c;
	    r &= (N - 1);
	}
	else
	{
	    if ((i = getc(infile)) == EOF)
	    {
	        break;
	    }
	    if ((j = getc(infile)) == EOF)
	    {
		break;
	    }
	    i |= ((j & 0xf0) << 4);
	    j = (j & 0x0f) + THRESHOLD;
	    for (k = 0; k <= j; k++)
	    {
		c = text_buf[(i + k) & (N - 1)];
		putc(c, outfile);
		text_buf[r++] = c;
		r &= (N - 1);
	    }
	}
    }
}

int
main (argc, argv)
int argc;
char *argv[];
{
    int mode, 
	fsel_return1, fs_button1,
	fsel_return2, fs_button2;

    appl_init();	
    {
	mode = form_alert(1, "[1][ Lloyd's compressed | filesystem! ][ Pack | Unpack ]");
	strcpy(inname, "FILE.IN");
	strcpy(outname, "FILE.OUT");
    	fsel_return1 = fsl_dialog(FSL_NORMAL, inname, NULL, NULL, "Source File:");
	if (fsel_return1 != 0)
	{
    	    fsel_return2 = fsl_dialog(FSL_NORMAL, outname, NULL, NULL, "Destination File:");
	}
	if (fsel_return1 == 0 || fsel_return2 == 0)
	{
	    appl_exit();
	    return(EXIT_SUCCESS);
	}
	if (strcmp(inname, outname) == 0)
	{
	    form_alert(1,"[1][ Select different input | and output file names!][ OK ]");
	}
	else
	{
	    infile = fopen(inname, "rb");
	    if (infile == NULL)
	    {
		frm_qtext("Cannot load 1%s#1", inname);
	    }
	    else
	    {
	        outfile = fopen(outname, "wb");
	        if (outfile == NULL)
		{
		    fclose(infile);
		    frm_qtext("Cannot load 2%s2", outname);
		}
		else
		{
		    if (mode == 1)
		    {
			Encode();
		    }
		    else
		    {
			Decode();
		    }
		    fclose(infile);
		    fclose(outfile);
		}
	    }
	}
    }
    return EXIT_FAILURE;
}