/* This file is part of dvi2bitmap; see README for copyrights and licence */

/* This is merely an interface to the kpathsea library */
#include "verbosity.h"

/**
 * Abstracts access to the <code>kpathsea</code> library.  This class
 * provides at singleton object which can service requests to the library.
 */
class KarlPathSearcher {
 public:
    const char *find (const char *font, int resolution);
    static KarlPathSearcher* getInstance(const char *name=0,
					 const int basedpi=0);
    static verbosities verbosity (const verbosities level);
    static const char *version_string (void);
    /**
     * Sets the name of the invoking program.  This acts as the
     * default for the initialising <code>name</code> parameter to
     * method {@link #getInstance}
     * @param name the name of the invoking program
     */
    static void setProgramName(const char* name) {
	default_program_name_ = name;
    }

 private:
    ~KarlPathSearcher();
    KarlPathSearcher(const char *name, const int basedpi);
    static verbosities verbosity_;
    static KarlPathSearcher* instance_;
    static const char* default_program_name_;
};
