/* 
 *	FIG : Facility for Interactive Generation of figures
 *
 *	Copyright (c) 1988 by Supoj Sutanthavibul (supoj@sally.UTEXAS.EDU)
 *	March 1988.
 *
 *	%W%	%G%
 *
 *	Written by baron@cs.ucla.edu
*/
#include <suntool/sunview.h>
#include <sys/stat.h>
#include <stdio.h>
#include <errno.h>
#include "object.h"
#include "paintop.h"
#include "func.h"

#define			PROMPT		1
#define			NO_PROMPT	0

extern F_compound	objects, scrap_objects, saved_objects, object_tails;
extern char		*do_name_expansion();

extern struct pixwin	*canvas_pixwin;
extern int		canvas_swfd;
extern struct cursor	null_cursor;
extern struct cursor	wait_cursor, crosshair_cursor;
extern int		foreground_color, background_color;
extern int		num_object;

			paste_selected();
int			paste();

extern			(*canvas_kbd_proc)();
extern			(*canvas_locmove_proc)();
extern			(*canvas_leftbut_proc)();
extern			(*canvas_middlebut_proc)();
extern			(*canvas_rightbut_proc)();
extern			null_proc();
extern			set_popupmenu();
extern F_line		*copy_line();
extern F_arc		*copy_arc();
extern F_ellipse	*copy_ellipse();
extern F_text		*copy_text();
extern F_spline		*copy_spline();
extern F_compound	*copy_compound();
extern char		*sys_errlist[];
extern int		sys_nerr, errno;

clear_scrap()
{
	if (scrap_objects.arcs != NULL)
		free_arc(&scrap_objects.arcs);
	if (scrap_objects.compounds != NULL)
		free_compound(&scrap_objects.compounds);
	if (scrap_objects.ellipses != NULL)
		free_ellipse(&scrap_objects.ellipses);
	if (scrap_objects.lines != NULL)
		free_line(&scrap_objects.lines);
	if (scrap_objects.splines != NULL)
		free_spline(&scrap_objects.splines);
	if (scrap_objects.texts != NULL)
		free_text(&scrap_objects.texts);
	scrap_objects.arcs = NULL;
	scrap_objects.compounds = NULL;
	scrap_objects.ellipses = NULL;
	scrap_objects.lines = NULL;
	scrap_objects.splines = NULL;
	scrap_objects.texts = NULL;
}

no_scrap_object()
{
	if (scrap_objects.texts != NULL) return(0);
	if (scrap_objects.lines != NULL) return(0);
	if (scrap_objects.ellipses != NULL) return(0);
	if (scrap_objects.splines != NULL) return(0);
	if (scrap_objects.arcs != NULL) return(0);
	if (scrap_objects.compounds != NULL) return(0);
	return(1);
}

write_file_scrap(file_name, prompt, objects)
F_compound	*objects;
char	*file_name;
int	prompt;
{
	FILE		*fp;
	struct stat	file_status;
	char		string[180];

	if (*file_name == 0) {
	    put_msg("No file.  Abort save operation.");
	    return(-1);
	    }
	if (stat(file_name, &file_status) == 0) { /* file exists */
	    if (file_status.st_mode & S_IFDIR) {
		put_msg("\"%s\" is a directory", file_name);
		return(-1);
		}
	    if (file_status.st_mode & S_IWRITE) { /* writing is permitted */
		if (file_status.st_uid != geteuid()) {
		    put_msg("\"%s\" permission is denied", file_name);
		    return(-1);
		    }
		else if (prompt) {
		    sprintf(string, "\"%s\" File exists. Please COMFIRM overwrite or CANCEL.", file_name);
		    if (wmgr_confirm(canvas_swfd, string) != -1) {
			put_msg("Cancel save");
			return(-1);
			}
		    }
		}
	    else {
		put_msg("\"%s\" File is read only", file_name);
		return(-1);
		}
	    }
	else if (errno != ENOENT)
	    return(-1);  /* file does exist but stat fails */

	if ((fp = fopen(file_name, "w")) == NULL) {
	    blink_msg();
	    put_msg("Couldn't open file %s, %s", file_name, sys_errlist[errno]);
	    return(-1);
	    }
	else {
	    num_object = 0;
	    write_objects(fp, objects);
	    put_msg("Object saved in \"%s\"", file_name);
	    return(0);
	    }
	}

write_scrap(file)
char	*file;
{
	int		rc;

	set_temp_cursor(&wait_cursor);
	file = do_name_expansion(file);
	if (file == NULL)
	    return 1;
	rc = write_file_scrap(file, PROMPT, &scrap_objects);
	reset_cursor();
	return rc;
}

read_to_scrap(file)
char	*file;
{
	int		s;
	F_compound	c;

	if (*file == 0) {
	    put_msg("Empty name");
	    return;
	    }
	file = do_name_expansion(file);
	if (file == NULL)
	    return;

	c.arcs = NULL;
	c.compounds = NULL;
	c.ellipses = NULL;
	c.lines = NULL;
	c.splines = NULL;
	c.texts = NULL;
	c.next = NULL;
	set_temp_cursor(&wait_cursor);
	s = read_fig(file, &c);
	if (s == 0) {		/* Successful read */
	    clear_scrap();
	    scrap_objects = c;
	    put_msg("File \"%s\" %d objects read to scrap", file, num_object);
	    }
	else if (s > 0)
	    read_fail_message(file, s);
	reset_cursor();
}

paste_selected()
{
	canvas_kbd_proc = null_proc;
	canvas_locmove_proc = null_proc;
	canvas_leftbut_proc = paste;
	canvas_middlebut_proc = null_proc;
	canvas_rightbut_proc = set_popupmenu;
	set_cursor(&crosshair_cursor);
	reset_action_on();
}

paste(x, y)
{
	F_line		*l, *line;
	F_spline	*s, *spline;
	F_ellipse	*e, *ellipse;
	F_text		*t, *text;
	F_arc		*a, *arc;
	F_compound	*f, *compound, temp;
	F_compound	*c = &scrap_objects;
	int		xmin, ymin, xmax, ymax;

	if (no_scrap_object()) {
		put_msg("The scrap is empty");
		return;
	}
	temp.arcs = NULL;
	temp.compounds = NULL;
	temp.ellipses = NULL;
	temp.lines = NULL;
	temp.splines = NULL;
	temp.texts = NULL;
	temp.next = NULL;
	compound_bound(c, &xmin, &ymin, &xmax, &ymax);
	for (l = c->lines; l != NULL; l = l->next) {
	    line = copy_line(l);
	    translate_line(line, x-xmin, y-ymax);
	    insert_line(&temp.lines, line);
	    }
	for (s = c->splines; s != NULL; s = s->next) {
	    spline = copy_spline(s);
	    translate_spline(spline, x-xmin, y-ymax);
	    insert_spline(&temp.splines, spline);
	   } 
	for (a = c->arcs; a != NULL; a = a->next) {
	    arc = copy_arc(a);
	    translate_arc(arc, x-xmin, y-ymax);
	    insert_arc(&temp.arcs, arc);
	   } 
	for (e = c->ellipses; e != NULL; e = e->next) {
	    ellipse = copy_ellipse(e);
	    translate_ellipse(ellipse, x-xmin, y-ymax);
	    insert_ellipse(&temp.ellipses, ellipse);
	    }
	for (t = c->texts; t != NULL; t = t->next) {
	    text = copy_text(t);
	    translate_text(text, x-xmin, y-ymax);
	    insert_text(&temp.texts, text);
	    }
	for (f = c->compounds; f != NULL; f = f->next) {
	    compound = copy_compound(f);
	    translate_compound(compound, x-xmin, y-ymax);
	    insert_compound(&temp.compounds, compound);
	    }
	saved_objects = temp;
	pw_batch_on(canvas_pixwin);
	draw_compound(&temp);
	show_compoundbb(&temp);
	pw_batch_off(canvas_pixwin);
	tail(&objects, &object_tails);
	append_objects(&objects, &saved_objects, &object_tails);
	set_action_object(F_CREATE, O_ALL_OBJECT);
	set_modifiedflag();
}
