/* 
 *	FIG : Facility for Interactive Generation of figures
 *
 *	Copyright (c) 1985 by Supoj Sutanthavibul (supoj@sally.UTEXAS.EDU)
 *	January 1985.
 *	1st revision : Aug 1985.
 *
 *	%W%	%G%
*/
#include <pixrect/pixrect_hs.h>
#include <sunwindow/window_hs.h>
#include <suntool/tool_struct.h>
#include <suntool/icon.h>
#include <suntool/window.h>
#include <suntool/frame.h>
#include <suntool/canvas.h>
#include <stdio.h>
#include "const.h"
#undef	canvas_pixwin

/***************** import global variables and routines *******************/

extern struct cursor	*cur_cursor;
extern int		cur_command;
extern int		errno;
extern int		action_on;     /* tracker.c */
extern int		magnet_mode;
extern int		zoom_factor;
extern int		DEBUG;

extern Frame		base_frame;
extern Canvas		panel_frame;
extern Canvas		topruler_frame;
extern Canvas		canvas_frame;
extern struct pixwin	*canvas_pixwin;
extern int		canvas_swfd;
extern int		receiving_msg;
extern			null_proc();
extern			(*canvas_kbd_proc)();
extern			(*canvas_locmove_proc)();
extern			(*canvas_leftbut_proc)();
extern			(*canvas_middlebut_proc)();
extern			(*canvas_rightbut_proc)();
extern			null_proc();
extern			set_popupmenu();
extern			redisplay_canvas();

extern			show_sideruler(), show_topruler();


/*********************** local variables and routines ************************/


static			canvas_selected();

int
make_canvas_frame(rightof_frame)
Frame		rightof_frame;
{
	canvas_frame = window_create(base_frame, CANVAS,
	    WIN_RIGHT_OF,		rightof_frame,
	    WIN_BELOW,			topruler_frame,
	    WIN_WIDTH,			CANVS_WIDTH,
	    WIN_HEIGHT,			CANVS_HEIGHT,
	    WIN_CURSOR,			cur_cursor,
	    WIN_EVENT_PROC,		canvas_selected,
	    WIN_CONSUME_KBD_EVENTS,	WIN_ASCII_EVENTS, 0,
	    CANVAS_FAST_MONO,		TRUE,
	    0);
	if (canvas_frame == 0) exit(1);
	canvas_swfd = window_fd(canvas_frame);
	canvas_pixwin = (Pixwin *)window_get(canvas_frame, CANVAS_PIXWIN);

	init_grid();
	canvas_leftbut_proc = null_proc;
	canvas_middlebut_proc = null_proc;
	canvas_rightbut_proc = null_proc;
	canvas_kbd_proc = canvas_locmove_proc = null_proc;
	}

static
canvas_selected(win, event)
Window win;
Event  *event;
{
	int		x, y;
	static int	last_x = -1, last_y = -1;	
	static int	last_event_id = 0;

	if (DEBUG) {
	    if (event_id(event) != LOC_MOVE  ||  last_event_id != LOC_MOVE)
		printf("canvas_selected: %s code = %d\n",
		   win_inputnegevent(event)? "neg": "pos", event_id(event));
	    last_event_id = event_id(event);
	    }

	if (win_inputnegevent(event))
	    return;

	x = event->ie_locx;
	y = event->ie_locy;
	if (zoom_factor != 1) {
	    x = CANVS_CENTER_X + iround(x - CANVS_CENTER_X, zoom_factor);
	    y = CANVS_CENTER_Y + iround(y - CANVS_CENTER_Y, zoom_factor);
	    }
	if (magnet_mode) {
	    x = zoomed_x(iround(unzoomed_x(x) + 1, 5) - 1);
	    y = zoomed_y(iround(unzoomed_y(y) + 1, 5) - 1);
	    }
	switch(event->ie_code) {
	    case LOC_MOVE:
	    case LOC_RGNENTER:
	    case LOC_WINENTER:
		if (last_x != x  ||  last_y != y) {
		    set_rulermark(x, y);
		    (*canvas_locmove_proc)(x, y);
		    last_x = x;
		    last_y = y;
		    }
		break;
	    case MS_LEFT:
		clear_message();
		canvas_leftbut_proc(x, y, event->ie_locx, event->ie_locy, event);
		break;
	    case MS_MIDDLE:
		clear_message();
		canvas_middlebut_proc(x,y, event->ie_locx,event->ie_locy, event);
		break;
	    case MS_RIGHT:
		canvas_rightbut_proc(event);
		break;
	    case WIN_RESIZE:
		redisplay_canvas();
		break;
	    default:
		if (event->ie_code <= ASCII_LAST)
		    canvas_kbd_proc(event->ie_code);
		break;
	    }
	}

int
iround(x, n)
{
	if (x >= 0)
	    return    n * ((x+n/2) / n);
	else
	    return  - n * (((-x)+n/2) / n);
	}

clear_canvas()
{
	pw_writebackground(canvas_pixwin, 0, 0, 2048, 2048, PIX_SRC);
	}
