////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Copyright 1999-2005, Hitek Software LLC
//http://www.sharewarejustice.com
//This source code is subject to change without any prior notice.  
//The source code is subject to a non-disclosure agreement. 
//No part of this source code may be reproduced, transmitted to other Shareware Developers or any other person, without the written permission of Hitek Software LLC.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Data;
using Microsoft.Win32;
using System.Net;
using System.Globalization;
using System.Web;

namespace Tracker
{
    public class CollectData
    {
        //posting methods
        public String POST = "POST";
        public String GET = "GET";

        public String GetParameterString(String method, String authorid, String authorpwd, String mode, String program, String version, String key, String key2)
        {
            try
            {
                ArrayList keys = new ArrayList();
                ArrayList values = new ArrayList();
                //add required author data
                //if method = GET, authorid and authorpwd = "***"
                if (method==GET)
                {
                    keys.Add("authorid"); values.Add("***");
                    keys.Add("authorpwd"); values.Add("***");
                }
                if (method==POST) //for POST mode, send in authorid and authorpwd
                {
                    keys.Add("authorid"); values.Add(authorid);
                    keys.Add("authorpwd"); values.Add(authorpwd);
                }
                keys.Add("mode"); values.Add(mode);
                keys.Add("program"); values.Add(program);
                keys.Add("version"); values.Add(version);
                keys.Add("key"); values.Add(key);
                keys.Add("key2"); values.Add(key2);
                //add recommended data 
                //this should be noted in license agreement
                keys.Add("owner"); values.Add(GetRegisteredOwner());
                keys.Add("organization"); values.Add(GetRegisteredOrganization());
                keys.Add("country"); values.Add(GetCountry());
                keys.Add("userdate"); values.Add(GetUserdate());
                keys.Add("timezone"); values.Add(GetTimezone());
                keys.Add("ip_internal"); values.Add(GetIP());
                keys.Add("computer"); values.Add(GetComputer());
                keys.Add("username"); values.Add(GetUsername());
                keys.Add("domain"); values.Add(GetDomain());
                keys.Add("os"); values.Add(GetOS());
                //add optional data added by author from user collected input
                //for example from a user registration form
                keys.Add("author1"); values.Add("");
                keys.Add("author2"); values.Add("");
                keys.Add("author3"); values.Add("");
                keys.Add("author4"); values.Add("");
                keys.Add("author5"); values.Add("");
                keys.Add("author6"); values.Add("");
                keys.Add("author7"); values.Add("");
                keys.Add("author8"); values.Add("");
                keys.Add("author9"); values.Add("");
                keys.Add("author10"); values.Add("");
                //data that authors can collect from system
                //this information should be noted in license agreement
                keys.Add("tracker1"); values.Add("");
                keys.Add("tracker2"); values.Add("");
                keys.Add("tracker3"); values.Add("");
                keys.Add("tracker4"); values.Add("");
                keys.Add("tracker5"); values.Add("");
                keys.Add("tracker6"); values.Add("");
                keys.Add("tracker7"); values.Add("");
                keys.Add("tracker8"); values.Add("");
                keys.Add("tracker9"); values.Add("");
                keys.Add("tracker10"); values.Add("");
                //add feedback email
                keys.Add("fbEmail"); values.Add("support@your_company.com");

                String parString = "";
                for (int i = 0; i < keys.Count; i++)
                {
                    //very important to do this..
                    values[i] = HttpUtility.UrlEncode(values[i].ToString());
                    parString += keys[i] + "=" + values[i] + "&";
                }
                parString = parString.Substring(0, parString.Length - 1);
                return parString;
            }
            catch (Exception e)
            {
                Console.WriteLine("Error = " + e.Message);
                return null;
            }
        }

        private String GetRegisteredOwner()
        {
            try
            {
                RegistryKey key = Registry.LocalMachine;
                key = key.OpenSubKey("SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion");
                if (key != null)
                {
                    Object value = key.GetValue("RegisteredOwner");
                    key.Close();
                    return value.ToString();
                }
                else
                {
                    return "-";
                }
            }
            catch (Exception e)
            {
                Console.WriteLine("Error = " + e.Message);
                return "-";
            }
        }

        private String GetRegisteredOrganization()
        {
            try
            {
                RegistryKey key = Registry.LocalMachine;
                key = key.OpenSubKey("SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion");
                if (key != null)
                {
                    Object value = key.GetValue("RegisteredOrganization");
                    key.Close();
                    return value.ToString();
                }
                else
                {
                    return "-";
                }
            }
            catch (Exception e)
            {
                Console.WriteLine("Error = " + e.Message);
                return "-";
            }
        }

        private String GetUserdate()
        {
            try
            {
                DateTime now = DateTime.Now;
                String date = now.ToLongDateString();
                String time = now.ToLongTimeString();
                return date + " " + time;
            }
            catch (Exception e)
            {
                Console.WriteLine("Error = " + e.Message);
                return "-";
            }
        }

        private String GetCountry()
        {
            try
            {
                RegionInfo ri = RegionInfo.CurrentRegion;
                return ri.DisplayName;
            }
            catch (Exception e)
            {
                Console.WriteLine("Error = " + e.Message);
                return "-";
            }
        }    

        private String GetTimezone()
        {
            try
            {
                TimeZone localZone = TimeZone.CurrentTimeZone;
                return localZone.StandardName;
            }
            catch (Exception e)
            {
                Console.WriteLine("Error = " + e.Message);
                return "-";
            }
        }

        private String GetComputer()
        {
            try
            {
                return Dns.GetHostName(); 
            }
            catch (Exception e)
            {
                Console.WriteLine("Error = " + e.Message);
                return "-";
            }
        }

        private String GetUsername()
        {
            try
            {
                return System.Environment.UserName;
            }
            catch (Exception e)
            {
                Console.WriteLine("Error = " + e.Message);
                return "-";
            }
        }

        private String GetDomain()
        {
            try
            {
                return System.Environment.UserDomainName;
            }
            catch (Exception e)
            {
                Console.WriteLine("Error = " + e.Message);
                return "-";
            }
        }

        private String GetIP()
        {
            try
            {
                String localhostname = Dns.GetHostName();
                IPHostEntry entries = Dns.GetHostEntry(localhostname);
                IPAddress[] addr = entries.AddressList;
                return addr[0].ToString();
            }
            catch (Exception e)
            {
                Console.WriteLine("Error = " + e.Message);
                return "-";
            }
        }
        
        private String GetOS()
        {
            try
            {
                return System.Environment.OSVersion.ToString();
            }
            catch (Exception e)
            {
                Console.WriteLine("Error = " + e.Message);
                return "-";
            }
        }
        
    }
}
