////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Copyright 1999-2005, Hitek Software LLC
//http://www.sharewarejustice.com
//This source code is subject to change without any prior notice.  
//The source code is subject to a non-disclosure agreement. 
//No part of this source code may be reproduced, transmitted to other Shareware Developers or any other person, without the written permission of Hitek Software LLC.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// PostData.cpp: implementation of the PostData class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "afxinet.h"
#include "Tracker.h"
#include "PostData.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

using namespace std;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

PostData::PostData()
{

}

PostData::~PostData()
{

}

int PostData::GetMethod(CString parString)
{
	int nRetCode = 0;
	CInternetSession session;
	CHttpConnection* pServer = NULL;
	CHttpFile* pFile = NULL;
	DWORD   dwAccessType = PRE_CONFIG_INTERNET_ACCESS;
	DWORD dwHttpRequestFlags = INTERNET_FLAG_EXISTING_CONNECT | INTERNET_FLAG_NO_AUTO_REDIRECT;
	const TCHAR szHeaders[] = _T("Accept: text/*\r\nUser-Agent: TRACKER TEST\r\n");

	try
	{
		CString postCgi = "http://www.sharewarejustice.com/cgi-bin/test.pl";
		postCgi = postCgi + "?" + parString;
		cout << (LPCTSTR)postCgi << endl;

		CString strServerName;
		CString strObject;
		INTERNET_PORT nPort;
		DWORD dwServiceType;

		// check to see if this is a reasonable URL
		if (!AfxParseURL((LPCTSTR)postCgi, dwServiceType, strServerName, strObject, nPort) ||dwServiceType != INTERNET_SERVICE_HTTP)
		{cerr << _T("Error: can only use URLs beginning with http://") << endl;}		
		
		pServer = session.GetHttpConnection(strServerName, nPort);
		pFile = pServer->OpenRequest(CHttpConnection::HTTP_VERB_GET,strObject, NULL, 1, NULL, NULL, dwHttpRequestFlags);
		pFile->AddRequestHeaders(szHeaders);
		pFile->SendRequest();

		DWORD dwRet;
		pFile->QueryInfoStatusCode(dwRet);
		cerr << _T("Status Code is ") << dwRet << endl;

		TCHAR sz[1024];
		while (pFile->ReadString(sz, 1023))
		{cout << sz;}
		
	}
	catch (CInternetException* pEx)
	{
		TCHAR szErr[1024];
		pEx->GetErrorMessage(szErr, 1024);
		cerr << _T("Error: (") << pEx->m_dwError << _T(") ");
		cerr << szErr << endl;
		nRetCode = 2;
		pEx->Delete();
	}
	catch(CException* e)
	{
		TCHAR szErr[1024];
		e->GetErrorMessage(szErr, 1024);
		cerr << szErr << endl;
		e->Delete();
	}
	if (pFile != NULL){delete pFile;}
	if (pServer != NULL){delete pServer;}
	session.Close();

	return nRetCode;
}

