'////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
'//Copyright 1999-2005, Hitek Software LLC
'//http://www.sharewarejustice.com
'//This source code is subject to change without any prior notice.  
'//The source code is subject to a non-disclosure agreement. 
'//No part of this source code may be reproduced, transmitted to other Shareware Developers or any other person, without the written permission of Hitek Software LLC.
'////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

Imports Microsoft.Win32
Imports System.Web
Imports System.Windows.Forms
Imports System.Net


Public Class CollectData
    Public GET_ As String = "GET"
    Public POST As String = "POST"

    Public Function GetParameterString(ByVal method As String, ByVal authorid As String, ByVal authorpwd As String, ByVal mode As String, ByVal program As String, ByVal version As String, ByVal key As String, ByVal key2 As String) As String
        Try
            Dim keys As ArrayList = New ArrayList()
            Dim values As ArrayList = New ArrayList()
            'add required author data
            If (method = GET_) Then
                'if method = GET, authorid and authorpwd = "***"
                keys.Add("authorid")
                values.Add("***")
                keys.Add("authorpwd")
                values.Add("***")
            ElseIf (method = POST) Then
                'if method = POST, send in authorid and authorpwd
                keys.Add("authorid")
                values.Add(authorid)
                keys.Add("authorpwd")
                values.Add(authorpwd)
            End If
            keys.Add("mode")
            values.Add(mode)
            keys.Add("program")
            values.Add(program)
            keys.Add("version")
            values.Add(version)
            keys.Add("key")
            values.Add(key)
            keys.Add("key2")
            values.Add(key2)
            'add recommended data 
            'this should be noted in license agreement
            keys.Add("owner")
            values.Add(GetRegisteredOwner())
            keys.Add("organization")
            values.Add(GetRegisteredOrganization())
            keys.Add("country")
            values.Add(GetCountry())
            keys.Add("userdate")
            values.Add(GetUserdate())
            keys.Add("timezone")
            values.Add(GetTimezone())
            keys.Add("ip_internal")
            values.Add(GetIP())
            keys.Add("computer")
            values.Add(GetComputer())
            keys.Add("username")
            values.Add(GetUsername())
            keys.Add("domain")
            values.Add(GetDomain())
            keys.Add("os")
            values.Add(GetOS())
            'add optional data added by author from user collected input
            'for example from a user registration form
            keys.Add("author1")
            values.Add("")
            keys.Add("author2")
            values.Add("")
            keys.Add("author3")
            values.Add("")
            keys.Add("author4")
            values.Add("")
            keys.Add("author5")
            values.Add("")
            keys.Add("author6")
            values.Add("")
            keys.Add("author7")
            values.Add("")
            keys.Add("author8")
            values.Add("")
            keys.Add("author9")
            values.Add("")
            keys.Add("author10")
            values.Add("")
            'data that authors can collect from system
            'this information should be noted in license agreement
            keys.Add("tracker1")
            values.Add("")
            keys.Add("tracker2")
            values.Add("")
            keys.Add("tracker3")
            values.Add("")
            keys.Add("tracker4")
            values.Add("")
            keys.Add("tracker5")
            values.Add("")
            keys.Add("tracker6")
            values.Add("")
            keys.Add("tracker7")
            values.Add("")
            keys.Add("tracker8")
            values.Add("")
            keys.Add("tracker9")
            values.Add("")
            keys.Add("tracker10")
            values.Add("")
            'add feedback email
            keys.Add("fbEmail")
            values.Add("support@your_company.com")


            Dim parString As String = ""
            For i As Integer = 0 To (keys.Count - 1)
                values.Item(i) = HttpUtility.UrlEncode(values.Item(i))
                parString += keys.Item(i) + "=" + values.Item(i) + "&"
            Next i

            parString = parString.Substring(0, parString.Length - 1)
            Return parString

        Catch exp As System.Exception
            Console.WriteLine("Error = " + exp.Message())
        End Try

        Return ""
    End Function

    Private Function GetRegisteredOwner() As String
        Try
            Dim key As RegistryKey = Registry.LocalMachine
            key = key.OpenSubKey("SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion")
            Dim value As String = key.GetValue("RegisteredOwner")
            key.Close()
            Return value.ToString()
        Catch exp As System.Exception
            Console.WriteLine("Error = " + exp.Message())
            Return "-"
        End Try
    End Function

    Private Function GetRegisteredOrganization()
        Try
            Dim key As RegistryKey = Registry.LocalMachine
            key = key.OpenSubKey("SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion")
                Dim value As String = key.GetValue("RegisteredOrganization")
            key.Close()
            Return value.ToString()
        Catch exp As System.Exception
            Console.WriteLine("Error = " + exp.Message())
            Return "-"
        End Try
    End Function

    Private Function GetUserdate() As String
        Try
            Dim Now As DateTime = DateTime.Now
            Dim datenow As String = Now.ToLongDateString()
            Dim timenow As String = Now.ToLongTimeString()
            Return datenow + " " + timenow
        Catch exp As System.Exception
            Console.WriteLine("Error = " + exp.Message())
            Return "-"
        End Try
    End Function

    Private Function GetCountry() As String
        Try
            Dim ri As Globalization.RegionInfo = Globalization.RegionInfo.CurrentRegion
            Return ri.DisplayName
            Return "-"
        Catch exp As System.Exception
            Console.WriteLine("Error = " + exp.Message())
            Return "-"
        End Try
    End Function

    Private Function GetTimezone() As String
        Try
            Dim localZone As TimeZone = TimeZone.CurrentTimeZone
            Return localZone.StandardName
        Catch exp As System.Exception
            Console.WriteLine("Error = " + exp.Message())
            Return "-"
        End Try
    End Function

    Private Function GetComputer() As String
        Try
            Return SystemInformation.ComputerName
        Catch exp As System.Exception
            Console.WriteLine("Error = " + exp.Message())
            Return "-"
        End Try
    End Function

    Private Function GetUsername() As String
        Try
            Return System.Environment.UserName
        Catch exp As System.Exception
            Console.WriteLine("Error = " + exp.Message())
            Return "-"
        End Try
    End Function

    Private Function GetDomain() As String
        Try
            Return System.Environment.UserDomainName
        Catch exp As System.Exception
            Console.WriteLine("Error = " + exp.Message())
            Return "-"
        End Try
    End Function

    Private Function GetIP() As String
        Try
            Dim localhostname As String = Dns.GetHostName()
            Dim entries As IPHostEntry = Dns.GetHostEntry(localhostname)
            Return entries.AddressList(0).ToString()
        Catch exp As System.Exception
            Console.WriteLine("Error = " + exp.Message())
            Return "-"
        End Try
    End Function

    Private Function GetOS() As String
        Try
            Return System.Environment.OSVersion.ToString()
        Catch exp As System.Exception
            Console.WriteLine("Error = " + exp.Message())
            Return "-"
        End Try
    End Function

    


End Class
