#include "stdAfx.h"
#include "CollectData.h"
using namespace System;
using namespace Microsoft::Win32;
using namespace System::Collections;
using namespace System::Collections::Generic;
using namespace System::Text;
using namespace System::Data;
using namespace System::Net;
using namespace System::Globalization;
using namespace System::Web;

CollectData::CollectData(void)
{
}

CollectData::~CollectData(void)
{
}



System::String^ CollectData::GetParameterString(System::String^ method , System::String^ authorid , System::String^ authorpwd , System::String^ mode , System::String^ program , System::String^ version , System::String^ key , System::String^ key2)
{
	try
	{
		ArrayList^ keys = gcnew ArrayList;
		ArrayList^ values = gcnew ArrayList();
		//add required author data
		//if method = GET, authorid and authorpwd = "***"
		if (method=="GET")
		{
			keys->Add("authorid"); values->Add("***");
			keys->Add("authorpwd"); values->Add("***");
		}
		else //for POST mode, send in authorid and authorpwd
		{
			keys->Add("authorid"); values->Add(authorid);
			keys->Add("authorpwd"); values->Add(authorpwd);
		}
		keys->Add("mode"); values->Add(mode);
		keys->Add("program"); values->Add(program);
		keys->Add("version"); values->Add(version);
		keys->Add("key"); values->Add(key);
		keys->Add("key2"); values->Add(key2);
		//add recommended data 
		//this should be noted in license agreement
		keys->Add("owner"); values->Add(GetRegisteredOwner());
		keys->Add("organization"); values->Add(GetRegisteredOrganization());
		keys->Add("country"); values->Add(GetCountry());
		keys->Add("userdate"); values->Add(GetUserdate());
		keys->Add("timezone"); values->Add(GetTimezone());
		keys->Add("ip_internal"); values->Add(GetIP());
		keys->Add("computer"); values->Add(GetComputer());
		keys->Add("username"); values->Add(GetUsername());
		keys->Add("domain"); values->Add(GetDomain());
		keys->Add("os"); values->Add(GetOS());
		//add optional data added by author from user collected input
		//for example from a user registration form
		keys->Add("author1"); values->Add("");
		keys->Add("author2"); values->Add("");
		keys->Add("author3"); values->Add("");
		keys->Add("author4"); values->Add("");
		keys->Add("author5"); values->Add("");
		keys->Add("author6"); values->Add("");
		keys->Add("author7"); values->Add("");
		keys->Add("author8"); values->Add("");
		keys->Add("author9"); values->Add("");
		keys->Add("author10"); values->Add("");
		//data that authors can collect from system
		//this information should be noted in license agreement
		keys->Add("tracker1"); values->Add("");
		keys->Add("tracker2"); values->Add("");
		keys->Add("tracker3"); values->Add("");
		keys->Add("tracker4"); values->Add("");
		keys->Add("tracker5"); values->Add("");
		keys->Add("tracker6"); values->Add("");
		keys->Add("tracker7"); values->Add("");
		keys->Add("tracker8"); values->Add("");
		keys->Add("tracker9"); values->Add("");
		keys->Add("tracker10"); values->Add("");
		//add feedback email
		keys->Add("fbEmail");values->Add("support@your_company.com");

		String^ parString = "";
		for (int i = 0; i < keys->Count; i++)
		{
			//very important to do this...
			values[i] = HttpUtility::UrlEncode(values[i]->ToString());
			parString += keys[i] + "=" + values[i] + "&";
		}
		parString = parString->Substring(0, parString->Length - 1);
		return parString;
	}
	catch(System::Exception^ e)
	{
		Console::WriteLine(e);
		return "-";
	}
}

System::String^ CollectData::GetRegisteredOwner(void)
{
	try
	{
		RegistryKey^ key = Registry::LocalMachine;
		key = key->OpenSubKey("SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion");
        Object^ value = key->GetValue("RegisteredOwner");
		key->Close();
		return value->ToString();       
	}
	catch(System::Exception^ e)
	{
		Console::WriteLine(e);
		return "-";
	}
}

System::String^ CollectData::GetRegisteredOrganization(void)
{
	try
	{
		RegistryKey^ key = Registry::LocalMachine;
		key = key->OpenSubKey("SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion");
        Object^ value = key->GetValue("RegisteredOrganization");
		key->Close();
		return value->ToString();  
	}
	catch(System::Exception^ e)
	{
		Console::WriteLine(e);
		return "-";
	}
}

System::String^ CollectData::GetUserdate(void)
{
	try
	{
		DateTime now = DateTime::Now;
		String^ date = now.ToLongDateString();
		String^ time = now.ToLongTimeString();
		return date + " " + time;
	}
	catch(System::Exception^ e)
	{
		Console::WriteLine(e);
		return "-";
	}
}

System::String^ CollectData::GetCountry(void)
{
	try
	{
		RegionInfo^ ri = RegionInfo::CurrentRegion;
        return ri->DisplayName;	
	}
	catch(System::Exception^ e)
	{
		Console::WriteLine(e);
		return "-";
	}
}

System::String^ CollectData::GetTimezone(void)
{
	try
	{
		TimeZone^ localZone = TimeZone::CurrentTimeZone;
        return localZone->StandardName;
	}
	catch(System::Exception^ e)
	{
		Console::WriteLine(e);
		return "-";
	}
}

System::String^ CollectData::GetComputer(void)
{
	try
	{
		return Dns::GetHostName(); 
	}
	catch(System::Exception^ e)
	{
		Console::WriteLine(e);
		return "-";
	}
}

System::String^ CollectData::GetUsername(void)
{
	try
	{
		return System::Environment::UserName;
	}
	catch(System::Exception^ e)
	{
		Console::WriteLine(e);
		return "-";
	}
}

System::String^ CollectData::GetDomain(void)
{
	try
	{
		return System::Environment::UserDomainName;
	}
	catch(System::Exception^ e)
	{
		Console::WriteLine(e);
		return "-";
	}
}

System::String^ CollectData::GetIP(void)
{
	try
	{
		String^ localhostname = Dns::GetHostName();
		IPHostEntry^ entries = Dns::GetHostEntry(localhostname);
		return entries->AddressList[0]->ToString();
	}
	catch(System::Exception^ e)
	{
		Console::WriteLine(e);
		return "-";
	}
}

System::String^ CollectData::GetOS(void)
{
	try
	{
		return System::Environment::OSVersion->ToString();
	}
	catch(System::Exception^ e)
	{
		Console::WriteLine(e);
		return "-";
	}
}
