package com.sciapp.demo;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import com.sciapp.common.gui.*;
/**
 *
 */
public class Demo extends JApplet {
	public static final String VERSION = "2.3";
/**
 *
 */
public Demo() {
}
/**
 * Returns information about this applet.
 * @return a string of information about this applet
 */
public String getAppletInfo() {
	return "Table Library Demo\n" + 
		"\n" + 
		"Applet showing the features of the Table Library API";
}
/**
 * Initializes the applet.
 */
public void init() {
	super.init();

	Container c = getContentPane();
	init(c);

	SkinManager.instance().setMainComponent(this);

	resize(700, 500);
}
/**
 *
 */
public static void init(Container c) {
	JTabbedPane tab = new JTabbedPane();

	TableDemoPanel tablePanel = new TableDemoPanel();
	TreeTableDemoPanel treeTablePanel = new TreeTableDemoPanel();
	JTableDemoPanel customTablePanel = new JTableDemoPanel();

	tab.addTab("Table", tablePanel);
	tab.addTab("TreeTable", treeTablePanel);
	tab.addTab("JTable", customTablePanel);

	JPanel topPanel = new JPanel();
	topPanel.setBorder(new javax.swing.border.TitledBorder(" Visualizations "));
	topPanel.setLayout(new BoxLayout(topPanel, BoxLayout.X_AXIS));

	SkinPanel sp = new SkinPanel();
	sp.add(new JLabel("Look & Feel"), 0);
	sp.setBorder(null);

	final JCheckBox fader = new JCheckBox("Use faders", false);
	fader.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
			boolean use = fader.isSelected();
			GUIFader.setEnabled(use);
		}
	});

	topPanel.add(sp);
	topPanel.add(fader);

	c.add(topPanel, BorderLayout.NORTH);
	c.add(tab, BorderLayout.CENTER);

	//setFading
	GUIFader.setEnabled(fader.isSelected());
}
/**
 *
 */
public static void main(String[] args) {
	JFrame frame = new JFrame("Table Libary v" + VERSION + " Demo");
	frame.addWindowListener(new WindowAdapter() {
		public void windowClosing(WindowEvent e) {
			System.exit(0);
		}
	});

	try {
		Container c = frame.getContentPane();
		init(c);

		frame.setSize(700, 500);
		//center
		Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension d = frame.getSize();
		frame.setLocation((screenSize.width - d.width) / 2,(screenSize.height - d.height) / 2);

		//set skin
		SkinManager.instance().setMainComponent(frame);

		//set visible
		frame.setVisible(true);
	} catch (Throwable t) {
		System.out.println(t);
	}
}
}
