package com.sciapp.demo;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.*;

import com.sciapp.table.*;
import com.sciapp.filter.FilterTablePanel;
import com.sciapp.renderers.*;
import com.sciapp.filter.*;
/**
 *
 */
public abstract class AbstractDemoPanel extends JPanel {
	//feature components
	public JButton addButton;
	public JTextField rowField;
	public JButton removeButton;
	public JCheckBox showLastColumn;
	public JCheckBox singleMode;
	public JCheckBox autoCreateFilter;
	public JCheckBox reorderFirstColumn;

	//table
	public JTable table;
	public SortTableModel sortTableModel; //a reference to the sort table model.
	public ListTableModel model; //a reference to the data model of the table.

	//various
	public FilterHeaderModel ft;
	public DataFeeder dataFeeder;

	protected ActionHandler actionHandler = new ActionHandler();

	private class ActionHandler implements ActionListener {
		public void actionPerformed(java.awt.event.ActionEvent e) {
			action(e);
		};
	}
/**
 *
 */
public AbstractDemoPanel() {
	this(new PersonTableModel(), new PersonDataFeeder());
}
/**
 *
 */
public AbstractDemoPanel(ListTableModel dataModel, DataFeeder dataFeeder) {

	this.dataFeeder = dataFeeder;

	setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));

	JPanel tablePanel = createTablePanel(dataModel);
	JPanel tableFeaturePanel = createTableFeaturePanel();

	add(tablePanel);
	add(tableFeaturePanel);
}
/**
 *
 */
protected void action(ActionEvent e) {
	Object source = e.getSource();

	if (source == addButton) {
		addRows();
	}
	else if (source == removeButton) {
		int rows[] = table.getSelectedRows();
		model.removeRows(rows);
	}
	else if (source == showLastColumn) {
		boolean selected = showLastColumn.isSelected();
		if (table instanceof AdvancedJTable) ((AdvancedJTable) table).setShowDummyColumn(selected);
	}
	else if (source == singleMode) {
		boolean selected = singleMode.isSelected();
		sortTableModel.setSortMode(
			selected ? SortTableModel.MULTI_SORT : SortTableModel.SINGLE_SORT);
	}
	else if (source == autoCreateFilter) {
		boolean isAuto = autoCreateFilter.isSelected();
		ft.setAutoCreateAllFilters(isAuto);
	}
	else if (source == reorderFirstColumn) {
		boolean isReorder = reorderFirstColumn.isSelected();
		if (table instanceof AdvancedJTable) ((AdvancedJTable) table).setFirstColumnFixed(isReorder);
	}
}
/**
 *
 */
public void addRows() {
	String text = rowField.getText();
	if (text == null) return;

	int rows = parseStringToInt(text);
	addRows(rows);
}
/**
 *
 */
public void addRows(int rows) {
	if (dataFeeder == null) return;

	if (rows == 1) {
		Object o = dataFeeder.createObject();
		model.addRow(o);
	}
	else if (rows > 1) {
		java.util.List list = dataFeeder.createObjects(rows);
		model.addRows(list);
	}
}
/**
 *
 */
protected abstract JTable createTable();
/**
 *
 */
protected JPanel createTableFeaturePanel() {
	JPanel p = new JPanel();

	//border
	Border comp =
		BorderFactory.createCompoundBorder(
			new TitledBorder(" Features "),
			BorderFactory.createEmptyBorder(5, 10, 0, 20));
	p.setBorder(comp);

	p.setLayout(new BoxLayout(p, BoxLayout.Y_AXIS));

	//add rows stuff
	addButton = new JButton("Add row(s)");
	addButton.addActionListener(actionHandler);

	rowField = new JTextField(6);
	rowField.addKeyListener(new KeyAdapter() {
		public void keyTyped(KeyEvent e) {
			if (e.getKeyChar() == KeyEvent.VK_ENTER) addRows();
		}
	});
	Dimension d = rowField.getMaximumSize();
	d.height = rowField.getPreferredSize().height;
	rowField.setMaximumSize(d);

	JPanel addPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
	addPanel.add(addButton);
	addPanel.add(rowField);
	addPanel.add(new JLabel("Enter the number of rows you want to add to the table."));
	p.add(addPanel);

	//remove stuff
	removeButton = new JButton("Remove row(s)");
	removeButton.addActionListener(actionHandler);
	JPanel removePanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
	removePanel.add(removeButton);
	removePanel.add(new JLabel("Remove the selected row(s)."));
	p.add(removePanel);

	//last column
	showLastColumn = new JCheckBox("Show Last Column", true);
	showLastColumn.addActionListener(actionHandler);
	JPanel column = new JPanel(new FlowLayout(FlowLayout.LEFT));
	column.add(showLastColumn);

	//sort mode
	singleMode = new JCheckBox("Multiple Column Sort Mode", true);
	singleMode.addActionListener(actionHandler);
	JPanel sortMode = new JPanel(new FlowLayout(FlowLayout.LEFT));
	sortMode.add(singleMode);

	//autocreate filter
	autoCreateFilter = new JCheckBox("Auto-create filter", true);
	autoCreateFilter.addActionListener(actionHandler);
	JPanel autoCreate = new JPanel(new FlowLayout(FlowLayout.LEFT));
	autoCreate.add(autoCreateFilter);

	//reorder first column
	reorderFirstColumn = new JCheckBox("First column fixed", false);
	reorderFirstColumn.addActionListener(actionHandler);
	JPanel reorderFirst = new JPanel(new FlowLayout(FlowLayout.LEFT));
	boolean isFixed = table instanceof AdvancedJTable ? ((AdvancedJTable) table).isFirstColumnFixed() : false;
	reorderFirstColumn.setSelected(isFixed);
	reorderFirst.add(reorderFirstColumn);

	//add above checkboxes to the panel
	JPanel panel = new JPanel(new FlowLayout(FlowLayout.LEFT));
	panel.add(column);
	panel.add(sortMode);
	panel.add(autoCreate);
	panel.add(reorderFirst);
	p.add(panel);

	return p;
}
/**
 *
 */
protected abstract ListTableModel createTableModel(ListTableModel model);
/**
 *
 */
public JPanel createTablePanel(ListTableModel dataModel) {
	JPanel p = new JPanel();
	p.setLayout(new BorderLayout());

	//border
	Border comp =
		BorderFactory.createCompoundBorder(
			new TitledBorder(" Table "),
			BorderFactory.createEmptyBorder(0, 0, 0, 0));
	p.setBorder(comp);

	//set data
	ListTableModel otm = dataModel;

	//models
	ListTableModel ltm = otm;
	FilterTableModel ftm = new FilterTableModel(ltm);
	SortTableModel stm = new SortTableModel(ftm);

	//set class variables
	sortTableModel = stm;
	model = createTableModel(stm);

	//table
	table = createTable();
	table.setModel(model);
	JScrollPane scroller = new AdvancedJScrollPane(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
	scroller.setViewportView(table);
	stm.setHeader(table.getTableHeader());

	//customize date renderer
	javax.swing.table.TableCellRenderer dr = (javax.swing.table.TableCellRenderer) table.getDefaultRenderer(java.util.Date.class);
	if (dr instanceof DateRenderer) {
		((DateRenderer) dr).setDateFormat(java.text.DateFormat.getDateInstance());
	}

	//add some data
	addRows(2);

	//set alternate color in renderers
	Color c = new Color(194, 194, 194);
	if (table instanceof AdvancedJTable) ((AdvancedJTable) table).setOddColor(c);

	//add to panel
	p.add(scroller, BorderLayout.CENTER);

	//create a PopupFilter
	ft = new CustomPopupFilterHeaderModel();
	ft.setTableHeader((com.sciapp.filter.FilterTableHeader)table.getTableHeader());
	ft.attachToTable(table);

	return p;
}
/**
 *
 */
public static int parseStringToInt(String str) {
	int ret = -1;
	if (str == null) return ret;
	try {
		ret = Integer.parseInt(str);
	} catch (NumberFormatException e){
	}
	return ret;
}
}
