/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class IniFile {
    Hashtable sections = new Hashtable();

    public IniFile() {
    }

    public IniFile(String string) throws FileNotFoundException {
        this();
        this.load(string);
    }

    public IniFile(URL uRL) throws IOException {
        this();
        this.load(uRL.openStream());
    }

    public IniFile(InputStream inputStream) throws IOException {
        this();
        this.load(inputStream);
    }

    public void setKeyValue(String string, String string2, String string3) {
        try {
            this.getSection(string).put(string2.toLowerCase(), string3);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    public Hashtable getSections() {
        return this.sections;
    }

    public Hashtable getSection(String string) {
        return (Hashtable)this.sections.get(string.toLowerCase());
    }

    public boolean isNullOrEmpty(String string, String string2) {
        String string3 = this.getKeyValue(string, string2);
        return string3 == null || string3.length() == 0;
    }

    public String getKeyValue(String string, String string2) {
        try {
            return (String)this.getSection(string).get(string2.toLowerCase());
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public int getKeyIntValue(String string, String string2) {
        return this.getKeyIntValue(string, string2, 0);
    }

    public int getKeyIntValue(String string, String string2, int n) {
        String string3 = this.getKeyValue(string, string2.toLowerCase());
        if (string3 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String[][] getKeysAndValues(String string) {
        Hashtable hashtable = this.getSection(string);
        if (hashtable == null) {
            return null;
        }
        String[][] stringArray = new String[hashtable.size()][2];
        int n = 0;
        Enumeration enumeration = hashtable.keys();
        Enumeration enumeration2 = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            stringArray[n][0] = (String)enumeration.nextElement();
            stringArray[n][1] = (String)enumeration2.nextElement();
            ++n;
        }
        return stringArray;
    }

    public String getSectionWhere(String[][] stringArray) {
        String string = null;
        Enumeration enumeration = this.getSections().keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            boolean bl = true;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                if (this.getKeyValue(string2, stringArray[i][0]) != null && this.getKeyValue(string2, stringArray[i][0]).equals(stringArray[i][1])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            string = string2;
            break;
        }
        return string;
    }

    public void load(String string) throws FileNotFoundException {
        this.load(new FileInputStream(string));
    }

    public void save(String string) throws IOException {
        this.save(new FileOutputStream(string));
    }

    public void load(InputStream inputStream) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            Hashtable<String, String> hashtable = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith(";") || string.startsWith("#")) continue;
                if (string.startsWith("[")) {
                    String string2 = string.substring(1, string.indexOf("]")).toLowerCase();
                    hashtable = (Hashtable<String, String>)this.sections.get(string2);
                    if (hashtable != null) continue;
                    hashtable = new Hashtable<String, String>();
                    this.sections.put(string2, hashtable);
                    continue;
                }
                if (string.indexOf("=") == -1 || hashtable == null) continue;
                String string3 = string.substring(0, string.indexOf("=")).trim().toLowerCase();
                String string4 = string.substring(string.indexOf("=") + 1).trim();
                hashtable.put(string3, string4);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void save(OutputStream outputStream) {
        try {
            PrintWriter printWriter = new PrintWriter(outputStream);
            Enumeration enumeration = this.sections.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                printWriter.println("[" + string + "]");
                Enumeration enumeration2 = this.getSection(string).keys();
                Enumeration enumeration3 = this.getSection(string).elements();
                while (enumeration2.hasMoreElements()) {
                    printWriter.println(enumeration2.nextElement() + "=" + enumeration3.nextElement());
                }
            }
            printWriter.flush();
            printWriter.close();
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addSection(String string) {
        this.sections.put(string.toLowerCase(), new Hashtable());
    }

    public void removeSection(String string) {
    }

    public static void main(String[] stringArray) throws Exception {
        new IniFile().load(new FileInputStream(stringArray[0]));
    }
}

