/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.util;

import com.l2fprod.contrib.freehep.PanelArtistUtilities;
import com.l2fprod.util.HSBFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.RectangularShape;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RGBImageFilter;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;

public final class ImageUtils
implements SwingConstants {
    public static final Component producer = new Component(){};
    public static final int PAINT_NORMAL = 0;
    public static final int PAINT_STRETCH = 1;
    public static final int PAINT_TILE = 2;
    public static final int PAINT_CENTERED = 3;
    public static final int PAINT_NONE = 5;
    public static final int TRANSPARENT_RED = 255;
    public static final int TRANSPARENT_GREEN = 0;
    public static final int TRANSPARENT_BLUE = 255;
    public static final int TRANSPARENT_TO_REMOVE;
    public static final int TRANSPARENT_PIXEL;

    private Color decodeColor(String string) {
        int n = 0;
        try {
            n = string.startsWith("0x") ? Integer.parseInt(string.substring(2), 16) : (string.startsWith("#") ? Integer.parseInt(string.substring(1), 16) : (string.startsWith("0") && string.length() > 1 ? Integer.parseInt(string.substring(1), 8) : Integer.parseInt(string, 10)));
            return new Color(n);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static ImageIcon getDisabledIcon(ImageIcon imageIcon) {
        return ImageUtils.getDisabledIcon(imageIcon.getImage());
    }

    public static ImageIcon getDisabledIcon(Image image) {
        return new ImageIcon(ImageUtils.getDisabledImage(image));
    }

    public static Image getDisabledImage(Image image) {
        if (image == null) {
            return null;
        }
        return ImageUtils.filterImage(new GrayFilter(true, 75), image);
    }

    public static Image filterImage(RGBImageFilter rGBImageFilter, Image image) {
        return producer.createImage(new FilteredImageSource(image.getSource(), rGBImageFilter));
    }

    public static Image rotateImage(Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int[] nArray2 = new int[n2 * n];
        int n3 = 0;
        for (int i = n; i > 0; --i) {
            for (int j = 0; j < n2; ++j) {
                nArray2[n3] = nArray[i + n * j - 1];
                ++n3;
            }
        }
        return ImageUtils.convertBytesToImage(producer, nArray2, n2, n);
    }

    public static Image rotateImage(Image image, double d) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int[] nArray2 = new int[n * n2];
        int n3 = 0;
        double d2 = -d / 57.29577951308232;
        double d3 = Math.cos(d2);
        double d4 = Math.sin(d2);
        int n4 = n >> 1;
        int n5 = n2 >> 1;
        for (int i = -n5; i < n5; ++i) {
            for (int j = -n4; j < n4; ++j) {
                int n6 = n4 + (int)((double)j * d3 - (double)i * d4);
                int n7 = n5 + (int)((double)j * d4 + (double)i * d3);
                nArray2[n3++] = n6 > 0 && n6 < n && n7 > 0 && n7 < n2 ? nArray[n * n7 + n6] : nArray[0];
            }
        }
        return producer.createImage(new MemoryImageSource(n, n2, nArray2, 0, n));
    }

    public static Image convertBytesToImage(Component component, int[] nArray, int n, int n2) {
        return component.createImage(new MemoryImageSource(n, n2, nArray, 0, n));
    }

    public static void paint(Component component, Graphics graphics, Image image) {
        ImageUtils.paint(component, graphics, image, true);
    }

    public static void paint(Component component, Graphics graphics, Image image, int n) {
        ImageUtils.paint(component, graphics, image, true, n);
    }

    public static void paint(Component component, Graphics graphics, Image image, boolean bl) {
        ImageUtils.paint(component, graphics, image, bl, 1);
    }

    public static void paint(Component component, Graphics graphics, Image image, boolean bl, int n) {
        ImageUtils.paint(component, graphics, image, 0, 0, component.getWidth(), component.getHeight(), bl, n);
    }

    public static void paint(Component component, Graphics graphics, Image image, int n, int n2, int n3, int n4) {
        ImageUtils.paint(component, graphics, image, n, n2, n3, n4, true, 1);
    }

    public static void paint(Component component, Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5) {
        ImageUtils.paint(component, graphics, image, n, n2, n3, n4, true, n5);
    }

    public static void paint(Component component, Graphics graphics, Image image, int n, int n2, int n3, int n4, boolean bl, int n5) {
        if (image == null) {
            return;
        }
        Color color = component.getBackground();
        if (component instanceof JComponent && ((JComponent)component).isOpaque() && color != null && !(color instanceof ColorUIResource)) {
            HSBFilter hSBFilter = new HSBFilter(color);
            image = component.createImage(new FilteredImageSource(image.getSource(), hSBFilter));
            image = ImageUtils.toBufferedImage(image);
        }
        switch (n5) {
            case 0: {
                graphics.drawImage(image, n, n2, component);
                break;
            }
            case 1: {
                graphics.drawImage(image, n, n2, n3, n4, component);
                break;
            }
            case 2: {
                ImageUtils.paintTile(component, graphics, image, n, n2, n3, n4, bl);
                break;
            }
            case 3: {
                graphics.drawImage(image, (n3 - image.getWidth(component)) / 2, (n4 - image.getHeight(component)) / 2, component);
                break;
            }
        }
    }

    public static void paintWindow(Component component, Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl, int n9) {
        int n10;
        int n11;
        int n12;
        BufferedImage bufferedImage = new BufferedImage(n3 += n, n4 += n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setClip(0, 0, n3, n4);
        switch (n9) {
            case 0: {
                graphics2D.drawImage(image, n, n2, component);
                break;
            }
            case 1: {
                graphics2D.drawImage(image, n, n2, n3, n4, component);
                break;
            }
            case 2: {
                ImageUtils.paintTile(component, graphics2D, image, n, n2, n3, n4, bl);
                break;
            }
            case 3: {
                graphics2D.drawImage(image, (n3 - image.getWidth(component)) / 2, (n4 - image.getHeight(component)) / 2, component);
                break;
            }
        }
        WritableRaster writableRaster = bufferedImage.getAlphaRaster();
        for (n12 = 0; n12 < n5; ++n12) {
            for (n11 = 0; n11 < n4; ++n11) {
                writableRaster.setSample(n12, n11, 0, 0);
            }
        }
        for (n12 = n5 + n7; n12 < n3; ++n12) {
            for (n11 = 0; n11 < n4; ++n11) {
                writableRaster.setSample(n12, n11, 0, 0);
            }
        }
        n12 = n5 + n7;
        for (n11 = n5; n11 < n12; ++n11) {
            for (n10 = n6 + n8; n10 < n4; ++n10) {
                writableRaster.setSample(n11, n10, 0, 0);
            }
        }
        for (n11 = n5; n11 < n12; ++n11) {
            for (n10 = 0; n10 < n6; ++n10) {
                writableRaster.setSample(n11, n10, 0, 0);
            }
        }
        graphics.drawImage(bufferedImage, 0, 0, n3, n4, component);
    }

    public static void paintTile(Component component, Graphics graphics, Image image, int n, int n2, int n3, int n4) {
        ImageUtils.paintTile(component, graphics, image, n, n2, n3, n4, true);
    }

    public static Image transparent(Image image) {
        return ImageUtils.toBufferedImage(image);
    }

    public static Image grab(Image image, int n, int n2, int n3, int n4) {
        if (n3 * n4 <= 0) {
            return null;
        }
        if (image instanceof BufferedImage) {
            return ((BufferedImage)image).getSubimage(n, n2, n3, n4);
        }
        int[] nArray = new int[n3 * n4];
        PixelGrabber pixelGrabber = new PixelGrabber(image, n, n2, n3, n4, nArray, 0, n3);
        try {
            pixelGrabber.grabPixels();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n5 = nArray[i * n3 + j];
                int n6 = n5 >> 24 & 0xFF;
                int n7 = n5 >> 16 & 0xFF;
                int n8 = n5 >> 8 & 0xFF;
                int n9 = n5 & 0xFF;
                if (n7 != 255 || n8 != 0 || n9 != 255) continue;
                nArray[i * n3 + j] = TRANSPARENT_PIXEL;
            }
        }
        Image image2 = producer.createImage(new MemoryImageSource(n3, n4, nArray, 0, n3));
        return ImageUtils.toBufferedImage(image2);
    }

    public static Image buildTile(Image image, int n) {
        int n2;
        int n3 = image.getWidth(producer);
        int n4 = image.getHeight(producer);
        int[] nArray = new int[n3 * n4];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n3, n4, nArray, 0, n3);
        try {
            pixelGrabber.grabPixels();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int[] nArray2 = new int[nArray.length * n];
        for (int i = 0; i < n4; ++i) {
            for (n2 = 0; n2 < n; ++n2) {
                System.arraycopy(nArray, n3 * i, nArray2, n3 * n * i + n3 * n2, n3);
            }
        }
        nArray = nArray2;
        int[] nArray3 = new int[nArray.length * n];
        for (n2 = 0; n2 < n; ++n2) {
            System.arraycopy(nArray, 0, nArray3, n2 * nArray.length, nArray.length);
        }
        return producer.createImage(new MemoryImageSource(n3 * n, n4 * n, nArray3, 0, n3 * n));
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image == null) {
            return null;
        }
        image = new ImageIcon(image).getImage();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        int n = dataBuffer.getSize();
        for (int i = 0; i < n; ++i) {
            if (dataBuffer.getElem(i) != TRANSPARENT_TO_REMOVE) continue;
            dataBuffer.setElem(i, TRANSPARENT_PIXEL);
        }
        return bufferedImage;
    }

    public static Image flipHorizontally(Image image) {
        if (image == null) {
            return null;
        }
        AffineTransform affineTransform = PanelArtistUtilities.getYFlipTransform(image.getHeight(producer));
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
        return affineTransformOp.filter((BufferedImage)image, null);
    }

    public static Image rotateLeft(Image image) {
        if (image == null) {
            return null;
        }
        AffineTransform affineTransform = PanelArtistUtilities.getCCWRotateTransform(image.getWidth(producer), image.getHeight(producer));
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
        return ImageUtils.transparent(affineTransformOp.filter((BufferedImage)image, null));
    }

    public static Image rotateRight(Image image) {
        if (image == null) {
            return null;
        }
        AffineTransform affineTransform = PanelArtistUtilities.getCWRotateTransform(image.getWidth(producer), image.getHeight(producer));
        AffineTransformOp affineTransformOp = new AffineTransformOp(affineTransform, 1);
        return ImageUtils.transparent(affineTransformOp.filter((BufferedImage)image, null));
    }

    private static void paintTile(Component component, Graphics graphics, Image image) {
        ImageUtils.paintTile(component, graphics, image, 0, 0, ((JComponent)component).getWidth(), ((JComponent)component).getHeight(), true);
    }

    private static void paintTile(Component component, Graphics graphics, Image image, boolean bl) {
        ImageUtils.paintTile(component, graphics, image, 0, 0, ((JComponent)component).getWidth(), ((JComponent)component).getHeight(), bl);
    }

    private static void paintTile(Component component, Graphics graphics, Image image, int n, int n2, int n3, int n4, boolean bl) {
        Serializable serializable;
        if (image == null) {
            return;
        }
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        int n7 = 0;
        int n8 = 0;
        Shape shape = graphics.getClip();
        if (shape.contains(n, n2, n3, n4) || n3 <= 0 || n4 <= 0) {
            graphics.setClip(n, n2, n3, n4);
        } else if (shape.intersects(n, n2, n3, n4)) {
            serializable = shape.getBounds();
            graphics.setClip(SwingUtilities.computeIntersection(n, n2, n3, n4, (Rectangle)((RectangularShape)((Object)serializable)).clone()));
        }
        if (bl) {
            n7 = component.getLocation().x;
            n8 = component.getLocation().y;
            for (serializable = component.getParent(); serializable != null && !(serializable instanceof JInternalFrame); serializable = ((Component)serializable).getParent()) {
                if (((Component)serializable).getParent() == null) continue;
                n7 += ((Component)serializable).getLocation().x;
                n8 += ((Component)serializable).getLocation().y;
            }
            n -= n7 % n5;
            n2 -= n8 % n6;
        }
        int n9 = n + n3 + n5;
        int n10 = n2 + n4 + n6;
        while (n <= n9) {
            for (int i = n2; i <= n10; i += n6) {
                graphics.drawImage(image, n, i, component);
            }
            n += n5;
        }
        graphics.setClip(shape);
    }

    static {
        producer.addNotify();
        TRANSPARENT_TO_REMOVE = new Color(255, 0, 255).getRGB();
        TRANSPARENT_PIXEL = new Color(255, 0, 0, 0).getRGB();
    }
}

