/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin.impl.kde;

import com.l2fprod.gui.plaf.skin.DefaultButton;
import com.l2fprod.gui.plaf.skin.SkinUtils;
import com.l2fprod.gui.plaf.skin.SkinWindowButton;
import com.l2fprod.gui.plaf.skin.impl.AbstractSkinFrame;
import com.l2fprod.gui.plaf.skin.impl.kde.KdeFrameBorder;
import com.l2fprod.util.IniFile;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;

final class KdeFrame
extends AbstractSkinFrame {
    DefaultButton topSelected;
    DefaultButton topUnselected;
    int topHeight = 17;
    Vector buttonList;
    int textShiftLeft = 16;
    int textShiftRight = 0;
    int textAlignment = 0;
    boolean textAbsolutePosition = false;
    boolean pixmapUnderTitle = false;
    boolean titleFrameShaded = false;
    Border border;
    static final String[] TEXT_ALIGNMENTS = new String[]{"left", "middle", "right"};
    static final int LEFT = 0;
    static final int MIDDLE = 1;
    static final int RIGHT = 2;

    public KdeFrame(IniFile iniFile, URL uRL) throws Exception {
        int n;
        Insets insets;
        Object object;
        String string = iniFile.getKeyValue("Window Titlebar", "TitlebarPixmapActive");
        if (string != null) {
            object = SkinUtils.loadImage(new URL(uRL, string));
            insets = iniFile.getKeyValue("Window Titlebar", "TitlebarPixmapActiveBorder") != null ? SkinUtils.stringToInsets(iniFile.getKeyValue("Window Titlebar", "TitlebarPixmapActiveBorder")) : new Insets(iniFile.getKeyIntValue("Window Titlebar", "TitlebarPixmapActiveTop"), iniFile.getKeyIntValue("Window Titlebar", "TitlebarPixmapActiveLeft"), iniFile.getKeyIntValue("Window Titlebar", "TitlebarPixmapActiveBottom"), iniFile.getKeyIntValue("Window Titlebar", "TitlebarPixmapActiveRight"));
            this.topSelected = new DefaultButton((Image)object, ((Image)object).getWidth(null), ((Image)object).getHeight(null), insets.top, insets.right, insets.bottom, insets.left);
            this.topHeight = this.topSelected.getHeight();
        }
        if ((string = iniFile.getKeyValue("Window Titlebar", "TitlebarPixmapInactive")) != null) {
            object = SkinUtils.loadImage(new URL(uRL, string));
            insets = iniFile.getKeyValue("Window Titlebar", "TitlebarPixmapActiveBorder") != null ? SkinUtils.stringToInsets(iniFile.getKeyValue("Window Titlebar", "TitlebarPixmapActiveBorder")) : new Insets(iniFile.getKeyIntValue("Window Titlebar", "TitlebarPixmapActiveTop"), iniFile.getKeyIntValue("Window Titlebar", "TitlebarPixmapActiveLeft"), iniFile.getKeyIntValue("Window Titlebar", "TitlebarPixmapActiveBottom"), iniFile.getKeyIntValue("Window Titlebar", "TitlebarPixmapActiveRight"));
            this.topUnselected = new DefaultButton((Image)object, ((Image)object).getWidth(null), ((Image)object).getHeight(null), insets.top, insets.right, insets.bottom, insets.left);
            this.topHeight = Math.max(this.topHeight, this.topUnselected.getHeight());
        }
        this.pixmapUnderTitle = "yes".equals(iniFile.getKeyValue("Window Titlebar", "PixmapUnderTitleText"));
        this.titleFrameShaded = "yes".equals(iniFile.getKeyValue("Window Titlebar", "TitleFrameShaded"));
        object = iniFile.getKeyValue("Window Titlebar", "TitleAlignment");
        if (object != null) {
            object = ((String)object).toLowerCase();
            n = TEXT_ALIGNMENTS.length;
            for (int i = 0; i < n; ++i) {
                if (!TEXT_ALIGNMENTS[i].equals(object)) continue;
                this.textAlignment = i;
                break;
            }
        }
        this.buttonList = new Vector();
        this.textAbsolutePosition = "yes".equals(iniFile.getKeyValue("Window Titlebar", "TitleAbsolutePosition"));
        String string2 = "ABCDEF";
        if (iniFile.getSection("Window Button Layout") == null) {
            iniFile.addSection("Window Button Layout");
            iniFile.setKeyValue("Window Button Layout", "ButtonA", "Off");
            iniFile.setKeyValue("Window Button Layout", "ButtonB", "Off");
            iniFile.setKeyValue("Window Button Layout", "ButtonC", "Off");
            iniFile.setKeyValue("Window Button Layout", "ButtonD", "Minimize");
            iniFile.setKeyValue("Window Button Layout", "ButtonE", "Maximize");
            iniFile.setKeyValue("Window Button Layout", "ButtonF", "Close");
        }
        int n2 = string2.length();
        for (n = 0; n < n2; ++n) {
            String string3 = iniFile.getKeyValue("Window Button Layout", "Button" + string2.charAt(n));
            if (string3 == null || "Off".equalsIgnoreCase(string3)) continue;
            FrameButton frameButton = new FrameButton(iniFile, uRL, string3);
            frameButton.setAlign(n < n2 / 2 ? 0 : 1);
            if (frameButton.icon != null) {
                if (n < n2 / 2) {
                    this.textShiftLeft += frameButton.icon.getIconWidth();
                } else {
                    this.textShiftRight += frameButton.icon.getIconWidth();
                }
                this.topHeight = Math.max(this.topHeight, frameButton.icon.getIconHeight());
            }
            this.buttonList.addElement(frameButton);
        }
        this.textShiftLeft += 4;
        this.textShiftRight += 4;
        if (iniFile.getSection("Window Border") != null && iniFile.getSection("Window Border").size() > 0) {
            this.border = new BorderUIResource(new KdeFrameBorder(iniFile, uRL));
            UIManager.put("InternalFrame.border", this.border);
        }
    }

    public Dimension getTopPreferredSize() {
        return new Dimension(this.textShiftLeft + this.textShiftRight + 50, this.topHeight);
    }

    public SkinWindowButton[] getWindowButtons(int n) {
        Vector<SkinWindowButton> vector = new Vector<SkinWindowButton>();
        int n2 = this.buttonList.size();
        for (int i = 0; i < n2; ++i) {
            FrameButton frameButton = (FrameButton)this.buttonList.elementAt(i);
            if (frameButton.getAlign() != n) continue;
            vector.addElement(frameButton.createButton());
        }
        Object[] objectArray = new SkinWindowButton[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean status() {
        return true;
    }

    public boolean installSkin(JComponent jComponent) {
        if (this.border != null) {
            jComponent.setBorder(this.border);
            jComponent.setOpaque(false);
            return true;
        }
        return false;
    }

    public boolean paintTop(Graphics graphics, Component component, boolean bl, String string) {
        Serializable serializable;
        if (this.topSelected != null && this.topUnselected != null) {
            if (bl) {
                this.topSelected.paint(graphics, 0, 0, component);
            } else {
                this.topUnselected.paint(graphics, 0, 0, component);
            }
        } else {
            serializable = graphics.getColor();
            if (bl) {
                graphics.setColor(UIManager.getColor("InternalFrame.activeTitleBackground"));
            } else {
                graphics.setColor(UIManager.getColor("InternalFrame.inactiveTitleBackground"));
            }
            graphics.fillRect(0, 0, ((JComponent)component).getWidth(), ((JComponent)component).getHeight());
            graphics.setColor((Color)serializable);
        }
        if (string != null) {
            Color color;
            serializable = graphics.getFontMetrics();
            int n = ((FontMetrics)serializable).getHeight() - ((FontMetrics)serializable).getLeading();
            int n2 = (this.topHeight - n) / 2 + ((FontMetrics)serializable).getAscent() + ((FontMetrics)serializable).getLeading();
            int n3 = ((FontMetrics)serializable).stringWidth(string);
            int n4 = 0;
            switch (this.textAlignment) {
                case 0: {
                    n4 = this.textShiftLeft;
                    break;
                }
                case 1: {
                    if (this.textAbsolutePosition) {
                        n4 = (((JComponent)component).getWidth() - n3) / 2;
                        break;
                    }
                    n4 = (((JComponent)component).getWidth() - this.textShiftLeft - this.textShiftRight) / 2 + this.textShiftLeft - n3 / 2;
                    break;
                }
                case 2: {
                    n4 = ((JComponent)component).getWidth() - n3 - this.textShiftRight;
                }
            }
            if (!this.pixmapUnderTitle) {
                color = graphics.getColor();
                if (bl) {
                    graphics.setColor(UIManager.getColor("InternalFrame.activeTitleBackground"));
                } else {
                    graphics.setColor(UIManager.getColor("InternalFrame.inactiveTitleBackground"));
                }
                graphics.fillRect(n4, 0, n3, ((JComponent)component).getHeight());
                graphics.setColor(color);
            }
            if (bl && this.titleFrameShaded) {
                color = graphics.getColor();
                graphics.setColor(color.darker().darker());
                graphics.drawString(string, n4 + 1, n2 + 1);
                graphics.setColor(color);
            }
            graphics.drawString(string, n4, n2);
        }
        return true;
    }

    class FrameButton {
        ImageIcon icon;
        ImageIcon rolloverIcon;
        ImageIcon downIcon;
        ImageIcon inactiveIcon;
        int align;
        int action = -1;

        FrameButton(IniFile iniFile, URL uRL, String string) throws Exception {
            String string2;
            if ("Iconify".equals(string)) {
                string = "Minimize";
            }
            if ((string2 = iniFile.getKeyValue("Window Titlebar", string + "Button")) != null) {
                this.inactiveIcon = this.icon = new ImageIcon(SkinUtils.loadImage(new URL(uRL, string2)));
                this.downIcon = this.icon;
            }
            if ((string2 = iniFile.getKeyValue("Window Titlebar", string + "DownButton")) != null) {
                this.downIcon = new ImageIcon(SkinUtils.loadImage(new URL(uRL, string2)));
            }
            if ((string2 = iniFile.getKeyValue("Window Titlebar", string + "InactiveButton")) != null) {
                this.inactiveIcon = new ImageIcon(SkinUtils.loadImage(new URL(uRL, string2)));
            }
            if ((string2 = iniFile.getKeyValue("Window Titlebar", string + "RolloverButton")) != null) {
                this.rolloverIcon = new ImageIcon(SkinUtils.loadImage(new URL(uRL, string2)));
            }
            if ("Maximize".equalsIgnoreCase(string)) {
                this.action = 22;
            } else if ("Minimize".equalsIgnoreCase(string)) {
                this.action = 23;
            } else if ("Close".equalsIgnoreCase(string)) {
                this.action = 0;
            }
        }

        public void setAlign(int n) {
            this.align = n;
        }

        public int getAlign() {
            return this.align;
        }

        public SkinWindowButton createButton() {
            SkinWindowButton skinWindowButton = new SkinWindowButton(-1, (KdeFrame.this.topHeight - this.icon.getIconHeight()) / 2, this.align, this.action);
            if (this.icon != null) {
                skinWindowButton.setSize(this.icon.getIconWidth(), this.icon.getIconHeight());
                skinWindowButton.setNoFocusIcon(this.inactiveIcon);
                skinWindowButton.setNoFocusRolloverIcon(this.inactiveIcon);
                skinWindowButton.setIcon(this.icon);
                skinWindowButton.setRolloverIcon(this.rolloverIcon != null ? this.rolloverIcon : this.icon);
                skinWindowButton.setPressedIcon(this.downIcon);
            }
            return skinWindowButton;
        }
    }
}

