/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin.impl.gtk;

import com.l2fprod.gui.plaf.skin.DefaultButton;
import com.l2fprod.gui.plaf.skin.SkinButton;
import com.l2fprod.gui.plaf.skin.impl.AbstractSkinButton;
import com.l2fprod.gui.plaf.skin.impl.gtk.GtkUtils;
import com.l2fprod.gui.plaf.skin.impl.gtk.parser.GtkParser;
import com.l2fprod.util.ImageUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;

final class GtkButton
extends AbstractSkinButton
implements SkinButton {
    DefaultButton checkIN;
    DefaultButton checkOUT;
    DefaultButton optionIN;
    DefaultButton optionOUT;
    Icon disabledCheckIN;
    Icon disabledCheckOUT;
    Icon disabledOptionIN;
    Icon disabledOptionOUT;
    DefaultButton disabledButton;
    DefaultButton pressedButton;
    DefaultButton normalButton;
    DefaultButton rolloverButton;
    DefaultButton disabledButtonIN;
    DefaultButton toggleIN;
    DefaultButton toggleOUT;
    DefaultButton toggleRollover;

    public GtkButton(GtkParser gtkParser) throws Exception {
        this.normalButton = GtkUtils.newButton(gtkParser, "GtkButton", new String[]{"function", "state", "shadow"}, new String[]{"BOX", "NORMAL", "OUT"});
        this.pressedButton = GtkUtils.newButton(gtkParser, "GtkButton", new String[]{"function", "state", "shadow"}, new String[]{"BOX", "ACTIVE", "IN"});
        this.disabledButton = GtkUtils.newButton(gtkParser, "GtkButton", new String[]{"function", "state", "shadow"}, new String[]{"BOX", "INSENSITIVE", "OUT"});
        this.disabledButtonIN = GtkUtils.newButton(gtkParser, "GtkButton", new String[]{"function", "state", "shadow"}, new String[]{"BOX", "INSENSITIVE", "IN"});
        this.rolloverButton = GtkUtils.newButton(gtkParser, "GtkButton", new String[]{"function", "state"}, new String[]{"BOX", "PRELIGHT"});
        this.toggleIN = GtkUtils.newButton(gtkParser, "GtkToggleButton", new String[]{"function", "shadow"}, new String[]{"BOX", "IN"});
        this.toggleOUT = GtkUtils.newButton(gtkParser, "GtkToggleButton", new String[]{"function", "shadow", "state"}, new String[]{"BOX", "OUT", null});
        this.toggleRollover = GtkUtils.newButton(gtkParser, "GtkToggleButton", new String[]{"function", "state"}, new String[]{"BOX", "PRELIGHT"});
        this.checkIN = GtkUtils.newButton(gtkParser, "GtkCheckButton", new String[]{"function", "shadow"}, new String[]{"CHECK", "IN"});
        this.disabledCheckIN = ImageUtils.getDisabledIcon(this.checkIN.center);
        this.checkOUT = GtkUtils.newButton(gtkParser, "GtkCheckButton", new String[]{"function", "shadow"}, new String[]{"CHECK", "OUT"});
        this.disabledCheckOUT = ImageUtils.getDisabledIcon(this.checkOUT.center);
        this.optionIN = GtkUtils.newButton(gtkParser, "GtkRadioButton", new String[]{"function", "shadow"}, new String[]{"OPTION", "IN"});
        this.disabledOptionIN = ImageUtils.getDisabledIcon(this.optionIN.center);
        this.optionOUT = GtkUtils.newButton(gtkParser, "GtkRadioButton", new String[]{"function", "shadow"}, new String[]{"OPTION", "OUT"});
        this.disabledOptionOUT = ImageUtils.getDisabledIcon(this.optionOUT.center);
    }

    public Dimension getCheckBoxIconSize() {
        if (this.checkIN != null) {
            return new Dimension(this.checkIN.getIconWidth(), this.checkIN.getIconHeight());
        }
        return new Dimension(13, 13);
    }

    public Dimension getRadioButtonIconSize() {
        if (this.optionIN != null) {
            return new Dimension(this.optionIN.getIconWidth(), this.optionIN.getIconHeight());
        }
        return new Dimension(13, 13);
    }

    public Icon getRadioIcon(AbstractButton abstractButton) {
        ButtonModel buttonModel = abstractButton.getModel();
        if (abstractButton instanceof JRadioButton || abstractButton instanceof JRadioButtonMenuItem) {
            if (buttonModel.isSelected() || buttonModel.isPressed() && buttonModel.isArmed()) {
                return abstractButton.isEnabled() ? this.optionIN : this.disabledOptionIN;
            }
            if (!buttonModel.isEnabled()) {
                if (buttonModel.isSelected()) {
                    return abstractButton.isEnabled() ? this.optionOUT : this.disabledOptionOUT;
                }
                return abstractButton.isEnabled() ? this.optionOUT : this.disabledOptionOUT;
            }
            return abstractButton.isEnabled() ? this.optionOUT : this.disabledOptionOUT;
        }
        if (abstractButton instanceof JCheckBox || abstractButton instanceof JCheckBoxMenuItem) {
            if (buttonModel.isSelected() || buttonModel.isPressed() && buttonModel.isArmed()) {
                return abstractButton.isEnabled() ? this.checkIN : this.disabledCheckIN;
            }
            if (!buttonModel.isEnabled()) {
                if (buttonModel.isSelected()) {
                    return abstractButton.isEnabled() ? this.checkOUT : this.disabledCheckOUT;
                }
                return abstractButton.isEnabled() ? this.checkOUT : this.disabledCheckOUT;
            }
            return abstractButton.isEnabled() ? this.checkOUT : this.disabledCheckOUT;
        }
        return null;
    }

    public boolean status() {
        return true;
    }

    public boolean installSkin(JComponent jComponent) {
        return true;
    }

    protected boolean paintDisabledButton(Graphics graphics, AbstractButton abstractButton) {
        this.disabledButton.paint(graphics, abstractButton);
        return true;
    }

    protected boolean paintPressedToggle(Graphics graphics, AbstractButton abstractButton) {
        this.toggleIN.paint(graphics, abstractButton);
        return true;
    }

    protected boolean paintRolloverToggle(Graphics graphics, AbstractButton abstractButton) {
        this.toggleRollover.paint(graphics, abstractButton);
        return true;
    }

    protected boolean paintToggle(Graphics graphics, AbstractButton abstractButton) {
        this.toggleOUT.paint(graphics, abstractButton);
        return true;
    }

    protected boolean paintPressedButton(Graphics graphics, AbstractButton abstractButton) {
        this.pressedButton.paint(graphics, abstractButton);
        return true;
    }

    protected boolean paintRolloverButton(Graphics graphics, AbstractButton abstractButton) {
        this.rolloverButton.paint(graphics, abstractButton);
        return true;
    }

    protected boolean paintNormalButton(Graphics graphics, AbstractButton abstractButton) {
        this.normalButton.paint(graphics, abstractButton);
        return true;
    }
}

