/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import com.l2fprod.gui.plaf.skin.SkinWindowButton;
import com.l2fprod.gui.plaf.skin.Window;
import com.l2fprod.util.OS;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class SkinTitlePane
extends BasicInternalFrameTitlePane {
    protected Window m_Window;
    private Action shadeAction;
    private boolean systemMenuAdded = false;
    private Skin skin;
    public static final int ICON_OFFSET = 16;
    public static final int ALIGN_TOP_LEFT = 0;
    public static final int ALIGN_TOP_RIGHT = 1;
    public static final int CLOSE_ACTION = 0;
    public static final int MAXIMIZE_ACTION = 22;
    public static final int MINIMIZE_ACTION = 23;
    public static final int NO_ACTION = -1;

    public SkinTitlePane(JInternalFrame jInternalFrame) {
        this(new Window.InternalFrameWindow(jInternalFrame));
    }

    public SkinTitlePane(Window window) {
        super(null);
        this.m_Window = window;
        if (OS.isOneDotFour()) {
            this.installListeners();
        }
    }

    public Window getWindow() {
        return this.m_Window;
    }

    public Dimension getPreferredSize() {
        return this.skin.getFrame().getTopPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.skin.getFrame().getTopPreferredSize();
    }

    public void paintComponent(Graphics graphics) {
        boolean bl = this.m_Window.isSelected();
        Font font = graphics.getFont();
        if (this.m_Window.getTitle() != null) {
            if (bl) {
                graphics.setColor(this.selectedTextColor);
            } else {
                graphics.setColor(this.notSelectedTextColor);
            }
            graphics.setFont(UIManager.getFont("InternalFrame.titleFont"));
        }
        this.skin.getFrame().paintTop(graphics, this, bl, this.m_Window.getTitle());
        graphics.setFont(font);
    }

    protected void setButtonIcons() {
    }

    protected void installTitlePane() {
        this.installDefaults();
        this.createActions();
        this.enableActions();
        this.assembleSystemMenu();
        this.setLayout(this.createLayout());
        this.add(this.menuBar);
        this.setOpaque(true);
        this.skin = SkinLookAndFeel.getSkin();
        this.createButtons();
    }

    protected void createActions() {
        this.maximizeAction = new MaximizeAction();
        this.maximizeAction.setEnabled(true);
        this.iconifyAction = new IconifyAction();
        this.iconifyAction.setEnabled(true);
        this.closeAction = new CloseAction();
        this.closeAction.setEnabled(true);
        this.restoreAction = new RestoreAction();
        this.restoreAction.setEnabled(true);
        this.shadeAction = new ShadeAction();
        this.shadeAction.setEnabled(true);
    }

    protected void installListeners() {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = this.createPropertyChangeListener();
        }
        this.m_Window.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallListeners() {
        this.m_Window.removePropertyChangeListener(this.propertyChangeListener);
    }

    protected void installDefaults() {
        this.selectedTitleColor = UIManager.getColor("InternalFrame.activeTitleBackground");
        this.selectedTextColor = UIManager.getColor("InternalFrame.activeTitleForeground");
        this.notSelectedTitleColor = UIManager.getColor("InternalFrame.inactiveTitleBackground");
        this.notSelectedTextColor = UIManager.getColor("InternalFrame.inactiveTitleForeground");
    }

    protected void createButtons() {
        int n;
        int n2;
        SkinWindowButton[] skinWindowButtonArray = this.skin.getFrame().getWindowButtons(0);
        if (skinWindowButtonArray != null) {
            n2 = skinWindowButtonArray.length;
            for (n = 0; n < n2; ++n) {
                this.addButton(skinWindowButtonArray[n]);
            }
        }
        if ((skinWindowButtonArray = this.skin.getFrame().getWindowButtons(1)) != null) {
            n2 = skinWindowButtonArray.length;
            for (n = 0; n < n2; ++n) {
                this.addButton(skinWindowButtonArray[n]);
            }
        }
    }

    protected void addButton(SkinWindowButton skinWindowButton) {
        skinWindowButton.setWindow(this.m_Window);
        switch (skinWindowButton.getWindowAction()) {
            case 0: {
                skinWindowButton.addActionListener(this.closeAction);
                this.registerButtonForAction(skinWindowButton, this.closeAction);
                break;
            }
            case 22: {
                skinWindowButton.addActionListener(this.maximizeAction);
                this.registerButtonForAction(skinWindowButton, this.maximizeAction);
                break;
            }
            case 23: {
                skinWindowButton.addActionListener(this.iconifyAction);
                this.registerButtonForAction(skinWindowButton, this.iconifyAction);
            }
        }
        this.add(skinWindowButton);
    }

    protected void addSystemMenuItems(JMenu jMenu) {
        JMenuItem jMenuItem = jMenu.add(this.restoreAction);
        jMenuItem.setMnemonic('R');
        jMenuItem = jMenu.add(this.iconifyAction);
        jMenuItem.setMnemonic('n');
        jMenuItem = jMenu.add(this.maximizeAction);
        jMenuItem.setMnemonic('x');
        jMenu.add(this.shadeAction);
        jMenu.add(new JSeparator());
        jMenuItem = jMenu.add(this.closeAction);
        jMenuItem.setMnemonic('C');
    }

    protected JMenuBar createSystemMenuBar() {
        this.menuBar = new SystemMenuBar();
        this.menuBar.setBorderPainted(false);
        return this.menuBar;
    }

    protected void enableActions() {
        if (this.m_Window == null) {
            return;
        }
        this.restoreAction.setEnabled(this.m_Window.isMaximum() || this.m_Window.isIcon());
        this.maximizeAction.setEnabled(this.m_Window.isMaximizable());
        this.iconifyAction.setEnabled(this.m_Window.isIconifiable() && !this.m_Window.isIcon());
        this.closeAction.setEnabled(this.m_Window.isClosable());
        this.shadeAction.setEnabled(!this.m_Window.isMaximum() && !this.m_Window.isIcon());
        this.doLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    protected PropertyChangeListener createActionChangeListener(AbstractButton abstractButton) {
        return new ActionChangedListener(abstractButton);
    }

    private void registerButtonForAction(AbstractButton abstractButton, Action action) {
        PropertyChangeListener propertyChangeListener = this.createActionChangeListener(abstractButton);
        action.addPropertyChangeListener(propertyChangeListener);
        abstractButton.setEnabled(action.isEnabled());
    }

    private class NoFocusButton
    extends JButton {
        public NoFocusButton() {
            this.setFocusPainted(false);
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public boolean isOpaque() {
            return true;
        }

        public void requestFocus() {
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        AbstractButton button;

        ActionChangedListener(AbstractButton abstractButton) {
            this.setTarget(abstractButton);
        }

        public void setTarget(AbstractButton abstractButton) {
            this.button = abstractButton;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (propertyChangeEvent.getPropertyName().equals("Name")) {
                String string2 = (String)propertyChangeEvent.getNewValue();
                this.button.setText(string2);
                this.button.repaint();
            } else if (string.equals("enabled")) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                this.button.setEnabled(bl);
                this.button.repaint();
            } else if (propertyChangeEvent.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)propertyChangeEvent.getNewValue();
                this.button.setIcon(icon);
                this.button.invalidate();
                this.button.repaint();
            }
        }
    }

    public class SystemMenuBar
    extends JMenuBar {
        public boolean isFocusTraversable() {
            return false;
        }

        public boolean isOpaque() {
            return true;
        }

        public void requestFocus() {
        }

        public void paint(Graphics graphics) {
            Icon icon = SkinTitlePane.this.m_Window.getFrameIcon();
            if (icon == null) {
                icon = UIManager.getIcon("InternalFrame.icon");
            }
            if (icon != null) {
                if (icon instanceof ImageIcon && (icon.getIconWidth() > 16 || icon.getIconHeight() > 16)) {
                    Image image = ((ImageIcon)icon).getImage();
                    ((ImageIcon)icon).setImage(image.getScaledInstance(16, 16, 4));
                }
                icon.paintIcon(this, graphics, 0, 0);
            }
        }
    }

    public class ShadeAction
    extends AbstractAction {
        public ShadeAction() {
            super("Shade");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SkinTitlePane.this.m_Window.setShaded(!SkinTitlePane.this.m_Window.isShaded());
        }
    }

    public class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super("Restore");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SkinTitlePane.this.m_Window.isMaximizable() && SkinTitlePane.this.m_Window.isMaximum()) {
                try {
                    SkinTitlePane.this.m_Window.setMaximum(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (SkinTitlePane.this.m_Window.isIconifiable() && SkinTitlePane.this.m_Window.isIcon()) {
                try {
                    SkinTitlePane.this.m_Window.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    public class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super("Minimize");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SkinTitlePane.this.m_Window.isIconifiable()) {
                if (!SkinTitlePane.this.m_Window.isIcon()) {
                    try {
                        SkinTitlePane.this.m_Window.setIcon(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    try {
                        SkinTitlePane.this.m_Window.setIcon(false);
                        if (SkinTitlePane.this.m_Window.isMaximizable() && SkinTitlePane.this.m_Window.isMaximum()) {
                            SkinTitlePane.this.m_Window.setMaximum(false);
                        }
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super("Maximize");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SkinTitlePane.this.m_Window.isMaximizable()) {
                if (!SkinTitlePane.this.m_Window.isMaximum()) {
                    try {
                        SkinTitlePane.this.m_Window.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    try {
                        SkinTitlePane.this.m_Window.setMaximum(false);
                        if (SkinTitlePane.this.m_Window.isIconifiable() && SkinTitlePane.this.m_Window.isIcon()) {
                            SkinTitlePane.this.m_Window.setIcon(false);
                        }
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super("Close");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SkinTitlePane.this.m_Window.isClosable()) {
                try {
                    SkinTitlePane.this.m_Window.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    public class TitlePaneLayout
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(100, 18);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            int n = SkinTitlePane.this.getWidth();
            int n2 = container.getComponentCount();
            int n3 = 2;
            int n4 = 0;
            SkinTitlePane.this.menuBar.setBounds(n3, (SkinTitlePane.this.getHeight() - 16) / 2, 16, 16);
            n3 += 18;
            for (int i = 1; i < n2; ++i) {
                SkinWindowButton skinWindowButton = (SkinWindowButton)container.getComponent(i);
                skinWindowButton.setVisible(skinWindowButton.isEnabled());
                if (!skinWindowButton.isEnabled()) continue;
                if (skinWindowButton.getAlign() == 0) {
                    if (skinWindowButton.getXCoord() == -1) {
                        skinWindowButton.setLocation(n3, Math.max(skinWindowButton.getYCoord(), 1));
                        n3 += skinWindowButton.getWidth();
                        continue;
                    }
                    skinWindowButton.setLocation(skinWindowButton.getXCoord(), skinWindowButton.getYCoord());
                    continue;
                }
                if (skinWindowButton.getAlign() != 1) continue;
                if (skinWindowButton.getXCoord() == -1) {
                    skinWindowButton.setLocation(n - n4 - skinWindowButton.getWidth(), Math.max(skinWindowButton.getYCoord(), 1));
                    n4 += skinWindowButton.getWidth();
                    continue;
                }
                skinWindowButton.setLocation(n - skinWindowButton.getXCoord(), skinWindowButton.getYCoord());
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("selected".equals(string)) {
                SkinTitlePane.this.repaint();
                return;
            }
            SkinTitlePane.this.enableActions();
            SkinTitlePane.this.revalidate();
            SkinTitlePane.this.repaint();
        }
    }
}

