/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import com.l2fprod.gui.plaf.skin.SkinSplitArrowButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public final class SkinSplitPaneDivider
extends BasicSplitPaneDivider
implements SwingConstants {
    protected Skin skin = SkinLookAndFeel.getSkin();
    static final Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    static final Insets NO_INSETS = new Insets(0, 0, 0, 0);

    public SkinSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
        super(basicSplitPaneUI);
        this.setLayout(new DividerLayout());
    }

    public void setDividerSize(int n) {
        this.dividerSize = n;
        this.splitPane.setDividerSize(n);
    }

    public void paint(Graphics graphics) {
        Graphics graphics2;
        Rectangle rectangle;
        Dimension dimension = this.getSize();
        this.skin.getSplitPane().paintGutter(graphics, this.splitPane, dimension);
        if (this.leftButton != null) {
            rectangle = this.leftButton.getBounds();
            graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.leftButton.paint(graphics2);
        }
        if (this.rightButton != null) {
            rectangle = this.rightButton.getBounds();
            graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.rightButton.paint(graphics2);
        }
        this.skin.getSplitPane().paintThumb(graphics, this.splitPane, dimension);
    }

    protected JButton createLeftOneTouchButton() {
        int n = 5;
        if (this.orientation == 1) {
            n = 7;
        }
        SkinSplitArrowButton skinSplitArrowButton = new SkinSplitArrowButton(n);
        skinSplitArrowButton.setCursor(defaultCursor);
        skinSplitArrowButton.setFocusPainted(false);
        skinSplitArrowButton.setBorderPainted(false);
        this.updateDividerSize(((JComponent)skinSplitArrowButton).getPreferredSize());
        return skinSplitArrowButton;
    }

    protected JButton createRightOneTouchButton() {
        int n = 1;
        if (this.orientation == 1) {
            n = 3;
        }
        SkinSplitArrowButton skinSplitArrowButton = new SkinSplitArrowButton(n);
        skinSplitArrowButton.setCursor(defaultCursor);
        skinSplitArrowButton.setFocusPainted(false);
        skinSplitArrowButton.setBorderPainted(false);
        this.updateDividerSize(((JComponent)skinSplitArrowButton).getPreferredSize());
        return skinSplitArrowButton;
    }

    protected void updateDividerSize(Dimension dimension) {
        int n = this.orientation == 1 ? dimension.width : dimension.height;
        int n2 = this.splitPane.getDividerSize();
        if (n2 < n) {
            this.splitPane.setDividerSize(n);
        }
    }

    protected class DividerLayout
    implements LayoutManager {
        protected DividerLayout() {
        }

        public void layoutContainer(Container container) {
            if (SkinSplitPaneDivider.this.leftButton != null && SkinSplitPaneDivider.this.rightButton != null && container == SkinSplitPaneDivider.this) {
                Dimension dimension = SkinSplitPaneDivider.this.leftButton.getPreferredSize();
                Dimension dimension2 = SkinSplitPaneDivider.this.rightButton.getPreferredSize();
                if (SkinSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                    Insets insets = SkinSplitPaneDivider.this.getInsets();
                    if (insets == null) {
                        insets = NO_INSETS;
                    }
                    if (SkinSplitPaneDivider.this.orientation == 0) {
                        int n = SkinSplitPaneDivider.this.getDividerSize() - (insets.left + insets.right);
                        int n2 = (container.getSize().height - n) / 2;
                        SkinSplitPaneDivider.this.leftButton.setBounds(insets.left + dimension.width, n2, dimension.width, dimension.height);
                        SkinSplitPaneDivider.this.rightButton.setBounds(insets.left * 2 + dimension.width + dimension2.width, n2, dimension2.width, dimension2.height);
                    } else {
                        int n = SkinSplitPaneDivider.this.getDividerSize() - (insets.top + insets.bottom);
                        int n3 = (container.getSize().width - n) / 2;
                        SkinSplitPaneDivider.this.leftButton.setBounds(n3, insets.top + dimension.height, dimension.width, dimension.height);
                        SkinSplitPaneDivider.this.rightButton.setBounds(n3, insets.top * 2 + dimension.height + dimension2.height, dimension2.width, dimension2.height);
                    }
                } else {
                    SkinSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                    SkinSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(0, 0);
        }

        public void removeLayoutComponent(Component component) {
        }

        public void addLayoutComponent(String string, Component component) {
        }
    }
}

