/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.text.View;

public class SkinRadioButtonUI
extends BasicRadioButtonUI {
    protected int dashedRectGapWidth;
    protected int dashedRectGapHeight;
    protected Color focusColor;
    protected Skin skin = SkinLookAndFeel.getSkin();
    private boolean initialized = false;
    static final SkinRadioButtonUI buttonUI = new SkinRadioButtonUI();
    private static Dimension size = new Dimension();
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        if (!this.initialized) {
            this.focusColor = Color.black;
            this.initialized = true;
        }
        abstractButton.setOpaque(false);
    }

    public synchronized void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Font font = jComponent.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        size = abstractButton.getSize(size);
        SkinRadioButtonUI.viewRect.y = 0;
        SkinRadioButtonUI.viewRect.x = 0;
        SkinRadioButtonUI.viewRect.width = SkinRadioButtonUI.size.width;
        SkinRadioButtonUI.viewRect.height = SkinRadioButtonUI.size.height;
        SkinRadioButtonUI.iconRect.height = 0;
        SkinRadioButtonUI.iconRect.width = 0;
        SkinRadioButtonUI.iconRect.y = 0;
        SkinRadioButtonUI.iconRect.x = 0;
        SkinRadioButtonUI.textRect.height = 0;
        SkinRadioButtonUI.textRect.width = 0;
        SkinRadioButtonUI.textRect.y = 0;
        SkinRadioButtonUI.textRect.x = 0;
        Icon icon = abstractButton.isSelected() ? abstractButton.getSelectedIcon() : abstractButton.getIcon();
        if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
            icon = abstractButton.isSelected() ? abstractButton.getRolloverSelectedIcon() : abstractButton.getRolloverIcon();
        }
        if (icon == null) {
            icon = this.skin.getButton().getRadioIcon(abstractButton);
        }
        String string = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), viewRect, iconRect, textRect, this.getDefaultTextIconGap(abstractButton));
        if (jComponent.isOpaque()) {
            graphics.setColor(abstractButton.getBackground());
            graphics.fillRect(0, 0, SkinRadioButtonUI.size.width, SkinRadioButtonUI.size.height);
        }
        if (icon != null) {
            icon.paintIcon(jComponent, graphics, SkinRadioButtonUI.iconRect.x, SkinRadioButtonUI.iconRect.y);
        }
        if (string != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, textRect);
            } else if (buttonModel.isEnabled()) {
                graphics.setColor(abstractButton.getForeground());
                BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), SkinRadioButtonUI.textRect.x, SkinRadioButtonUI.textRect.y + fontMetrics.getAscent());
            } else {
                graphics.setColor(abstractButton.getBackground().brighter());
                BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), SkinRadioButtonUI.textRect.x + 1, SkinRadioButtonUI.textRect.y + fontMetrics.getAscent() + 1);
                graphics.setColor(abstractButton.getBackground().darker());
                BasicGraphicsUtils.drawString(graphics, string, buttonModel.getMnemonic(), SkinRadioButtonUI.textRect.x, SkinRadioButtonUI.textRect.y + fontMetrics.getAscent());
            }
        }
        if (abstractButton.hasFocus() && abstractButton.isFocusPainted() && SkinRadioButtonUI.textRect.width > 0 && SkinRadioButtonUI.textRect.height > 0) {
            this.paintFocus(graphics, textRect, size);
        }
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    protected void paintFocus(Graphics graphics, Rectangle rectangle, Dimension dimension) {
        graphics.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        SkinRadioButtonUI.buttonUI.skin = SkinLookAndFeel.getSkin();
        SkinRadioButtonUI.buttonUI.initialized = false;
        return buttonUI;
    }
}

