/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sql.converter.CharacterConverter;

public class CharacterConverter12Byte
extends CharacterConverter {
    static final int ORACHARMASK = 255;
    static final int UCSCHARWIDTH = 16;
    static final int ORACHARWIDTH = 16;
    static final int BYTEWIDTH = 8;
    static final int BELOW_CJK = 12287;
    public char[] m_ucsCharLevel1 = null;
    public int[] m_ucsCharLevel2 = null;
    public int m_ucsCharReplacement = 0;
    public int[] m_oraCharLevel1 = null;
    public int[] m_oraCharSurrogateLevel = null;
    public char[] m_oraCharLevel2 = null;
    public char m_1ByteOraCharReplacement = '\u0000';
    public char m_2ByteOraCharReplacement = '\u0000';
    static final short MAX_7BIT = 127;
    protected static int MAXLIMIT = 42000;

    public CharacterConverter12Byte() {
        this.m_groupId = 1;
    }

    public void buildUnicodeToOracleMapping() {
        int n2;
        int n3;
        int n4;
        int n5;
        char[] cArray;
        Object object;
        int n6;
        int n7;
        Enumeration enumeration;
        this.m_oraCharLevel1 = new int[256];
        this.m_oraCharSurrogateLevel = null;
        this.m_oraCharLevel2 = null;
        Vector vector = new Vector(45055, 12287);
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (n10 < 256) {
            this.m_oraCharLevel1[n10] = -1;
            ++n10;
        }
        int n11 = 0;
        while (n11 < 65535) {
            try {
                int n12 = this.toUnicode(n11);
                enumeration = (Enumeration)new int[2];
                enumeration[0] = n12;
                enumeration[1] = n11;
                vector.addElement(enumeration);
                this.storeMappingRange(n12, hashtable, hashtable2);
            }
            catch (SQLException sQLException) {}
            ++n11;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n7 = this.extraUnicodeToOracleMapping.length;
            int n13 = 0;
            while (n13 < n7) {
                n6 = this.extraUnicodeToOracleMapping[n13][0];
                this.storeMappingRange(n6, hashtable, hashtable2);
                ++n13;
            }
        }
        enumeration = hashtable.keys();
        int n14 = 0;
        int n15 = 0;
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            cArray = (char[])hashtable.get(object);
            if (cArray == null) continue;
            n14 += 256;
        }
        enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            cArray = (char[])hashtable2.get(object);
            if (cArray == null) continue;
            n15 += 256;
        }
        if (n14 != 0) {
            this.m_oraCharSurrogateLevel = new int[n14];
        }
        if (n15 != 0) {
            this.m_oraCharLevel2 = new char[n15];
        }
        int n16 = 0;
        while (n16 < n14) {
            this.m_oraCharSurrogateLevel[n16] = -1;
            ++n16;
        }
        int n17 = 0;
        while (n17 < n15) {
            this.m_oraCharLevel2[n17] = 65535;
            ++n17;
        }
        int n18 = 0;
        while (n18 < vector.size()) {
            int[] nArray = (int[])vector.elementAt(n18);
            n5 = nArray[0] >> 24 & 0xFF;
            n4 = nArray[0] >> 16 & 0xFF;
            n3 = nArray[0] >> 8 & 0xFF;
            n2 = nArray[0] & 0xFF;
            if (n5 >= 216 && n5 < 220) {
                if (this.m_oraCharLevel1[n5] == -1) {
                    this.m_oraCharLevel1[n5] = n9;
                    n9 += 256;
                }
                if (this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] == -1) {
                    this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] = n9;
                    n9 += 256;
                }
                if (this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] == -1) {
                    this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] = n8;
                    n8 += 256;
                }
                if (this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] + n2] == '\uffff') {
                    this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] + n2] = (char)(nArray[1] & 0xFFFF);
                }
            } else {
                if (this.m_oraCharLevel1[n3] == -1) {
                    this.m_oraCharLevel1[n3] = n8;
                    n8 += 256;
                }
                if (this.m_oraCharLevel2[this.m_oraCharLevel1[n3] + n2] == '\uffff') {
                    this.m_oraCharLevel2[this.m_oraCharLevel1[n3] + n2] = (char)(nArray[1] & 0xFFFF);
                }
            }
            ++n18;
        }
        if (this.extraUnicodeToOracleMapping != null) {
            n7 = this.extraUnicodeToOracleMapping.length;
            int n19 = 0;
            while (n19 < n7) {
                n6 = this.extraUnicodeToOracleMapping[n19][0];
                n5 = n6 >>> 24 & 0xFF;
                n4 = n6 >>> 16 & 0xFF;
                n3 = n6 >>> 8 & 0xFF;
                n2 = n6 & 0xFF;
                if (n5 >= 216 && n5 < 220) {
                    if (this.m_oraCharLevel1[n5] == -1) {
                        this.m_oraCharLevel1[n5] = n9;
                        n9 += 256;
                    }
                    if (this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] == -1) {
                        this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] = n9;
                        n9 += 256;
                    }
                    if (this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] == -1) {
                        this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] = n8;
                        n8 += 256;
                    }
                    this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n5] + n4] + n3] + n2] = (char)(this.extraUnicodeToOracleMapping[n19][1] & 0xFFFF);
                } else {
                    if (this.m_oraCharLevel1[n3] == -1) {
                        this.m_oraCharLevel1[n3] = n8;
                        n8 += 256;
                    }
                    this.m_oraCharLevel2[this.m_oraCharLevel1[n3] + n2] = (char)(this.extraUnicodeToOracleMapping[n19][1] & 0xFFFF);
                }
                ++n19;
            }
        }
    }

    public void extractCodepoints(Vector vector) {
        int n2 = 0;
        int n3 = 65535;
        int n4 = n2;
        while (n4 <= n3) {
            try {
                int[] nArray = new int[]{n4, this.toUnicode(n4)};
                vector.addElement(nArray);
            }
            catch (SQLException sQLException) {}
            ++n4;
        }
    }

    public void extractExtraMappings(Vector vector) {
        if (this.extraUnicodeToOracleMapping == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.extraUnicodeToOracleMapping.length) {
            int[] nArray = new int[]{this.extraUnicodeToOracleMapping[n2][0], this.extraUnicodeToOracleMapping[n2][1]};
            vector.addElement(nArray);
            ++n2;
        }
    }

    public char getOraChar1ByteRep() {
        return this.m_1ByteOraCharReplacement;
    }

    public char getOraChar2ByteRep() {
        return this.m_2ByteOraCharReplacement;
    }

    public int getUCS2CharRep() {
        return this.m_ucsCharReplacement;
    }

    public boolean hasExtraMappings() {
        return this.extraUnicodeToOracleMapping != null;
    }

    char toOracleCharacter(char c2, char c3) throws SQLException {
        char c4 = '\uffff';
        if (c3 != '\u0000') {
            int n2 = c2 >>> 8 & 0xFF;
            int n3 = c2 & 0xFF;
            int n4 = c3 >>> 8 & 0xFF;
            int n5 = c3 & 0xFF;
            if (this.m_oraCharLevel1[n2] != -1 && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] != -1 && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] != -1 && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5] != '\uffff') {
                c4 = this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5];
            }
        } else {
            int n6 = c2 >>> 8 & 0xFF;
            int n7 = c2 & 0xFF;
            if (this.m_oraCharLevel1[n6] != -1 && this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7] != '\uffff') {
                c4 = this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7];
            }
        }
        if (c4 == '\uffff') {
            throw new SQLException("Cannot map Unicode to Oracle character.");
        }
        return c4;
    }

    char toOracleCharacterWithReplacement(char c2, char c3) {
        char c4 = '\uffff';
        if (c3 != '\u0000') {
            int n2 = c2 >>> 8 & 0xFF;
            int n3 = c2 & 0xFF;
            int n4 = c3 >>> 8 & 0xFF;
            int n5 = c3 & 0xFF;
            if (this.m_oraCharLevel1[n2] != -1 && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] != -1 && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] != -1 && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5] != '\uffff') {
                c4 = this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[n2] + n3] + n4] + n5];
            }
        } else {
            int n6 = c2 >>> 8 & 0xFF;
            int n7 = c2 & 0xFF;
            if (this.m_oraCharLevel1[n6] != -1 && this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7] != '\uffff') {
                c4 = this.m_oraCharLevel2[this.m_oraCharLevel1[n6] + n7];
            }
        }
        if (c4 == '\uffff') {
            if (c2 > '\u2fff') {
                return this.m_2ByteOraCharReplacement;
            }
            return this.m_1ByteOraCharReplacement;
        }
        return c4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] toOracleString(String string) throws SQLException {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2 * 4];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            char c2;
            if (cArray[n4] >= '\ud800' && cArray[n4] < '\udc00') {
                if (n4 + 1 >= n2 || cArray[n4 + 1] < '\udc00' || cArray[n4 + 1] > '\udfff') throw new SQLException("Cannot map Unicode to Oracle character.");
                c2 = this.toOracleCharacterWithReplacement(cArray[n4], cArray[n4 + 1]);
                ++n4;
            } else {
                c2 = this.toOracleCharacter(cArray[n4], '\u0000');
            }
            if (c2 >> 8 != 0) {
                byArray[n3++] = (byte)(c2 >> 8);
                byArray[n3++] = (byte)c2;
            } else {
                byArray[n3++] = (byte)c2;
            }
            ++n4;
        }
        if (n3 >= byArray.length) return byArray;
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    public byte[] toOracleStringWithReplacement(String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return new byte[0];
        }
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        byte[] byArray = new byte[n2 * 4];
        int n3 = 65535;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            block8: {
                block7: {
                    block5: {
                        block6: {
                            if (cArray[n5] < '\ud800' || cArray[n5] >= '\udc00') break block5;
                            if (n5 + 1 >= n2 || cArray[n5 + 1] < '\udc00' || cArray[n5 + 1] > '\udfff') break block6;
                            n3 = this.toOracleCharacterWithReplacement(cArray[n5], cArray[n5 + 1]);
                            ++n5;
                            break block7;
                        }
                        byArray[n4++] = (byte)(this.m_2ByteOraCharReplacement >> 8);
                        byArray[n4++] = (byte)this.m_2ByteOraCharReplacement;
                        break block8;
                    }
                    n3 = this.toOracleCharacterWithReplacement(cArray[n5], '\u0000');
                }
                if (n3 >> 8 != 0) {
                    byArray[n4++] = (byte)(n3 >> 8);
                    byArray[n4++] = (byte)n3;
                } else {
                    byArray[n4++] = (byte)n3;
                }
            }
            ++n5;
        }
        if (n4 < byArray.length) {
            byte[] byArray2 = new byte[n4];
            System.arraycopy(byArray, 0, byArray2, 0, n4);
            return byArray2;
        }
        return byArray;
    }

    int toUnicode(int n2) throws SQLException {
        int n3 = n2 >> 8 & 0xFF;
        int n4 = n2 & 0xFF;
        if (this.m_ucsCharLevel1[n3] == '\uffff' || this.m_ucsCharLevel2[this.m_ucsCharLevel1[n3] + n4] == -1) {
            throw new SQLException("Cannot map Oracle character to Unicode.");
        }
        int n5 = this.m_ucsCharLevel2[this.m_ucsCharLevel1[n3] + n4];
        return n5;
    }

    public String toUnicodeString(byte[] byArray, int n2, int n3) throws SQLException {
        int n4 = n2 + n3;
        String string = new String();
        int n5 = n2;
        while (n5 < n4) {
            int n6;
            int n7 = byArray[n5] & 0xFF;
            if (n7 > 127) {
                if (n5 < n4 - 1) {
                    n7 = byArray[n5] << 8 & 0xFF00 | byArray[n5 + 1] & 0xFF;
                    ++n5;
                } else {
                    throw new SQLException("Cannot map Oracle character to Unicode.");
                }
            }
            if (((long)(n6 = this.toUnicode(n7)) & 0xFFFFFFFFL) > 65535L) {
                string = String.valueOf(string) + (char)(n6 >>> 16);
                string = String.valueOf(string) + (char)(n6 & 0xFFFF);
            } else {
                string = String.valueOf(string) + (char)n6;
            }
            ++n5;
        }
        return string;
    }

    public String toUnicodeStringWithReplacement(byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        String string = new String();
        int n5 = n2;
        while (n5 < n4) {
            int n6;
            int n7 = byArray[n5] & 0xFF;
            if (n7 > 127) {
                if (n4 - n5 < 2) break;
                n7 = byArray[n5] << 8 & 0xFF00 | byArray[n5 + 1] & 0xFF;
                ++n5;
            }
            if (((long)(n6 = this.toUnicodeWithReplacement(n7)) & 0xFFFFFFFFL) > 65535L) {
                string = String.valueOf(string) + (char)(n6 >>> 16);
                string = String.valueOf(string) + (char)(n6 & 0xFFFF);
            } else {
                string = String.valueOf(string) + (char)n6;
            }
            ++n5;
        }
        return string;
    }

    int toUnicodeWithReplacement(int n2) {
        int n3 = n2 >> 8 & 0xFF;
        int n4 = n2 & 0xFF;
        int n5 = this.m_ucsCharLevel1[n3] != '\uffff' && this.m_ucsCharLevel2[this.m_ucsCharLevel1[n3] + n4] != -1 ? this.m_ucsCharLevel2[this.m_ucsCharLevel1[n3] + n4] : this.m_ucsCharReplacement;
        return n5;
    }
}

