/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleConnection;
import oracle.jpub.runtime.Util;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.ORADataFactory;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class MutableStruct {
    int length;
    STRUCT pickled;
    Datum[] datums;
    Object[] attributes;
    CustomDatumFactory[] old_factories;
    ORADataFactory[] factories;
    int[] sqlTypes;
    boolean pickledCorrect;

    public MutableStruct(STRUCT sTRUCT, int[] nArray, ORADataFactory[] oRADataFactoryArray) {
        this.length = oRADataFactoryArray.length;
        this.pickled = sTRUCT;
        this.factories = oRADataFactoryArray;
        this.sqlTypes = nArray;
        this.pickledCorrect = true;
    }

    public MutableStruct(Object[] objectArray, int[] nArray, ORADataFactory[] oRADataFactoryArray) {
        this.length = oRADataFactoryArray.length;
        this.attributes = objectArray;
        this.factories = oRADataFactoryArray;
        this.sqlTypes = nArray;
        this.pickledCorrect = false;
    }

    public MutableStruct(STRUCT sTRUCT, int[] nArray, CustomDatumFactory[] customDatumFactoryArray) {
        this.length = customDatumFactoryArray.length;
        this.pickled = sTRUCT;
        this.old_factories = customDatumFactoryArray;
        this.sqlTypes = nArray;
        this.pickledCorrect = true;
    }

    public MutableStruct(Object[] objectArray, int[] nArray, CustomDatumFactory[] customDatumFactoryArray) {
        this.length = customDatumFactoryArray.length;
        this.attributes = objectArray;
        this.old_factories = customDatumFactoryArray;
        this.sqlTypes = nArray;
        this.pickledCorrect = false;
    }

    public Datum toDatum(Connection connection, String string) throws SQLException {
        if (!this.pickledCorrect) {
            this.pickled = new STRUCT(StructDescriptor.createDescriptor(string, connection), connection, this.getDatumAttributes(connection));
            this.pickledCorrect = true;
        }
        return this.pickled;
    }

    public Datum toDatum(oracle.jdbc.OracleConnection oracleConnection, String string) throws SQLException {
        return this.toDatum((Connection)oracleConnection, string);
    }

    public Datum toDatum(OracleConnection oracleConnection, String string) throws SQLException {
        return this.toDatum((Connection)oracleConnection, string);
    }

    public Object getAttribute(int n2) throws SQLException {
        Object object = this.getLazyAttributes()[n2];
        if (object == null) {
            Datum datum = this.getLazyDatums()[n2];
            if (this.old_factories == null) {
                this.attributes[n2] = object = Util.convertToObject(datum, this.sqlTypes[n2], this.factories[n2]);
                if (Util.isMutable(datum, this.factories[n2])) {
                    this.resetDatum(n2);
                }
            } else {
                this.attributes[n2] = object = Util.convertToObject(datum, this.sqlTypes[n2], this.old_factories[n2]);
                if (Util.isMutable(datum, this.old_factories[n2])) {
                    this.resetDatum(n2);
                }
            }
        }
        return object;
    }

    public Object getOracleAttribute(int n2) throws SQLException {
        Object object;
        if (this.old_factories == null) {
            if (this.factories[n2] == null) {
                object = this.getDatumAttribute(n2, null);
                Datum datum = this.getLazyDatums()[n2];
                if (Util.isMutable(datum, this.factories[n2])) {
                    this.pickledCorrect = false;
                }
            } else {
                object = this.getAttribute(n2);
            }
        } else if (this.old_factories[n2] == null) {
            object = this.getDatumAttribute(n2, null);
            Datum datum = this.getLazyDatums()[n2];
            if (Util.isMutable(datum, this.old_factories[n2])) {
                this.pickledCorrect = false;
            }
        } else {
            object = this.getAttribute(n2);
        }
        return object;
    }

    public Object[] getAttributes() throws SQLException {
        int n2 = 0;
        while (n2 < this.length) {
            this.getAttribute(n2);
            ++n2;
        }
        return this.attributes;
    }

    public Object[] getOracleAttributes() throws SQLException {
        Object[] objectArray = new Object[this.length];
        int n2 = 0;
        while (n2 < this.length) {
            objectArray[n2] = this.getOracleAttribute(n2);
            ++n2;
        }
        return objectArray;
    }

    public void setAttribute(int n2, Object object) throws SQLException {
        if (object == null) {
            this.getLazyDatums();
        }
        this.resetDatum(n2);
        this.getLazyAttributes()[n2] = object;
    }

    public void setDoubleAttribute(int n2, double d2) throws SQLException {
        this.setAttribute(n2, new Double(d2));
    }

    public void setFloatAttribute(int n2, float f2) throws SQLException {
        this.setAttribute(n2, new Float(f2));
    }

    public void setIntAttribute(int n2, int n3) throws SQLException {
        this.setAttribute(n2, new Integer(n3));
    }

    public void setOracleAttribute(int n2, Object object) throws SQLException {
        if (this.old_factories == null) {
            if (this.factories[n2] == null) {
                this.setDatumAttribute(n2, (Datum)object);
            } else {
                this.setAttribute(n2, object);
            }
        } else if (this.old_factories[n2] == null) {
            this.setDatumAttribute(n2, (Datum)object);
        } else {
            this.setAttribute(n2, object);
        }
    }

    Datum getDatumAttribute(int n2, Connection connection) throws SQLException {
        Datum datum = this.getLazyDatums()[n2];
        if (datum == null) {
            Object object = this.getLazyAttributes()[n2];
            this.datums[n2] = datum = Util.convertToOracle(object, connection);
        }
        return datum;
    }

    void setDatumAttribute(int n2, Datum datum) throws SQLException {
        this.resetAttribute(n2);
        this.getLazyDatums()[n2] = datum;
        this.pickledCorrect = false;
    }

    Datum[] getDatumAttributes(Connection connection) throws SQLException {
        int n2 = 0;
        while (n2 < this.length) {
            this.getDatumAttribute(n2, connection);
            ++n2;
        }
        return (Datum[])this.datums.clone();
    }

    void resetAttribute(int n2) throws SQLException {
        if (this.attributes != null) {
            this.attributes[n2] = null;
        }
    }

    void resetDatum(int n2) throws SQLException {
        if (this.datums != null) {
            this.datums[n2] = null;
        }
        this.pickledCorrect = false;
    }

    Object[] getLazyAttributes() {
        if (this.attributes == null) {
            this.attributes = new Object[this.length];
        }
        return this.attributes;
    }

    Datum[] getLazyDatums() throws SQLException {
        if (this.datums == null) {
            if (this.pickled != null) {
                this.datums = this.pickled.getOracleAttributes();
                this.pickledCorrect = true;
                if (this.attributes != null) {
                    int n2 = 0;
                    while (n2 < this.length) {
                        if (this.attributes[n2] != null) {
                            this.datums[n2] = null;
                            this.pickledCorrect = false;
                        }
                        ++n2;
                    }
                }
            } else {
                this.datums = new Datum[this.length];
            }
        }
        return this.datums;
    }
}

