/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import oracle.jdbc.driver.OracleLog;

public class OracleMultiPhaseArgs {
    int action = 0;
    int nsites = 0;
    Vector dbLinks = null;
    Vector xids = null;

    public OracleMultiPhaseArgs() {
    }

    public OracleMultiPhaseArgs(int n2, int n3, Vector vector, Vector vector2) {
        if (n3 <= 1) {
            this.action = 0;
            this.nsites = 0;
            this.dbLinks = null;
            this.xids = null;
        } else if (!vector.isEmpty() && !vector2.isEmpty() && vector2.size() == n3 && vector.size() == 3 * n3) {
            this.action = n2;
            this.nsites = n3;
            this.xids = vector;
            this.dbLinks = vector2;
        }
    }

    public OracleMultiPhaseArgs(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        this.xids = new Vector();
        this.dbLinks = new Vector();
        try {
            this.action = dataInputStream.readInt();
            this.nsites = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            byte[] byArray2 = new byte[n3];
            int n4 = dataInputStream.read(byArray2, 0, n3);
            int n5 = 0;
            while (n5 < this.nsites) {
                int n6 = dataInputStream.readInt();
                byte[] byArray3 = new byte[n6];
                int n7 = dataInputStream.read(byArray3, 0, n6);
                this.xids.addElement(new Integer(n2));
                this.xids.addElement(byArray2);
                this.xids.addElement(byArray3);
                String string = dataInputStream.readUTF();
                this.dbLinks.addElement(string);
                ++n5;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public byte[] toByteArray() {
        return this.toByteArrayOS().toByteArray();
    }

    public ByteArrayOutputStream toByteArrayOS() {
        byte[] byArray = null;
        int n2 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeInt(this.action);
            dataOutputStream.writeInt(this.nsites);
            int n3 = 0;
            while (n3 < this.nsites) {
                String string = (String)this.dbLinks.elementAt(n3);
                int n4 = (Integer)this.xids.elementAt(n3 * 3);
                byte[] byArray2 = (byte[])this.xids.elementAt(n3 * 3 + 1);
                byte[] byArray3 = (byte[])this.xids.elementAt(n3 * 3 + 2);
                if (n3 == 0) {
                    n2 = n4;
                    byArray = byArray2;
                    dataOutputStream.writeInt(n4);
                    dataOutputStream.writeInt(byArray2.length);
                    dataOutputStream.write(byArray2, 0, byArray2.length);
                }
                dataOutputStream.writeInt(byArray3.length);
                dataOutputStream.write(byArray3, 0, byArray3.length);
                dataOutputStream.writeUTF(string);
                ++n3;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream;
    }

    public int getAction() {
        return this.action;
    }

    public int getnsite() {
        return this.nsites;
    }

    public Vector getdbLinks() {
        return this.dbLinks;
    }

    public Vector getXids() {
        return this.xids;
    }

    public void printMPArgs() {
        OracleLog.print(this, 256, 16, 64, "-------printMPArgs entry-------");
        OracleLog.print(this, 256, 16, 64, "  action = " + this.action);
        OracleLog.print(this, 256, 16, 64, "  nsites = " + this.nsites);
        int n2 = 0;
        while (n2 < this.nsites) {
            String string = (String)this.dbLinks.elementAt(n2);
            int n3 = (Integer)this.xids.elementAt(n2 * 3);
            byte[] byArray = (byte[])this.xids.elementAt(n2 * 3 + 1);
            byte[] byArray2 = (byte[])this.xids.elementAt(n2 * 3 + 2);
            OracleLog.print(this, 256, 16, 64, "  fmtid  [" + n2 + "] = " + n3);
            OracleLog.print(this, 256, 16, 64, "  gtrid  [" + n2 + "] = ");
            this.printByteArray(byArray);
            OracleLog.print(this, 256, 16, 64, "  bqual  [" + n2 + "] = ");
            this.printByteArray(byArray2);
            OracleLog.print(this, 256, 16, 64, "  dblink [" + n2 + "] = " + string);
            ++n2;
        }
        OracleLog.print(this, 256, 16, 64, "-------printMPArgs return-------");
    }

    private void printByteArray(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < byArray.length) {
            stringBuffer.append(byArray[n2] + " ");
            ++n2;
        }
        OracleLog.print(this, 256, 16, 64, "         " + stringBuffer.toString());
    }
}

