/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.ttc7;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.ttc7.TTCColumn;

public abstract class TTCDataSet {
    protected TTCColumn[] columns;
    protected int depth;
    protected int marshaledRows;
    protected int unmarshaledRows;
    protected int unmarshaledCols;

    protected TTCDataSet(TTCColumn[] tTCColumnArray, int n2) {
        this.columns = tTCColumnArray != null ? tTCColumnArray : new TTCColumn[]{};
        this.depth = n2;
    }

    protected void marshalTypes() throws IOException, SQLException {
        int n2 = 0;
        while (n2 < this.columns.length) {
            this.columns[n2].marshalType();
            ++n2;
        }
    }

    protected int numberOfColumns() {
        return this.columns.length;
    }

    public void incrementeUnmarshaledRows() {
        ++this.unmarshaledRows;
    }

    public void incrementUnmarshaledcols() {
        ++this.unmarshaledCols;
    }

    public boolean isLastCol() {
        boolean bl = this.unmarshaledCols == this.columns.length - 1;
        return bl;
    }

    protected void print(int n2, int n3, int n4) {
        OracleLog.print(this, n2, n3, n4, "   ---- Enter: TTCDataSet.print --- ");
        OracleLog.print(this, n2, n3, n4, "     +++ Beginning of Columns Info +++++++ ");
        OracleLog.print(this, n2, n3, n4, "         columns.length = " + this.columns.length);
        int n5 = 0;
        while (n5 < this.columns.length) {
            OracleLog.print(this, n2, n3, n4, "Column # " + n5);
            this.columns[n5].print(n2, n3, n4);
            ++n5;
        }
        OracleLog.print(this, n2, n3, n4, "     +++ End of Columns Info +++++++ ");
        OracleLog.print(this, n2, n3, n4, "     TTCDataSet.depth          =" + this.depth);
        OracleLog.print(this, n2, n3, n4, "     TTCDataSet.marshaledRows  =" + this.marshaledRows);
        OracleLog.print(this, n2, n3, n4, "     TTCDataSet.unmarshaledRows=" + this.unmarshaledRows);
        OracleLog.print(this, n2, n3, n4, "   ---- Exit: TTCDataSet.print --- ");
    }

    protected abstract void marshalRow() throws SQLException, IOException;

    protected abstract boolean unmarshalRow() throws SQLException, IOException;

    protected boolean unmarshalRow(int n2, int n3) throws SQLException, IOException {
        return false;
    }

    protected void processIndicator() throws IOException, SQLException {
    }

    protected abstract boolean next() throws SQLException, IOException;
}

