/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import oracle.jdbc.OracleParameterMetaData;
import oracle.jdbc.dbaccess.DBConversion;
import oracle.jdbc.dbaccess.DBDataSet;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.ScrollRsetStatement;
import oracle.jdbc.internal.ObjectData;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleTypeCHAR;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class OraclePreparedStatement
extends OracleStatement
implements oracle.jdbc.internal.OraclePreparedStatement,
ScrollRsetStatement {
    private int min_binary_stream_size;
    private int min_ascii_stream_size;
    private int premature_batch_count;
    boolean check_bind_types = true;
    DBDataSet m_binds;
    boolean m_scrollRsetTypeSolved;
    boolean has_ref_cursors = false;
    protected static final int BSTYLE_UNKNOWN = 0;
    protected static final int BSTYLE_ORACLE = 1;
    protected static final int BSTYLE_JDBC = 2;
    protected int m_batchStyle = 0;

    public OraclePreparedStatement(OracleConnection oracleConnection, String string, int n2, int n3) throws SQLException {
        this(oracleConnection, string, n2, n3, 1003, 1007);
    }

    public OraclePreparedStatement(OracleConnection oracleConnection, String string, int n2, int n3, int n4, int n5) throws SQLException {
        super(oracleConnection, n2, n3, n4, n5);
        this.statementType = 1;
        this.need_to_parse = true;
        this.has_ref_cursors = false;
        this.prepare_for_new_result(true);
        this.sql_query = string;
        this.m_originalSql = string;
        this.clear_params = true;
        this.m_binds = null;
        this.m_scrollRsetTypeSolved = false;
        this.premature_batch_count = 0;
        this.binds_in = this.connection.db_access.createDBDataSet(oracleConnection, this, n2, 1);
        this.parseSqlKind();
        if (oracleConnection.db_access.getVersionNumber() >= 8000) {
            this.min_binary_stream_size = 2000;
            this.min_ascii_stream_size = 4000;
        } else {
            this.min_binary_stream_size = 255;
            this.min_ascii_stream_size = 2000;
        }
    }

    protected void enterImplicitCache() throws SQLException {
        this.cacheState = OracleStatement.CACHED;
        this.m_creationState = 1;
        this.initializeState(this.batch, this.row_prefetch, this.m_autoRefetch, this.serverCursor);
        if (this.connection.m_stmtClearMetaData) {
            this.initializeMetaData();
        }
        this.dbstmt.enterCache();
        if (this.binds_in != null) {
            this.binds_in.enterCache();
        }
        if (this.binds_out != null) {
            this.binds_out.enterCache();
        }
        if (this.columns_defined_by_user && this.defines != null) {
            this.defines.enterCache();
        }
    }

    protected void enterExplicitCache() throws SQLException {
        this.cacheState = OracleStatement.CACHED;
        this.m_creationState = 2;
    }

    protected void exitImplicitCacheToActive() throws SQLException {
        this.cacheState = OracleStatement.ACTIVE;
        this.dbstmt.reactivate();
        if (this.binds_in != null) {
            this.binds_in.reactivate();
        }
        if (this.binds_out != null) {
            this.binds_out.reactivate();
        }
        if (this.defines != null) {
            this.defines.reactivate();
        }
        if (this.row_prefetch != this.connection.getDefaultRowPrefetch()) {
            this.row_prefetch = this.connection.getDefaultRowPrefetch();
            this.default_row_prefetch = this.connection.getDefaultRowPrefetch();
            this.need_to_parse = true;
        }
        if (this.batch != this.connection.getDefaultExecuteBatch()) {
            this.batch = this.connection.getDefaultExecuteBatch();
            this.need_to_parse = true;
        }
        if (this.m_autoRefetch != this.connection.getDefaultAutoRefetch()) {
            this.m_autoRefetch = this.connection.getDefaultAutoRefetch();
            this.need_to_parse = true;
        }
    }

    protected void exitExplicitCacheToActive() throws SQLException {
        this.cacheState = OracleStatement.ACTIVE;
    }

    protected void exitImplicitCacheToClose() throws SQLException {
        this.cacheState = OracleStatement.CLOSED;
        super.close();
    }

    protected void exitExplicitCacheToClose() throws SQLException {
        this.cacheState = OracleStatement.CLOSED;
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.privateClose(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWithKey(String string) throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.privateClose(string);
            }
        }
    }

    private void privateClose(String string) throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.doesJdbcBatchExist()) {
            this.clearBatch();
        } else {
            this.sendBatch();
        }
        if (this.connection.isStatementCacheInitialized() && this.cacheState != OracleStatement.CLOSED && this.cacheState != OracleStatement.NON_CACHED) {
            if (string == null) {
                if (this.connection.getImplicitCachingEnabled()) {
                    this.connection.cacheImplicitStatement(this, this.sql_query, this.statementType, this.m_userRsetType);
                } else {
                    this.cacheState = OracleStatement.CLOSED;
                    super.close();
                }
            } else if (this.connection.getExplicitCachingEnabled()) {
                this.connection.cacheExplicitStatement(this, string);
            } else {
                this.cacheState = OracleStatement.CLOSED;
                super.close();
            }
        } else {
            super.close();
        }
        if (string == null) {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResultSet executeQuery() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.executeUpdate();
                if (this.isRegularResultSet()) {
                    this.current_result_set = new OracleResultSetImpl(this.connection, this);
                    return this.current_result_set;
                }
                if (this.m_scrollRset != null) return this.m_scrollRset;
                this.current_result_set = new OracleResultSetImpl(this.connection, this);
                this.m_scrollRset = this.current_result_set;
                return this.m_scrollRset;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.noMoreUpdateCounts = false;
                this.checkIfJdbcBatchExists();
                this.ensureOpen();
                if (this.has_ref_cursors) {
                    this.need_to_parse = true;
                }
                if (this.isRegularResultSet()) {
                    this.prepare_for_new_result(true);
                    this.get_data_for_columns(this.batch);
                    this.doExecuteWithTimeout();
                    if (this.valid_rows <= 0) return this.valid_rows;
                    this.valid_rows += this.premature_batch_count;
                    this.premature_batch_count = 0;
                    return this.valid_rows;
                }
                if (!this.m_scrollRsetTypeSolved) {
                    int n2 = this.doScrollPstmtExecuteUpdate() + this.premature_batch_count;
                    return n2;
                }
                this.prepare_for_new_result(true);
                this.get_data_for_columns(this.batch);
                this.doExecuteWithTimeout();
                this.current_result_set = new OracleResultSetImpl(this.connection, this);
                this.m_scrollRset = ResultSetUtil.createScrollResultSet(this, this.current_result_set, this.m_realRsetType);
                if (!this.connection.m_accumulateBatchResult) return this.valid_rows;
                if (this.valid_rows <= 0) return this.valid_rows;
                this.valid_rows += this.premature_batch_count;
                this.premature_batch_count = 0;
                return this.valid_rows;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                this.checkIfJdbcBatchExists();
                this.executeUpdate();
                boolean bl = this.sql_kind == 0;
                return bl;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int sendBatch() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                if (this.isJdbcBatchStyle()) {
                    return 0;
                }
                this.ensureOpen();
                if (this.m_currentRank <= 0) {
                    if (this.connection.m_accumulateBatchResult) {
                        return 0;
                    }
                    int n2 = this.valid_rows;
                    return n2;
                }
                int n3 = this.batch;
                try {
                    --this.m_currentRank;
                    if (this.batch != this.m_currentRank) {
                        this.batch = this.m_currentRank;
                        this.need_to_parse = true;
                    }
                    this.doExecuteWithTimeout();
                    Object var6_6 = null;
                    if (this.batch != n3) {
                        this.batch = n3;
                        this.need_to_parse = true;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (this.batch == n3) throw throwable;
                    this.batch = n3;
                    this.need_to_parse = true;
                    throw throwable;
                }
                if (!this.connection.m_accumulateBatchResult) return this.valid_rows;
                this.valid_rows += this.premature_batch_count;
                this.premature_batch_count = 0;
                return this.valid_rows;
            }
        }
    }

    public synchronized void setExecuteBatch(int n2) throws SQLException {
        this.setOracleBatchStyle();
        this.set_execute_batch(n2);
    }

    private synchronized void set_execute_batch(int n2) throws SQLException {
        if (n2 <= 0) {
            DBError.throwSqlException(42);
        }
        if (n2 == this.batch) {
            return;
        }
        this.batch = n2;
        if (this.m_currentRank > 0) {
            this.sendBatch();
        }
        this.binds_in.setBatchSize(n2);
        this.need_to_parse = true;
    }

    public final int getExecuteBatch() {
        return this.batch;
    }

    public synchronized void defineParameterTypeBytes(int n2, int n3, int n4) throws SQLException {
        if (n4 < 0) {
            DBError.throwSqlException(53);
        }
        if (n2 < 1) {
            DBError.throwSqlException(3);
        }
        switch (n3) {
            case -7: 
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n3 = 6;
                break;
            }
            case 999: {
                n3 = 999;
                break;
            }
            case 1: {
                n3 = 96;
                break;
            }
            case 12: {
                n3 = 1;
                break;
            }
            case 91: 
            case 92: {
                n3 = 12;
                break;
            }
            case -103: {
                n3 = 182;
                break;
            }
            case -104: {
                n3 = 183;
                break;
            }
            case -100: 
            case 93: {
                n3 = 180;
                break;
            }
            case -101: {
                n3 = 181;
                break;
            }
            case -102: {
                n3 = 231;
                break;
            }
            case -3: 
            case -2: {
                n3 = 23;
                break;
            }
            case -8: {
                n3 = 104;
                break;
            }
            case 2004: {
                n3 = 113;
                break;
            }
            case 2005: {
                n3 = 112;
                break;
            }
            case -13: {
                n3 = 114;
                break;
            }
            case -10: {
                n3 = 102;
                break;
            }
            default: {
                DBError.throwSqlException(23);
            }
        }
        this.binds_in.setType(n2 - 1, n3, n4, (short)1);
    }

    public synchronized void defineParameterTypeChars(int n2, int n3, int n4) throws SQLException {
        int n5 = this.connection.db_access.getNlsRatio();
        if (n3 == 1 || n3 == 12) {
            this.defineParameterTypeBytes(n2, n3, n4 * n5);
        } else {
            this.defineParameterTypeBytes(n2, n3, n4);
        }
    }

    public synchronized void defineParameterType(int n2, int n3, int n4) throws SQLException {
        this.defineParameterTypeBytes(n2, n3, n4 * this.connection.dataSizeScale);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSet resultSet = this.getResultSet();
        if (resultSet != null) {
            return resultSet.getMetaData();
        }
        return null;
    }

    protected void setItem(int n2, int n3, byte[] byArray) throws SQLException {
        this.checkBindTypes(true, n2, n3);
        if (this.binds_in.setBytesBindItem(n2, this.m_currentRank, n3, byArray)) {
            this.need_to_parse = true;
        }
    }

    protected void setItem(int n2, int n3, String string) throws SQLException {
        this.checkBindTypes(true, n2, n3);
        if (this.binds_in.setBytesBindItem(n2, this.m_currentRank, n3, string)) {
            this.need_to_parse = true;
        }
    }

    protected void setStreamItem(int n2, int n3, InputStream inputStream, int n4) throws SQLException {
        if (n4 < 0) {
            DBError.throwSqlException(43);
        }
        this.checkBindTypes(true, n2, n3);
        this.binds_in.setStreamBindItem(n2, this.m_currentRank, n3, inputStream, n4);
    }

    public synchronized void setNull(int n2, int n3, String string) throws SQLException {
        if (n3 == 2002 || n3 == 2008 || n3 == 2003 || n3 == 2007 || n3 == 2006) {
            int n4 = this.get_internal_type(n3);
            OracleNamedType oracleNamedType = null;
            int n5 = n2 - 1;
            this.columnSetNull = true;
            this.checkBindTypes(true, n5, n4);
            switch (n3) {
                case 2002: 
                case 2006: 
                case 2008: {
                    StructDescriptor structDescriptor = StructDescriptor.createDescriptor(string, this.connection);
                    oracleNamedType = structDescriptor.getOracleTypeADT();
                    break;
                }
                case 2003: {
                    ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor(string, this.connection);
                    oracleNamedType = arrayDescriptor.getOracleTypeCOLLECTION();
                    break;
                }
                case 2007: {
                    OpaqueDescriptor opaqueDescriptor = OpaqueDescriptor.createDescriptor(string, this.connection);
                    oracleNamedType = opaqueDescriptor.getPickler();
                    break;
                }
                default: {
                    DBError.throwSqlException(1);
                }
            }
            if (this.binds_in.setNullADTBindItem(n5, this.m_currentRank, n4, oracleNamedType)) {
                this.need_to_parse = true;
            }
        } else {
            this.setNull(n2, n3);
        }
        this.columnSetNull = false;
    }

    public synchronized void setNull(int n2, int n3) throws SQLException {
        if (n3 == 2002 || n3 == 2008 || n3 == 2003 || n3 == 2007 || n3 == 2006) {
            DBError.throwSqlException(4, "sqlType=" + n3);
        }
        int n4 = n2 - 1;
        int n5 = this.get_internal_type(n3);
        this.columnSetNull = true;
        this.checkBindTypes(true, n4, n5);
        switch (n5) {
            case 8: {
                n5 = 1;
                break;
            }
            case 24: {
                n5 = 23;
            }
        }
        this.binds_in.setNullBindItem(n4, this.m_currentRank, n5);
        this.columnSetNull = false;
    }

    public synchronized void setBoolean(int n2, boolean bl) throws SQLException {
        int n3 = n2 - 1;
        byte[] byArray = DBConversion.BooleanToNumberBytes(bl);
        this.setItem(n3, 6, byArray);
    }

    public synchronized void setByte(int n2, byte by) throws SQLException {
        int n3 = n2 - 1;
        byte[] byArray = DBConversion.ByteToNumberBytes(by);
        this.setItem(n3, 6, byArray);
    }

    public synchronized void setShort(int n2, short s2) throws SQLException {
        int n3 = n2 - 1;
        byte[] byArray = DBConversion.ShortToNumberBytes(s2);
        this.setItem(n3, 6, byArray);
    }

    public synchronized void setInt(int n2, int n3) throws SQLException {
        int n4 = n2 - 1;
        byte[] byArray = DBConversion.IntToNumberBytes(n3);
        this.setItem(n4, 6, byArray);
    }

    public synchronized void setLong(int n2, long l2) throws SQLException {
        int n3 = n2 - 1;
        byte[] byArray = DBConversion.LongToNumberBytes(l2);
        this.setItem(n3, 6, byArray);
    }

    public synchronized void setFloat(int n2, float f2) throws SQLException {
        int n3 = n2 - 1;
        byte[] byArray = DBConversion.FloatToNumberBytes(f2);
        this.setItem(n3, 6, byArray);
    }

    public synchronized void setDouble(int n2, double d2) throws SQLException {
        int n3 = n2 - 1;
        byte[] byArray = DBConversion.DoubleToNumberBytes(d2);
        this.setItem(n3, 6, byArray);
    }

    public synchronized void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        int n3 = n2 - 1;
        byte[] byArray = DBConversion.BigDecimalToNumberBytes(bigDecimal);
        this.setItem(n3, 6, byArray);
    }

    public synchronized void setString(int n2, String string) throws SQLException {
        int n3 = n2 - 1;
        boolean bl = this.connection.getProtocolType().equals("thin");
        boolean bl2 = false;
        if (this.binds_in != null) {
            boolean bl3 = bl2 = this.binds_in.getFormOfUse(n2 - 1) == 2;
        }
        if (bl) {
            this.setItem(n3, 1, string);
        } else {
            byte[] byArray = null;
            byArray = bl2 ? this.connection.conversion.StringToNCharBytes(string) : this.connection.conversion.StringToCharBytes(string);
            this.setItem(n3, 1, byArray);
        }
    }

    public synchronized void setFixedCHAR(int n2, String string) throws SQLException {
        int n3 = n2 - 1;
        byte[] byArray = this.connection.conversion.StringToCharBytes(string);
        this.setItem(n3, 999, byArray);
    }

    public synchronized void setCursor(int n2, ResultSet resultSet) throws SQLException {
        throw DBError.newSqlException(23);
    }

    public synchronized void setROWID(int n2, ROWID rOWID) throws SQLException {
        this.setDatum(n2 - 1, 104, rOWID);
    }

    public synchronized void setArray(int n2, Array array) throws SQLException {
        this.setARRAY(n2, (ARRAY)array);
    }

    public synchronized void setARRAY(int n2, ARRAY aRRAY) throws SQLException {
        if (aRRAY == null) {
            DBError.throwSqlException(68);
        }
        if (aRRAY.getDescriptor() == null) {
            DBError.throwSqlException(61);
        }
        int n3 = n2 - 1;
        this.checkBindTypes(true, n3, 109);
        byte[] byArray = aRRAY.toBytes();
        if (this.binds_in.setADTBindItem(n3, this.m_currentRank, 109, byArray, aRRAY.getDescriptor().getOracleTypeCOLLECTION())) {
            this.need_to_parse = true;
        }
    }

    public synchronized void setOPAQUE(int n2, OPAQUE oPAQUE) throws SQLException {
        int n3 = n2 - 1;
        if (oPAQUE == null) {
            DBError.throwSqlException(68);
        }
        if (oPAQUE.getDescriptor() == null) {
            DBError.throwSqlException(61);
        }
        this.checkBindTypes(true, n3, 109);
        byte[] byArray = oPAQUE.toBytes();
        if (this.binds_in.setADTBindItem(n3, this.m_currentRank, 109, byArray, (OracleTypeOPAQUE)oPAQUE.getDescriptor().getPickler())) {
            this.need_to_parse = true;
        }
    }

    public synchronized void setStructDescriptor(int n2, StructDescriptor structDescriptor) throws SQLException {
        int n3 = n2 - 1;
        if (structDescriptor == null) {
            DBError.throwSqlException(68);
        }
        this.checkBindTypes(true, n3, 109);
        this.binds_in.setADTBindType(n3, this.m_currentRank, 109, structDescriptor.getOracleTypeADT());
    }

    public synchronized void setPreBindsCompelete() throws SQLException {
        this.binds_in.setFirstRow(false);
    }

    public synchronized void setSTRUCT(int n2, STRUCT sTRUCT) throws SQLException {
        StructDescriptor structDescriptor;
        int n3 = n2 - 1;
        if (sTRUCT == null) {
            DBError.throwSqlException(68);
        }
        if ((structDescriptor = sTRUCT.getDescriptor()) == null) {
            DBError.throwSqlException(61);
        }
        this.checkBindObjectTypes(true, n3, 109, structDescriptor);
        byte[] byArray = sTRUCT.toBytes();
        if (this.binds_in.setADTBindItem(n3, this.m_currentRank, 109, byArray, structDescriptor.getOracleTypeADT())) {
            this.need_to_parse = true;
        }
    }

    public synchronized void setRAW(int n2, RAW rAW) throws SQLException {
        this.setDatum(n2 - 1, 23, rAW);
    }

    public synchronized void setCHAR(int n2, CHAR cHAR) throws SQLException {
        int n3 = 1;
        CHAR cHAR2 = cHAR;
        if (cHAR2 != null) {
            short s2 = (short)cHAR2.getCharacterSet().getOracleId();
            CharacterSet characterSet = this.binds_in != null && this.binds_in.getFormOfUse(n2 - 1) == 2 ? this.connection.conversion.getAccessNCharSetObj() : this.connection.conversion.getAccessCharSetObj();
            if (characterSet != null && s2 != characterSet.getOracleId()) {
                byte[] byArray = cHAR2.getBytes();
                cHAR2 = new CHAR(characterSet.convert(cHAR.getCharacterSet(), byArray, 0, byArray.length), characterSet);
            }
        }
        this.setDatum(n2 - 1, n3, cHAR2);
    }

    public synchronized void setDATE(int n2, DATE dATE) throws SQLException {
        this.setDatum(n2 - 1, 12, dATE);
    }

    public synchronized void setNUMBER(int n2, NUMBER nUMBER) throws SQLException {
        this.setDatum(n2 - 1, 6, nUMBER);
    }

    private void setDatum(int n2, int n3, Datum datum) throws SQLException {
        if (datum == null) {
            this.setItem(n2, n3, (byte[])null);
        } else {
            this.setItem(n2, n3, datum.getBytes());
        }
    }

    public synchronized void setBLOB(int n2, BLOB bLOB) throws SQLException {
        this.setDatum(n2 - 1, 113, bLOB);
    }

    public synchronized void setBlob(int n2, Blob blob) throws SQLException {
        this.setBLOB(n2, (BLOB)blob);
    }

    public synchronized void setCLOB(int n2, CLOB cLOB) throws SQLException {
        this.setDatum(n2 - 1, 112, cLOB);
    }

    public synchronized void setClob(int n2, Clob clob) throws SQLException {
        this.setCLOB(n2, (CLOB)clob);
    }

    public synchronized void setBFILE(int n2, BFILE bFILE) throws SQLException {
        this.setDatum(n2 - 1, 114, bFILE);
    }

    public synchronized void setBfile(int n2, BFILE bFILE) throws SQLException {
        this.setBFILE(n2, bFILE);
    }

    public synchronized void setBytes(int n2, byte[] byArray) throws SQLException {
        int n3 = n2 - 1;
        if (byArray != null) {
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.setItem(n3, 23, byArray2);
        } else {
            this.setItem(n3, 23, (byte[])null);
        }
    }

    public synchronized void setInternalBytes(int n2, byte[] byArray, int n3) throws SQLException {
        int n4 = n2 - 1;
        this.setItem(n4, n3, byArray);
    }

    public synchronized void setDate(int n2, Date date) throws SQLException {
        int n3 = n2 - 1;
        byte[] byArray = this.connection.conversion.DateToDateBytes(date);
        this.setItem(n3, 12, byArray);
    }

    public synchronized void setTime(int n2, Time time) throws SQLException {
        int n3 = n2 - 1;
        byte[] byArray = this.connection.conversion.TimeToDateBytes(time);
        this.setItem(n3, 12, byArray);
    }

    public synchronized void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        int n3 = n2 - 1;
        byte[] byArray = TIMESTAMP.toBytes(timestamp);
        this.setItem(n3, 180, byArray);
    }

    public synchronized void setINTERVALYM(int n2, INTERVALYM iNTERVALYM) throws SQLException {
        this.setDatum(n2 - 1, 182, iNTERVALYM);
    }

    public synchronized void setTIMESTAMP(int n2, TIMESTAMP tIMESTAMP) throws SQLException {
        this.setDatum(n2 - 1, 180, tIMESTAMP);
    }

    public synchronized void setTIMESTAMPTZ(int n2, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        this.setDatum(n2 - 1, 181, tIMESTAMPTZ);
    }

    public synchronized void setTIMESTAMPLTZ(int n2, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        if (this.connection.getSessionTimeZone() == null) {
            DBError.throwSqlException(105);
        }
        this.setDatum(n2 - 1, 231, tIMESTAMPLTZ);
    }

    public synchronized void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.set_execute_batch(1);
        if (inputStream != null) {
            int n4 = n2 - 1;
            int n5 = this.connection.db_access.getMinAsciiStreamSize(this.connection, this.min_ascii_stream_size);
            if (this.sql_kind == 1 || n3 <= n5 || !this.isRegularResultSet()) {
                try {
                    byte[] byArray = new byte[n3];
                    inputStream.read(byArray, 0, n3);
                    byte[] byArray2 = this.connection.conversion.asciiBytesToCHARBytes(byArray);
                    this.setItem(n4, 1, byArray2);
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                }
            } else {
                InputStream inputStream2 = this.connection.conversion.ConvertStream(inputStream, 5, n3);
                this.setStreamItem(n4, 8, inputStream2, n3);
            }
        } else {
            this.setString(n2, null);
        }
    }

    public synchronized void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.set_execute_batch(1);
        if (inputStream != null) {
            int n4 = n2 - 1;
            if (this.sql_kind == 1 || n3 <= this.min_binary_stream_size || !this.isRegularResultSet()) {
                try {
                    byte[] byArray = new byte[n3];
                    inputStream.read(byArray, 0, n3);
                    this.setItem(n4, 23, byArray);
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                }
            } else {
                this.setStreamItem(n4, 24, inputStream, n3);
            }
        } else {
            this.setBytes(n2, null);
        }
    }

    public synchronized void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.set_execute_batch(1);
        if (inputStream != null) {
            int n4 = n2 - 1;
            InputStream inputStream2 = this.connection.conversion.ConvertStream(inputStream, 4, n3);
            int n5 = 2 * (this.min_ascii_stream_size / this.connection.db_access.getC2SNlsRatio()) / this.connection.conversion.getMaxCharbyteSize();
            if (this.sql_kind == 1 || n3 <= n5 || !this.isRegularResultSet()) {
                try {
                    int n6;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                    byte[] byArray = new byte[1024];
                    while ((n6 = inputStream2.read(byArray)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n6);
                    }
                    this.setItem(n4, 1, byteArrayOutputStream.toByteArray());
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                }
            } else {
                this.setStreamItem(n4, 8, inputStream2, n3 * this.connection.conversion.getMaxCharbyteSize());
            }
        } else {
            this.setString(n2, null);
        }
    }

    public synchronized void setCustomDatum(int n2, CustomDatum customDatum) throws SQLException {
        Datum datum = customDatum.toDatum(this.connection);
        this.setOracleObject(n2, datum);
    }

    public synchronized void setORAData(int n2, ORAData oRAData) throws SQLException {
        Datum datum = oRAData.toDatum(this.connection);
        this.setOracleObject(n2, datum);
    }

    public synchronized void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        if (object == null && n3 != 2002 && n3 != 2008 && n3 != 2003 && n3 != 2007 && n3 != 2006) {
            this.setNull(n2, n3);
        } else {
            switch (n3) {
                case 1: {
                    if (object instanceof CHAR) {
                        this.setCHAR(n2, (CHAR)object);
                        break;
                    }
                    this.setString(n2, (String)object);
                    break;
                }
                case 12: {
                    this.setString(n2, (String)object);
                    break;
                }
                case 999: {
                    this.setFixedCHAR(n2, (String)object);
                    break;
                }
                case -1: {
                    this.setString(n2, (String)object);
                    break;
                }
                case 2: {
                    if (object instanceof NUMBER) {
                        this.setNUMBER(n2, (NUMBER)object);
                        break;
                    }
                    if (object instanceof Byte) {
                        this.setByte(n2, (Byte)object);
                        break;
                    }
                    if (object instanceof Short) {
                        this.setShort(n2, (Short)object);
                        break;
                    }
                    if (object instanceof Integer) {
                        this.setInt(n2, (Integer)object);
                        break;
                    }
                    if (object instanceof Long) {
                        this.setLong(n2, (Long)object);
                        break;
                    }
                    if (object instanceof Float) {
                        this.setFloat(n2, ((Float)object).floatValue());
                        break;
                    }
                    if (object instanceof Double) {
                        this.setDouble(n2, (Double)object);
                        break;
                    }
                    this.setBigDecimal(n2, (BigDecimal)object);
                    break;
                }
                case 3: {
                    this.setBigDecimal(n2, (BigDecimal)object);
                    break;
                }
                case -7: {
                    this.setBoolean(n2, (Boolean)object);
                    break;
                }
                case -6: {
                    this.setByte(n2, ((Number)object).byteValue());
                    break;
                }
                case 5: {
                    this.setShort(n2, ((Number)object).shortValue());
                    break;
                }
                case 4: {
                    this.setInt(n2, ((Number)object).intValue());
                    break;
                }
                case -5: {
                    this.setLong(n2, ((Number)object).longValue());
                    break;
                }
                case 6: 
                case 7: {
                    this.setFloat(n2, ((Number)object).floatValue());
                    break;
                }
                case 8: {
                    this.setDouble(n2, ((Number)object).doubleValue());
                    break;
                }
                case -2: {
                    if (object instanceof RAW) {
                        this.setRAW(n2, (RAW)object);
                        break;
                    }
                    this.setBytes(n2, (byte[])object);
                    break;
                }
                case -3: {
                    this.setBytes(n2, (byte[])object);
                    break;
                }
                case -4: {
                    this.setBytes(n2, (byte[])object);
                    break;
                }
                case 91: {
                    if (object instanceof DATE) {
                        this.setDATE(n2, (DATE)object);
                        break;
                    }
                    this.setDate(n2, (Date)object);
                    break;
                }
                case 92: {
                    this.setTime(n2, (Time)object);
                    break;
                }
                case 93: {
                    if (object instanceof TIMESTAMP) {
                        this.setTIMESTAMP(n2, (TIMESTAMP)object);
                        break;
                    }
                    this.setTimestamp(n2, (Timestamp)object);
                    break;
                }
                case -100: {
                    this.setTIMESTAMP(n2, (TIMESTAMP)object);
                    break;
                }
                case -101: {
                    this.setTIMESTAMPTZ(n2, (TIMESTAMPTZ)object);
                    break;
                }
                case -102: {
                    this.setTIMESTAMPLTZ(n2, (TIMESTAMPLTZ)object);
                    break;
                }
                case -103: {
                    this.setINTERVALYM(n2, (INTERVALYM)object);
                    break;
                }
                case -8: {
                    this.setROWID(n2, (ROWID)object);
                    break;
                }
                case 2004: {
                    this.setBLOB(n2, (BLOB)object);
                    break;
                }
                case 2005: {
                    this.setCLOB(n2, (CLOB)object);
                    break;
                }
                case -13: {
                    this.setBFILE(n2, (BFILE)object);
                    break;
                }
                case 2002: 
                case 2008: {
                    this.setSTRUCT(n2, STRUCT.toSTRUCT(object, this.connection));
                    break;
                }
                case 2003: {
                    this.setARRAY(n2, (ARRAY)object);
                    break;
                }
                case 2007: {
                    this.setOPAQUE(n2, (OPAQUE)object);
                    break;
                }
                case 2006: {
                    this.setREF(n2, (REF)object);
                    break;
                }
                default: {
                    DBError.throwSqlException(4);
                }
            }
        }
    }

    public void setObject(int n2, Object object, int n3) throws SQLException {
        this.setObject(n2, object, n3, 0);
    }

    public void setRefType(int n2, REF rEF) throws SQLException {
        this.setREF(n2, rEF);
    }

    public synchronized void setRef(int n2, Ref ref) throws SQLException {
        this.setREF(n2, (REF)ref);
    }

    public synchronized void setREF(int n2, REF rEF) throws SQLException {
        if (rEF == null) {
            DBError.throwSqlException(68);
        }
        if (rEF.getDescriptor() == null) {
            DBError.throwSqlException(52);
        }
        int n3 = n2 - 1;
        this.checkBindTypes(true, n3, 111);
        byte[] byArray = rEF.getBytes();
        if (this.binds_in.setADTBindItem(n3, this.m_currentRank, 111, byArray, rEF.getDescriptor().getOracleTypeADT())) {
            this.need_to_parse = true;
        }
    }

    public synchronized void setObject(int n2, Object object) throws SQLException {
        if (object instanceof ORAData) {
            this.setORAData(n2, (ORAData)object);
        } else if (object instanceof CustomDatum) {
            this.setCustomDatum(n2, (CustomDatum)object);
        } else {
            int n3 = this.sqlTypeForObject(object);
            this.setObject(n2, object, n3, 0);
        }
    }

    public synchronized void setOracleObject(int n2, Datum datum) throws SQLException {
        this.setObject(n2, datum);
    }

    public synchronized void setPlsqlIndexTable(int n2, Object object, int n3, int n4, int n5, int n6) throws SQLException {
        if (n3 < 0 || n4 < 0 || n3 < n4) {
            DBError.throwSqlException(68, "maxLen < 0, curLen < 0 or maxLen < curLen ");
        }
        int n7 = this.get_internal_type(n5);
        this.checkPlsqlIndexTableBindTypes(true, n2 - 1, n3, n7, n6);
        Datum[] datumArray = null;
        switch (n7) {
            case 1: 
            case 96: {
                OracleTypeCHAR oracleTypeCHAR = new OracleTypeCHAR(this.connection);
                datumArray = oracleTypeCHAR.toDatumArray(object, this.connection, 1L, n4);
                break;
            }
            case 2: 
            case 6: {
                datumArray = OracleTypeNUMBER.toNUMBERArray(object, this.connection, 1L, n4);
                break;
            }
            default: {
                DBError.throwSqlException(97);
                return;
            }
        }
        if (this.binds_in.setPlsqlIndexTableItem(n2 - 1, this.m_currentRank, datumArray, n3, n4, n7, n6)) {
            this.need_to_parse = true;
        }
    }

    void checkPlsqlIndexTableBindTypes(boolean bl, int n2, int n3, int n4, int n5) throws SQLException {
        int n6 = 0;
        switch (n4) {
            case 1: 
            case 2: 
            case 6: 
            case 96: {
                break;
            }
            default: {
                DBError.throwSqlException(97);
            }
        }
        if (!this.check_bind_types) {
            return;
        }
        n6 = bl ? this.binds_in.checkPlsqlIndexTableBindTypes(this.binds_out, n2, n3, n5, n4) : this.binds_out.checkPlsqlIndexTableBindTypes(this.binds_in, n2, n3, n5, n4);
        if (n6 == -1) {
            this.sendBatch();
            this.need_to_parse = true;
            this.clearDefines();
        }
    }

    void end_of_result_set() throws SQLException {
        this.prepare_for_new_result(false);
    }

    private void get_data_for_columns(int n2) throws SQLException {
        this.binds_in.rowCompleted(this.m_currentRank);
        if (this.binds_out != null) {
            this.binds_out.rowCompleted(this.m_currentRank);
        }
    }

    protected void checkBindTypes(boolean bl, int n2, int n3) throws SQLException {
        if (!this.check_bind_types) {
            return;
        }
        int n4 = bl ? this.binds_in.checkBindTypes(this.binds_out, n2, n3) : this.binds_out.checkBindTypes(this.binds_in, n2, n3);
        if (n4 == -1) {
            int n5 = this.m_currentRank;
            this.premature_batch_count = this.sendBatch();
            this.need_to_parse = true;
            this.binds_in.clearItem(n5, true);
        }
    }

    protected void checkBindObjectTypes(boolean bl, int n2, int n3, StructDescriptor structDescriptor) throws SQLException {
        if (!this.check_bind_types) {
            return;
        }
        int n4 = bl ? this.binds_in.checkBindObjectTypes(this.binds_out, n2, n3, structDescriptor) : this.binds_out.checkBindObjectTypes(this.binds_in, n2, n3, structDescriptor);
        if (n4 == -1) {
            this.premature_batch_count = this.sendBatch();
            this.need_to_parse = true;
        }
    }

    int sqlTypeForObject(Object object) {
        if (object == null) {
            return 0;
        }
        if (!(object instanceof Datum)) {
            if (object instanceof String) {
                return this.fixedString ? 999 : 12;
            }
            if (object instanceof BigDecimal) {
                return 2;
            }
            if (object instanceof Boolean) {
                return -7;
            }
            if (object instanceof Integer) {
                return 4;
            }
            if (object instanceof Long) {
                return -5;
            }
            if (object instanceof Float) {
                return 6;
            }
            if (object instanceof Double) {
                return 8;
            }
            if (object instanceof byte[]) {
                return -3;
            }
            if (object instanceof Short) {
                return 5;
            }
            if (object instanceof Byte) {
                return -6;
            }
            if (object instanceof Date) {
                return 91;
            }
            if (object instanceof Time) {
                return 92;
            }
            if (object instanceof Timestamp) {
                return 93;
            }
            if (object instanceof SQLData) {
                return 2002;
            }
            if (object instanceof ObjectData) {
                return 2002;
            }
        } else {
            if (object instanceof BLOB) {
                return 2004;
            }
            if (object instanceof CLOB) {
                return 2005;
            }
            if (object instanceof BFILE) {
                return -13;
            }
            if (object instanceof ROWID) {
                return -8;
            }
            if (object instanceof NUMBER) {
                return 2;
            }
            if (object instanceof DATE) {
                return 91;
            }
            if (object instanceof TIMESTAMP) {
                return 93;
            }
            if (object instanceof TIMESTAMPTZ) {
                return -101;
            }
            if (object instanceof TIMESTAMPLTZ) {
                return -102;
            }
            if (object instanceof REF) {
                return 2006;
            }
            if (object instanceof CHAR) {
                return 1;
            }
            if (object instanceof RAW) {
                return -2;
            }
            if (object instanceof ARRAY) {
                return 2003;
            }
            if (object instanceof STRUCT) {
                return 2002;
            }
            if (object instanceof OPAQUE) {
                return 2007;
            }
            if (object instanceof INTERVALYM) {
                return -103;
            }
        }
        return 1111;
    }

    public synchronized void clearParameters() throws SQLException {
        this.clear_params = true;
        if (this.binds_in != null) {
            this.binds_in.clearItem(this.m_currentRank, false);
        }
    }

    private void printByteArray(byte[] byArray) {
        if (byArray != null) {
            int n2 = byArray.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = byArray[n3] & 0xFF;
                if (n4 < 16) {
                    // empty if block
                }
                ++n3;
            }
        }
    }

    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.set_execute_batch(1);
        if (reader != null) {
            int n4 = n2 - 1;
            short s2 = 2;
            if (this.binds_in != null) {
                s2 = this.binds_in.getFormOfUse(n4);
            }
            InputStream inputStream = this.connection.conversion.ConvertStream(reader, 7, n3, s2);
            int n5 = this.min_ascii_stream_size / this.connection.db_access.getC2SNlsRatio() / this.connection.conversion.getMaxCharbyteSize();
            if (this.sql_kind == 1 || n3 <= n5 || !this.isRegularResultSet()) {
                try {
                    int n6;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                    byte[] byArray = new byte[1024];
                    while ((n6 = inputStream.read(byArray)) != -1) {
                        byteArrayOutputStream.write(byArray, 0, n6);
                    }
                    this.setItem(n4, 1, byteArrayOutputStream.toByteArray());
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    DBError.throwSqlException(iOException);
                }
            } else {
                this.setStreamItem(n4, 8, inputStream, n3 * this.connection.conversion.getMaxCharbyteSize());
            }
        } else {
            this.setString(n2, null);
        }
    }

    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        this.setDATE(n2, date == null ? null : new DATE(date, calendar));
    }

    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        this.setDATE(n2, time == null ? null : new DATE(time, calendar));
    }

    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setDATE(n2, timestamp == null ? null : new DATE(timestamp, calendar));
    }

    public void setCheckBindTypes(boolean bl) {
        this.check_bind_types = bl;
    }

    protected final void setOracleBatchStyle() throws SQLException {
        if (this.m_batchStyle == 2) {
            DBError.throwSqlException(90, "operation cannot be mixed with JDBC-2.0-style batching");
        } else if (this.m_batchStyle == 0) {
            // empty if block
        }
        this.m_batchStyle = 1;
    }

    protected final void setJdbcBatchStyle() throws SQLException {
        if (this.m_batchStyle == 1) {
            DBError.throwSqlException(90, "operation cannot be mixed with Oracle-style batching");
        }
        this.m_batchStyle = 2;
    }

    protected final void checkIfJdbcBatchExists() throws SQLException {
        if (this.doesJdbcBatchExist()) {
            DBError.throwSqlException(81, "batch must be either executed or cleared");
        }
    }

    private boolean doesJdbcBatchExist() {
        return this.m_currentRank > 0 && this.m_batchStyle == 2;
    }

    private boolean isJdbcBatchStyle() {
        return this.m_batchStyle == 2;
    }

    public synchronized void addBatch() throws SQLException {
        this.setJdbcBatchStyle();
        this.binds_in.rowCompleted(-1);
        if (this.binds_in.hasStreamType()) {
            DBError.throwSqlException(90, "streams type cannot be used in batching");
        }
        this.checkBindsInAndOut();
        ++this.m_currentRank;
    }

    public synchronized void addBatch(String string) throws SQLException {
        DBError.throwSqlException(23);
    }

    public synchronized void clearBatch() throws SQLException {
        if (this.binds_in != null && this.binds_in.getNoOfArgs() > 0) {
            this.binds_in.clearItems();
        }
        this.m_currentRank = 0;
        this.clear_params = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        OracleConnection oracleConnection = this.connection;
        synchronized (oracleConnection) {
            OraclePreparedStatement oraclePreparedStatement = this;
            synchronized (oraclePreparedStatement) {
                int[] nArray;
                int n2;
                block20: {
                    block19: {
                        n2 = 0;
                        this.setJdbcBatchStyle();
                        if (this.m_currentRank == 0) {
                            return new int[0];
                        }
                        nArray = new int[this.m_currentRank];
                        this.ensureOpen();
                        this.prepare_for_new_result(true);
                        if (this.sql_string_changed) {
                            this.parseSqlKind();
                        }
                        if (this.sql_kind == 0) {
                            DBError.throwBatchUpdateException(80, 0, null);
                        }
                        try {
                            Object var8_6;
                            SQLException sQLException2;
                            block18: {
                                try {
                                    this.need_to_parse = true;
                                    this.doExecuteOther(true);
                                }
                                catch (SQLException sQLException2) {
                                    n2 = 0;
                                    break block18;
                                }
                                var8_6 = null;
                                break block19;
                            }
                            while (true) {
                                if (n2 >= nArray.length) break;
                                nArray[n2] = -3;
                                ++n2;
                            }
                            DBError.throwBatchUpdateException(sQLException2, nArray.length, nArray);
                            var8_6 = null;
                            this.cleanupForBatching();
                            break block20;
                        }
                        catch (Throwable throwable) {
                            Object var8_7 = null;
                            this.cleanupForBatching();
                            throw throwable;
                        }
                    }
                    this.cleanupForBatching();
                }
                if (this.valid_rows < 0) {
                    n2 = 0;
                    while (true) {
                        if (n2 >= nArray.length) {
                            DBError.throwBatchUpdateException(81, 0, nArray);
                            break;
                        }
                        nArray[n2] = -3;
                        ++n2;
                    }
                }
                n2 = 0;
                while (n2 < nArray.length) {
                    nArray[n2] = -2;
                    ++n2;
                }
                return nArray;
            }
        }
    }

    public DBDataSet getBinds() {
        return this.m_binds;
    }

    void scrollStmt_cleanup(boolean bl) throws SQLException {
        this.m_binds = null;
        super.scrollStmt_cleanup(bl);
    }

    private int doScrollPstmtExecuteUpdate() throws SQLException {
        this.scrollStmt_cleanup(false);
        this.parseSqlKind();
        if (this.sql_kind != 0) {
            this.prepare_for_new_result(true);
            this.get_data_for_columns(this.batch);
            this.doExecuteWithTimeout();
            return this.valid_rows;
        }
        boolean bl = true;
        String string = null;
        if (!this.m_needToAddIdentifier) {
            this.prepare_for_new_result(true);
            this.get_data_for_columns(this.batch);
            this.doExecuteWithTimeout();
            this.current_result_set = new OracleResultSetImpl(this.connection, this);
            this.m_realRsetType = this.m_userRsetType;
        } else {
            try {
                this.m_revisedSql = ResultSetUtil.addIdentifierToSql(this.m_originalSql);
                this.need_to_parse = true;
                this.sql_string_changed = true;
                this.prepare_for_new_result(true);
                this.sql_query = this.m_revisedSql;
                if (this.columns_defined_by_user) {
                    this.adjustUserDefines(1);
                }
                this.prepare_for_new_result(true);
                this.get_data_for_columns(this.batch);
                this.doExecuteWithTimeout();
                this.m_binds = this.binds_in;
                this.current_result_set = new OracleResultSetImpl(this.connection, this);
            }
            catch (SQLException sQLException) {
                bl = false;
                string = sQLException.getMessage();
                this.m_binds = this.binds_in;
            }
            if (bl) {
                this.m_realRsetType = this.m_userRsetType;
            } else {
                this.m_realRsetType = this.m_userRsetType > 3 ? 3 : 1;
                this.need_to_parse = true;
                this.sql_string_changed = true;
                this.prepare_for_new_result(true);
                this.sql_query = this.m_originalSql;
                if (this.columns_defined_by_user) {
                    this.adjustUserDefines(-1);
                }
                this.prepare_for_new_result(true);
                this.doExecuteWithTimeout();
                this.m_binds = this.binds_in;
                this.current_result_set = new OracleResultSetImpl(this.connection, this);
                bl = true;
            }
        }
        if (this.current_result_set == null || !bl) {
            DBError.check_error(1, "Unable to create result set");
        } else {
            if (this.m_userRsetType != this.m_realRsetType) {
                this.m_warning = DBError.addSqlWarning(this.m_warning, 91, string);
            }
            this.m_scrollRset = ResultSetUtil.createScrollResultSet(this, this.current_result_set, this.m_realRsetType);
        }
        this.m_scrollRsetTypeSolved = true;
        return this.valid_rows;
    }

    private void cleanup() {
        if (this.connection.m_stmtClearMetaData && this.binds_in != null) {
            this.binds_in.cleanup();
        }
        this.clear_params = true;
    }

    public synchronized void setDisableStmtCaching(boolean bl) {
        if (bl) {
            this.cacheState = OracleStatement.NON_CACHED;
        }
    }

    public synchronized void setFormOfUse(int n2, short s2) {
        this.binds_in.setFormOfUse(n2, s2);
    }

    public void setURL(int n2, URL uRL) throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public OracleParameterMetaData OracleGetParameterMetaData() throws SQLException {
        DBError.throwUnsupportedFeatureSqlException();
        return null;
    }
}

