/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.util.ArrayList;
import unity.functions.ExtractAttribute;
import unity.relational.Attribute;
import unity.relational.Relation;
import unity.relational.Tuple;

public abstract class Expression {
    protected Expression parent = null;
    protected ArrayList children = new ArrayList(2);
    protected int returnType = -1;

    public abstract Object evaluate(Tuple var1);

    public int getReturnType() {
        return this.returnType;
    }

    public void setReturnType(int iType) {
        this.returnType = iType;
    }

    public Expression getParent() {
        return this.parent;
    }

    public void setParent(Expression parent) {
        this.parent = parent;
    }

    public boolean hasChildren() {
        return this.getNumChildren() != 0;
    }

    public int getNumChildren() {
        return this.children == null ? 0 : this.children.size();
    }

    public Expression getChild(int index) {
        return index >= this.getNumChildren() || index < 0 ? null : (Expression)this.children.get(index);
    }

    public Object computeType(Object input) {
        String objClass = input.getClass().getName();
        if (objClass.equals("java.lang.String")) {
            String val = (String)input;
            if (val.length() < 2) {
                return val;
            }
            val = val.substring(1, val.length() - 1);
            try {
                Integer i = new Integer(val);
                this.returnType = Attribute.TYPE_INT;
                return i;
            }
            catch (Exception i) {
                try {
                    Double d = new Double(val);
                    this.returnType = Attribute.TYPE_DOUBLE;
                    return d;
                }
                catch (Exception exception) {
                    this.returnType = Attribute.TYPE_STRING;
                    return val;
                }
            }
        }
        if (objClass.equals("java.lang.Integer")) {
            this.returnType = Attribute.TYPE_INT;
            return input;
        }
        if (objClass.equals("java.lang.Double")) {
            this.returnType = Attribute.TYPE_DOUBLE;
            return input;
        }
        this.returnType = Attribute.TYPE_STRING;
        return input.toString();
    }

    public String toString(Relation relation) {
        return this.toString();
    }

    public String toString(Relation relation, Attribute outputAttribute) {
        return this.toString();
    }

    public static ArrayList getAttributeIndexReferences(Expression exp) {
        ArrayList<Integer> a = new ArrayList<Integer>();
        if (exp instanceof ExtractAttribute) {
            a.add(new Integer(((ExtractAttribute)exp).getAttributeLoc()));
        } else {
            int i = 0;
            while (i < exp.getNumChildren()) {
                Expression child = exp.getChild(i);
                a.addAll(Expression.getAttributeIndexReferences(child));
                ++i;
            }
        }
        return a;
    }

    public int[] getExprLocs() {
        ArrayList res = Expression.getAttributeIndexReferences(this);
        int[] r = new int[res.size()];
        int i = 0;
        while (i < res.size()) {
            r[i] = (Integer)res.get(i);
            ++i;
        }
        return r;
    }
}

