/*
 * Decompiled with CFR 0.152.
 */
package komponens.filepanel;

import freejava.Beallitasok;
import freejava.Nyelv;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ToolTipManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ListUI;
import komponens.filepanel.FileListCellRenderer;
import komponens.filepanel.FilePanel;
import komponens.filepanel.FilePanelFile;
import komponens.filepanel.FilePanelMegjelenito;

public class FileLista
extends JList
implements ListSelectionListener,
FilePanelMegjelenito {
    private FilePanel filePanel;
    private File[] fajlok = new File[0];
    private File[] konyvtarak = new File[0];
    private static File[] meghajtokUtvonala = (File[])FilePanel.meghajtok.clone();
    private File utvonal;
    private DefaultListModel listModel = new DefaultListModel();
    private JLabel lbInfo;

    public FileLista(FilePanel filePanel, JLabel jLabel) {
        this.filePanel = filePanel;
        this.lbInfo = jLabel;
        this.setModel(this.listModel);
        this.setSelectionMode(0);
        this.setCellRenderer(new FileListCellRenderer());
        this.addListSelectionListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() != 119) {
            super.processKeyEvent(keyEvent);
        }
        if (keyEvent.getID() != 401) return;
        if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32) {
            int n = this.getSelectedIndex();
            if (keyEvent.getModifiers() == 8 && n > this.konyvtarak.length && n - 1 < this.konyvtarak.length + this.fajlok.length) {
                this.filePanel.setFoFile(this.getTeljesUtvonal());
                return;
            }
            if (keyEvent.getModifiers() == 2) {
                this.frissit(this.getSelectedValue().toString());
                return;
            }
            this.action();
            return;
        }
        if (keyEvent.getKeyCode() != 127) {
            this.filePanel.processKeyEvent(keyEvent);
            return;
        }
        int n = this.getSelectedIndex();
        if (keyEvent.getModifiers() == 2 && n > 0) {
            if (n < this.listModel.getSize() - FilePanel.meghajtok.length) {
                this.filePanel.fileTorles(new File(this.utvonal, this.getSelectedValue().toString()));
                return;
            }
        }
        if (n <= this.konyvtarak.length) return;
        if (n - 1 >= this.konyvtarak.length + this.fajlok.length) return;
        this.filePanel.fileBezar(this.getTeljesUtvonal(), true);
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.getID() == 501) {
            if (mouseEvent.getModifiers() == 4) {
                this.processMouseEvent(new MouseEvent(this, mouseEvent.getID(), mouseEvent.getWhen(), 16, mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                Object e = this.getSelectedValue();
                File file = null;
                if (e instanceof FilePanelFile) {
                    file = ((FilePanelFile)e).getFile();
                }
                this.filePanel.showFelpattanoMenu(file, mouseEvent);
            }
        } else if (mouseEvent.getID() == 502 && mouseEvent.getClickCount() > 1 && mouseEvent.getModifiers() == 16) {
            this.action();
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (mouseEvent != null && Beallitasok.filePanelToolTipText) {
            Object e;
            Point point = mouseEvent.getPoint();
            ListUI listUI = this.getUI();
            int n = listUI.locationToIndex(this, point);
            if (n != -1 && (e = this.listModel.getElementAt(n)) != null && e instanceof FilePanelFile) {
                return ((FilePanelFile)e).toString();
            }
        }
        return null;
    }

    public void frissit(Object object) {
        this.frissit();
        if (this.listModel.contains(object)) {
            this.setSelectedValue(object, true);
        } else {
            FilePanelFile filePanelFile = new FilePanelFile(new File(this.utvonal, object.toString()));
            this.setSelectedValue(filePanelFile, true);
        }
    }

    public void frissit() {
        int n = this.getSelectedIndex();
        Object e = this.getSelectedValue();
        this.listUtvonal(this.utvonal);
        if (this.listModel.indexOf(e) > 0) {
            this.setSelectedValue(e, true);
        } else if (n < this.listModel.getSize()) {
            this.setSelectedValue(this.listModel.getElementAt(n), true);
        }
    }

    public boolean listUtvonal(File file) {
        this.utvonal = file;
        try {
            int n;
            this.lbInfo.setText(this.utvonal.getAbsolutePath());
            this.fajlok = this.utvonal.listFiles(this.filePanel.fileSzuro);
            this.konyvtarak = this.utvonal.listFiles(this.filePanel.konyvtarSzuro);
            Arrays.sort(this.fajlok);
            Arrays.sort(this.konyvtarak);
            this.listModel.removeAllElements();
            this.removeAll();
            this.filePanel.jbUp.setEnabled(!FilePanel.isGyoker(this.utvonal));
            this.filePanel.jbHome.setEnabled(!this.utvonal.getPath().equals(Beallitasok.homeDir));
            this.listModel.addElement("..");
            for (n = 0; n < this.konyvtarak.length; ++n) {
                this.listModel.addElement(new FilePanelFile(this.konyvtarak[n]));
            }
            for (n = 0; n < this.fajlok.length; ++n) {
                this.listModel.addElement(new FilePanelFile(this.fajlok[n]));
            }
            this.setSelectedValue("..", true);
            n = 0;
            while (true) {
                if (n >= FilePanel.meghajtok.length) break;
                this.listModel.addElement(new FilePanelFile(FilePanel.meghajtok[n]));
                ++n;
            }
            n = 1;
            return n != 0;
        }
        catch (Exception exception) {
            if (this.fajlok == null) {
                this.fajlok = new File[0];
            }
            if (this.konyvtarak == null) {
                this.konyvtarak = new File[0];
            }
            boolean bl = false;
            return bl;
        }
    }

    private void meghajtoValtas() {
        File file = this.utvonal.getAbsoluteFile();
        int n = this.getSelectedIndex();
        File file2 = this.utvonal;
        for (File file3 = this.utvonal.getParentFile(); file3 != null; file3 = file3.getParentFile()) {
            file2 = file3;
        }
        for (int i = 0; i < meghajtokUtvonala.length; ++i) {
            if (!FilePanel.meghajtok[i].equals(file2)) continue;
            FileLista.meghajtokUtvonala[i] = this.utvonal.getAbsoluteFile();
            i = meghajtokUtvonala.length;
        }
        int n2 = n - 1 - (this.konyvtarak.length + this.fajlok.length);
        if (!this.listUtvonal(meghajtokUtvonala[n2])) {
            this.utvonal = file;
            if (!this.listUtvonal(FilePanel.meghajtok[n2])) {
                this.listUtvonal(file);
                this.setSelectedValue(this.listModel.getElementAt(n), true);
                this.lbInfo.setText(Nyelv.get("FileList.ErrorRead", FilePanel.meghajtok[n2]));
            }
        }
    }

    public void backSpace() {
        File file = this.utvonal;
        File file2 = this.utvonal.getParentFile();
        if (file2 != null) {
            this.listUtvonal(file2);
            this.setSelectedValue(new FilePanelFile(file), true);
        }
    }

    public File getUtvonal() {
        return this.utvonal;
    }

    public String getTeljesUtvonal() {
        String string = "";
        if (!FilePanel.isGyoker(this.utvonal)) {
            string = File.separator;
        }
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.utvonal.getAbsolutePath()))).append(string).append(this.getSelectedNev())));
    }

    public String getSelectedNev() {
        String string = "";
        int n = this.getSelectedIndex();
        if (n > 0) {
            if (n - 1 < this.konyvtarak.length) {
                string = this.konyvtarak[n - 1].getName();
            } else if (n - 1 < this.konyvtarak.length + this.fajlok.length) {
                string = this.fajlok[n - this.konyvtarak.length - 1].getName();
            }
        }
        return string;
    }

    private void action() {
        int n = this.getSelectedIndex();
        if (n >= 0) {
            if (n == 0) {
                this.backSpace();
            } else if (n <= this.konyvtarak.length) {
                File file = new File(this.utvonal, this.konyvtarak[n - 1].getName());
                File file2 = this.utvonal;
                if (file.exists() && !this.listUtvonal(file)) {
                    this.listUtvonal(file2);
                    this.lbInfo.setText(Nyelv.get("FileList.ErrorDir", file.getAbsolutePath()));
                }
            } else if (n <= this.konyvtarak.length + this.fajlok.length) {
                this.filePanel.fileMegnyitasa();
            } else {
                this.meghajtoValtas();
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        int n = this.getSelectedIndex();
        if (n >= 0) {
            if (n == 0) {
                this.lbInfo.setText(this.utvonal.getAbsolutePath());
            } else if (n <= this.konyvtarak.length + this.fajlok.length) {
                this.lbInfo.setText(this.utvonal.getAbsolutePath());
            } else {
                this.lbInfo.setText(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.utvonal.getPath()))).append(" || link >> ").append(meghajtokUtvonala[n - 1 - (this.konyvtarak.length + this.fajlok.length)]))));
            }
        }
    }
}

