.code
;
; *************************
; *****  %_make.3arg  *****  MAKE(v, width, offset)
; *************************
;
; in:	arg2 = offset of bitfield
;	arg1 = width of bitfield
;	arg0 = value from which to extract bitfield
; out:	eax = arg0 with specified bitfield set
;
; destroys: ebx, ecx, edx, esi, edi
;
%_make.3arg:
mov	eax,[esp+4]     							; eax = value from which to extract bitfield
mov	ebx,[esp+8]     							; ebx = width
mov	ecx,[esp+12]    							; ecx = offset
and	ebx,31          							; want only low 5 bits of width
and	eax,[width_table + ebx*4] 		; cut off all but width bits
shl	eax,cl          							; shift up to offset position
ret

;
; *****  Width Table  *****
;
.const
align	8
width_table:
dd	11111111111111111111111111111111b
dd	00000000000000000000000000000001b
dd	00000000000000000000000000000011b
dd	00000000000000000000000000000111b
dd	00000000000000000000000000001111b
dd	00000000000000000000000000011111b
dd	00000000000000000000000000111111b
dd	00000000000000000000000001111111b
dd	00000000000000000000000011111111b
dd	00000000000000000000000111111111b
dd	00000000000000000000001111111111b
dd	00000000000000000000011111111111b
dd	00000000000000000000111111111111b
dd	00000000000000000001111111111111b
dd	00000000000000000011111111111111b
dd	00000000000000000111111111111111b
dd	00000000000000001111111111111111b
dd	00000000000000011111111111111111b
dd	00000000000000111111111111111111b
dd	00000000000001111111111111111111b
dd	00000000000011111111111111111111b
dd	00000000000111111111111111111111b
dd	00000000001111111111111111111111b
dd	00000000011111111111111111111111b
dd	00000000111111111111111111111111b
dd	00000001111111111111111111111111b
dd	00000011111111111111111111111111b
dd	00000111111111111111111111111111b
dd	00001111111111111111111111111111b
dd	00011111111111111111111111111111b
dd	00111111111111111111111111111111b
dd	01111111111111111111111111111111b
