/*****
 *
 * File: celldata.h
 *
 * Cellsim, cellular automata simulator
 *
 * Header-file for the celldata.c file
 *
 *****/

/*
 *
 * Cellsim copyright 1989, 1990 by Chris Langton and Dave Hiebeler
 * (cgl@lanl.gov, hiebeler@heretic.lanl.gov)
 *
 * This package may be freely distributed, as long as you don't:
 * - remove this notice
 * - try to make money by doing so
 * - prevent others from copying it freely
 * - distribute modified versions without clearly documenting your changes
 *   and notifying us
 *
 * Please contact either of the authors listed above if you have questions
 * or feel an exception to any of the above restrictions is in order.
 *
 * If you make changes to the code, or have suggestions for changes,
 * let us know!  If we use your suggestion, you will receive full credit
 * of course.
 */

/*****
 * Cellsim history:
 *
 * Cellsim was originally written on Apollo workstations by Chris Langton.
 *
 * Sun versions:
 *
 * - version 1.0
 *   by C. Ferenbaugh and C. Langton
 *   released 09/02/88
 *
 * - version 1.5
 *   by Dave Hiebeler and C. Langton  May - June 1989
 *   released 07/03/89
 *
 * - version 2.0
 *   by Dave Hiebeler and C. Langton  July - August 1989
 *   never officially released (unofficially released 09/08/89)
 *
 * - version 2.5
 *   by Dave Hiebeler and C. Langton  September '89 - February 1990
 *   released 02/26/90
 *****/


/*****
 *
 * Includes and defines
 *
 *****/
#include <pixrect/pixrect_hs.h>
#include "cell.def"

#define pr_swap(p1, p1h, p2, p2h) \
    temp = (p1);  (p1) = (p2);  (p2) = temp; \
    temp_handle = (p1h);  (p1h) = (p2h);  (p2h) = temp_handle



/*****
 *
 * External vars
 *
 *****/
extern short
    S, B, ABASE, AMASK, DIM;
extern int
    ICBASE, ICSIZE;


/*****
 *
 * Local vars
 *
 *****/
State  *ca, *ia;		/* image arrays and pixrects - GLOBAL */
struct pixrect *ca_handle, *ia_handle;
struct mpr_data *a1data, *a2data;

State  *temp;				/* used for swapping */
struct pixrect *temp_handle;

struct pixrect *buffer[NBUFFERS];
State  *bufptr[NBUFFERS];		/* image buffers (local only) */

struct pixrect *sh_handle;		/* shift pixrect */
State  *sh;
