/* xsum.c */

#include "xsum.h"

/*****************************************************************************/
/*			declaration of variables 			     */
/*****************************************************************************/

Widget toplevel,formw,titlew,logfilew,statefilew;
Widget vieww,canvasw,procnum[MAXNUMPROCS];
Widget patternw[MAXNUMSTATES],patternlabelw[MAXNUMSTATES];
Widget infobutton,quitbutton;
Widget logfilelabelw,statefilelabelw;

/* popup widgets */
Widget popupw,popupform,donebutton;
Widget proclabel,procnum[MAXNUMPROCS],statelabel[MAXNUMSTATES];
Widget percentlabel[MAXNUMPROCS][MAXNUMSTATES];

/* hair widget */
Widget hairlabel,haircount,hairpercent;

/* scale widget */
Widget scale[6],marker[6],scalelabel;

Display *dpy;
int screen;
GC gc,gcxor;
XGCValues gcv;
Window win;
Colormap cmap;

/* for monochrome display */
Pixmap mybitmap,horizStripes,verStripes,rightSlant,leftSlant,checkerd;
int numPatterns=6; /* number of pixmaps + solid_fill */

char logfilename[80];
char statefilename[50];

int have_color;
int foreground;
int background;

timevar total_time;
int num_procs,num_states;
int canvas_height,canvas_width;

float hairpos;
timevar hairpos_time;

struct statetype state[MAXNUMSTATES];
struct sum procinfo[MAXNUMPROCS][MAXNUMSTATES];
struct rbd rbdata;


/****************************************************************************/
/*			XSUM MAIN FUNCTION				    */
/****************************************************************************/
main(argc, argv)
int argc;
char *argv[];
{

    InputData(argc,argv);

    if((num_procs>MAXNUMPROCS)||(num_states>MAXNUMSTATES)){
	fprintf(stderr,"error:  number of processes > MAXNUMPROCS\n");
	exit(1);
	}

    InitGraphics(argc,argv);
    Draw();

    XtMainLoop();
    
}  /* End of Main Function */


/*****************************************************************************/
/* ITOA: converts integers into their corresponding ascii values so that they*/
/*       may be used as strings.(copied from upshot.c)                       */
/*****************************************************************************/
void itoa(i,s)
int i;
char s[];
{
    int j=0;
    int first,last,temp;

    do{
	s[j++] = i%10 +'0';
    } while((i/=10) > 0);
    s[j]='\0';

    for(first=0,last=strlen(s)-1;first<last;first++,last--)
	temp=s[first],s[first]=s[last],s[last]=temp;
}


/*****************************************************************************/
/* QUITCALLBACK:  function called when quit button is pressed.               */
/*****************************************************************************/
quitcallback(w,client_data,call_data)
Widget w;
XtPointer client_data,call_data;
{
    exit(0);
}


/*****************************************************************************/
/* INFOCALLBACK:  function called when info button is pressed.               */
/*		  Pops up a hidden window the contains some information      */
/*  		  regarding the processors activity.                         */
/*****************************************************************************/
infocallback(w,client_data,call_data)
Widget w;
XtPointer client_data,call_data;
{
    Position x,y;

    XtTranslateCoords(formw,10,10,&x,&y);

    XtMoveWidget(popupw,x-100,y-100);

    /* make the info button inactive */
    XtSetSensitive(infobutton, FALSE);

    XtPopup(popupw,XtGrabNone);
}


/*****************************************************************************/
/* DONECALLBACK:  function called when done button is pressed.               */
/*                Removes the pop up window from the screen.                 */
/*****************************************************************************/
donecallback(w,client_data,call_data)
Widget w;
XtPointer client_data,call_data;
{
    XtPopdown(popupw);

    /* make the info button active again */
    XtSetSensitive(infobutton, TRUE);
}


/*****************************************************************************/
/* INITGRAPHICS:  sets up the window and the widgets.                        */
/*****************************************************************************/
InitGraphics(argc,argv)
int argc;
char *argv[];
{
    Arg arg[25];
    int i,j,n,frame_depth;
    int min_canvas_height;
    XSetWindowAttributes w_attr;
    char buf[80];

    canvas_width = CANVAS_WIDTH+1;
    canvas_height = 20*num_procs + 10;
    min_canvas_height = 20*16;

    if(canvas_height < min_canvas_height)
	canvas_height = min_canvas_height;

    toplevel = XtInitialize(argv[0],"XSum",NULL,0,&argc,argv);

    dpy = XtDisplay(toplevel);
    screen = DefaultScreen(dpy);
    frame_depth = XDefaultDepth(dpy,screen);
    have_color = frame_depth>1 ? TRUE : FALSE;
    cmap = DefaultColormap(dpy,screen);

    if((!have_color)&&(num_states>numPatterns)){
	fprintf(stderr,"error:  not enough patterns for the states\n");
	exit(1);
	}

    if(have_color){
	foreground = ConvertColor(canvasw,"white");
	background = ConvertColor(canvasw,"black");
	}
    else{
	foreground = ConvertColor(canvasw,"black");
	background = ConvertColor(canvasw,"white");
	}

    /* containing form */
    n = 0;
    XtSetArg(arg[n],XtNwidth,600); n++;
    XtSetArg(arg[n],XtNheight,700); n++;
    formw = XtCreateManagedWidget("formw",formWidgetClass,toplevel,arg,n);

    /* popup shell */
    n = 0;
    popupw = XtCreatePopupShell("Info",
			transientShellWidgetClass,toplevel,arg,n);

    /* popup form */
    n = 0;
    XtSetArg(arg[n],XtNwidth,((num_states+1)*80)+(num_states*5)); n++;
    XtSetArg(arg[n],XtNheight,(num_procs*20)+15); n++;
    popupform = XtCreateManagedWidget("popupform",
			formWidgetClass,popupw,arg,n);

    /* "Processes", label */
    n = 0;
    XtSetArg(arg[n],XtNwidth,100); n++;
    XtSetArg(arg[n],XtNheight,15); n++;
    XtSetArg(arg[n],XtNborderWidth,0); n++;
    proclabel = XtCreateManagedWidget("Processes",
			labelWidgetClass,popupform,arg,n);

    /* "States", label */
    for(i=0;i<num_states;++i){
    	n = 0;
	XtSetArg(arg[n],XtNhorizDistance,(i*85)+5); n++;
	XtSetArg(arg[n],XtNfromHoriz,proclabel); n++;
    	XtSetArg(arg[n],XtNwidth,80); n++;
    	XtSetArg(arg[n],XtNheight,15); n++;
    	XtSetArg(arg[n],XtNborderWidth,0); n++;
	statelabel[i] = XtCreateManagedWidget(state[i].note,
			labelWidgetClass,popupform,arg,n);
	}

    /* percentages */
    for(i=0;i<num_procs;++i){
	n = 0;
	XtSetArg(arg[n],XtNvertDistance,(i*20)+5); n++;
	XtSetArg(arg[n],XtNfromVert,proclabel); n++;
	XtSetArg(arg[n],XtNwidth,100); n++;
	XtSetArg(arg[n],XtNheight,15); n++;
	itoa(i,buf);
	procnum[i] = XtCreateManagedWidget(buf,
			labelWidgetClass,popupform,arg,n);

	for(j=0;j<num_states;++j){
	    n = 0;
	    XtSetArg(arg[n],XtNvertDistance,(i*20)+5); n++;
	    XtSetArg(arg[n],XtNfromVert,statelabel[j]); n++;
	    XtSetArg(arg[n],XtNhorizDistance,(j*85)+5); n++;
	    XtSetArg(arg[n],XtNfromHoriz,procnum[i]); n++;
	    XtSetArg(arg[n],XtNwidth,80); n++;
	    XtSetArg(arg[n],XtNheight,15); n++;
	    sprintf(buf,"%2.2f",procinfo[i][j].percent);
	    percentlabel[i][j] = XtCreateManagedWidget(buf,
			labelWidgetClass,popupform,arg,n);
	    }
	}

    /* popdown button */
    n = 0;
    XtSetArg(arg[n],XtNvertDistance,(num_procs*20)+5); n++;
    XtSetArg(arg[n],XtNfromVert,proclabel); n++;
    XtSetArg(arg[n],XtNhorizDistance,(20+85*num_states)/2); n++;
    XtSetArg(arg[n],XtNheight,15); n++;
    XtSetArg(arg[n],XtNwidth,80); n++;
    XtSetArg(arg[n],XtNlabel,"Cancel"); n++;
    donebutton = XtCreateManagedWidget("done",
			commandWidgetClass,popupform,arg,n);
    XtAddCallback(donebutton,XtNcallback,donecallback,NULL);

    /* label */
    n = 0;
    XtSetArg(arg[n],XtNwidth,600); n++;
    XtSetArg(arg[n],XtNheight,50); n++;
    XtSetArg(arg[n],XtNborderWidth,0); n++;
    titlew = XtCreateManagedWidget("SUMMARY",labelWidgetClass,formw,arg,n);

    /* logfilelabelw */
    n = 0;
    XtSetArg(arg[n],XtNvertDistance,10); n++;
    XtSetArg(arg[n],XtNfromVert,titlew); n++;
    XtSetArg(arg[n],XtNhorizDistance,50); n++;
    XtSetArg(arg[n],XtNwidth,150); n++;
    XtSetArg(arg[n],XtNheight,20); n++;
    XtSetArg(arg[n],XtNborderWidth,0); n++;
    logfilelabelw = XtCreateManagedWidget("Log file: ",
				labelWidgetClass,formw,arg,n);

    /* statefilelabelw */
    n = 0;
    XtSetArg(arg[n],XtNvertDistance,10); n++;
    XtSetArg(arg[n],XtNfromVert,titlew); n++;
    XtSetArg(arg[n],XtNhorizDistance,5); n++;
    XtSetArg(arg[n],XtNfromHoriz,logfilelabelw); n++;
    XtSetArg(arg[n],XtNwidth,150); n++;
    XtSetArg(arg[n],XtNheight,20); n++;
    XtSetArg(arg[n],XtNborderWidth,0); n++;
    statefilelabelw = XtCreateManagedWidget("State file: ",
				labelWidgetClass,formw,arg,n); 

    /* logfilew */
    n = 0;
    XtSetArg(arg[n],XtNvertDistance,5); n++;
    XtSetArg(arg[n],XtNfromVert,logfilelabelw); n++;
    XtSetArg(arg[n],XtNhorizDistance,50); n++;
    XtSetArg(arg[n],XtNwidth,150); n++;
    XtSetArg(arg[n],XtNheight,20); n++;
    logfilew = XtCreateManagedWidget(logfilename,
				labelWidgetClass,formw,arg,n); 

    /* statefilew */
    n = 0;
    XtSetArg(arg[n],XtNvertDistance,5); n++;
    XtSetArg(arg[n],XtNfromVert,statefilelabelw); n++;
    XtSetArg(arg[n],XtNhorizDistance,5); n++;
    XtSetArg(arg[n],XtNfromHoriz,logfilew); n++;
    XtSetArg(arg[n],XtNwidth,150); n++;
    XtSetArg(arg[n],XtNheight,20); n++;
    statefilew = XtCreateManagedWidget(statefilename,
				labelWidgetClass,formw,arg,n);

    /* info, button */
    n = 0;
    XtSetArg(arg[n],XtNvertDistance,35); n++;
    XtSetArg(arg[n],XtNfromVert,titlew); n++;
    XtSetArg(arg[n],XtNhorizDistance,5); n++;
    XtSetArg(arg[n],XtNfromHoriz,statefilew); n++;
    XtSetArg(arg[n],XtNwidth,90); n++;
    XtSetArg(arg[n],XtNheight,20); n++;
    XtSetArg(arg[n],XtNlabel,"Info"); n++;
    infobutton = XtCreateManagedWidget("infobutton",
				commandWidgetClass,formw,arg,n);
    XtAddCallback(infobutton,XtNcallback,infocallback,NULL); 

    /* quit, button */
    n = 0;
    XtSetArg(arg[n],XtNvertDistance,35); n++;
    XtSetArg(arg[n],XtNfromVert,titlew); n++;
    XtSetArg(arg[n],XtNhorizDistance,5); n++;
    XtSetArg(arg[n],XtNfromHoriz,infobutton); n++;
    XtSetArg(arg[n],XtNwidth,90); n++;
    XtSetArg(arg[n],XtNheight,20); n++;
    XtSetArg(arg[n],XtNlabel,"Quit"); n++;
    quitbutton = XtCreateManagedWidget("quitbutton",
		commandWidgetClass,formw,arg,n);
    XtAddCallback(quitbutton,XtNcallback,quitcallback,NULL);

    /* viewport */
    n = 0;
    XtSetArg(arg[n],XtNvertDistance,80); n++;
    XtSetArg(arg[n],XtNfromVert,titlew); n++;
    XtSetArg(arg[n],XtNhorizDistance,50); n++;
    XtSetArg(arg[n],XtNwidth,501); n++;
    XtSetArg(arg[n],XtNheight,canvas_height); n++;
    vieww = XtCreateManagedWidget("vieww",
			viewportWidgetClass,formw,arg,n);

    /* canvas */
    n = 0;
    /*XtSetArg(arg[n],XtNvertDistance,80); n++;
    XtSetArg(arg[n],XtNfromVert,titlew); n++;
    XtSetArg(arg[n],XtNhorizDistance,50); n++;*/
    XtSetArg(arg[n],XtNwidth,canvas_width); n++;
    XtSetArg(arg[n],XtNheight,canvas_height); n++;
    XtSetArg(arg[n],XtNborderWidth,0); n++;
    XtSetArg(arg[n],XtNforeground,foreground); n++;
    XtSetArg(arg[n],XtNbackground,background); n++;
    canvasw = XtCreateManagedWidget("canvasw",
			compositeWidgetClass,vieww,arg,n);

    for(i=0;i<num_states;++i){
	n = 0;
	XtSetArg(arg[n],XtNvertDistance,(i*50)+80); n++;
	XtSetArg(arg[n],XtNfromVert,titlew); n++;
	XtSetArg(arg[n],XtNhorizDistance,25); n++;
	XtSetArg(arg[n],XtNfromHoriz,vieww); n++;
	XtSetArg(arg[n],XtNwidth,60); n++;
	XtSetArg(arg[n],XtNheight,10); n++;
	/*XtSetArg(arg[n],XtNborderWidth,0); n++;*/
	sprintf(buf,"%s%d","patternw",i);
	patternw[i] = XtCreateManagedWidget("",
				labelWidgetClass,formw,arg,n);

	n = 0;
	XtSetArg(arg[n],XtNvertDistance,(i*50)+90); n++;
	XtSetArg(arg[n],XtNfromVert,titlew); n++;
	XtSetArg(arg[n],XtNhorizDistance,10); n++;
	XtSetArg(arg[n],XtNfromHoriz,vieww); n++;
	XtSetArg(arg[n],XtNwidth,100); n++;
	XtSetArg(arg[n],XtNheight,20); n++;
	XtSetArg(arg[n],XtNborderWidth,0); n++;
	patternlabelw[i] = XtCreateManagedWidget(state[i].note,
				labelWidgetClass,formw,arg,n);
	}

    /* hair label */
    n = 0;
    XtSetArg(arg[n],XtNvertDistance,20); n++;
    XtSetArg(arg[n],XtNfromVert,patternlabelw[num_states-1]); n++;
    XtSetArg(arg[n],XtNhorizDistance,10); n++;
    XtSetArg(arg[n],XtNfromHoriz,vieww); n++;
    XtSetArg(arg[n],XtNwidth,100); n++;
    XtSetArg(arg[n],XtNheight,20); n++;
    XtSetArg(arg[n],XtNborderWidth,0); n++;
    hairlabel = XtCreateManagedWidget("Hair",
				labelWidgetClass,formw,arg,n);

    /* counter for the crosshair -- percent */
    n = 0;
    XtSetArg(arg[n],XtNvertDistance,5); n++;
    XtSetArg(arg[n],XtNfromVert,hairlabel); n++;
    XtSetArg(arg[n],XtNhorizDistance,10); n++;
    XtSetArg(arg[n],XtNfromHoriz,vieww); n++;
    XtSetArg(arg[n],XtNwidth,100); n++;
    XtSetArg(arg[n],XtNheight,15); n++;
    XtSetArg(arg[n],XtNborderWidth,0); n++;
    hairpercent = XtCreateManagedWidget("0.0%",
				labelWidgetClass,formw,arg,n);

    /* counter for the crosshair -- time */
    n = 0;
    XtSetArg(arg[n],XtNvertDistance,5); n++;
    XtSetArg(arg[n],XtNfromVert,hairpercent); n++;
    XtSetArg(arg[n],XtNhorizDistance,10); n++;
    XtSetArg(arg[n],XtNfromHoriz,vieww); n++;
    XtSetArg(arg[n],XtNwidth,100); n++;
    XtSetArg(arg[n],XtNheight,15); n++;
    XtSetArg(arg[n],XtNborderWidth,0); n++;
    haircount = XtCreateManagedWidget("0",
				labelWidgetClass,formw,arg,n);

    putScale();

    XtRealizeWidget(toplevel);

    XtAddEventHandler(canvasw,ButtonPressMask,FALSE,start_rubber_band,&rbdata);
    XtAddEventHandler(canvasw,ButtonMotionMask,FALSE,track_rubber_band,&rbdata);
    XtAddEventHandler(canvasw,ButtonReleaseMask,FALSE,end_rubber_band,&rbdata);

    win = XtWindow(canvasw);

    dpy = XtDisplay(canvasw);
    
    XGrabButton(dpy,AnyButton,AnyModifier,win,TRUE,
		ButtonPressMask | ButtonMotionMask | ButtonReleaseMask,
		GrabModeAsync,GrabModeAsync,win,
		XCreateFontCursor(dpy,XC_sb_up_arrow));

    gc = XCreateGC(dpy,win,NULL,NULL);

    /* set up Xor graphics context for drawing the hair */
    n = 0;
    XtSetArg(arg[n],XtNforeground,&gcv.foreground); n++;
    XtSetArg(arg[n],XtNbackground,&gcv.background); n++;
    XtGetValues(canvasw,arg,n);

    gcv.foreground = gcv.foreground ^ gcv.background;
    gcv.function = GXxor;

    gcxor = XtGetGC(canvasw,GCForeground | GCBackground | GCFunction, &gcv); 

    w_attr.backing_store = Always;
    w_attr.save_under = True;

    XChangeWindowAttributes(dpy,win,(CWBackingStore | CWSaveUnder),&w_attr);

} /* End of InitGraphics */


int ConvertColor(w,colorname)
Widget w;
char *colorname;
{
    XColor color, ignore;

    if(XAllocNamedColor(dpy,cmap,colorname,&color,&ignore))
	return(color.pixel);
    else{
	printf("Warning:  couldn't allocate color %s\n",colorname);
	return(BlackPixel(dpy,screen));
	}
}


/*****************************************************************************/
/* START_RUBBER_BAND:  draws a vertical line on the canvas where the cursor  */
/*		       is located.  Updates the hair position.               */
/*****************************************************************************/
void start_rubber_band(w,data,event)
Widget w;
caddr_t data;
XEvent *event;
{
    Arg arg[5];
    int n;
    char buf[80];

    rbdata.x_last = rbdata.x_start = event->xbutton.x;
    rbdata.y_last = rbdata.y_start = event->xbutton.y;

    hairpos = ((float)rbdata.x_last/(float)CANVAS_WIDTH) * 100.0;
    hairpos_time = ((float)rbdata.x_last/(float)CANVAS_WIDTH) * total_time;

    n = 0;
    sprintf(buf,"%2.1f%%",hairpos);
    XtSetArg(arg[n],XtNlabel,buf); n++;
    XtSetValues(hairpercent,arg,n);

    n = 0;
    sprintf(buf,"%u",hairpos_time);
    XtSetArg(arg[n],XtNlabel,buf); n++;
    XtSetValues(haircount,arg,n);

    XDrawLine(dpy,win,gcxor,rbdata.x_start,0,rbdata.x_start,canvas_height);
}


/*****************************************************************************/
/* TRACK_RUBBER_BAND:  erases the old vertical line on the canvas and draws  */
/*		       a new vertical line on the new position of the cursor.*/
/*		       Updates the hair position.                            */
/*****************************************************************************/
void track_rubber_band(w,data,event)
Widget w;
caddr_t data;
XEvent *event;
{
    Arg arg[5];
    int n;
    char buf[80];

    XDrawLine(dpy,win,gcxor,rbdata.x_last,0,rbdata.x_last,canvas_height);

    rbdata.x_last = event->xbutton.x;
    rbdata.y_last = event->xbutton.y;

    XDrawLine(dpy,win,gcxor,rbdata.x_last,0,rbdata.x_last,canvas_height);

    n = 0;
    hairpos = ((float)rbdata.x_last/(float)CANVAS_WIDTH) * 100.0;
    hairpos_time = ((float)rbdata.x_last/(float)CANVAS_WIDTH) * total_time;

    n = 0;
    sprintf(buf,"%2.1f%%",hairpos);
    XtSetArg(arg[n],XtNlabel,buf); n++;
    XtSetValues(hairpercent,arg,n);

    n = 0;
    sprintf(buf,"%u",hairpos_time);
    XtSetArg(arg[n],XtNlabel,buf); n++;
    XtSetValues(haircount,arg,n);
}


/*****************************************************************************/
/* END_RUBBER_BAND:  removes the hair from the canvas and updates the counter*/
/*****************************************************************************/
void end_rubber_band(w,data,event)
Widget w;
caddr_t data;
XEvent *event;
{
    Arg arg[5];
    int n;
    char buf[80];

    XDrawLine(dpy,win,gcxor,rbdata.x_last,0,rbdata.x_last,canvas_height);

    rbdata.x_last = event->xbutton.x;
    rbdata.y_last = event->xbutton.y;

    XDrawLine(dpy,win,gcxor,rbdata.x_last,0,rbdata.x_last,canvas_height);

    /* pause */
    for(n=0;n<1000;++n)
	;

    XDrawLine(dpy,win,gcxor,rbdata.x_last,0,rbdata.x_last,canvas_height);

    n = 0;
    sprintf(buf,"%2.1f%%",hairpos);
    XtSetArg(arg[n],XtNlabel,buf); n++;
    XtSetValues(hairpercent,arg,n);

    n = 0;
    sprintf(buf,"%u",hairpos_time);
    XtSetArg(arg[n],XtNlabel,buf); n++;
    XtSetValues(haircount,arg,n);
}


/*****************************************************************************/
/* DRAW:  creates the bitmaps to be used on the monochrome display.          */
/*        Labels the y-axis of the canvas.                                   */
/*        Displays the states (patterns/colors) on the side of the canvas.   */ 
/*        Draws the horizontal line corresponding to the processes.          */
/*        Draws (horizontal) rectangles to represent the events.             */ 
/*****************************************************************************/
Draw()
{

    if(have_color)
	putColor();
    else{
	createBitmaps();
	putPattern();
    }
    putProcNumLabels();
    drawProcLine();
    drawEventLog();

} /* End of Draw */


/*****************************************************************************/
/* PUTPATTERN:  Changes the background of the pattern widgets to show the    */
/*              patterns used to represent the states.                       */
/*****************************************************************************/
putPattern()
{
    Arg arg[5];
    int i,n;
    Pixmap mypixmap;

    for(i=0;i<num_states;++i){

    	switch(i){
	    case 0:
		    break;
	    case 1:
		    mypixmap = checkerd;
		    break;
	    case 2:
		    mypixmap = horizStripes;
		    break;
	    case 3:
		    mypixmap = verStripes;
		    break;
	    case 4:
		    mypixmap = rightSlant;
		    break;
	    case 5:
		    mypixmap = leftSlant;
		    break;
	    }

	if(i == 0){
	    n = 0;
	    XtSetArg(arg[n],XtNbackground,foreground); n++;
	    XtSetValues(patternw[i],arg,n);
	    }
	else{
    	    n = 0;
    	    XtSetArg(arg[n],XtNbackgroundPixmap,mypixmap); n++;
    	    XtSetValues(patternw[i],arg,n);
	    }

	} /* end of for loop */

} /* End of putPattern */


/*****************************************************************************/
/* PUTCOLOR:  displays the colors corresponding to states.                   */
/*****************************************************************************/
putColor()
{
    Arg arg[5];
    int i,n;

    for(i=0;i<num_states;++i){
        n = 0;
	XtSetArg(arg[n],XtNbackground,
			ConvertColor(canvasw,state[i].color)); n++;
	XtSetValues(patternw[i],arg,n);
	}

} /* End of putColor */


/*****************************************************************************/
/* PUTPROCNUMLABELS:  labels the y-axis of the canvas with process numbers.  */
/*****************************************************************************/
putProcNumLabels()
{
    Arg arg[25];
    int i,n;
    char buf[20];

    for(i=0;i<num_procs;++i){
	n = 0;
	XtSetArg(arg[n],XtNvertDistance,(20*i)+5+80); n++;
	XtSetArg(arg[n],XtNfromVert,titlew); n++;
	XtSetArg(arg[n],XtNhorizDistance,25); n++;
	XtSetArg(arg[n],XtNwidth,20); n++;
	XtSetArg(arg[n],XtNheight,20); n++;
	XtSetArg(arg[n],XtNborderWidth,0); n++;
	itoa(i,buf);
	procnum[i] = XtCreateManagedWidget(buf,labelWidgetClass,formw,arg,n);
	}

} /* End of putProcNumLabels */


/*****************************************************************************/
/* CREATEBITMAPS:  initializes the patterns for monochrome display.          */
/*****************************************************************************/
createBitmaps()
{
    checkerd = XCreateBitmapFromData(dpy,win,checkerd_bits,
				     checkerd_width,checkerd_height);

    horizStripes = XCreateBitmapFromData(dpy,win,horizStripes_bits,
				     horizStripes_width,horizStripes_height);

    verStripes = XCreateBitmapFromData(dpy,win,verStripes_bits,
				     verStripes_width,verStripes_height);

    rightSlant = XCreateBitmapFromData(dpy,win,rightSlant_bits,
				     rightSlant_width,rightSlant_height);

    leftSlant = XCreateBitmapFromData(dpy,win,leftSlant_bits,
				     leftSlant_width,leftSlant_height);

    /* numPatterns = 6; including Solid Fill */

}


/*****************************************************************************/
/* DRAWPROCLINE:  draws horizontal lines to serve as x-axis for the processes*/
/*****************************************************************************/
drawProcLine()
{
    int i,x1,x2,y;

    x1 = 0; x2 = canvas_width;
    for(i=0,y=15;i<num_procs;++i,y+=20)
	XDrawLine(dpy,win,gc,x1,y,x2,y);
}


/*****************************************************************************/
/* DRAWEVENTLOG:  based on the states definition, filled rectangles are drawn*/
/*		  to show graphically the events. Events representing same   */
/*		  state are collected and combined.                          */
/*****************************************************************************/
drawEventLog()
{
    int i,j,x,y,x_offset;
    int *start,*end;
    float factor;

    start = (int *)calloc(num_procs,sizeof(int));
    end = (int *)calloc(num_procs,sizeof(int));

    /* initialize end */
    for(i=0;i<num_procs;++i)
	end[i] = 0;

    /* initialize conversion factor 
		-- microseconds to pixels */
    factor = (float)CANVAS_WIDTH / (float)total_time;  

    for(i=0;i<num_states;++i){

	if(have_color)
	    XSetForeground(dpy,gc,ConvertColor(canvasw,state[i].color));
	else
	    setFillPattern(i);

	for(j=0,y=10;j<num_procs;++j,y+=20){

	    start[j] = end[j];

	    x_offset = (int)ceil((float)procinfo[j][i].total_time * factor);
	    XFillRectangle(dpy,win,gc,start[j],y,x_offset,10);

	    end[j] += x_offset;
	    }
	}

    /* return the gc to its initial values */
    XSetFillStyle(dpy,gc,FillSolid);
    XSetForeground(dpy,gc,ConvertColor(canvasw,"white"));

    free(start);
    free(end);
}


/*****************************************************************************/
/* SETFILLPATTERN:  updates the graphics context to a particular pattern.    */
/*****************************************************************************/
setFillPattern(i)
int i;
{
    switch(i){
	case 0:
		/* solid */
		XSetFillStyle(dpy,gc,FillSolid);
		break;
	case 1:
		/* checkerd */
		XSetFillStyle(dpy,gc,FillTiled);
		XSetTile(dpy,gc,checkerd);
		break;
	case 2:
		/* horizStripes */ 
		XSetFillStyle(dpy,gc,FillTiled);
		XSetTile(dpy,gc,horizStripes);
		break;
	case 3:
		/* verStripes */
		XSetFillStyle(dpy,gc,FillTiled);
		XSetTile(dpy,gc,verStripes);
		break;
	case 4:
		/* rightSlant */
		XSetFillStyle(dpy,gc,FillTiled);
		XSetTile(dpy,gc,rightSlant);
		break;
	case 5:
		/* leftSlant */
		XSetFillStyle(dpy,gc,FillTiled);
		XSetTile(dpy,gc,leftSlant);
		break;
	}
}


/*****************************************************************************/
/* PUTSCALE:  label the x-axis with time; time is in milliseconds.           */
/*****************************************************************************/
putScale()
{
    Arg arg[25];
    char buf[10];
    int i,n,x,y,length;
    int interval;
    timevar timems;

    timems = total_time/1000;
    interval = ceil((double)(float)timems/5.0);

    x = 50; 
    for(i=0;i<6;++i){
	n = 0;
	XtSetArg(arg[n],XtNvertDistance,canvas_height+80); n++;
	XtSetArg(arg[n],XtNfromVert,titlew); n++;
	XtSetArg(arg[n],XtNhorizDistance,x-5); n++;
	XtSetArg(arg[n],XtNwidth,10); n++;
	XtSetArg(arg[n],XtNheight,20); n++;
	XtSetArg(arg[n],XtNborderWidth,0); n++;
	strcpy(buf,"|");
	marker[i] = XtCreateManagedWidget(buf,labelWidgetClass,formw,arg,n);

	n = 0;
	XtSetArg(arg[n],XtNvertDistance,canvas_height+80+20); n++;
	XtSetArg(arg[n],XtNfromVert,titlew); n++;
	XtSetArg(arg[n],XtNhorizDistance,x-25); n++;
	XtSetArg(arg[n],XtNwidth,50); n++;
	XtSetArg(arg[n],XtNheight,20); n++;
	XtSetArg(arg[n],XtNborderWidth,0); n++;
	sprintf(buf,"%d",(i<5) ? i*interval : (int)timems);
	scale[i] = XtCreateManagedWidget(buf,labelWidgetClass,formw,arg,n);

	x += 100;
	}

    n = 0;
    XtSetArg(arg[n],XtNvertDistance,canvas_height+80+20+25); n++;
    XtSetArg(arg[n],XtNfromVert,titlew); n++;
    XtSetArg(arg[n],XtNhorizDistance,50); n++;
    /*XtSetArg(arg[n],XtNwidth,100); n++;*/
    XtSetArg(arg[n],XtNheight,20); n++;
    XtSetArg(arg[n],XtNborderWidth,0); n++;
    scalelabel = XtCreateManagedWidget("time in milliseconds",
					labelWidgetClass,formw,arg,n);
}

/******************************** end ****************************************/
