#include "upshot.h" 

/* INIT GRAPHICS *************************************************************/
init_graphics(argc,argv)
     int argc;
     char **argv;
{
#ifdef X_REL4
  x_graphics_init(argc,argv);
#endif
}


/* SET UP EQUIPMENT **********************************************************/
set_up_equipment(logfile,statefile,keyString)
     char logfile[],statefile[],keyString[];
{
#ifdef X_REL4
  setupWidgets(logfile,statefile,keyString);
#endif
}



/* CLEAN PIXMAP **************************************************************/
clean_pixmap(pixmap)
     Pixmap *pixmap;
{
#ifdef X_REL4
xclean_pixmap(pixmap);
#endif
}



/* CREATE PIXMAP *************************************************************/
create_pixmap()
{
#ifdef X_REL4
xcreate_pixmap();
#endif
}


/* FREE PIXMAP ***************************************************************/
free_pixmap()
/* Since X pixmaps can only be used once they must be disposed of and freed
   in order to redefine a new drawing area.  This is the call that frees the
   pixmap and presently it is only implemented for X. */
{
#ifdef X_REL4
/*
XFreePixmap(display,canvas_pixmap);
*/
#endif
}




/* TRANSFER PIXMAP DATA ******************************************************/
CopyPixmapToCanvas()
{
/*This call is meant to be done only once after the start button has been
  pressed.  It calls the scrollbars move canvas callback to do the drawing*/
#ifdef X_REL4
  BufferScroll(Bscroll,NULL,NULL);
#endif
}


/* SCROLLBAR SET THUMB *******************************************************/
ScrollbarSetThumb(scrollbar,top,shown)
Widget scrollbar;
float top;
float shown;
{
#ifdef X_REL4
  XawScrollbarSetThumb(scrollbar,top,shown);
#endif
}

/* CHANGE FONT ***************************************************************/
change_font(font_identifier)
     Font font_identifier;
{
/*the font specifier is used to differentiate between the two available fonts*/
#ifdef X_REL4
xchange_font(font_identifier);
#endif
}

/* DRAWLINE ******************************************************************/
drawline(drawable,x,y,x1,y1,mode,lcolor,lwidth)
Drawable drawable;               /*This is an X data type*/
int x,y,x1,y1,mode,lcolor,lwidth;
{
#ifdef X_REL4
	xline(drawable,x,y,x1,y1,XOR,BLACK);
#endif
}



/* DRAWRECTANGLE *************************************************************/
drawrectangle(x,y,width,height)
     int x,y,width,height;
{
#ifdef X_REL4
  XDrawRectangle(display,w,gc,x,y,width,height);
#endif
  }




/* DRAWSTRING ****************************************************************/
drawstring(drawable,x,y,s,length)
     Drawable drawable;          /*this is an X data structure */
     int x,y;
     char s[];
     int length;
{
#ifdef X_REL4
	xdrawstring(drawable,x,y,s,length);
#endif
}


/* END LINE ******************************************************************/
endLine()
{
#ifdef X_REL4
  xEndline();
#endif
}

/* ERROR DISPLAY *************************************************************/
ErrorBox(message)
     char message[];
{
#ifdef X_REL4
     xErrorBox(message);
#endif
}


/* CONVERT COLOR *************************************************************/
int ConvertColor(colorname)
     char colorname[];
{
#ifdef X_REL4
     return(xConvertColor(colorname));
#endif
}


/* LABEL UNITS ***************************************************************/
void label_units()
{
#ifdef X_REL4
  xlabel_units();
#endif
}

 
/* DEFINE STATE KEY **********************************************************/
DefineStateKey(stateTotal)
     int stateTotal;
{
#ifdef X_REL4
  xDefineStateKey(stateTotal);
#endif
}


/* SHOW STATE KEY ************************************************************/
ShowStateKey()
{
#ifdef X_REL4
  /* POPUP VERSION:
     In X the StateKey is contained in a popup window which will brought up
     simply with a call to XtPopup 
  XtPopup(StateKeyWindow,XtGrabNone);
  */
    XtMapWidget(StateKeyViewport);

#endif
}


/* HIDE STATE KEY ************************************************************/
HideStateKey()
{
#ifdef X_REL4
  /* POPUP VERSION:
  XtPopdown(StateKeyWindow);  
  */
  if(colorScreen)  /*WARNING: since there isn't a state key for b&w it can't
		     be mapped or unmapped*/
      XtUnmapWidget(StateKeyViewport);
#endif
}

/* EVENT DATA BOX ************************************************************/
EventDataBox(x,y,id,event,time,cData,tasks,whichbutton)
     int x,y;
     int id,event,time;
     char cData[];
     int tasks,whichbutton;
{
#ifdef X_REL4
  xEventDataBox(x,y,id,event,time,cData,tasks,whichbutton);
#endif
}

/* MAIN LOOP *****************************************************************/
main_loop()
{
#ifdef X_REL4
XtMainLoop();
#endif
}
