/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/crypto/RCS/dumphex.c,v $
 *
 *
 *  MODULE NAME:    dumphex.c
 *
 *
 *  AUTHORS:
 *
 *	J. Tardo
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


/* dumphex.c */
#include <stdio.h>
#include <ctype.h>

#define CHARS_PER_LINE 16

/*
 * write out half-ASCII hex characters to a file
 */

int fdumphex (x,l,fp)
int l;
unsigned char * x;
FILE *fp ;
{
    int i;
    for(i=0;i<l;i++){
	if ((i!=0) && ((i%CHARS_PER_LINE)==0))  fprintf(fp,"\n");
	fprintf(fp," %02x",*x++);
	}
    fprintf(fp,"\n");	 
}

int fdumpbin (x,l,fp)
int l;
unsigned char * x;
FILE *fp ;
{
    int i;
    fprintf(fp,"%x;", l);	 
    for(i=0;i<l;i++){
	putc(*x++, fp);
	}
}

/*
 * read in half-ASCII text, skipping whites, until EOF or non-hex encoded byte
 * found, returning number of bytes read.
 */
int freadhex (x,l,fp)
int l;
unsigned char * x;
FILE *fp ;
{
    int i,j;
    for(i=0;fscanf(fp," %02x",&j);i++) *x++=j;
    return (i);
}

int freadbin (x,l,fp)
int l;
unsigned char * x;
FILE *fp ;
{
    int i,j, len;

    fscanf(fp, "%x;", &len);
    for (i=0;i<len;i++) { j=getc(fp);  *x++=j; }
    return (len);
}


int dumphex (x,l)
int l;
unsigned char * x;
{
    fdumphex(x,l,stdout);
}
