/*	@(#)stddef.h	2.2	ULTRIX	6/8/89	*/
/************************************************************************
 *									*
 *			Copyright (c) 1989 by				*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/
/************************************************************************
 *			Modification History
 *
 *	Jon Reeves, 1989 May 10
 * 001	Created to satisfy ANSI standard
 *
 *	Reeves, 1989 May 30
 * 002	Added specific protection for size_t, wchar_t
 *
 ************************************************************************/

#ifndef	_STDDEF_H_
#define	_STDDEF_H_

typedef	int		ptrdiff_t;	/* difference of two pointers */

#ifndef _WCHAR_T_
#define _WCHAR_T_
typedef	unsigned char	wchar_t;	/* size of largest character */
#endif

#ifndef	_SIZE_T_
#define	_SIZE_T_
typedef	unsigned int	size_t;		/* type of sizeof */
#endif

/*
	Null pointer.
 */
#define	NULL 0

/*
	Offset in bytes of a member of the specified type.
 */
#define	offsetof(s_name, m_name) (size_t)&(((s_name*)0)->m_name)

#endif
