#############################################################################
##
#A  Matrix Group and G-module library                   Derek Holt
#A                                                      Charles Leedham-Green
#A                                                      Eamonn O'Brien
#A                                                      Sarah Rees 
##
#A  @(#)$Id$
##
#Y  Copyright 1994 -- School of Mathematical Sciences, ANU   
##
#H  $Log$
##
#############################################################################
##
## generate random elements in group
## 
#############################################################################
##
#F ScrambleElement (gens) . . .     scramble the elements of gens
## 
##
ScrambleElements := function (gens, n)

   local NmrGens, i, s, t, u;
 
   NmrGens := Length (gens);

   for i in [1..n] do
      s := Random ([1..NmrGens]);
      t := Random ([1..NmrGens]);
      if s <> t then 
         u := Random ([1..2]);
         if u = 1 then 
            gens[s] := gens[s] * gens[t];
         else
            gens[s] := gens[t] * gens[s];
         fi;
      fi;
   od; 

end; #ScrambleElements 

#############################################################################
##
#F InitialiseSeed (gens, SeedLength, n) . . . initialise Seed     
## 
## n is the total number of multiplications performed to 
## compute initial array 
##
InitialiseSeed := function (gens, SeedLength, n)

   local Seed, i, NmrGens;
   
   #have we supplied a group or G-module rather than a set of matrices?
   if IsGroup (gens) then 
      gens := gens.generators;
   fi;

   if IsGModule (gens) then 
      gens := MatricesFlag (gens);
   fi;
			
   NmrGens := Length (gens);
   SeedLength := Maximum (SeedLength, Length (gens));

   Seed := [];
   for i in [1..SeedLength] do 
      Seed[i] := gens[Mod (i, NmrGens) + 1];
   od;
   
   ScrambleElements (Seed, n);
   
   return Seed;

end; #InitialiseSeed

#############################################################################
##
#F RandomElement (Seed) . . .                   find a random element in Seed 
## update Seed to ensure that the same element is not handed back on next call
##
RandomElement := function (Seed) 

   local A, s, t, u;

   s := Random ([1..Length (Seed)]);
   A := Seed[s];

   repeat 
      t := Random ([1..Length (Seed)]);
   until s <> t;

   u := Random ([1..2]);
   if u = 1 then 
      Seed[s] := Seed[s] * Seed[t];
   else
      Seed[s] := Seed[t] * Seed[s];
   fi;

   return A;

end; #RandomElement
