/*
C
C  _______________________________________________________________
C
C*   Licence
C    =======
C
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C
C  _______________________________________________________________
C
*/


#include <stdio.h>

#include "kask.h"
#include "kaskevnt.h"
#include "kaskcmd.h"

extern char *malloc();

long allocMem = 0L;

static char line[256];
static KaskEvent ZIBEv;

void *ZIBAlloc(size)
  long size;
  {
    void *buf;
    int lng=size;
    buf = (void*)malloc(lng);
    if (buf!=nil) allocMem += size;
/*	printf(" Mem, size %d %d \n", allocMem,size);		*/
    return buf;
  }

void ZIBFree(buf)
  void *buf;
  {
    free(buf);
    return;
  }
  
REAL ZIBSeconds()
  {
     long t = clock();
     return t*1.0e-6;
  }

int ZIBReadFile(name,buffer)
  char *name, **buffer;
  {
    FILE *fd;
	long textLng;

	fd = fopen(name,"r");
	if (fd==nil)
	  { 
		sprintf(globBuf,"File '%s' could not be opened\n",
				name);
		ZIBStdOut(globBuf);
		return false;
	  }
	textLng = fseek(fd, 0L, 2);
	textLng = ftell(fd);
	rewind(fd);
	*buffer = (char*)ZIBAlloc(textLng+1L);
	if (*buffer==nil)
	  {
		sprintf(globBuf,"Not enough memory to store %ld bytes of '%s'\n",
				textLng, name);
		ZIBStdOut(globBuf);
		fclose(fd);
		*buffer = nil;
		return false;
	  }
	textLng = fread(*buffer,1L,textLng,fd);
	(*buffer)[textLng] = '\0';
	fclose(fd);

	return true;
  }

static FILE *outFile = nil;

void ZIBNL()
  {
    putc('\n',outFile);
	return;
  }

void ZIBStdOut(s)
  char *s;
  {
	if (outFile==nil) outFile = stdout; /* fopen("test.output","w"); */
    fputs(s,outFile);
	return;
  }

KaskEvent *ZIBEvent()
  {
	*line = NUL;
	fputs(stdCmdModes.prompt, stdout); fflush(stdout);
	if (fgets(line, 256, stdin)==nil)
	  {
	    if (*line==NUL)
		  {
		    fprintf(outFile, "No response from input\n");
			goon = false;
			return nil;
		  }
		else
		  {
		    fprintf(outFile, "Line longer than 254 characters\n");
			line[255] = NUL;
		  }
	  }
	ZIBEv.type = LineComplete;
	(ZIBEv.value).line = line;
	return &ZIBEv;
  }
