/*
C
C  _______________________________________________________________
C
C*   Licence
C    =======
C
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C
C  _______________________________________________________________
C
*/


#include <math.h>
 
#include "kask.h"
#include "kasktri.h"
#include "kaskass.h"
#include "kasksol.h"
  
INTEGDATA *stdIData=nil, *qStdIData=nil, *lStdIData=nil, *eStdIData=nil;
 
/*
    Integration points and weights
*/
REAL *iPointX, *iPointY, *iWeight,
			**shape, **shapeX, **shapeY,
			**shapeXX, **shapeXY, **shapeYY;

int  noOfLinIPs = 2;
REAL linIPsX[3][2] = { {0.5+0.5/SQRT3,0.5-0.5/SQRT3},
			    {0.0,0.0},
			    {0.5-0.5/SQRT3,0.5+0.5/SQRT3} };
REAL linIPsY[3][2] = { {0.5-0.5/SQRT3,0.5+0.5/SQRT3},
			    {0.5-0.5/SQRT3,0.5+0.5/SQRT3},
			    {0.0,0.0} };
REAL linIW[3][2]  = { {SQRT2/2.0,SQRT2/2.0},{0.5,0.5},{0.5,0.5} };
REAL line[6][3][2];

int noOfIPoints, noOfShapeFunc,
	iFrom, iTo, kFrom, kTo,
	symP, curAss, partP;

REAL *assAdr[6];

VOIDPROC Shape;

static int ellipMsg = false, qNegMsg = false;

int InitNumAss(type)
  int type;
  {
    int i, j,k;
    REAL dum1,dum2,dum3,dum4,dum5;

	if (stdIData==nil)
	  { 
	    stdIData = NewIData(BANKIP,3, StdShape, actProblem->symP);
	    if (stdIData==nil) return false;
	  }
    if (qStdIData==nil)
	  { 
	    qStdIData = NewIData(BANKIP, 6, StdQShape, actProblem->symP);
	    if (qStdIData==nil) return false;
	  }
    if (lStdIData==nil)
	  { 
	    lStdIData = NewIData(BANKIP, 6, StdShape, actProblem->symP);
	    if (lStdIData==nil) return false;
	  }
	if (eStdIData==nil)
	  { 
	    eStdIData = NewIData(USERIP, 3, StdShape, actProblem->symP);
	    if (eStdIData==nil) return false;
	  }

	curAss = type;
	assA = assAG;
	assB = assBG;
	switch (type)
	{
	  case N_STD:
	  case N_LL:
		assA = assAdr;
		for(i=0; i<6; i++) assA[i] = assAL[i];
	  	noOfIPoints = stdIData->noOfIPoints;
		noOfShapeFunc = stdIData->noOfShapeFunc;
 	   	Shape =  StdShape;
		iFrom = 0;
		iTo = stdIData->noOfShapeFunc;
		kFrom = 0;
		kTo = stdIData->noOfShapeFunc;
		symP = actProblem->symP;
		iPointX = stdIData->integPointX;
		iPointY = stdIData->integPointY;
		iWeight = stdIData->integWeight;
		shape = stdIData->shape;
		shapeX = stdIData->shapeX;
		shapeY = stdIData->shapeY;
		shapeXX = stdIData->shapeXX;
		shapeXY = stdIData->shapeXY;
		shapeYY = stdIData->shapeYY;
		break;
	  case N_QUAD:
	  	noOfIPoints = qStdIData->noOfIPoints;
	   	noOfShapeFunc = qStdIData->noOfShapeFunc;
 	   	Shape   = StdQShape;
		iFrom   = 0;
		iTo     = qStdIData->noOfShapeFunc;
		kFrom   = 0;
		kTo     = qStdIData->noOfShapeFunc;
		symP    = actProblem->symP;
		iPointX = qStdIData->integPointX;
		iPointY = qStdIData->integPointY;
		iWeight = qStdIData->integWeight;
		shape   = qStdIData->shape;
		shapeX  = qStdIData->shapeX;
		shapeY  = qStdIData->shapeY;
		shapeXX = qStdIData->shapeXX;
		shapeXY = qStdIData->shapeXY;
		shapeYY = qStdIData->shapeYY;
		break;
	  case N_EQ:
	  	noOfIPoints = lStdIData->noOfIPoints;
	   	noOfShapeFunc = lStdIData->noOfShapeFunc;
 	   	Shape   = StdShape;
		iFrom   = 0;
		iTo     = lStdIData->noOfShapeFunc;
		kFrom   = 0;
		kTo     = lStdIData->noOfShapeFunc;
		symP    = actProblem->symP;
		iPointX = lStdIData->integPointX;
		iPointY = lStdIData->integPointY;
		iWeight = lStdIData->integWeight;
		shape   = lStdIData->shape;
		shapeX  = lStdIData->shapeX;
		shapeY  = lStdIData->shapeY;
		shapeXX = lStdIData->shapeXX;
		shapeXY = lStdIData->shapeXY;
		shapeYY = lStdIData->shapeYY;
		break;

	  case N_LQ:
	  case N_QL:
	    noOfIPoints = lStdIData->noOfIPoints;
	  	noOfShapeFunc = 6;
 	   	Shape =  StdShape;
		iFrom = 3;
		iTo = 6;
		kFrom = 0;
		kTo = 3;
		symP = FULL;
		iPointX = lStdIData->integPointX;
		iPointY = lStdIData->integPointY;
		iWeight = lStdIData->integWeight;
		shape = lStdIData->shape;
		shapeX = lStdIData->shapeX;
		shapeY = lStdIData->shapeY;
		shapeXX = lStdIData->shapeXX;
		shapeXY = lStdIData->shapeXY;
		shapeYY = lStdIData->shapeYY;
		break;
	  case N_QQ:
	  	noOfIPoints = lStdIData->noOfIPoints;
	   	noOfShapeFunc = 6;
 	   	Shape =  StdShape;
		iFrom = 3;
		iTo = 6;
		kFrom = 3;
		kTo = 6;
		symP = DIAGONAL;
		iPointX = lStdIData->integPointX;
		iPointY = lStdIData->integPointY;
		iWeight = lStdIData->integWeight;
		shape = lStdIData->shape;
		shapeX = lStdIData->shapeX;
		shapeY = lStdIData->shapeY;
		shapeXX = lStdIData->shapeXX;
		shapeXY = lStdIData->shapeXY;
		shapeYY = lStdIData->shapeYY;
		break;
	  case N_EL:
	  	noOfIPoints = eStdIData->noOfIPoints;
	   	noOfShapeFunc = eStdIData->noOfShapeFunc;
 	   	Shape =  StdShape;
		iFrom = 0;
		iTo = eStdIData->noOfShapeFunc;
		kFrom = 0;
		kTo = eStdIData->noOfShapeFunc;
		symP = actProblem->symP;
		iPointX = eStdIData->integPointX;
		iPointY = eStdIData->integPointY;
		iWeight = eStdIData->integWeight;
		shape   = eStdIData->shape;
		shapeX  = eStdIData->shapeX;
		shapeY  = eStdIData->shapeY;
		shapeXX = eStdIData->shapeXX;
		shapeXY = eStdIData->shapeXY;
		shapeYY = eStdIData->shapeYY;
		break;

	  default:
	    ZIBStdOut("Unknown parameter for InitNumAss\n");
	    return false;
	}
		for(i = 0; i<6; i++)
		  {
		    assB[i] = ZERO;
			for (k = 0; k<6; k++) assA[i][k] = ZERO;
		  }

	/*      fuer Cauchy-Rdbedg.:
		Tabellierung der Werte der phi[i] 
		in den Integrationspunkten jeder Kante   */

	for(i=0;i<6;i++)
	    {
	      for(k=0;k<3;k++)
	          { for(j=0;j<2;j++)
		    { 
		      (*Shape)(linIPsX[k][j],linIPsY[k][j],i,&line[i][k][j],
			    &dum1,&dum2,&dum3,&dum4,&dum5);   
		    }  
	          }    
            }
 
	return true;
  }

int NumAss(t)
  TR *t;
  {
    REAL *td = (REAL*)(t->user);
    PT *p1 = t->p1,*p2 = t->p2,*p3 = t->p3;
    PT  **pts = &(t->p1), *pt1,*pt2;
    EDG **eds = &(t->e1);
    TR *tFather;
    REAL *fVals=actProblem->fVals,*cauVals=actProblem->cauVals;
    REAL f11, f12, f21, f22, dx, dy, hilfe,sXX,sXY,sYY;
    REAL xm, ym, pXxy[7], pYxy[7], qxy[7], gxy[7], xixy[2],sigmaxy[2],d, dAbs;
    int i,k,kk,m,firstTime=false;

 	if ((curAss==N_STD)&&(actSolve->iluP==0))
	  {
		if (td!=nil)
		  {
			assA[0]=&(td[0]);
			assA[1]=&(td[1]);
			assA[2]=&(td[3]);
			assB=&(td[6]);
			return true;
		  }
		tFather = t->father;
		if (tFather!=nil)
		  {
			if ((tFather->user)!=nil)
			  {
				td = (REAL*)(tFather->user);
				tFather->user = nil;
			  }
			else td = (REAL*)GetElem(LOCALSTIFF);
		   }
		else td = (REAL*)GetElem(LOCALSTIFF);
		if (td==nil) return false;
		t->user = (PTR)td;
		assA[0]=&(td[0]);
		assA[1]=&(td[1]);
		assA[2]=&(td[3]);
		assB=&(td[6]);
        firstTime = true;
	  }
/*	 printf("p1 %e %e \n",p1->x,p1->y);
 printf("p2 %e %e \n",p2->x,p2->y);
 printf("p3 %e %e \n",p3->x,p3->y);
*/
    f11 = (p2->x)-(p1->x);
    f12 = (p3->x)-(p1->x);
    f21 = (p2->y)-(p1->y);
    f22 = (p3->y)-(p1->y);
    d = f11*f22-f12*f21;
	dAbs = fabs(d);
 
	for (m = 0; m<noOfIPoints; m++)
     {
	xm = f11*iPointX[m]+f12*iPointY[m]+(p1->x);
	ym = f21*iPointX[m]+f22*iPointY[m]+(p1->y);


	(actProblem->F)(xm, ym,t->class,fVals);
	   pXxy[m] = fVals[0];
	   pYxy[m] = fVals[1];
	   if ((pXxy[m]*pYxy[m])<ZERO)
	     {
		   if (!ellipMsg)
		     {
			   sprintf(globBuf, "p1*p2<0, not elliptic at (%e,%e)", xm, ym);
			   ZIBStdOut(globBuf);
			   ellipMsg = true;
			 }
		 }
	   qxy[m] = fVals[2];
	   if (qxy[m]<ZERO)
	     {
		   if (!qNegMsg)
		     {
			   sprintf(globBuf, "q<0 at (%e,%e)", xm, ym);
			   ZIBStdOut(globBuf);
			   qNegMsg = true;
			 }
		 }
           gxy[m] = fVals[3];
     }

    for (i = iFrom; i<iTo; i++)
     {
       if ((partP==P_STIFF)||(partP==P_ALL)||firstTime)
	   for (k = kFrom; k<kTo; k++)
        {
		  if ((symP==SYMMETRIC)&&(k>i)) continue;
		  if ((symP==DIAGONAL)&&(k!=i)) continue;
		  assA[i][k] = ZERO;
          for (m = 0; m<noOfIPoints; m++)
           {
             sXX = shapeX[i][m]*shapeX[k][m];
			 sXY = (shapeY[i][m]*shapeX[k][m]+shapeX[i][m]*shapeY[k][m]);
			 sYY = shapeY[i][m]*shapeY[k][m];
			 hilfe = iWeight[m]*((1.0/dAbs)*
			 	(pXxy[m]*
                  (f22*f22*sXX-f21*f22*sXY+f21*f21*sYY)+
			 	 pYxy[m]*
                  (f12*f12*sXX-f11*f12*sXY+f11*f11*sYY))+
                 dAbs*qxy[m]*shape[i][m]*shape[k][m]
				 );
			 assA[i][k] += hilfe;
           }
/*   printf("i,k, assA[i,k] %d %d %e \n",i,k, assA[i][k]);  */

        }

       if ((partP==P_RHS)||(partP==P_ALL)||firstTime)
	     {
	   	   assB[i] = ZERO;
       	   for(m = 0; m<noOfIPoints; m++)
    		{
     		  hilfe = iWeight[m]*gxy[m]*shape[i][m];
   			  assB[i] += hilfe;
 			}
		   assB[i] = assB[i]*dAbs;
/*    printf("i, dAbs,assB[i] %d %e %e \n",i, dAbs, assB[i]);   */

		 }
      }
/*
	sprintf(globBuf, "assA:(%d,%d,%d)", (t->p1)->indexP,
			(t->p2)->indexP, (t->p3)->indexP);
	PrintMatFull(globBuf, assA, noOfShapeFunc, symP);
	PrintVecFull("assB", assB, noOfShapeFunc);
*/

/*      Behandlung der Cauchy-Randbedingungen     */

        for (k=0;k<3;k++)
     	  { if (eds[k]->boundP == CAUCHY)
		{ pt1 = pts[(k+1)%3]; pt2 = pts[(k+2)%3];
		  dx  = (pt2->x) - (pt1->x);
		  dy  = (pt2->y) - (pt1->y);
		  d   = sqrt( dx*dx + dy*dy );

		  for (m=0; m<noOfLinIPs; m++)
		    {
     		xm = f11*linIPsX[k][m]+f12*linIPsY[k][m]+(p1->x);
     		ym = f21*linIPsX[k][m]+f22*linIPsY[k][m]+(p1->y);
			(actProblem->CauchyF)(xm, ym, t->class, cauVals);
		 	sigmaxy[m]	= cauVals[0];
		 	xixy[m]		= cauVals[1];
		    }


    		 if ((partP==P_STIFF)||(partP==P_ALL)||firstTime)
		    {
		     for (i= iFrom; i< iTo; i++)
		        {
		         for (kk = kFrom; kk < kTo; kk++)
      		           {
		            if ((symP==SYMMETRIC) && (kk>i))  continue;
		            if ((symP==DIAGONAL)  && (kk!=i)) continue;

 			    hilfe = ZERO;
	                    for (m = 0; m < noOfLinIPs; m++)
                              {
           		       hilfe += linIW[k][m]*sigmaxy[m]*line[i][k][m]*line[kk][k][m];
			      }
		            hilfe =  d*hilfe;
			    if (k==0)   hilfe = hilfe / SQRT2;
			    assA[i][kk] += hilfe;
                           }
                        }
		      }


      		 if ((partP==P_RHS)||(partP==P_ALL)||firstTime)
	 	    {
		      for (i= iFrom; i< iTo; i++)
		          {
		     	   hilfe = ZERO;
       	  	           for(m = 0; m < noOfLinIPs; m++)
     		              hilfe += linIW[k][m]*xixy[m]*line[i][k][m];
		           hilfe =  d*hilfe;
		           if (k==0)   hilfe = hilfe / SQRT2;
		           assB[i]  += hilfe; 
			  }
		     }

		}
	  }

    return true;
  }


int eNormInt(t)
  TR *t;
  {
    PT *p1 = t->p1,*p2 = t->p2,*p3 = t->p3;
    REAL *fVals=actProblem->fVals;
	REAL *solVals=actProblem->solVals;
    REAL f11, f12, f21, f22, hilfe, hilf1, sXX, sYY, d, dAbs;
    REAL xm, ym, pXxy[7], pYxy[7], qxy[7];
	REAL u[7], ux[7], uy[7], uh[3];
    int i,m;

    f11 = (p2->x)-(p1->x);
    f12 = (p3->x)-(p1->x);
    f21 = (p2->y)-(p1->y);
    f22 = (p3->y)-(p1->y);
	d	= f11*f22-f12*f21;
	dAbs= fabs(d);

	for (m = 0; m<noOfIPoints; m++)
		{
		xm = f11*iPointX[m]+f12*iPointY[m]+(p1->x);
		ym = f21*iPointX[m]+f22*iPointY[m]+(p1->y);


		(actProblem->F)(xm, ym,t->class,fVals);
		pXxy[m] = fVals[0];
		pYxy[m] = fVals[1];
		qxy[m]  = fVals[2];
		(actProblem->Sol)(xm, ym,t->class,solVals);
		u[m]  = solVals[0];
		ux[m] = solVals[1];
		uy[m] = solVals[2];

		eNormU += dAbs* (iWeight[m]*(pXxy[m]*ux[m]*ux[m] 
					+ pYxy[m]*uy[m]*uy[m] + qxy[m]*u[m]*u[m]) );
		}
	

	uh[0] = RA(p1,R_SOL);
	uh[1] = RA(p2,R_SOL);
	uh[2] = RA(p3,R_SOL);

    for (i = 0; i < 3; i++)
		{
		hilfe = ZERO;
        for (m = 0; m < noOfIPoints; m++)
           {
             sXX = shapeX[i][m];
			 sYY = shapeY[i][m];
			 hilf1 = pXxy[m]*ux[m]* ( f22*sXX-f21*sYY)		+
							 pYxy[m]*uy[m]* (-f12*sXX+f11*sYY) ;
			 hilfe += iWeight[m]*( (dAbs/d)*
							(hilf1)	+
							dAbs*qxy[m]*u[m]*shape[i][m] );
/* printf("iWeight[m], sXX, sYY %e %e %e \n",iWeight[m],sXX, sYY);  */
           }
		 eNormUUl += uh[i]*hilfe;
		}




    return true;
  }

int PrStiff(t)
  TR *t;
  {
    (actProblem->NumAss)(t);
	sprintf(globBuf, "assA:(%d,%d,%d)", (t->p1)->indexP,
			(t->p2)->indexP, (t->p3)->indexP);
	PrintMatFull(globBuf, assA, noOfShapeFunc, symP);
	PrintVecFull("assB", assB, noOfShapeFunc);
    return true;
  }
