 /*
C*    Begin Prologue ELLKASK
C   ______________________________________________________________
C
C*  Title
C
C     Adaptive hierarchical finite element code for solving linear
C     scalar second-order 2-D elliptic partial differential equations
C     on general domains
C
C*  Written by        R. Roitzsch, B. Erdmann
C                     with contributions by R. Kornhuber, F. Bornemann
C*  Purpose           Adaptive finite element solution of elliptic partial
C                     differential equations
C*  Method            finite element discretization, conjugate gradients,
C                     hierarchical basis as preconditioner, adaptive  
C                     multi level scheme 
C*  Category          ? - elliptic partial differential equations
C*  Keywords          ellipitc partial differential equations,
C                     finite element method, multi level methods,
C                     adaptive refinement
C*  Version           1.2
C*  Revision          January 1991
C*  Latest Change     January 1991
C*  Library           CodeLib
C*  Code              C
C*  Environment       Unix systems, Sun (graphics),
C                     Macintosh.
C*  Copyright     (c) Konrad Zuse Zentrum fuer
C                     Informationstechnik Berlin
C                     Heilbronner Str. 10, D-1000 Berlin 31
C                     phone 0049+30+89604-0, 
C                     telefax 0049+30+89604-125
C*  Contact           Rainer Roitzsch 
C                     ZIB, Numerical Software Development 
C                     phone: 0049+30+89604-215
C                     e-mail: 
C                     RFC822 notation: roitzsch@sc.zib-berlin.de
C                     X.400: C=de;A=dbp;P=zib-berlin;OU=sc;S=Roitzsch
C
C*  References 
C
C     /1/ P. Deuflhard, P. Leinen, H. Yserentant:
C         Concept of an Adaptive Hierarchical Finite Element Code.
C         IMPACT I, 3-35 (1989)
C
C     /2/ R. Roitzsch:
C         KASKADE User's Manual
C         KASKADE Programmer's Manual
C         ZIB Technical Reports TR-89-4/5
C
C     /3/ Bodo Erdmann, Rainer Roitzsch
C         KASKADE - Numerical Experiments
C         ZIB Technical Report - in preparation
C
C  _______________________________________________________________
C
C*   Licence
C    =======
C
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C
C  _______________________________________________________________
C
C
C*    More:
C     ======
C
C     see /2,3/, ellkask.doc
C
C*    End Prologue ELLKASK

 */
#include <stdio.h>

#include "kask.h"
#include "kaskevnt.h"
#include "kaskcmd.h"
#include "kasktri.h"

/* #define PERFORMANCE */

#ifdef PERFORMANCE
#undef true
#undef false
#include <Perf.h>
#define ROMII 0x78
#endif

#ifdef PERFORMANCE
TP2PerfGlobals ThePGlobals;
OSErr err;
#endif

static char *cmdDefFileName = "ellkask.def";

static void SetAddresses();

int goon = true, globArgc, cmdError = false;
char **globArgv, **globEnvp;
char *kaskPath = "";
char *globBuf = nil;

static REAL totalTime, lastTime;

main(argc, argv, envp)
  int argc;
  char **argv, **envp;
  {
    COMMAND *cmd;
	KaskEvent *event;

#ifdef PERFORMANCE
ThePGlobals = nil;
if (!InitPerf(&ThePGlobals, 4, 8, false, true, "\pCODE",
			  ROMII, "", false, 0, 0, 8))
  { ZIBStdOut("Init of performance tools failed\n"); return -1; }
(void)PerfControl(ThePGlobals, true);
#endif

	globBuf = (char*)ZIBAlloc(256L);
	if (globBuf==nil) { ZIBStdOut("Aua\n"); return -1; }
	totalTime = ZIBSeconds();
	lastTime = totalTime;

	ZIBStdOut("Start of ELLKASK (Version 1.2) January 1991\n");

	globArgc = argc;
	globArgv = argv;
	globEnvp = envp;

	if (!InitCommands(kaskPath, cmdDefFileName))
	  { ZIBStdOut("Jammer\n"); return -1; }
	if (!InitTri(R_MAXPT, R_MAXEDG, R_MAXTR))
	  { ZIBStdOut("Schmerz\n"); return -1; }
	SetAddresses();

	while (goon)                        /* Start of Event Loop */
	{
	  event = GetKaskEvent();
	  if (event==nil) break;
	  switch (event->type)
	  {
	    case LineComplete:
		  DoCommands((event->value).line,(PROC)nil);
		  break;
		default:
		  goon = false;
		  /* Error: unknown event */
		  break;
	  }
	  while (goon)
	  {
		cmd = GetNextCommand();
		if (cmd==nil) break;
		if (cmd==((COMMAND*)-1)) continue;
	    if(!ExecCommand(cmd)) cmdError = true;
	  }
	}                                     /* End of Event Loop */
	totalTime = ZIBSeconds()-totalTime;
	sprintf(globBuf, "End of ELLKASK after %.2f secs\n",totalTime);
	ZIBStdOut(globBuf);

#ifdef PERFORMANCE
err = PerfDump(ThePGlobals, "\pkaskade.out", false, 0);
if (err!= noErr) ZIBStdOut("Writing performance data failed\n");
TermPerf(ThePGlobals);
#endif

	return 0;
  }

static int PrTime(cmd)
  COMMAND *cmd;
  {
    REAL tt = ZIBSeconds();
	char s1[256], s2[256];

	if (ParsCheck(cmd,0,0)) return false;

	ZIBNL();
	sprintf(&s1[0], "%.2f", tt-totalTime);
	sprintf(&s2[0], "%.2f", tt-lastTime);
	sprintf(globBuf, "Time: %s secs, since last call %s secs, allocated memory: %dbyte\n",
			&s1[0], &s2[0], allocMem);
	ZIBStdOut(globBuf);

	lastTime = tt;
	return true;
  }

static void SetAddresses()
  {
	extern int CmdQuit(), CmdPrint(), CmdDo(), CmdExit(), CmdHelp();
	extern int RdTri(), WrTri();
	extern int StdProblem(), Problem(), Toms();
	extern int UpdPrb(), InfPrb(), Laplace();
	extern int TriInf(), TriSel(), TriDel(), TriChk(), ILUCheck();
	extern int SelInteg(), SetInteg(), TestInteg();
	extern int SolveDir(), ErrEsti(), RefCmd(), SolveIte(), SetBreak(), Solve();
	extern int Graphic(), ShowGraph(), PostScript(), Window();
	extern int InfPar(), SetPar();
	extern int PreCond(), Estimator();
	extern int Statistics(), Quadratic();

	SetCommand( 0, CmdQuit);
	SetCommand( 1, CmdPrint);
	SetCommand( 2, CmdDo);
	SetCommand( 3, CmdExit);
	SetCommand( 5, PrTime);
	SetCommand( 6, CmdHelp);
	SetCommand(10, RdTri);
	SetCommand(11, WrTri);
	SetCommand(12, TriInf);
	SetCommand(13, TriSel);
	SetCommand(14, TriDel);
	SetCommand(15, TriChk);
	SetCommand(16, RefCmd);
	SetCommand(17, ILUCheck);
	SetCommand(20, StdProblem);
	SetCommand(21, Problem);
	SetCommand(22, InfPrb);
	SetCommand(23, Laplace);
	SetCommand(24, Toms);
	SetCommand(25, SelInteg);
	SetCommand(26, SetInteg);
	SetCommand(27, TestInteg);
	SetCommand(30, SolveDir);
	SetCommand(31, ErrEsti);
	SetCommand(32, SolveIte);
	SetCommand(33, SetBreak);
	SetCommand(34, Solve);
	SetCommand(35, Graphic);
	SetCommand(36, ShowGraph);
	SetCommand(37, PostScript);
	SetCommand(41, Window);
	SetCommand(42, InfPar);
	SetCommand(43, SetPar);
	SetCommand(44, PreCond);
	SetCommand(45, Estimator);
	SetCommand(46, Statistics);
	SetCommand(47, Quadratic);


	return;
  }
