      PROGRAM LIMTST
C
C  EXAMPLE FOR THE CALL OF SUBROUTINE LIMEXS
C  INTEGRATOR FOR DIFFERENTIAL-ALGEBRAIC SYSTEMS
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION Y(3),RW(1000)
      INTEGER IW(1000),IJOB(20)
      EXTERNAL FCNS,LSCS,JACS
      EXTERNAL FCNT,LSCT,JACT
      N=3
      NZC=0
      NZV=2
      T=0.D0
      Y(1)=-1.D0
      Y(2)=5.D0
      Y(3)=4.D0*Y(1)/(3.D0*Y(1)-8.D0)
      TEND=0.1108D0
      RTOL=1.D-3
      YMAX0=1.D0
      HMAX=TEND-T
      H=1.D-3
      NRW=143
      NIW=111
      LDIM=7
      IJOB(1)=0
      IJOB(2)=1
      IJOB(3)=2
      IJOB(4)=0
      IJOB(5)=0
      IJOB(6)=2
      IJOB(6)=4
      IJOB(7)=1
C
      CALL LIMEXS (N,NZC,NZV,LDIM,LSCS,FCNS,JACS,T,Y,TEND,RTOL,
     1             YMAX0,HMAX,H,IJOB,NRW,RW,NIW,IW)
C
C
      N=2
      NZC=0
      NZV=1
      T=0.D0
      Y(1)=0.D0
      Y(2)=5.D0
      TEND=2.D0
      RTOL=1.D-3
      YMAX0=1.D0
      HMAX=TEND-T
      H=0.D0
      NRW=1000
      NIW=1000
      LDIM=1
      IJOB(1)=0
      IJOB(2)=1
      IJOB(3)=2
      IJOB(4)=0
      IJOB(5)=0
      IJOB(6)=2
      IJOB(6)=4
      IJOB(7)=1
C
      CALL LIMEXS (N,NZC,NZV,LDIM,LSCT,FCNT,JACT,T,Y,TEND,RTOL,
     1             YMAX0,HMAX,H,IJOB,NRW,RW,NIW,IW)
C
C
      STOP
      END
C
C
      SUBROUTINE FCNS (N,NZV,T,Y,DY,BV,IRV,ICV,IFLAG)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION Y(N),DY(N),BV(NZV),IRV(NZV),ICV(NZV)
      IF(IFLAG.EQ.0) GOTO 100
      DY(1)=-0.8D0*Y(1)+1.D1*Y(2)-0.6D0*Y(1)*Y(3)
      DY(2)=-1.D1+1.6D0*Y(3)/Y(2)
      DY(3)=0.8D0*Y(1)+1.6D0*Y(3)-0.6D0*Y(1)*Y(3)
      BV(1)=1.D0/Y(2)
      BV(2)=1.D0
      RETURN
100   IRV(1)=2
      ICV(1)=2
      IRV(2)=1
      ICV(2)=1
      RETURN
      END
C
      SUBROUTINE LSCS (NZC,BC,IRC,ICC,IFLAG)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION BC(NZC)
      DIMENSION IRC(NZC),ICC(NZC)
      IF(IFLAG.EQ.0) GOTO 100
      BC(1)=1.D0
      RETURN
100   IRC(1)=1
C     ICC(1)=1
      RETURN
      END
C
      SUBROUTINE JACS (N,LDIM,T,Y,YP,A,JA,IA,IFLAG)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION Y(N),YP(N),A(LDIM)
      INTEGER JA(LDIM),IA(*)
      IF(IFLAG.EQ.0) GOTO 100
      A(1)=-0.8D0-0.6D0*Y(3)
      A(2)=1.D1
      A(3)=-0.6D0*Y(1)
      A(4)=(YP(2)-1.6D0*Y(3))/Y(2)**2
      A(5)=1.6D0/Y(2)
      A(6)=0.8D0-0.6D0*Y(3)
      A(7)=1.6D0-0.6D0*Y(1)
      RETURN
100   JA(1)=1
      JA(2)=2
      JA(3)=3
      JA(4)=2
      JA(5)=3
      JA(6)=1
      JA(7)=3
      IA(1)=1
      IA(2)=4
      IA(3)=6
      IA(4)=8
      RETURN
      END
C
      SUBROUTINE FCNT (N,NZV,T,Y,DY,BV,IRV,ICV,IFLAG)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DIMENSION Y(N),DY(N),BV(NZV),IRV(NZV),ICV(NZV)
      IF(IFLAG.EQ.0) GOTO 100
      DY(1)=1.D0
      DY(2)=Y(2)
      BV(1)=1.D0
      RETURN
100   IRV(1)=1
      ICV(1)=1
      RETURN
      END
C
      SUBROUTINE LSCT (NZC,BC,IRC,ICC,IFLAG)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION BC(NZC)
      DIMENSION IRC(NZC),ICC(NZC)
      IF(IFLAG.EQ.0) GOTO 100
C     BC(1)=1.D0/5.D0
      RETURN
100   IRC(1)=1
C     ICC(1)=1
      RETURN
      END
C
      SUBROUTINE JACT (N,LDIM,T,Y,YP,A,JA,IA,IFLAG)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
      DOUBLE PRECISION Y(N),YP(N),A(LDIM)
      INTEGER JA(LDIM),IA(*)
      IF(IFLAG.EQ.0) GOTO 100
      A(1)=1.D0
      RETURN
100   JA(1)=2
      IA(1)=1
      IA(2)=1
      IA(3)=2
      RETURN
      END
C
      SUBROUTINE LIMEXS (N,NZC,NZV,LDIM,LSC,FCN,JAC,T,Y,TEND,RTOL,
     1                   YMAX0,HMAX,H,IJOB,NRW,RW,NIW,IW)
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C***********************************************************************
C                                                                      *
C    EXTRAPOLATION INTEGRATOR FOR THE SOLUTION OF                      *
C    LINEARLY IMPLICIT DIFFERENTIAL-ALGEBRAIC SYSTEMS OF THE FORM      *
C                                                                      *
C                                                                      *
C      (*)   B (T,Y) * Y' (T) = F (T,Y)                                *
C                                                                      *
C            B :(N,N)-MATRIX,  1.LE.RANK(B).LE.N                       *
C                                                                      *
C***********************************************************************
C
C  EQUATION (*) REPRESENTS AN ODE, IF B IS NONSINGULAR, AND
C  A DIFFERENTIAL-ALGEBRAIC EQUATION (DAE), IF B IS SINGULAR.
C  LIMEXS USES AN ITERATIVE OR DIRECT REALIZATION OF THE SEMI-IMPLICIT
C  EULER-METHOD (EULSIM) FOR THE DISCRETIZATION OF (*).
C
C=======================================================================
C                                                                      =
C     REVISION 3.5  FROM MAY 24, '88                                   =
C                   (=REV 3.2 + MY-ESTIMATE + SPARSE LINEAR ALGEBRA)   =
C                                                                      =
C=======================================================================
C
C  -------------------------------------------------------------------
C
C*  Title
C
C    Numerical solution of Linearly IMplicit differential-algebraic
C    systems with EXtrapolation and Sparse linear algebra techniques
C
C*  Written by        U. Nowak, J. Zugck   
C*  Purpose           Solution of linearly implicit differential-
C                     algebraic systems up to index 1.
C*  Method            Extrapolation integrator with order and stepsize
C                     control. Sparse matrix techniques for linear 
C                     systems
C                     (see references below)
C*  Category          i1a2b: Stiff and mixed implicit differential- 
C                     algebraic systems up to index 1.
C*  Keywords          Differential equations, differential-algebraic 
C                     systems, extrapolation integrator, sparse matrix
C                     techniques
C*  Version           3.5
C*  Revision          May 1988     
C*  Latest Change     January 1991 
C*  Library           CodeLib
C*  Code              Fortran, Double Precision
C*  Environment       Fortran environment on PC's, workstations and
C                     hosts.
C*  Copyright     (c) Konrad Zuse Zentrum fuer
C                     Informationstechnik Berlin
C                     Heilbronner Str. 10, D-1000 Berlin 31
C                     phone 0049+30+89604-0, 
C                     telefax 0049+30+89604-125
C*  Contact           U. Nowak     
C                     ZIB
C                     Numerical Software Development 
C                     phone: 0049+30+89604-175 ;
C                     e-mail: 
C                     RFC822 notation: nowak@sc.zib-berlin.de
C                     X.400: C=de;A=dbp;P=zib-berlin;OU=sc;S=Nowak  
C
C
C  -------------------------------------------------------------------
C
C* licence   
C    You may use or modify this code for your own non commercial
C    purposes for an unlimited time. 
C    In any case you should not deliver this code without a special 
C    permission of ZIB.
C    In case you intend to use the code commercially, we oblige you
C    to sign an according licence agreement with ZIB.
C
C* warranty
C    This code has been tested up to a certain level. Defects and
C    weaknesses, which may be included in the code, do not establish
C    any warranties by ZIB. ZIB does not take over any liabilities
C    which may follow from aquisition or application of this code.
C
C* software status 
C    This code is under partial care of ZIB and belongs to ZIB software
C    class II.
C
C  -------------------------------------------------------------------
C
C
C REFERENCES:
C============
C
C /1/ P. DEUFLHARD, U. NOWAK:
C     EXTRAPOLATION INTEGRATORS FOR QUASILINEAR IMPLICIT ODE'S
C     UNIVERSITY OF HEIDELBERG, SFB 123, TECH. REP. 332 (1985)
C     IN:
C     P. DEUFLHARD, B. ENQUIST (EDS):
C     LARGE SCALE SCIENTIFIC COMPUTING
C     BIRKAEUSER, PROG.SCI.COMP. 7, (1987)
C
C /2/ P. DEUFLHARD, E. HAIRER, J. ZUGCK:
C     ONE STEP AND EXTRAPOLATION METHODS FOR DIFFERENTIAL-ALGEBRAIC
C     SYSTEMS
C     NUM. MATH. 51, 501-516 (1987)
C
C /3/ I.S.DUFF, U.NOWAK:
C     ON SPARSE SOLVERS IN A STIFF INTEGRATOR OF EXTRAPOLATION
C     TYPE.
C     IMA JOURNAL OF NUMERICAL ANALYSIS 7, 391-405 (1987)
C
C /4/ P.DEUFLHARD:
C     RECENT PROGRESS IN EXTRAPOLATION METHODS FOR ODE'S.
C     SIAM REVIEW 27, 505-535  (1985)
C
C=======================================================================
C
C
C  EXTERNAL SUBROUTINES (TO BE SUPPLIED BY THE USER):
C  --------------------------------------------------
C
C   FCN(N,NZV,T,Y,RHS,BV  RIGHT-HAND-SIDE F(T,Y) OF THE SYSTEM, INCLU-
C       ,IRV,ICV,IFLAG)   DING VARIABLE PART BV OF LEFT-HAND-SIDE MATRIX
C                         B(T,Y)
C                         (SPECIFY BV(1),IRV(1),ICV(1) IF NO VARIABLE
C                          ENTRIES IN THE LEFT-HAND-SIDE MATRIX B(T,Y)
C                          OCCUR)
C   LSC(NZC,BC,IRC,ICC,   CONSTANT PART BC OF LEFT-HAND-SIDE MATRIX
C       IFLAG)            B(T,Y) (NON-ZERO ENTRIES ONLY)
C                         (PASS A DUMMY-ROUTINE,IF THERE ARE NO CONSTANT
C                          ENTRIES IN THE LEFT-HAND-SIDE MATRIX B(T,Y) )
C   JAC(N,LDIM,T,Y,YP,A,  ANALYTIC JACOBIAN OF THE RESIDUAL R(T,Y)
C       JA,IA,IFLAG)      R(T,Y):= F(T,Y)-B(T,Y)*Y'
C
C      T                  ACTUAL POSITION
C      Y(N)               VALUES OF Y AT T
C      YP(N)              VALUES OF Y' AT T
C      RHS(N)             VALUES OF THE RIGHT-HAND-SIDE FUNCTIONS F(T,Y)
C      N                  DIMENSION OF THE SYSTEM
C      BV(NZV)            ENTRIES OF VARIABLE PART BV OF LEFT-HAND-SIDE
C                         MATRIX B(T,Y) (SPARSE MODE STORAGE SCHEME, SEE
C                          NOTE 1 BELOW)
C      IRV(NZV)           INTEGER ARRAY CONTAINING ROW-INDICES OF BV
C      ICV(NZV)           INTEGER ARRAY CONTAINING COLUMN-INDICES OF BV
C      NZV                NUMBER OF ENTRIES OF BV
C      BC(NZC)            ENTRIES OF CONSTANT PART BC OF LEFT-HAND-SIDE
C                         MATRIX B(T,Y) (SPARSE MODE STORAGE SCHEME, SEE
C                          NOTE 1 BELOW)
C      IRC(NZC)           INTEGER ARRAY CONTAINING ROW-INDICES OF BC
C      ICC(NZC)           INTEGER ARRAY CONTAINING COLUMN-INDICES OF BC
C      NZC                NUMBER OF ENTRIES OF BC
C      A(LDIM)            ENTRIES OF THE SPARSE JACOBIAN A AT T,Y
C                          (SPARSE MODE STORAGE SCHEME, SEE
C                          NOTE 2 BELOW)
C      LDIM               NUMBER OF ENTRIES OF A
C      JA(LDIM)           INTEGER ARRAY CONTAINING COLUMN INDICES OF A
C      IA(N+1)            INTEGER ARRAY CONTAINING POINTERS TO BEGIN
C                         OF ROWS OF A
C      IFLAG              MODE INDICATOR
C                         FOR IFLAG=0 :LSC,FCN,JAC MUST RETURN IRC,ICC
C                                      IRV,ICV,JA,IA
C                         FOR IFLAG=1 :LSC,FCN,JAC MUST RETURN BC,BV,A
C
C
C  INPUT PARAMETERS (* MARKS TRANSIENT PARAMETERS):
C  ------------------------------------------------
C
C  * T                  STARTING POINT OF INTEGRATION
C  * Y(N)               INITIAL VALUES Y(1),...,Y(N)
C    TEND               PRESCRIBED FINAL POINT OF INTEGRATION
C    RTOL               PRESCRIBED RELATIVE PRECISION (.GT.0)
C    YMAX0              THRESHOLD FOR RELATIVE ERROR CONTROL
C                       ERROR IS RELATIVE (COMPONENTWISE) WITH RESPECT
C                       TO:       MAX(YMAX(I),YMAX0)
C                          WHERE: YMAX(I):= MAXIMUM OF ABS(Y) FOR
C                                 COMPONENT NO.I COMPUTED SO FAR
C    HMAX               MAXIMUM PERMITTED STEPSIZE
C                       (HMAX=TEND-T IS RECOMMENDED)
C  * H                  INITIAL STEPSIZE GUESS
C                       (FOR H=0 AN INITIAL STEPSIZE GUESS IS INTERNALLY
C                        GENERATED)
C    IJOB(20)           INTEGER VECTOR, CONTROLLING THE EXECUTION OF
C                       THE JOB, LENGTH:=20
C   * IJOB(1)           =0: B IS KNOWN TO BE OR MIGHT BE SINGULAR
C                       =1: B IS KNOWN TO BE NONSINGULAR
C     IJOB(2)           =0: NUMERICAL DIFFERENCE-APPROXIMATION OF THE
C                           JACOBIAN OF THE RIGHT-HAND-SIDE F(T,Y)
C                           INTERNALLY GENERATED
C                       =1: ANALYTIC JACOBIAN SUPPLIED BY THE USER
C     IJOB(3)           DUMMY
C     IJOB(4)           DUMMY
C     IJOB(5)           DUMMY
C   * IJOB(6)           PERFORMANCE STATISTICS
C                       =0: NO OUTPUT
C                       =1: STANDARD OUTPUT (ERRORS)
C                       =2: ADDITIONALLY INTEGRATION MONITOR
C                       =3: ADDITIONALLY ENHANCED INFORMATION
C                       =4: ADDITIONALLY INFORMATION ON SPARSE MODE
C                           PERFORMANCE
C                       =5: ADDITIONALLY ITERATION MONITOR ( OF ITERA-
C                           TIVE REALIZATION OF DISCRETIZATION )
C                           AND DESCRIPTION OF SPARSE PATTERNS
C     IJOB(7)           SOLUTION OUTPUT
C                       =0: NO OUTPUT
C                       =1: INITIAL VALUES AND SOLUTION VALUES
C                       =2: ADDITIONALLY SOLUTION VALUES AT INTERMEDIATE
C                           POINTS CHOSEN BY LIMEXS
C    NRW                DIMENSION OF REAL WORK-SPACE,
C                       TO BE CHOSEN .GE. :
C
C                       2.3*LDIM+N+(JM+9)*N+2*NZV+NZC+2*JM*JM+JM
C
C                         JM  = 5                  , IF IJOB(1).EQ.0
C                             = 7                  , IF IJOB(1).EQ.1
C
C    RW                 REAL WORK-SPACE
C    NIW                DIMENSION OF INTEGER WORK-SPACE,
C                       TO BE CHOSEN .GE. :
C
C                       3.3*LDIMQ+2*LDIM+14*N+3*(NZV+NZC)+2*JM+KM+2
C
C                         LDIMQ = DIMENSION OF MERGED PATTERN (BC+BV+A)
C                         KM  = JM-1
C
C    IW                 INTEGER WORK-SPACE
C
C ==================================================================
C ===  NOTE 1 : EXAMPLE FOR SPARSE MODE STORAGE SCHEME FOR BC/BV ===
C ==================================================================
C
C                   CONSIDER THE FOLLOWING CASE:
C
C                               |0     0    0  |
C                    B(T,Y)=    |1     1    0  |
C                               |T+1  -T   Y(2)|
C
C    WITH NZV=3 AND NZC=2 STORAGE OF BV AND BC IS DONE BY THE FOLLOWING
C    LINES:
C
C                   BV (1) = T+1.D0
C                   IRV(1) = 3
C                   ICV(1) = 1
C                   BV (2) = Y(2)
C                   IRV(2) = 3
C                   ICV(2) = 3
C                   BV (3) = -T
C                   IRV(3) = 3
C                   ICV(3) = 2
C            C
C                   BC (1) = 1.D0
C                   IRC(1) = 2
C                   ICC(1) = 1
C                   BC (2) = 1.D0
C                   IRC(2) = 2
C                   ICC(2) = 2
C
C        (THE ORDER OF THE ENTRIES IN BV AND BC IS ARBITRARY)
C
C
C ==================================================================
C ===  NOTE 2 : EXAMPLE FOR SPARSE MODE STORAGE SCHEME FOR JAC   ===
C ==================================================================
C
C                   CONSIDER THE FOLLOWING CASE:
C
C                               |Y(3)  0    C  |
C                    A(T,Y)=    | 0    0    0  |
C                               | 0   Y(2)  0  |
C
C    WITH LDIM=3 THE STORAGE OF A IS DONE BY THE FOLLOWING LINES:
C
C                   IA(1) = 1
C                   A (1) = Y(3)
C                   JA(1) = 1
C                   A (2) = C
C                   JA(2) = 3
C                   IA(2) = 3
C                   IA(3) = 3
C                   A (3) = Y(2)
C                   JA(3) = 2
C                   IA(4) = 4
C
C        (THE ORDER OF THE ENTRIES IN A,JA IS NOT ARBITRARY:
C         INDICES OF ONE ROW MUST BE IN INCREASING ORDER)
C
C
C ===========================================================
C
C
C  OUTPUT PARAMETERS:
C  ------------------
C
C    T                  ACTUAL FINAL POINT OF INTEGRATION
C    Y(N)               FINAL VALUES AT T
C    H                  STEPSIZE PROPOSAL FOR NEXT INTEGRATION STEP
C                       (H.EQ.0. ,IF LIMEXS FAILS TO PROCEED)
C    IJOB(6)    .GE. 0: SUCCESSFUL INTEGRATION
C                       (IJOB(6) NOT ALTERED INTERNALLY)
C               .LT. 0: ERROR CODE AFTER A FAIL RUN OF LIMEXS 
C                  =-1: MORE THAN JRMAX STEPSIZE REDUCTIONS
C                       OCCURRED PER BASIC INTEGRATION STEP
C                  =-2: MORE THAN NSTMAX BASIC INTEGRATION STEPS PER
C                       INTERVAL HAVE BEEN PERFORMED
C                  =-3: STEPSIZE PROPOSAL FOR NEXT BASIC INTEGRATION
C                       STEP WAS TOO SMALL
C                  =-4: MATRIX PENCIL B-H*A IS SINGULAR:
C                       NO OR INFINITELY MANY SOLUTIONS EXIST
C                  =-5: ITERATIVE REALIZATION OF DISCRETIZATION FAILED
C                       TO SUCCEED
C                  =-6: NILPOTENCY OF THE SYSTEM IS GREATER THAN
C                       ONE
C                  =-7: INITIAL VALUES ARE INCONSISTENT OR NILPOTENCY
C                       OF THE SYSTEM IS GREATER THAN ONE
C                  =-8: REAL OR INTEGER WORK-SPACE IS EXHAUSTED
C                  =-9: THE GIVEN PROBLEM IS AN ALGEBRAIC EQUATION
C                       (LIMEXS IS NOT SUITABLE IN THIS CASE)
C
C  OUTPUT AFTER A SUCCESSFULLY COMPLETED TASK ONLY:
C  ------------------------------------------------
C
C   IJOB(13)  =   NUMBER OF PERFORMED INTEGRATION STEPS
C   IJOB( 9)  =   NUMBER OF FUNCTION-EVALUATIONS (FOR INTEGRATION)
C   IJOB(12)  =   NUMBER OF JACOBIAN EVALUATIONS
C   IJOB(10)  =   NUMBER OF GAUSSIAN DECOMPOSITIONS
C   IJOB(11)  =   NUMBER OF FORWARD-BACKWARD-SUBSTITUTIONS
C   IJOB(14)  =   NUMBER OF ANALYSE/FACTOR DECOMPOSITIONS
C   IJOB(15)  =   NUMBER OF TEST-FACTOR DECOMPOSITIONS
C   IJOB(16)  =   NUMBER OF FACTOR DECOMPOSITIONS
C   IJOB(17)  =   NUMBER NONZEROS IN DECOMPOSITIONS
C   IJOB(18)  =   ESTIMATE FOR UNUSED REAL WORKSPACE
C   IJOB(19)  =   ESTIMATE FOR UNUSED INTEGER WORKSPACE
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
C  THE NUMERICAL SOLUTION OF THE ARISING LINEAR EQUATIONS IS DONE BY
C  MEANS OF THE SUBROUTINES MA30LA,MA30LM,MA30LB,MA30LC. THESE ROUTINES
C  ARE VARIANTS OF THE HARWELL ROUTINES MA30A,MA30B,MA30C WHICH WERE
C  MODIFIED FOR USE IN LARKIN.
C
C-----------------------------------------------------------------------
C         THIS IS A DRIVER ROUTINE FOR THE CORE-INTEGRATOR LIMESI
C-----------------------------------------------------------------------
C
      DOUBLE PRECISION Y(N),RW(NRW)
      INTEGER IW(NIW),IJOB(20)
C
      EXTERNAL LSC,FCN,JAC
C
      COMMON/LIMX1/LOUT
      COMMON/LIMX2/EPMACH,SMALL
      COMMON/LIMX3/NSTMAX,JRMAX,ISMAX
C
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C              INITIAL PREPARATIONS
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
C  OUTPUT UNIT FOR INTEGRATION MONITOR
C  -----------------------------------
C
      LOUT=6
C
C  RELATIVE MACHINE PRECISION
C  --------------------------
C
      EPMACH=1.D-16
C
C  SQUARE-ROOT OF SMALLEST POSITIVE MACHINE NUMBER
C  -----------------------------------------------
C
      SMALL=1.D-35
C
C  PRESCRIBED MAXIMUM ROW NUMBER OF EXTRAPOLATION-TABLEAU
C  -----------------------------------------------------
C
      JM=7
      IF(IJOB(1).EQ.1) GOTO 10
      JM=5
C
C  PRESCRIBED MAXIMUM COLUMN NUMBER OF EXTRAPOLATION-TABLEAU
C  --------------------------------------------------------
10    KM=JM-1
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  INTERNAL PARAMETERS
C  (STANDARD VALUES FIXED BELOW;
C   TO BE ALTERED, IF NECESSARY, BY THE SKILLFULL USER)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
C  MAXIMUM PERMITTED NUMBER OF BASIC INTEGRATION STEPS PER INTERVAL
C  ----------------------------------------------------------------
C
      NSTMAX=900
C
C  MAXIMUM PERMITTED NUMBER OF STEPSIZE REDUCTIONS PER BASIC STEP
C  --------------------------------------------------------------
C  (DUE TO EXTRAPOLATION-TABLEAU)
C
      JRMAX=20
C
C  MAXIMUM PERMITTED NUMBER OF STEPSIZE REDUCTIONS PER BASIC STEP
C  --------------------------------------------------------------
C  (DUE TO ZERO PIVOT IN GAUSSIAN DECOMPOSITION)
C
      ISMAX=5
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  CHECK FOR TYPE OF LEFT-HAND-SIDE
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
      IJOB(8)=0
      IF(NZV.GT.0.AND.NZC.GT.0) GOTO 30
      IF(NZV+NZC.EQ.0) GOTO 60
      IF(NZC.NE.0) GOTO 20
      NZC=1
      IJOB(8)=2
      GOTO 30
20    NZV=1
      IJOB(8)=1
C
C
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  BUILD-UP OF WORK-SPACE
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
C
30    CONTINUE     
C FOR INTEGRATOR
      MINRW0=(JM+9)*N+2*NZV+NZC+2*JM*JM+JM+JM*N+N
      MINIW0=2*JM+KM
C FOR SPARSE LINEAR ALGEBRA AND STRUCTURE
      MINRW=2*LDIM+N+MINRW0
      NIWH=3*NZC+3*NZV+9*N+2+2*LDIM
      MINIW=MINIW0+NIWH+LDIM
      IF(MINIW.GT.NIW.OR.MINRW.GT.NRW) GOTO 50
C
C  SET POINTERS
      LDIMH=NIW-MINIW0-NIWH
      NP1=N+1
      I1=1
      I2=I1+JM
      I3=I2+JM
      I4=I3+KM
      I5=I4+NZC
      I6=I5+NZC
      I7=I6+NZC
      I8=I7+NZV
      I9=I8+NZV
      I10=I9+NZV
      I11=I10+LDIM
      I12=I11+NP1
      I13=I12+LDIM
      I14=I13+LDIMH
      I15=I14+NP1
      I16=I15+N
      I17=I16+N
      I18=I17+N
      I19=I18+N
C
C GET STRUCTURE OF VARIABLE/CONSTANT LEFTHAND SIDE AND JACOBIAN OF RHS
C
      IFLAG=0
      IF(IJOB(8).NE.2) CALL LSC (NZC,RW(1),IW(I4),IW(I5),IFLAG)
      CALL FCN (N,NZV,T,Y,RW(1),RW(N+1),IW(I7),IW(I8),IFLAG)
      CALL JAC (N,LDIM,T,Y,RW(1),RW(N+1),IW(I10),IW(I11),IFLAG)
C
      INFOM=IJOB(6)-3
C
      CALL MERGE (N,LDIM,NZC,NZV,IW(I10),IW(I11),IW(I4),IW(I5),
     1            IW(I7),IW(I8),IW(I12),IW(I6),IW(I9),IW(I13),
     2            IW(I14),LDIMQ,IW(I15),IW(I16),IW(I17),IW(I18),
     3            IW(I19),LDIMH,NP1,IJOB(8),INFOM,LOUT)
C
      IF(INFOM.LT.0) GOTO 210
C
      NIWSH=12*N+2*LDIMQ
      NIWH=3*NZC+3*NZV+2*LDIM+2*NP1+LDIMQ
      MINIW=MINIW0+NIWH+NIWSH
      MINRW=MINRW0+LDIM+LDIMQ+N
      IF(MINIW.GT.NIW.OR.MINRW.GT.NRW) GOTO 50
C
      IH=I14-1
      I14=I13+LDIMQ
      I15=I14+NP1
      DO 43 I=1,NP1
      IW(I14+I-1)=IW(IH+I)
43    CONTINUE
      NIWS=NIW-MINIW0-NIWH
      NRWS=NRW-MINRW0-LDIM
      N1=1
      NJM=N*JM
      JMJM=JM*JM
C
      N2=N1+NRWS
      N3=N2+LDIM
      N4=N3+NZC
      N5=N4+NZV
      N6=N5+NZV
      N7=N6+NJM
      N8=N7+JMJM
      N9=N8+JMJM
      N10=N9+N
      N11=N10+N
      N12=N11+N
      N13=N12+N
      N14=N13+N
      N15=N14+N
      N16=N15+N
      N17=N16+N
      N18=N17+JM
      N19=N18+NJM
C
      IPRINT=1
      IF(IJOB(6).EQ.0) IPRINT=0
C
C     CALL OF CORE INTEGRATOR LIMESI
C     ------------------------------
C
      CALL LIMESI (N,LDIM,NRWS,NZC,NZV,JM,KM,LSC,FCN,JAC,T,Y,TEND,
     1             RTOL,YMAX0,HMAX,H,IJOB,NIWS,IW(I15),IW(I1),
     2             IW(I2),IW(I3),IW(I4),IW(I5),IW(I6),IW(I7),
     3             IW(I8),IW(I9),IW(I10),IW(I11),IW(I12),IW(I13),
     4             IW(I14),LDIMQ,RW(N1),RW(N2),RW(N3),RW(N4),RW(N5),
     5             RW(N6),RW(N7),RW(N8),RW(N9),RW(N10),RW(N11),RW(N12),
     6             RW(N13),RW(N14),RW(N15),RW(N16),RW(N17),RW(N18),
     7             RW(N19))
C
      IF(IJOB(8).EQ.2) NZC=0
      IF(IJOB(8).EQ.1) NZV=0
      IF(IJOB(6).LE.0) GOTO 1000
      IF(IJOB(6).GE.2) WRITE(LOUT,100) IJOB(13),IJOB(9),IJOB(12),
     1                               IJOB(10),IJOB(11)
      IF(IJOB(6).GE.2) WRITE(LOUT,105) LDIMQ,IJOB(17),IJOB(14),
     1                               IJOB(15),IJOB(16)
      NIWMIN=NIW-IJOB(19)
      NRWMIN=NRW-IJOB(18)
      IF(IJOB(6).GE.2) WRITE(LOUT,107) NRWMIN,NIWMIN
1000  IF(IJOB(6).LT.0.AND.IPRINT.EQ.0) WRITE(LOUT,110) IJOB(6)
      RETURN
C
C  FAIL EXIT  (WORK-SPACE EXHAUSTED)
C  ---------------------------------
50    CONTINUE
      ICODE=-8
      IF(IJOB(6).EQ.0) WRITE(LOUT,110) ICODE
      IF(IJOB(6).GT.0.AND.MINRW.GT.NRW) WRITE(LOUT,80) MINRW
      IF(IJOB(6).GT.0.AND.MINIW.GT.NIW) WRITE(LOUT,90) MINIW
      IJOB(6)=ICODE
      RETURN
60    ICODE=-9
      IF(IJOB(6).EQ.0) WRITE(LOUT,110) ICODE
      IF(IJOB(6).GT.0) WRITE(LOUT,120)
      IJOB(6)=ICODE
      RETURN
210   ICODE=-10
      IF(IJOB(6).EQ.0) WRITE(LOUT,110) ICODE
      IJOB(6)=ICODE
      RETURN
C
C ----------------------------------------------------------------------
C                  FORMAT-STATEMENTS
C ----------------------------------------------------------------------
C
80    FORMAT(1X,' *** ERROR *** :  REAL WORK-SPACE EXHAUSTED',/,
     1       1X,'                  ENLARGE AT LEAST TO:',I7,/)
90    FORMAT(1X,' *** ERROR *** :  INTEGER WORK-SPACE EXHAUSTED',/,
     1       1X,'                  ENLARGE AT LEAST TO:',I7,/)
100   FORMAT(/,1X,' **********  STATISTICS  **********',/,
     1         1X,' ****    STEPS     :',I6,'     ****',/,
     2         1X,' ****    F.-EV     :',I6,'     ****',/,
     3         1X,' ****    JAC.-EV.  :',I6,'     ****',/,
     4         1X,' ****    DECOMP.   :',I6,'     ****',/,
     5         1X,' ****    SUBST.    :',I6,'     ****',/,
     6         1X,' **********************************',/)
105   FORMAT(  1X,' **********************************',/,
     1         1X,' ****    NNZ(Q)    :',I6,'     ****',/,
     2         1X,' ****    NNZ(LU)   :',I6,'     ****',/,
     3         1X,' ****    A-FACTOR  :',I6,'     ****',/,
     4         1X,' ****    T-FACTOR  :',I6,'     ****',/,
     5         1X,' ****    FACTOR    :',I6,'     ****',/,
     6         1X,' **********************************',/)
107   FORMAT(  1X,' **********************************',/,
     1         1X,' ****    NRW-MIN   :',I6,'     ****',/,
     2         1X,' ****    NIW-MIN   :',I6,'     ****',/,
     3         1X,' **********************************',/)
110   FORMAT(/1X,' ### ERROR CODE FROM LIMEX :',I3,' ###',/)
120   FORMAT(/1X,'THE GIVEN PROBLEM IS AN ALGEBRAIC EQUATION, LIMEX IS N
     1OT SUITABLE',/)
C
C ----------------------------------------------------------------------
C  END OF DRIVER ROUTINE LIMEXS
C ----------------------------------------------------------------------
C
      END
      SUBROUTINE LIMESI(N,LDIM,NRWS,NZC,NZV,JM,KM,LSC,FCN,JAC,T,Y,TEND,
     1                  RTOL,YMAX0,HMAX,H,IJOB,NIWS,IWS,NJ,INCR,NRED,
     1                  IRC,ICC,ITC,IRV,ICV,ITV,JA,IA,ITA,JQ,IQ,LDIMQ,
     2                  RWS,A,BC,BV0,BVK,DT,D,AL,YM,DEL,
     3                  DZ,SM,ETA,W1,W2,W3,AJ,DTP,YP)
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
      DIMENSION Y(N),RWS(NRWS),A(LDIM),BC(NZC),BV0(NZV),BVK(NZV),
     1          DT(N,JM),D(JM,JM),AL(JM,JM),YM(N),
     2          DEL(N),DZ(N),SM(N),ETA(N),W1(N),W2(N),W3(N),AJ(JM),
     3          DTP(N,JM),YP(N)
C
      INTEGER NJ(JM),INCR(JM),NRED(KM),IJOB(20)
      INTEGER IRC(NZC),ICC(NZC),ITC(NZC),IRV(NZV),ICV(NZV),ITV(NZV)
      INTEGER IWS(NIWS),JA(LDIM),IA(*),ITA(LDIM),JQ(LDIMQ),IQ(*)
      INTEGER IDISP(2)
C
      LOGICAL LDIR,PRM1,PRM2
      LOGICAL QDM,QDMA,QMY
C
C
      LOGICAL BD1,BD2,BD3,BANFA
      EXTERNAL LSC,FCN,JAC
C
      COMMON/LIMX4/NSOL
      COMMON/LIMX1/LOUT
      COMMON/LIMX2/EPMACH,SMALL
      COMMON/LIMX3/NSTMAX,JRMAX,ISMAX
C
C
      COMMON / MA30LE / LP,BD1,BD2,BD3
      COMMON / MA30LF / IRNCP,ICNCP,IRANK,MINIRN,MINICN
      COMMON / MA30LG / DEPS,RATMIN
C
C
      DATA EPMIN/1.D-10/,ETADIF/1.D-6/,EX1/0.6D0/,EX2/1.5D0/,FMIN/1.D-2/
     1     ,FOUR/4.D0/,ONE/1.D0/,ONE1/1.01D0/,QUART/0.25D0/,RMIN/0.9D0/,
     2     RO/0.25D0/,SAFE/0.5D0/,SAFEIN/2.D-2/,TEN/1.D1/,
     3     THRSHM/1.D-1/,ZERO/0.D0/,HALF/.5D0/,TWO/2.D0/,SAFEDM/.8D0/
C
C ----------------------------------------------------------------------
C                        INITIAL PREPARATIONS
C ----------------------------------------------------------------------
C
      LDIR=.FALSE.
C
C
      JOB=0
      EPMACH=EPMACH*TEN
      EPDIFF=DSQRT(EPMACH)
      HMAX=DABS(HMAX)
      HMAXU=HMAX
      NSTEP=0
      NFCN=0
      NJAC=0
      NANFA=0
      NTFAC=0
      NFAC=0
      NSOL=0
      H1=TEND-T
      INIT=0
C
C  LP: SPARSE SOLVER MESSAGES
      LP=LOUT
      PRM1=.FALSE.
      PRM2=.FALSE.
      IF(IJOB(6).GE.3) PRM1=.TRUE.
      IF(IJOB(6).GE.4) PRM2=.TRUE.
C
C
C  PARAMETERS FOR SPARSE LINEAR EQUATION SOLVER
C
C  THRESHOLD VALUES FOR CONDITIONAL PIVOTING:
C  FOR ANALYSE/FACTOR
      THRESH=1.D-2
C
      IF(EPMACH.GT.1.D-10) THRESH=THRESH*5.D0
      IF(EPMACH.GT.1.D-5) THRESH=0.5D0
C
C  FOR WORTH PIVOT RATIO IN FACTOR
      TGROW=1.D-6
C
      IF(EPMACH.GT.1.D-12) TGROW=1.D-5
      IF(EPMACH.GT.1.D-8) TGROW=1.D-3
      IF(EPMACH.GT.1.D-5) TGROW=1.D-1
C
C
C
C  PREPARATIONS FOR SPARSE SOLVER
C
C
C  COUNT NONZEROS IN LU DECOMPOSITION
      NZAMAX=0
C
C  ELBOW ROOM FOR ARRAY IRN
      IELBO1=N
C  ELBOW ROOM FOR ARRAY ICN
      IELBO2=N
C  MINIMUM EXPECTED FILL-IN FACTOR
      XKAMIN=1.3D0
C  MINIMUM VALUE FOR UNBALANCED WORK SPACE (MESSAGE)
      NBAL=N
C
C  DIMENSION OF ARRAY IRN
      LIRN=LDIMQ+IELBO1
C  FREE SPACE OF ARRAY IWS FOR ARRAY ICN
      LICNI=NIWS-12*N-LIRN
C  FREE SPACE OF ARRAY RWS FOR ELEMENTS OF LU-DECOMPOSITION
      LICNR=NRWS-N
C  ACTUAL DIMENSION LICN
      LICN=LICNI
      IF(LICNR.LT.LICN) LICN=LICNR
C
C  CHECK FOR MINIMAL REQUIREMENTS
C
      LICNM1=DFLOAT(LDIMQ)*XKAMIN
      LICNM2=LDIMQ+IELBO2
      IF(LICN.GE.LICNM1.AND.LICN.GE.LICNM2) GOTO 333
C
      IF(IJOB(6).LE.0) GOTO 4770
      LICNDI=LICNM1-LICNI
      IF(LICNDI.GT.0) WRITE(LOUT,9331) LICNDI
      LICNDI=LICNM2-LICNI
      IF(LICNDI.GT.0) WRITE(LOUT,9331) LICNDI
      LICNDI=LICNM1-LICNR
      IF(LICNDI.GT.0) WRITE(LOUT,9332) LICNDI
      LICNDI=LICNM2-LICNR
      IF(LICNDI.GT.0) WRITE(LOUT,9332) LICNDI
9331  FORMAT(/,' NOT ENOUGH SPACE FOR LU-DECOMPOSITION',/,
     @  '     ENLARGE INTEGER WORK SPACE AT LEAST BY',I6,' ELEMENTS')
9332  FORMAT(/,' NOT ENOUGH SPACE FOR LU-DECOMPOSITION',/,
     @  '     ENLARGE REAL WORK SPACE AT LEAST BY',I6,' ELEMENTS')
      GOTO 4770
C
333   CONTINUE
C  CHECK BALANCE OF REAL AND INTEGER WORKSPACE
      NFRI=0
      NFRR=0
      NFREE=LICNI-LICNR
      IF(NFREE.GT.0) NFRI=NFREE
      IF(NFREE.GT.NBAL.AND.PRM1) WRITE(LOUT,9300) NFREE
      NFREE=LICNR-LICNI
      IF(NFREE.GT.0) NFRR=NFREE
      IF(NFREE.GT.NBAL.AND.PRM1) WRITE(LOUT,9305) NFREE
9300  FORMAT(/,41H REAL AND INTEGER WORK SPACE NOT BALANCED,/,
     @37H INTEGER WORK SPACE MAY BE REDUCED BY,I6,18H STORAGE LOCATIONS)
9305  FORMAT(/,41H REAL AND INTEGER WORK SPACE NOT BALANCED,/,
     @34H REAL WORK SPACE MAY BE REDUCED BY,I6,18H STORAGE LOCATIONS)
C
C  SET POINTERS FOR WORKSPACE
      IP1=1
      IP2=IP1+LICN
      IP3=IP2+LIRN
      IP4=IP3+N
      IP5=IP4+N
      IP6=IP5+N
      IP7=IP6+N
      IP8=IP7+N
      IP9=IP8+N
      IP10=IP9+N
      IP11=IP10+N
      IP12=IP11+N
      IP13=IP12+N
      IP14=IP13+N
C  FURTHER PREPARATIONS
      NP1=N+1
      IDISP(1)=1
      BANFA=.TRUE.
      DEPS=TWO
C
C
C
      IF(IJOB(8).EQ.2) GOTO 1000
      CALL LSC (NZC,BC,IRC,ICC,1)
C
C ----------------------------------------------------------------------
C                          INITIAL SCALING
C  (FOR REAL LIFE APPLICATIONS TO BE ALTERED BY THE SKILLFUL USER)
C ----------------------------------------------------------------------
C
1000  DO 1010 I=1,N
      U=DABS(Y(I))
      IF(U.LT.YMAX0) U=YMAX0
      SM(I)=U
1010  ETA(I)=ETADIF
C
C ----------------------------------------------------------------------
C           SET PARAMETERS FOR EXTRAPOLATION AND ORDER-CONTROL
C ----------------------------------------------------------------------
C
C  STEPSIZE SEQUENCE FOR EULSIM
C  ----------------------------
C
      DO 1020 J=1,JM
1020  NJ(J)=J
C
      DO 1030 I=1,N
      YP(I)=EPMACH
      DO 1030 J=1,JM
      DT(I,J)=0.D0
      DTP(I,J)=0.D0
1030  CONTINUE
C
      FN=DFLOAT(N)
      FJ1=DFLOAT(NJ(1))
      EPH=RO*RTOL
C
C  FOR MY-ESTIMATE
      EPKAP=0.03D0
      CMYRED=FJ1*HALF
      CMYMAX=FJ1*0.9D0
      TOLN=RTOL*RTOL*FN
      CMYH=ZERO
      DELT0=ZERO
C
      AJ(1)=FJ1
      DO 1060 J=2,JM
      J1=J-1
      INCR(J1)=0
      NRED(J1)=0
      FJ=DFLOAT(NJ(J))
      V=AJ(J1)+FJ-ONE
      AJ(J)=V
      DO 1040 K=1,J1
      W=FJ/DFLOAT(NJ(K))
1040  D(J,K)=W
      IF(J.EQ.2) GOTO 1060
      W=V-FJ1
      DO 1050 K1=2,J1
      K=K1-1
      U=(AJ(K1)-V)/(W*DFLOAT(K1))
      U=EPH**U
1050  AL(J1,K)=U
1060  CONTINUE
C
C  EVALUATION OF COST COEFFICIENTS
C  -------------------------------
      COSTF=ONE
      COSTJ=10.D0*COSTF
      COSTS=ZERO
      COSTLR=ZERO
C
      COSTQ=ONE/QUART
      COSTQ=3.D0
      IF(COSTLR.GT.ZERO .AND. COSTS.GT.ZERO) COSTQ=COSTLR/COSTS
C
      IF((COSTS+COSTLR+COSTJ).EQ.ZERO) GOTO 1080
      AJ(1)=COSTJ+COSTLR+(COSTF+COSTS)*FJ1
      DO 1070 J=2,JM
      J1=J-1
1070  AJ(J)=AJ(J1)+(COSTF+COSTS)*(DFLOAT(NJ(J))-ONE)+COSTS+COSTLR
1080  KOH=1
      JOH=2
1090  CONTINUE
      IF(JOH.GE.JM) GOTO 1100
      IF(AJ(JOH+1)*ONE1.GT.AJ(JOH)*AL(JOH,KOH)) GOTO 1100
      KOH=JOH
      JOH=JOH+1
      GOTO 1090
1100  K=0
      KM=KOH
      JMH=JOH
      INCR(JMH)=-1
      OMJO=ZERO
      IF(IJOB(6).GT.0) WRITE(LOUT,9010) RTOL,YMAX0,KM
      IF(IJOB(7).GE.1) WRITE(LOUT,9160) (Y(I),I=1,N)
      IF(IJOB(6).GE.3) WRITE(LOUT,9020)
      IF(IJOB(6).EQ.2) WRITE(LOUT,9030)
C
C ----------------------------------------------------------------------
C                        BASIC INTEGRATION STEP
C ----------------------------------------------------------------------
C
2000  CONTINUE
      IF(DABS(H1).LE.DABS(T)*EPMACH*TEN) GOTO 4600
      IF(DABS(H1).LE.EPMACH*DABS(H)) GO TO 4600
      IF(IJOB(6).EQ.2) WRITE(LOUT,9110) NSTEP,T
      IF(IJOB(6).GE.3) WRITE(LOUT,9100) NSTEP,NFCN,T,H,K,KOH
      IF(IJOB(7).EQ.2.AND.NSTEP.GT.0) WRITE(LOUT,9000) (Y(I),I=1,N)
      IF(DABS(H1).GE.ONE1*DABS(H)) GO TO 2010
      HR=H
      H=H1
2010  JRED=0
      NSTC=0
      ISING=0
      IT=0
      DMH=SAFEDM
      DO 2020 K=1,KM
2020  INCR(K)=INCR(K)+1
      HMAX=DABS(H1)
      IF(HMAXU.LT.HMAX) HMAX=HMAXU
      CALL RESLIS (N,NZV,T,Y,DZ,YM,BV0,IRV,ICV,YP,FCN,IJOB,1)
      NFCN=NFCN+1
C
C
C ----------------------------------------------------------------------
C                     ANALYTIC EXPRESSION OF JACOBIAN
C ----------------------------------------------------------------------
C
C  SUBROUTINE JAC SHOULD PROVIDE JACOBIAN MATRIX OF RESIDUAL A=DR/DY
C  LIMEX USES INTERNALLY THE MATRIX A=-DR/DY (SCALED)
C
      CALL JAC (N,LDIM,T,Y,YP,A,JA,IA,1)
      NJAC=NJAC+1
C
C  SCALING OF THE SYSTEM OF LINEAR EQUATIONS
      IMAX=0
      DO 2151 I=1,N
      SHI=ONE/SM(I)
      IMIN=IMAX+1
      IMAX=IA(I+1)-1
      IF(IMAX.LT.IMIN) GOTO 2151
      DO 2150 L=IMIN,IMAX
      IH=JA(L)
2150  A(L)=-SM(IH)*A(L)*SHI
2151  CONTINUE
C
C
C
C ----------------------------------------------------------------------
C                     DISCRETIZATION
C ----------------------------------------------------------------------
C
2170  DO 2180 K=1,N
2180  DZ(K)=DZ(K)/SM(K)
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  INITIAL STEPSIZE GUESS, IF H=ZERO
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
      IF(INIT.GT.0.OR.H.NE.ZERO) GOTO 2500
      ANORM1=ZERO
      IMAX=0
      DO 2200 I=1,N
      IMIN=IMAX+1
      IMAX=IA(I+1)-1
      ROW=ZERO
      IF(IMAX.LT.IMIN) GOTO 2200
      DO 2190 L=IMIN,IMAX
      IH=JA(L)
2190  ROW=DABS(A(L))+ROW
2200  IF(ROW.GT.ANORM1) ANORM1=ROW
      IF(ANORM1.EQ.ZERO) ANORM1=ONE
      H=SAFEIN/ANORM1
      IF(H.GT.H1)H=H1
      INIT=1
C
2500  TN=T+H
      LDIR=.FALSE.
      IF(COSTQ.LE.ZERO) LDIR=.TRUE.
      FCM=DABS(H)/HMAX
      IF(FCM.LT.FMIN) FCM=FMIN
      DM=DMH*TWO
      IF(IJOB(6).GE.5) WRITE(LOUT,9415)
      QMY=.FALSE.
      QDM=.FALSE.
      FCMY=FCM
C
      DO 3000 J=1,JMH
      IEST=0
      IF(J.EQ.2) IEST=1
      M=NJ(J)
      G=H/DFLOAT(M)
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  SEMI-IMPLICIT EULER STARTING STEP
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
      DO 3070 I=1,N
      YM(I)=Y(I)
3070  DEL(I)=G*DZ(I)
C
      IFAIL=0
C
C  SPARSE LU-DECOMPOSION OF (I/G - A)
C
      IF(.NOT.BANFA) GOTO 2750
C
C  ANALYSE/FACTOR SPARSE MATRIX
      IDISP2=LICN-LDIMQ
      IDISP(2)=IDISP2+1
      IMAX=0
      DO 2610 I=1,N
      IMIN=IMAX+1
      IMAX=IQ(I+1)
C  SET ROW LENGTHS
      IWS(IP3+I-1)=IMAX-IMIN
      IMAX=IMAX-1
C  SET PERMUTATION TO IDENTITY
      IWS(IP5+I-1)=I
      IWS(IP6+I-1)=I
C  SET COLUMN INDICES
      DO 2600 II=IMIN,IMAX
      IH=IDISP2+II
      IWS(IH)=JQ(II)
2600  CONTINUE
2610  CONTINUE
C
C  SET VALUES
      DO 2615 L=1,LDIMQ
      RWS(IDISP2+L)=ZERO
2615  CONTINUE
      DO 2620 L=1,LDIM
      RWS(IDISP2+ITA(L))=RWS(IDISP2+ITA(L))+G*A(L)
2620  CONTINUE
      IF(IJOB(8).EQ.1) GOTO 3040
      DO 3030 I=1,NZV
      RWS(IDISP2+ITV(I))=RWS(IDISP2+ITV(I))
     1                 +SM(ICV(I))*BV0(I)/SM(IRV(I))
3030  CONTINUE
3040  IF(IJOB(8).EQ.2) GOTO 3060
      DO 3050 I=1,NZC
      RWS(IDISP2+ITC(I))=RWS(IDISP2+ITC(I))+SM(ICC(I))*BC(I)/SM(IRC(I))
3050  CONTINUE
3060  CONTINUE
      IDISP2=IDISP2+1
C
C
      CALL MA30LA (N,IWS(IP1),RWS(IP1),LICN,IWS(IP3),IWS(IP4),IDISP,
     @  IWS(IP5),IWS(IP6),IWS(IP2),LIRN,IWS(IP7),IWS(IP8),IWS(IP9),
     @  IWS(IP10),IWS(IP11),IWS(IP12),IWS(IP13),IWS(IP14),THRESH,IFAIL)
      NANFA=NANFA+1
C
C
C  EMERGENCY EXIT FOR SINGULAR MATRIX AND ARRAY OVERFLOW
      IF(IFAIL.LT.0.AND.IJOB(6).GE.1) WRITE(LOUT,9333) IFAIL
9333  FORMAT(/,' LU-DECOMPOSITION (MA30LA) FAILED, ERROR CODE =',I3)
      IF(IFAIL.LT.0) GOTO 4100
C
      IELB2=LICN-IDISP(2)
C
C  COMPUTE MAPPING
      CALL MA30LM (N,NP1,IDISP(2),IWS(IP1),IQ,JQ,LDIMQ,IWS(IP2),
     @            IWS(IP3),IWS(IP5),IWS(IP6),IWS(IP13))
C
      IDISP2=IDISP(2)
      IF(IDISP2.GT.NZAMAX) NZAMAX=IDISP2
C
      BANFA=.FALSE.
      GOTO 2900
C
C  FACTOR SPARSE MATRIX
2750  CONTINUE
      IFAIL=0
C
C  SET VALUES
      DO 2755 I=1,IDISP2
2755  RWS(I)=ZERO
      DO 2780 L=1,LDIM
      RWS(IWS(LICN+ITA(L)))=RWS(IWS(LICN+ITA(L)))+G*A(L)
2780  CONTINUE
      IF(IJOB(8).EQ.1) GOTO 3041
      DO 3031 I=1,NZV
      RWS(IWS(LICN+ITV(I)))=RWS(IWS(LICN+ITV(I)))
     1                 +SM(ICV(I))*BV0(I)/SM(IRV(I))
3031  CONTINUE
3041  IF(IJOB(8).EQ.2) GOTO 3061
      DO 3051 I=1,NZC
      RWS(IWS(LICN+ITC(I)))=RWS(IWS(LICN+ITC(I)))
     1                  +SM(ICC(I))*BC(I)/SM(IRC(I))
3051  CONTINUE
3061  CONTINUE
      IF(J.EQ.1) DEPS=HALF
C
C
      CALL MA30LB (N,IWS(IP1),RWS(IP1),LICN,IWS(IP3),IWS(IP4),IDISP,
     @     IWS(IP5),IWS(IP6),RWS(IP2),IWS(IP13),IFAIL)
      IF(DEPS.NE.TWO) NTFAC=NTFAC+1
      IF(DEPS.EQ.TWO) NFAC=NFAC+1
C
C
      DEPS=TWO
C
C  MATRIX SINGULAR
      IF(IFAIL.LT.0) GOTO 2790
C
C  CHECK PIVOT RATIO (FOR J.EQ.1)
      IF(J.NE.1.OR.RATMIN.GE.TGROW) GOTO 2800
C
C  NEW ANALYSE/FACTOR NECESSARY (RESTART STEP)
2790  BANFA=.TRUE.
      GOTO 2500
2800  CONTINUE
C
C  SOLUTION OF LINEAR SYSTEM (I/G - A)*DEL = DEL
2900  CONTINUE
C
C
      CALL MA30LC (N,IWS(IP1),RWS(IP1),LICN,IWS(IP3),IWS(IP4),IDISP,
     @            IWS(IP5),IWS(IP6),DEL,RWS(IP2))
      NSOL=NSOL+1
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  COMPUTATIONAL ESTIMATION OF ONE-SIDED LIPSCHITZ CONSTANT
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
      DMY=ZERO
      DO 3080 I=1,N
 3080 DMY=DMY+DEL(I)*DEL(I)
C
      DELT0A=DELT0
      DELT0=DSQRT(DMY)
      QDMA=QDM
      QDM=(DMY.GE.TOLN)
      IF(J.NE.2) GOTO 3095
      IF(.NOT.QDMA) GOTO 3095
      CKAP=DELT0/DELT0A
      CKQ=DFLOAT(NJ(J-1))/DFLOAT(NJ(J))
      C=ONE-CKAP
      IF(C.LE.EPKAP) GOTO 3090
      CMYH=DFLOAT(NJ(J))*(CKQ-CKAP)/C
      CMY=CMYH/H
      FCMY=CMYH/CMYRED
      QMY=.TRUE.
3090  CONTINUE
      IF (.NOT.QMY.OR.(CMYH.LT.CMYMAX)) GOTO 3095
      RED=CMYRED/CMYH
      IF (IJOB(6).GT.2) WRITE(LOUT,9091) CMYH
9091  FORMAT(1X,'CMYH TOO LARGE; CMYH =',D15.4)
      GOTO  4001
3095  CONTINUE
C
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C       CHECK FOR SYSTEMS WITH NILPOTENCY GREATER THAN ONE
C       AND/OR INCONSISTENT INITIAL VALUES
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
      IF(IJOB(1).EQ.1.OR.J.GT.2.OR.NSTEP.GT.2) GOTO 3140
      IF(J.GT.1) GOTO 3110
      DELM=ZERO
      DO 3100 I=1,N
      W3(I)=DABS(DEL(I))
3100  IF(W3(I).GT.DELM)DELM=W3(I)
      GOTO 3140
3110  DO 3120 I=1,N
      IF(DEL(I).EQ.ZERO) GOTO 3120
      IF(DABS(DEL(I)).LT.SMALL) GOTO 3120
      W3(I)=W3(I)/DABS(DEL(I))
      IF(DABS(W3(I)).GT.EX2) GOTO 3120
      IF(IJOB(6).GT.2.AND.NSTEP.EQ.0.AND.JRED.EQ.0) WRITE(LOUT,9140)I
      IF(W3(I)*DABS(DEL(I)).GT.DELM*THRSHM.AND.JRED.GT.2) GOTO 3130
3120  CONTINUE
      GOTO 3140
3130  IF(W3(I).LT.EX1) GOTO 4750
      GOTO 4760
C
3140  CONTINUE
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  SEMI-IMPLICIT EULER DISCRETIZATION (ITERATIVE REALISATION)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
      DO 3150  I=1,N
3150  YM(I)=YM(I)+DEL(I)*SM(I)
      IF(M.EQ.1) GOTO 3300
      M=M-1
C
C
      DO 3299 K=1,M
      TH=T+DFLOAT(K)*G
3155  CALL FCN (N,NZV,TH,YM,DEL,BVK,IRV,ICV,1)
      NFCN=NFCN+1
      IF(K.GT.1.OR.LDIR) GOTO 3170
      DIFFB=ZERO
      IF(IJOB(8).EQ.1) GOTO 3170
      DO 3160 I=1,NZV
      IR=IRV(I)
      IC=ICV(I)
      DIFF=BVK(I)-BV0(I)
      DIFFB=DIFFB+DIFF*DIFF*SM(IC)*SM(IC)/SM(IR)/SM(IR)
3160  CONTINUE
      DIFFB=DSQRT(DIFFB/DFLOAT(NZV))
      DIFFB=DFLOAT(M)*DIFFB
3170  DO 3180 I=1,N
3180  DEL(I)=G*DEL(I)/SM(I)
C
      IF(LDIR) GOTO 3200
C
      CALL MA30LC (N,IWS(IP1),RWS(IP1),LICN,IWS(IP3),IWS(IP4),IDISP,
     @            IWS(IP5),IWS(IP6),DEL,RWS(IP2))
      NSOL=NSOL+1
C
      IF(IJOB(8).NE.1.AND.DIFFB.GT.RTOL*1.D-2) GOTO 3184
      GOTO 3290
3184  ITFAIL=0
      DO 3188 I=1,N
3188  W1(I)=DEL(I)
      CALL ITERS (N,NZV,KOH,BV0,BVK,DEL,SM,W1,
     1             W2,IJOB,IRV,ICV,RTOL,ITFAIL,
     2             THETA,DELTA,IEST,FNH,ITER,COSTQ,
     3 IWS,RWS,NIWS,NRWS,LICN,IDISP,IP1,IP2,IP3,IP4,IP5,IP6)
C
      IEST=0
      IF(IJOB(6).GE.5) WRITE(LOUT,9421) K,ITER,ITFAIL,THETA,DELTA
C
      IF(ITFAIL.GE.1) LDIR=.TRUE.
      IF(ITFAIL.GT.1) GOTO 3155
      GOTO 3290
C
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  SEMI-IMPLICIT EULER DISCRETIZATION (DIRECT REALISATION)
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
3200  CONTINUE
C
C  FACTOR SPARSE MATRIX
C
C  SET VALUES
      DO 3210 I=1,IDISP2
3210  RWS(I)=ZERO
      DO 3212 L=1,LDIM
      RWS(IWS(LICN+ITA(L)))=RWS(IWS(LICN+ITA(L)))+G*A(L)
3212  CONTINUE
      IF(IJOB(8).EQ.1) GOTO 3216
      DO 3214 I=1,NZV
      RWS(IWS(LICN+ITV(I)))=RWS(IWS(LICN+ITV(I)))
     1                 +SM(ICV(I))*BVK(I)/SM(IRV(I))
3214  CONTINUE
3216  IF(IJOB(8).EQ.2) GOTO 3220
      DO 3218 I=1,NZC
      RWS(IWS(LICN+ITC(I)))=RWS(IWS(LICN+ITC(I)))
     1                  +SM(ICC(I))*BC(I)/SM(IRC(I))
3218  CONTINUE
3220  CONTINUE
      IF(J.EQ.1) DEPS=HALF
      IFAIL=0
C
C
      CALL MA30LB (N,IWS(IP1),RWS(IP1),LICN,IWS(IP3),IWS(IP4),IDISP,
     @     IWS(IP5),IWS(IP6),RWS(IP2),IWS(IP13),IFAIL)
      IF(DEPS.NE.TWO) NTFAC=NTFAC+1
      IF(DEPS.EQ.TWO) NFAC=NFAC+1
C
C
      DEPS=TWO
C
C  MATRIX SINGULAR
      IF(IFAIL.LT.0) GOTO 3240
C
C  CHECK PIVOT RATIO (FOR J.EQ.1)
      IF(J.NE.1.OR.RATMIN.GE.TGROW) GOTO 3250
C
C  NEW ANALYSE/FACTOR NECESSARY (RESTART STEP)
3240  BANFA=.TRUE.
      GOTO 2500
3250  CONTINUE
C
      IF(IJOB(6).GE.5) WRITE(LOUT,9429) K,IFAIL
C
      CALL MA30LC (N,IWS(IP1),RWS(IP1),LICN,IWS(IP3),IWS(IP4),IDISP,
     @            IWS(IP5),IWS(IP6),DEL,RWS(IP2))
      NSOL=NSOL+1
C
C
3290  CONTINUE
      IEST=0
      DO 3295 I=1,N
3295  YM(I)=YM(I)+DEL(I)*SM(I)
3299  CONTINUE
C
C ----------------------------------------------------------------------
C                           EXTRAPOLATION
C ----------------------------------------------------------------------
C
3300  ERR=ZERO
      DO 33201 I=1,N
      C=DEL(I)*SM(I)/G
      V=DTP(I,1)
      DTP(I,1)=C
      IF(J.EQ.1) GOTO 33201
      TA=C
      DO 33101 K=2,J
      JK=J-K+1
      B1=D(J,JK)
      W=C-V
      U=W/(B1-ONE)
      C=B1*U
      V=DTP(I,K)
      DTP(I,K)=U
33101 TA=U+TA
      YP(I)=TA
33201 CONTINUE
C
3301  CONTINUE
      DO 3320 I=1,N
      C=YM(I)
      V=DT(I,1)
      DT(I,1)=C
      IF(J.EQ.1) GOTO 3320
      TA=C
      DO 3310 K=2,J
      JK=J-K+1
      B1=D(J,JK)
      W=C-V
      U=W/(B1-ONE)
      C=B1*U
      V=DT(I,K)
      DT(I,K)=U
3310  TA=U+TA
      YM(I)=TA
      TA=DABS(TA)
      IF(TA.LT.SM(I)) TA=SM(I)
      U=U/TA
      ERR=ERR+U*U
3320  CONTINUE
      IF(J.EQ.1) GOTO 3000
C
C ERROR (SCALED ROOT MEAN SQUARE)
C -------------------------------
C
      ERR=DSQRT(ERR/FN)
      KONV=0
      IF(ERR.LE.RTOL) KONV=1
      ERR=ERR/EPH
C
C ----------------------------------------------------------------------
C                            ORDER CONTROL
C ----------------------------------------------------------------------
C
      K=J-1
      ROOT=ONE/DFLOAT(J)
      FC=ERR**ROOT
      IF(FC.LT.FCM) FC=FCM
      IF(FC.LT.FCMY) FC=FCMY
C
C  OPTIMAL ORDER DETERMINATION
C  ---------------------------
C
      OMJ=FC*AJ(J)
      IF(J.GT.2.AND.OMJ*ONE1.GT.OMJO.OR.K.GT.JOH) GOTO 3340
      KO=K
      JO=J
      OMJO=OMJ
      FCO=FC
3340  CONTINUE
      IF(J.LT.KOH.AND.NSTEP.GT.0) GOTO 3000
      IF(KONV.EQ.0) GOTO 3360
      IF(KO.LT.K.OR.INCR(J).LT.0) GOTO 4500
      IF(QMY.AND.CMYH.GT.CMYRED) GOTO 4500
C
C  POSSIBLE INCREASE OF ORDER
C  --------------------------
C
      IF(NRED(KO).GT.0) NRED(KO)=NRED(KO)-1
      FC=FCO/AL(J,K)
      IF(FC.LT.FCM) FC=FCM
      IF(FC.LT.FCMY) FC=FCMY
      J1=J+1
      IF(AJ(J1)*FC*ONE1.GT.OMJO) GOTO 4500
      FCO=FC
      KO=JO
      JO=JO+1
      GOTO 4500
C
C ----------------------------------------------------------------------
C                            CONVERGENCE MONITOR
C ----------------------------------------------------------------------
C
3360  RED=ONE/FCO
      JK=KM
      IF(JOH.LT.KM) JK=JOH
      IF(K.GE.JK) GOTO 4000
      IF(KO.LT.KOH) RED=AL(KOH,KO)*RED
      IF(AL(JK,KO).LT.FCO) GOTO 4000
3000  CONTINUE
C
C  STEPSIZE REDUCTION (DUE TO EXTRAPOLATION TABLEAU)
C --------------------------------------------------
C
4000  RED=RED*SAFE
4001  IF(RED.GE.RMIN) RED=RMIN
      H=H*RED
4010  CONTINUE
      IF(NSTEP.EQ.0) GOTO 4020
      NRED(KOH)=NRED(KOH)+1
      INCR(KOH)=-2
4020  JRED=JRED+1
      IF(IJOB(6).GT.2) WRITE(LOUT,9080) JRED,RED
      IF(JRED.GT.JRMAX) GOTO 4700
      GOTO 2500
C
C  STEPSIZE REDUCTION (EMPIRICAL DEVICE)
C  -------------------------------------
C
4100  IF(IFAIL.GE.-2.AND.IJOB(1).EQ.0) ISING=ISING+1
      IF(ISING.GT.ISMAX) GOTO 4730
      IF(NSTEP.EQ.0.AND.JRED.GT.2.AND.NSTC.GT.2) GOTO 4760
      HMAX=G*FJ1*QUART
      IF(IFAIL.GE.-2) HMAX=HMAX*SAFE
      RED=HMAX/DABS(H)
      H=HMAX
      IF(IFAIL.LE.-3) GOTO 4150
      IF(JRED.GT.0.OR.IT.GT.0)GOTO 4020
      GOTO 4010
4150  IF(IJOB(6).LE.0) GOTO 4770
      IF(IFAIL.EQ.-3) WRITE(LOUT,9321)
9321  FORMAT(1X,' WORKSPACE PROBLEM IN MA30LA, PROBABLE REASON:',/,
     *       1X,' DEFINED VALUE OF IELBO1 TOO SMALL',/)
      IF(IFAIL.LE.-4) WRITE(LOUT,9322)
9322  FORMAT(1X,' WORKSPACE PROBLEM IN MA30LA, PROBABLE REASON:',/,
     *       1X,' REAL AND/OR INTEGER WORKSPACE TOO SMALL',/)
      GOTO 4770
C
C ----------------------------------------------------------------------
C              PREPARATIONS FOR NEXT BASIC INTEGRATION STEP
C ----------------------------------------------------------------------
C
4500  TOLD=T
      T=TN
      H1=TEND-T
      DO 4510 I=1,N
      TA=YM(I)
      Y(I)=TA
C
C  RESCALING
C  ---------
C
      TA=DABS(TA)
      IF(TA.LT.SM(I)) GOTO 4510
      SM(I)=TA
4510  CONTINUE
      NSTEP=NSTEP+1
      IF(NSTEP.GT.NSTMAX) GO TO 4710
C
C
C STEPSIZE PREDICTION
C -------------------
C
      H=H/FCO
      KOH=KO
      JOH=KOH+1
      IF(DABS(H).GT.DABS(T)*EPMACH*TEN) GO TO 2000
      GO TO 4720
C
C ----------------------------------------------------------------------
C                             SOLUTION EXIT
C ----------------------------------------------------------------------
C
4600  H=HR
      HMAX=HMAXU
      IJOB(13)=NSTEP
      IJOB(9)=NFCN
      IJOB(10)=NANFA+NTFAC+NFAC
      IJOB(11)=NSOL
      IJOB(12)=NJAC
      IJOB(14)=NANFA
      IJOB(15)=NTFAC
      IJOB(16)=NFAC
      IJOB(17)=NZAMAX
      IF(IJOB(6).GE.3) WRITE(LOUT,9100) NSTEP,NFCN,T,H,K,KO
      IF(IJOB(6).EQ.2) WRITE(LOUT,9110) NSTEP,T
      IF(IJOB(7).GT.0) WRITE(LOUT,9150) T,(Y(I),I=1,N)
C
C  CHECK FOR POSSIBLE REDUCTION OF WORK SPACE
      XKAACT=DFLOAT(NZAMAX)/DFLOAT(LDIMQ)
      IF(XKAACT.LT.XKAMIN*0.9D0.AND.PRM2)
     1            WRITE(LOUT,9308) XKAMIN,XKAACT
9308  FORMAT(/,' ACTUAL FILL-IN FACTOR LESS THAN IMPLEMENTED MINIMAL',
     1   ' EXPECTED',/,' XKAMIN MAY BE REDUCED FROM ',F6.2,' TO',F6.2)
      IF(IRNCP.GT.10.AND.PRM1) WRITE(LOUT,9309)
9309  FORMAT(/,' INCREASE IMPLEMENTED VALUE FOR IELBO1 TO SPEED UP',
     1       /,' LINEAR ALGEBRA')
      IF(ICNCP.GT.10.AND.PRM1) WRITE(LOUT,9310)
9310  FORMAT(/,47H REAL AND INTEGER WORK SPACE MAY BE ENLARGED TO,
     @24H SPEED UP LINEAR ALGEBRA)
      IF(ICNCP.GT.3) GOTO 1000
C POSSIBLE REDUCTION OF WORKSPACE
      NFREE=LICN-NZAMAX
      NFREEH=LICN-DFLOAT(LDIMQ)*XKAMIN
      IF(NFREE.GT.NFREEH) NFREE=NFREEH
      NFREEH=LICN-(MINICN*12)/10
      IF(NFREE.GT.NFREEH) NFREE=NFREEH
      NFREE=(NFREE*9)/10
      IF(NFREE.LE.10) GOTO 4650
      IF(PRM2) WRITE(LOUT,9320) NFREE
9320  FORMAT(/,46H REAL AND INTEGER WORK SPACE MAY BE REDUCED BY,I6,
     @18H STORAGE LOCATIONS)
C
C
4650  CONTINUE
      IJOB(19)=NFREE+NFRI-1
      IJOB(18)=NFREE+NFRR-1
      RETURN
C
C ----------------------------------------------------------------------
C                               FAIL EXIT
C ----------------------------------------------------------------------
C
4700  CONTINUE
      IF(IJOB(6).GT.0) WRITE(LOUT,9120)JRMAX
      IJOB(6)=-1
      GOTO 4800
4710  CONTINUE
      IF(IJOB(6).GT.0) WRITE(LOUT,9090) NSTMAX
      IJOB(6)=-2
      GOTO 4800
4720  CONTINUE
      IF(IJOB(6).GT.0) WRITE(LOUT,9060)
      IJOB(6)=-3
      GOTO 4800
4730  CONTINUE
      IF(IJOB(6).GT.0) WRITE(LOUT,9070)
      IJOB(6)=-4
      GOTO 4800
4750  CONTINUE
      IF(IJOB(6).GT.0) WRITE(LOUT,9050)
      IJOB(6)=-6
      GOTO 4800
4760  CONTINUE
      IF(IJOB(6).GT.0) WRITE(LOUT,9130)
      IJOB(6)=-7
      GOTO 4800
4770  CONTINUE
      IJOB(6)=-8
4800  H=ZERO
      HMAX=HMAXU
      RETURN
C
C ----------------------------------------------------------------------
C                  FORMAT-STATEMENTS
C ----------------------------------------------------------------------
C
9000  FORMAT(/,1X,' --- CURRENT VALUES --- ',/(1X,4D18.9),/)
9010  FORMAT(/,1X,' ----------------------------------------------------
     1------------------',/,
     2       1X,' -LIMEX- :  REL.PREC. ',D10.3,'   THRESHOLD ',D10.3,'
     3 MAX. COL. ',I3,/,
     4'  ---------------------------------------------------------------
     5-------',/)
9020  FORMAT(/,3X,'STEP',3X,'  F-CALLS',10X,'T',14X,'H',10X,
     *'USED/AIMED COLUMN',/)
9030  FORMAT(/,5X,'STEP',8X,'T')
9050  FORMAT(1X,' PROBLEM NOT SOLVABLE WITH LIMEX, PROBABLE REASON:',/1X
     *,' NILPOTENCY OF THE SYSTEM GREATER THAN ONE',/)
9060  FORMAT(/1X,' STEPSIZE REDUCTION FAILED TO SUCCEED '//)
9070  FORMAT(/1X,' THE MATRIX-PENCIL B-H*A IS SINGULAR, THE SYSTEM IS NO
     *T SOLVABLE',/)
9080  FORMAT(/1X,I3,'.REDUCTION, STEPSIZE REDUCTION FACTOR ',D10.3)
9090  FORMAT(1X,' MORE THAN NSTMAX=',I3,' INTEGRATION STEPS'//)
9100  FORMAT(/1X,I5,2X,I9,3X,D15.5,2X,D15.5,I9,I9)
9110  FORMAT(/1X,I7,2X,D15.5)
9120  FORMAT(1X,' MORE THAN JRMAX=',I3,' STEPSIZE REDUCTIONS DUE TO EXTR
     *APOLATION TABLEAU')
9130  FORMAT(1X,' PROBLEM NOT SOLVABLE WITH LIMEX, PROBABLE REASON:',/1X
     *,' INITIAL DATA INCONSISTENT OR NILPOTENCY OF THE SYSTEM GREATER T
     *HAN ONE',/)
9140  FORMAT(1X,' *** WARNING *** '/1X,' COMPONENT',I5,'    DOES NOT HAV
     *E AN ASYMPTOTIC ',/1X,' EXPANSION IN THE INITIALIZATION PHASE '/)
9150  FORMAT(/1X,' *** SOLUTION AT T   =',D18.9,' ***',/(1X,4D18.9))
9160  FORMAT(1X,' *** INITIAL VALUES *** ',/(1X,4D18.9))
9415  FORMAT(/,2X,'     K  ITER  FAIL',8X,'THETA',7X,'DELTA0')
9421  FORMAT(2X,3I6,2D13.3)
9429  FORMAT(2X,I6,6X,I6)
C
C ----------------------------------------------------------------------
C                  END OF CORE-INTEGRATOR LIMESI
C ----------------------------------------------------------------------
C
      END
      SUBROUTINE ITERS (N,NZV,KO,BV0,BVK,DEL,SM,W1,W2,
     1                  IJOB,IRV,ICV,RTOL,ITFAIL,
     2                  THETA,DELTA,IEST,FNH,ITER,COSTQ,
     3 IWS,RWS,NIWS,NRWS,LICN,IDISP,IP1,IP2,IP3,IP4,IP5,IP6)
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C ----------------------------------------------------------------------
C   SUBROUTINE ITERAT PERFORMS THE ITERATIVE REALIZATION OF THE
C   DISCRETIZATION FOR VARIABLE LEFT-HAND-SIDE MATRIX B(T,Y)
C ----------------------------------------------------------------------
C
      DIMENSION BV0(NZV),BVK(NZV),DEL(N),SM(N),W1(N),
     1          W2(N),IJOB(20),IRV(NZV),ICV(NZV)
      DIMENSION IWS(NIWS),RWS(NRWS),IDISP(2)
C
      COMMON/LIMX4/NSOL
      COMMON/LIMX1/LOUT
C
      DATA ZERO/0.D0/
      DATA THTMX1/.25D0/ , THTMX2/.50D0/ , DELMX1/.25D0/ , DELMX2/.5D0/
C
C  PREPARATIONS
C  ------------
C
      JOB=0
      ITOPT=IFIX(SNGL(COSTQ))
      ITMAX=2*ITOPT
      ITER=1
      THETA=ZERO
      DELTA=ZERO
      IF(IEST.EQ.1) DELMAX=DELMX1
      IF(IEST.EQ.1) THTMAX=THTMX1
      IF(IEST.EQ.0) DELMAX=DELMX2
      IF(IEST.EQ.0) THTMAX=THTMX2
C
C  DESCALE INITIAL VALUE OF ITERATION
C  ----------------------------------
C
      IF(IJOB(6).GT.5.AND.IEST.EQ.1) WRITE(LOUT,150)
      DO 10 I=1,N
10    W2(I)=W1(I)*SM(I)
C
C  COMPUTATION OF DELTA-B*X
C  ------------------------
C
20    DO 30 I=1,N
      W1(I)=ZERO
30    CONTINUE
      DO 40  I=1,NZV
      IC=ICV(I)
      IR=IRV(I)
      W1(IR)=W1(IR)+(BV0(I)-BVK(I))*W2(IC)
40    CONTINUE
      DO 50 I=1,N
50    W1(I)=W1(I)/SM(I)
C
C  SOLUTION OF THE LINEAR EQUATION
C  -------------------------------
C
      CALL MA30LC (N,IWS(IP1),RWS(IP1),LICN,IWS(IP3),IWS(IP4),IDISP,
     @            IWS(IP5),IWS(IP6),W1,RWS(IP2))
      NSOL=NSOL+1
C
C  ERROR ESTIMATION AND CALCULATION OF STEPSIZE CONTROL PARAMETERS
C  ---------------------------------------------------------------
C
      ERR=ZERO
      DO 80 I=1,N
80    ERR=ERR+W1(I)*W1(I)
      ERR=DSQRT(ERR/DFLOAT(N))
      IF(ITER.GT.2) GOTO 100
      IF(ITER.EQ.1 .AND. ERR.GT.DELMAX) GOTO 220
      IF(ITER.EQ.1) GOTO 90
      THETA=ERR/DELTA
      IF(THETA.GT.THTMAX) GOTO 230
      IF(IEST.EQ.0) GOTO 100
      ZZ=THETA**DFLOAT(ITOPT+2)*DELTA
      IF(ZZ.GT.RTOL*1.D-1) GOTO 240
      GOTO 100
90    DELTA=ERR
C
100   IF(IJOB(6).GT.5.AND.IEST.EQ.1) WRITE(LOUT,160) ITER,ERR
      IF(ERR.LE.RTOL*1.D-1) GOTO 130
      ITER=ITER+1
      DO 110 I=1,N
      DEL(I)=DEL(I)+W1(I)
110   W2(I)=W1(I)*SM(I)
      IF(ITER.LE.ITMAX) GOTO 20
      GOTO 250
C
C  SOLUTION EXIT
C  -------------
C
130   DO 140 I=1,N
140   DEL(I)=DEL(I)+W1(I)
      ITFAIL=0
      IF(IEST.EQ.1 .AND. ITER.GT.ITOPT) ITFAIL=1
      RETURN
C
C  FAIL EXITS
C------------
C
220   ITFAIL=2
      RETURN
C
230   ITFAIL=3
      RETURN
C
240   ITFAIL=4
      RETURN
C
250   ITFAIL=5
      RETURN
C
150   FORMAT(10X,' ####       ITER           ERROR      ####')
160   FORMAT(10X,' ####      ',I4,7X,D12.4,'    ####')
C
C ----------------------------------------------------------------------
C                    END OF SUBROUTINE ITERAT
C ----------------------------------------------------------------------
C
      END
      SUBROUTINE RESLIS (NEQ,NZV,T,U,URHS,URES,BV,IR,IC,UP,FCN,IJOB,
     1                   IFLAG)
C
C*********************************************************************
C
C  COMPUTES RESIDUAL
C
C*********************************************************************
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C
      DIMENSION U(NEQ),URHS(NEQ),URES(NEQ),UP(NEQ)
      DIMENSION BV(NZV),IR(NZV),IC(NZV)
      DIMENSION IJOB(20)
C
      EXTERNAL FCN
C
      CALL FCN (NEQ,NZV,T,U,URHS,BV,IR,IC,IFLAG)
C
      DO 100 I=1,NEQ
      URES(I)=URHS(I)
100   CONTINUE
C
      IF(IJOB(8).EQ.1) RETURN
C
      DO 200 I=1,NZV
      ICH=IC(I)
      IRH=IR(I)
      URES(IRH)=URES(IRH)-BV(I)*UP(ICH)
200   CONTINUE
C
      RETURN
      END
      SUBROUTINE MERGE (N,LDIM,NZC,NZV,JA,IA,IRC,ICC,IRV,ICV,
     1                  IT0,IT1,IT2,JQ,IQ,LDIMQ,ICCS,ICPL,
     2                  IVCS,IVPL,IMERGE,LDH,NP1,IJOB8,INFO,LOUT)
C
      DIMENSION JA(LDIM),IA(NP1),JQ(LDH),IQ(NP1)
      DIMENSION IRC(NZC),ICC(NZC),IRV(NZV),ICV(NZV)
      DIMENSION ICCS(N),ICPL(N),IVCS(N),IVPL(N),IMERGE(*)
      DIMENSION IT0(LDIM),IT1(NZC),IT2(NZV)
C
      IF(INFO.LE.0) GOTO 90
C
      NZCH=NZC
      NZVH=NZV
      IF(IJOB8.EQ.1) NZVH=0
      IF(IJOB8.EQ.2) NZCH=0
      WRITE(LOUT,9000)
9000  FORMAT(//,' MESSAGES FROM SUBROUTINE MERGE:',/,1X,32('='))
      WRITE(LOUT,9010) LDIM,NZCH,NZVH
9010  FORMAT(/,' DIMENSIONS OF INPUT PATTERNS:',/,
     1   '    LDIM = ',I6,/,'     NZC = ',I6,/,'     NZV = ',I6)
C
      IF(INFO.LE.1) GOTO 90
C
      WRITE(LOUT,9020)
9020  FORMAT(//,' VALUES:')
9050  FORMAT(10I6)
      WRITE(LOUT,9021)
9021  FORMAT(/,' OF JA:')
      IF(LDIM.GT.0) WRITE(LOUT,9050) (JA(I),I=1,LDIM)
      WRITE(LOUT,9022)
9022  FORMAT(/,' OF IA:')
      WRITE(LOUT,9050) (IA(I),I=1,NP1)
      WRITE(LOUT,9023)
9023  FORMAT(/,' OF IRC:')
      IF(IJOB8.NE.2) WRITE(LOUT,9050) (IRC(I),I=1,NZC)
      WRITE(LOUT,9024)
9024  FORMAT(/,' OF ICC:')
      IF(IJOB8.NE.2) WRITE(LOUT,9050) (ICC(I),I=1,NZC)
      WRITE(LOUT,9025)
9025  FORMAT(/,' OF IRV:')
      IF(IJOB8.NE.1) WRITE(LOUT,9050) (IRV(I),I=1,NZV)
      WRITE(LOUT,9026)
9026  FORMAT(/,' OF ICV:')
      IF(IJOB8.NE.0) WRITE(LOUT,9050) (ICV(I),I=1,NZV)
C
90    ISUM=0
C
      DO 2000 IROW=1,N
C
      IQ(IROW)=ISUM+1
C
C
C  GET COLUMN INDICES OF ACTUAL ROW
      IH=0
      IF(IJOB8.EQ.2) GOTO 101
      DO 100 J=1,NZC
      IF(IRC(J).NE.IROW) GOTO 100
      IH=IH+1
      ICCS(IH)=ICC(J)
      ICPL(IH)=J
100   CONTINUE
101   CONTINUE
      NC=IH
C
      IH=0
      IF(IJOB8.EQ.1) GOTO 201
      DO 200 J=1,NZV
      IF(IRV(J).NE.IROW) GOTO 200
      IH=IH+1
      IVCS(IH)=ICV(J)
      IVPL(IH)=J
200   CONTINUE
201   CONTINUE
      NV=IH
C
C  MERGE COLUMN INDICES OF ACTUAL ROW
      IMIN=IA(IROW)
      IMAX=IA(IROW+1)
      NA=IMAX-IMIN
      IMAX=IMAX-1
      IH=0
      IF(NA.LE.0) GOTO 350
      DO 300 L=IMIN,IMAX
      IH=IH+1
      IMERGE(IH)=JA(L)
300   CONTINUE
350   CONTINUE
C
      IF(NC.LE.0) GOTO 450
      DO 400 L=1,NC
      IH=IH+1
      IMERGE(IH)=ICCS(L)
400   CONTINUE
450   CONTINUE
C
      IF(NV.LE.0) GOTO 550
      DO 500 L=1,NV
      IH=IH+1
      IMERGE(IH)=IVCS(L)
500   CONTINUE
550   CONTINUE
C
      IF(IH.LE.0) GOTO 8000
C
      NH=IH-1
      IF(NH.EQ.0) GOTO 850
C
C  SORTING
600   CONTINUE
      IFLAG=0
      DO 700 I=1,NH
      IF(IMERGE(I).LE.IMERGE(I+1)) GOTO 700
      IFLAG=1
      ISAVE=IMERGE(I)
      IMERGE(I)=IMERGE(I+1)
      IMERGE(I+1)=ISAVE
700   CONTINUE
      IF(IFLAG.NE.0) GOTO 600
C
C  CONDENSING
      NH=NH+1
      IH=1
      DO 800 I=2,NH
      IF(IMERGE(I).EQ.IMERGE(I-1)) GOTO 800
      IH=IH+1
      IMERGE(IH)=IMERGE(I)
800   CONTINUE
850   CONTINUE
      NQ=IH
C
C  CREATE TRANSFORMATIONS
      IF(NA.LE.0) GOTO 950
      DO 900 L=IMIN,IMAX
      DO 900 J=1,NQ
      IF(JA(L).EQ.IMERGE(J)) IT0(L)=ISUM+J
900   CONTINUE
950   CONTINUE
C
      IF(NC.LE.0) GOTO 1050
      DO 1000 L=1,NC
      DO 1000 J=1,NQ
      IF(ICCS(L).EQ.IMERGE(J)) IT1(ICPL(L))=ISUM+J
1000  CONTINUE
1050  CONTINUE
C
      IF(NV.LE.0) GOTO 1150
      DO 1100 L=1,NV
      DO 1100 J=1,NQ
      IF(IVCS(L).EQ.IMERGE(J)) IT2(IVPL(L))=ISUM+J
1100  CONTINUE
1150  CONTINUE
C
C  SET PATTERN OF MERGED MATRICES
      DO 1200 L=1,NQ
      JQ(ISUM+L)=IMERGE(L)
1200  CONTINUE
C
      ISUM=ISUM+NQ
C
C
2000  CONTINUE
C
      IQ(N+1)=ISUM+1
      LDIMQ=ISUM
C
      IF(INFO.LE.0) GOTO 2090
C
      WRITE(LOUT,9210) LDIMQ
9210  FORMAT(/,' DIMENSION OF MERGED PATTERN:',/,
     1   '    LDIMQ = ',I6)
C
      IF(INFO.LE.1) GOTO 2090
C
      WRITE(LOUT,9220)
9220  FORMAT(//,' VALUES:')
      WRITE(LOUT,9221)
9221  FORMAT(/,' OF JQ:')
      IF(LDIMQ.GT.0) WRITE(LOUT,9050) (JQ(I),I=1,LDIMQ)
      WRITE(LOUT,9222)
9222  FORMAT(/,' OF IQ:')
      WRITE(LOUT,9050) (IQ(I),I=1,NP1)
      WRITE(LOUT,9223)
9223  FORMAT(/,' OF ITA:')
      IF(LDIM.GT.0) WRITE(LOUT,9050) (IT0(I),I=1,LDIM)
      WRITE(LOUT,9224)
9224  FORMAT(/,' OF ITC:')
      IF(IJOB8.NE.2) WRITE(LOUT,9050) (IT1(I),I=1,NZC)
      WRITE(LOUT,9225)
9225  FORMAT(/,' OF ITV:')
      IF(IJOB8.NE.1) WRITE(LOUT,9050) (IT2(I),I=1,NZV)
C
2090  CONTINUE
      INFO=0
C
      RETURN
C
C  ERROR EXIT
C
8000  CONTINUE
      IF(INFO.GE.-2) WRITE(LOUT,9800)
9800  FORMAT(//,' ERROR IN SUBROUTINE MERGE',//)
      IF(INFO.GE.-2) WRITE(LOUT,9810) IROW
9810  FORMAT('   NO ENTRIES IN ROW NO.',I6,/,
     1       '   MERGED PATTERN STRUCTURALLY SINGULAR')
      INFO=-1
C
      RETURN
C
C  END OF SUBROUTINE MERGE
C
      END
      SUBROUTINE MA30LA(N,ICN,A,LICN,LENR,LENRL,IDISP,IP,IQ,IRN,
     @LIRN,LENC,IFIRST,LASTR,NEXTR,LASTC,NEXTC,IPTR,IPC,UIN,IFLAG)
C
C  ANALYSE AND FACTOR SPARSE MATRIX
C
C
C DATE OF LATEST CHANGE: APRIL 27, '82
C
      DOUBLE PRECISION A(LICN),U,UIN,AU,UMAX,AMAX,ZERO
CSP       REAL A(LICN)
      DOUBLE PRECISION DABS,DMAX1,DMIN1
CSP       REAL ABS,AMAX1,AMIN1
      INTEGER PIVOT,PIVEND,DISPC,OLDPIV,OLDEND,PIVROW
      INTEGER ROWI
      INTEGER IDISP(2)
      LOGICAL ABORT1,ABORT2,ABORT3
      INTEGER ICN(LICN),LENR(N),LENRL(N),IP(N),IQ(N),LENC(N)
CI2       INTEGER*2 ICN(LICN),LENR(N),LENRL(N),IP(N),IQ(N),LENC(N)
C
C FOR HANLING OF MORE THAN 32000 NONZEROS WITH INTEGER*2 VERSION CHANGE
C ARRAYS IPC AND IPATR TO STANDARD INTEGER
C
      INTEGER IRN(LIRN),IPC(N),IPTR(N)
CI2       INTEGER*2 IRN(LIRN),IPC(N),IPTR(N)
      INTEGER IFIRST(N),LASTR(N),NEXTR(N),LASTC(N),NEXTC(N)
CI2       INTEGER*2 IFIRST(N),LASTR(N),NEXTR(N),LASTC(N),NEXTC(N)
C
      COMMON /MA30LE/ LP,ABORT1,ABORT2,ABORT3
      COMMON /MA30LF/ IRNCP,ICNCP,IRANK,MINIRN,MINICN
C
      DATA UMAX/.999999999D0/
CSP       DATA UMAX/.9999/
      DATA ZERO/0.0D0/
CSP       DATA ZERO/0.0/
C
      MINIRN=0
      MINICN=IDISP(1)-1
      MOREI=0
      IRANK=N
      IRNCP=0
      ICNCP=0
      IFLAG=0
C RESET U IF NECESSARY.
      U=DMIN1(UIN,UMAX)
CSP       U=AMIN1(UIN,UMAX)
      U=DMAX1(U,ZERO)
CSP       U=AMAX1(U,ZERO)
C IBEG IS THE POSITION OF THE NEXT PIVOT ROW AFTER ELIMINATION STEP
C     USING IT.
      IBEG=IDISP(1)
C IACTIV IS THE POSITION OF THE FIRST ENTRY IN THE ACTIVE PART OF A/ICN.
      IACTIV=IDISP(2)
C NZROW IS CURRENT NUMBER OF NON-ZEROS IN ACTIVE AND UNPROCESSED PART
C     OF ROW FILE ICN.
      NZROW=LICN-IACTIV+1
      MINICN=NZROW+MINICN
C
C     SET UP POINTERS TO THE
C     BEGINNINGS OF THE ROWS.
      IPTR(1)=IACTIV
      IF (N.EQ.1) GO TO 20
      NM1=N-1
      DO 10 I=1,NM1
   10 IPTR(I+1)=IPTR(I)+LENR(I)
C
C ***********************************************
C ****    LU DECOMPOSITION OF MATRIX         ****
C ***********************************************
C
C IACTIV IS THE POSITION OF THE FIRST ELEMENT IN THE MATRIX
C ITOP IS THE POSITION OF THE LAST ELEMENT IN THE MATRIX.
  20  ITOP=LICN
C
C SET UP COLUMN ORIENTED STORAGE.
      DO 110 I=1,N
      LENRL(I)=0
  110 LENC(I)=0
      IF (ITOP-IACTIV.LT.LIRN) GO TO 120
      MINIRN=ITOP-IACTIV+1
      PIVOT=0
      GO TO 1050
C
C CALCULATE COLUMN COUNTS.
  120 DO 130 II=IACTIV,ITOP
      I=ICN(II)
  130 LENC(I)=LENC(I)+1
C SET UP COLUMN POINTERS SO THAT IPC(J) POINTS TO POSITION AFTER END
C     OF COLUMN J IN COLUMN FILE.
      IPC(N)=LIRN+1
      IF(N.EQ.1) GOTO 142
      DO 140 JJ=2,N
      J=N-JJ+1
  140 IPC(J)=IPC(J+1)-LENC(J+1)
  142 DO 160 INDROW=1,N
      J1=IPTR(INDROW)
      J2=J1+LENR(INDROW)-1
      IF (J1.GT.J2) GO TO 160
      DO 150 JJ=J1,J2
      J=ICN(JJ)
      IPOS=IPC(J)-1
      IRN(IPOS)=INDROW
      IPC(J)=IPOS
  150 CONTINUE
  160 CONTINUE
C DISPC IS THE LOWEST INDEXED ACTIVE LOCATION IN THE COLUMN FILE.
      DISPC=IPC(1)
      NZCOL=LIRN-DISPC+1
      MINIRN=MAX0(NZCOL,MINIRN)
      NZMIN=1
C
C INITIALIZE ARRAY IFIRST.  IFIRST(I) = +/- K INDICATES THAT ROW/COL
C     K HAS I NON-ZEROS.  IF IFIRST(I) = 0, THERE IS NO ROW OR COLUMN
C     WITH I NON ZEROS.
      DO 170 I=1,N
  170 IFIRST(I)=0
C
C COMPUTE ORDERING OF ROW AND COLUMN COUNTS.
C FIRST RUN THROUGH COLUMNS (FROM COLUMN N TO COLUMN 1).
      DO 190 JJ=1,N
      J=N-JJ+1
      NZ=LENC(J)
      IF (NZ.NE.0) GO TO 180
      IPC(J)=0
      LASTC(J)=0
      GO TO 190
  180 ISW=IFIRST(NZ)
      IFIRST(NZ)=-J
      LASTC(J)=0
      NEXTC(J)=-ISW
      ISW1=IABS(ISW)
      IF (ISW.NE.0) LASTC(ISW1)=J
  190 CONTINUE
C NOW RUN THROUGH ROWS (AGAIN FROM N TO 1).
      DO 210 II=1,N
      I=N-II+1
      NZ=LENR(I)
      IF (NZ.NE.0) GO TO 200
      IPTR(I)=0
      LASTR(I)=0
      GO TO 210
  200 ISW=IFIRST(NZ)
      IFIRST(NZ)=I
      IF (ISW.GT.0) GO TO 205
      NEXTR(I)=0
      LASTR(I)=ISW
      GO TO 210
 205  NEXTR(I)=ISW
      LASTR(I)=LASTR(ISW)
      LASTR(ISW)=I
  210 CONTINUE
C
C
C **********************************************
C ****    START OF MAIN ELIMINATION LOOP    ****
C **********************************************
      DO 930 PIVOT=1,N
C
C FIRST FIND THE PIVOT USING MARKOWITZ CRITERION WITH STABILITY
C     CONTROL.
C JCOST IS THE MARKOWITZ COST OF THE BEST PIVOT SO FAR,.. THIS
C     PIVOT IS IN ROW IPIV AND COLUMN JPIV.
      NZ2=NZMIN
      JCOST=N*N
C
C EXAMINE ROWS/COLUMNS IN ORDER OF ASCENDING COUNT.
      DO 290 L=1,2
      LL=L
C A PASS WITH L EQUAL TO 2 IS ONLY PERFORMED IN THE CASE OF SINGULARITY.
      DO 280 NZ=NZ2,N
      IF (JCOST.LE.(NZ-1)**2) GO TO 380
      IJFIR=IFIRST(NZ)
      IF (IJFIR) 212,211,215
 211  IF (LL.EQ.1) NZMIN=NZ+1
      GO TO 280
 212  LL=2
      IJFIR=-IJFIR
      GO TO 245
 215  LL=2
C SCAN ROWS WITH NZ NON-ZEROS.
      DO 235 IDUMMY=1,N
      IF (IJFIR.EQ.0) GO TO 240
C ROW IJFIR IS NOW EXAMINED.
      I=IJFIR
      IJFIR=NEXTR(I)
C FIRST CALCULATE MULTIPLIER THRESHOLD LEVEL.
      AMAX=ZERO
      J1=IPTR(I)+LENRL(I)
      J2=IPTR(I)+LENR(I)-1
      DO 220 JJ=J1,J2
 220  AMAX=DMAX1(AMAX,DABS(A(JJ)))
CSP  220  AMAX=AMAX1(AMAX,ABS(A(JJ)))
      AU=AMAX*U
C SCAN ROW FOR POSSIBLE PIVOTS
      DO 230 JJ=J1,J2
      IF (DABS(A(JJ)).LE.AU.AND.L.EQ.1) GO TO 230
CSP       IF (ABS(A(JJ)).LE.AU.AND.L.EQ.1) GO TO 230
      J=ICN(JJ)
      KCOST=(NZ-1)*(LENC(J)-1)
      IF (KCOST.GE.JCOST) GO TO 230
C BEST PIVOT SO FAR IS FOUND.
      JCOST=KCOST
      IJPOS=JJ
      IPIV=I
      JPIV=J
      IF (JCOST.LE.(NZ-1)**2) GO TO 380
  230 CONTINUE
 235  CONTINUE
C
C COLUMNS WITH NZ NON-ZEROS NOW EXAMINED.
 240  IJFIR=IFIRST(NZ)
      IJFIR=-LASTR(IJFIR)
 245  IF (JCOST.LE.NZ*(NZ-1)) GO TO 380
      DO 270 IDUMMY=1,N
      IF (IJFIR.EQ.0) GO TO 280
      J=IJFIR
      IJFIR=NEXTC(IJFIR)
      I1=IPC(J)
      I2=I1+NZ-1
C SCAN COLUMN J.
      DO 260 II=I1,I2
      I=IRN(II)
      KCOST=(NZ-1)*(LENR(I)-LENRL(I)-1)
      IF (KCOST.GE.JCOST) GO TO 260
C PIVOT HAS BEST MARKOWITZ COUNT SO FAR ... NOW CHECK ITS
C     SUITABILITY ON NUMERIC GROUNDS BY EXAMINING THE OTHER NON-ZEROS
C     IN ITS ROW.
      J1=IPTR(I)+LENRL(I)
      J2=IPTR(I)+LENR(I)-1
C WE NEED A STABILITY CHECK ON SINGLETON COLUMNS BECAUSE OF POSSIBLE
C     PROBLEMS WITH UNDERDETERMINED SYSTEMS.
      AMAX=ZERO
      DO 250 JJ=J1,J2
      AMAX=DMAX1(AMAX,DABS(A(JJ)))
CSP       AMAX=AMAX1(AMAX,ABS(A(JJ)))
  250 IF (ICN(JJ).EQ.J) JPOS=JJ
      IF (DABS(A(JPOS)).LE.AMAX*U.AND.L.EQ.1) GO TO 260
CSP       IF (ABS(A(JPOS)).LE.AMAX*U.AND.L.EQ.1) GO TO 260
      JCOST=KCOST
      IPIV=I
      JPIV=J
      IJPOS=JPOS
      IF (JCOST.LE.NZ*(NZ-1)) GO TO 380
  260 CONTINUE
C
  270 CONTINUE
C
  280 CONTINUE
C
C MATRIX IS NUMERICALLY OR STRUCTURALLY SINGULAR  ... WHICH IT IS WILL
C     BE DIAGNOSED LATER.
      IRANK=IRANK-1
  290 CONTINUE
C ASSIGN REST OF ROWS AND COLUMNS TO ORDERING ARRAY.
C MATRIX IS STRUCTURALLY SINGULAR.
      IF (IFLAG.NE.2.AND.IFLAG.NE.-5) IFLAG=1
      IRANK=IRANK-N+PIVOT+1
      IF (.NOT.ABORT1) GO TO 300
      IDISP(2)=IACTIV
      IFLAG=-1
      IF (LP.NE.0) WRITE(LP,50)
 50   FORMAT(65H ERROR RETURN FROM MA30LA BECAUSE MATRIX IS STRUCTURALLY
     @ SINGULAR)
      GO TO 1110
  300 K=PIVOT-1
      DO 350 I=1,N
      IF (LASTR(I).NE.0) GO TO 350
      K=K+1
      LASTR(I)=K
      IF (LENRL(I).EQ.0) GO TO 340
      MINICN=MAX0(MINICN,NZROW+IBEG-1+MOREI+LENRL(I))
      IF (IACTIV-IBEG.GE.LENRL(I)) GO TO 320
      CALL MA30LD(A,ICN,IPTR(1),N,IACTIV,ITOP,.TRUE.)
C CHECK NOW TO SEE IF MA30LD HAS CREATED ENOUGH AVAILABLE SPACE.
      IF (IACTIV-IBEG.GE.LENRL(I)) GO TO 320
C CREATE MORE SPACE BY DESTROYING PREVIOUSLY CREATED LU FACTORS.
      MOREI=MOREI+IBEG-IDISP(1)
      IBEG=IDISP(1)
      IF (LP.NE.0) WRITE(LP,310)
      IFLAG=-5
  310 FORMAT(48H LU DECOMPOSITION DESTROYED TO CREATE MORE SPACE)
      IF (ABORT3) GO TO 1030
  320 J1=IPTR(I)
      J2=J1+LENRL(I)-1
      IPTR(I)=0
      DO 330 JJ=J1,J2
      A(IBEG)=A(JJ)
      ICN(IBEG)=ICN(JJ)
      ICN(JJ)=0
  330 IBEG=IBEG+1
      NZROW=NZROW-LENRL(I)
  340 IF (K.EQ.N) GO TO 360
  350 CONTINUE
  360 K=PIVOT-1
      DO 370 I=1,N
      IF (LASTC(I).NE.0) GO TO 370
      K=K+1
      LASTC(I)=-K
      IF (K.EQ.N) GO TO 940
  370 CONTINUE
C
C THE PIVOT HAS NOW BEEN FOUND IN POSITION (IPIV,JPIV) IN LOCATION
C     IJPOS IN ROW FILE.
C UPDATE COLUMN AND ROW ORDERING ARRAYS TO CORRESPOND WITH REMOVAL
C     OF THE ACTIVE PART OF THE MATRIX.
  380 ISING=PIVOT
      IF (A(IJPOS).NE.ZERO) GO TO 390
C NUMERICAL SINGULARITY IS RECORDED HERE.
      ISING=-ISING
      IF (IFLAG.NE.-5) IFLAG=2
      IF (.NOT.ABORT2) GO TO 390
      IDISP(2)=IACTIV
      IFLAG=-2
      IF (LP.NE.0) WRITE(LP,70)
 70   FORMAT(65H ERROR RETURN FROM MA30LA BECAUSE MATRIX IS NUMERICALLY
     @ SINGULAR)
      GO TO 1110
  390 OLDPIV=IPTR(IPIV)+LENRL(IPIV)
      OLDEND=IPTR(IPIV)+LENR(IPIV)-1
C CHANGES TO COLUMN ORDERING.
      DO 460 JJ=OLDPIV,OLDEND
      J=ICN(JJ)
      LC=LASTC(J)
      NC=NEXTC(J)
      IF (NC.NE.0) LASTC(NC)=LC
      IF (LC.EQ.0) GO TO 440
      NEXTC(LC)=NC
      GO TO 460
 440  NZ=LENC(J)
      ISW=IFIRST(NZ)
      IF (ISW.GT.0) LASTR(ISW)=-NC
      IF (ISW.LT.0) IFIRST(NZ)=-NC
  460 CONTINUE
C CHANGES TO ROW ORDERING.
      I1=IPC(JPIV)
      I2=I1+LENC(JPIV)-1
      DO 530 II=I1,I2
      I=IRN(II)
      LR=LASTR(I)
      NR=NEXTR(I)
      IF (NR.NE.0) LASTR(NR)=LR
      IF (LR.LE.0) GO TO 500
      NEXTR(LR)=NR
      GO TO 530
 500  NZ=LENR(I)-LENRL(I)
      IF (NR.NE.0) IFIRST(NZ)=NR
      IF (NR.EQ.0) IFIRST(NZ)=LR
  530 CONTINUE
C     RECORD THE COLUMN PERMUTATION IN LASTC(JPIV) AND THE ROW
C     PERMUTATION IN LASTR(IPIV).
      LASTC(JPIV)=ISING
      LASTR(IPIV)=PIVOT
C
C MOVE PIVOT TO POSITION LENRL+1 IN PIVOT ROW AND MOVE PIVOT ROW
C     TO THE BEGINNING OF THE AVAILABLE STORAGE.
C THE L PART AND THE PIVOT IN THE OLD COPY OF THE PIVOT ROW IS
C     NULLIFIED WHILE, IN THE STRICTLY UPPER TRIANGULAR PART, THE
C     COLUMN INDICES, J SAY, ARE OVERWRITTEN BY THE CORRESPONDING
C     ELEMENT OF IQ (IQ(J)) AND IQ(J) IS SET TO THE NEGATIVE OF THE
C     DISPLACEMENT OF THE COLUMN INDEX FROM THE PIVOT ELEMENT.
      IF (OLDPIV.EQ.IJPOS) GO TO 540
      AU=A(OLDPIV)
      A(OLDPIV)=A(IJPOS)
      A(IJPOS)=AU
      ICN(IJPOS)=ICN(OLDPIV)
      ICN(OLDPIV)=JPIV
C CHECK TO SEE IF THERE IS SPACE IMMEDIATELY AVAILABLE IN A/ICN TO
C     HOLD NEW COPY OF PIVOT ROW.
  540 MINICN=MAX0(MINICN,NZROW+IBEG-1+MOREI+LENR(IPIV))
      IF (IACTIV-IBEG.GE.LENR(IPIV)) GO TO 550
      CALL MA30LD(A,ICN,IPTR(1),N,IACTIV,ITOP,.TRUE.)
      OLDPIV=IPTR(IPIV)+LENRL(IPIV)
      OLDEND=IPTR(IPIV)+LENR(IPIV)-1
C CHECK NOW TO SEE IF MA30LD HAS CREATED ENOUGH AVAILABLE SPACE.
      IF (IACTIV-IBEG.GE.LENR(IPIV)) GO TO 550
C CREATE MORE SPACE BY DESTROYING PREVIOUSLY CREATED LU FACTORS.
      MOREI=MOREI+IBEG-IDISP(1)
      IBEG=IDISP(1)
      IF (LP.NE.0) WRITE(LP,310)
      IFLAG=-5
      IF (ABORT3) GO TO 1030
      IF (IACTIV-IBEG.GE.LENR(IPIV)) GO TO 550
C THERE IS STILL NOT ENOUGH ROOM IN A/ICN.
      IFLAG=-4
      GO TO 1030
C COPY PIVOT ROW AND SET UP IQ ARRAY.
  550 IJPOS=0
      J1=IPTR(IPIV)
C
      DO 570 JJ=J1,OLDEND
      A(IBEG)=A(JJ)
      ICN(IBEG)=ICN(JJ)
      IF (IJPOS.NE.0) GO TO 560
      IF (ICN(JJ).EQ.JPIV) IJPOS=IBEG
      ICN(JJ)=0
      GO TO 570
  560 K=IBEG-IJPOS
      J=ICN(JJ)
      ICN(JJ)=IQ(J)
      IQ(J)=-K
  570 IBEG=IBEG+1
C
      IJP1=IJPOS+1
      PIVEND=IBEG-1
      LENPIV=PIVEND-IJPOS
      NZROW=NZROW-LENRL(IPIV)-1
      IPTR(IPIV)=OLDPIV+1
      IF (LENPIV.EQ.0) IPTR(IPIV)=0
C
C REMOVE PIVOT ROW (INCLUDING PIVOT) FROM COLUMN ORIENTED FILE.
      DO 600 JJ=IJPOS,PIVEND
      J=ICN(JJ)
      I1=IPC(J)
      LENC(J)=LENC(J)-1
C I2 IS LAST POSITION IN NEW COLUMN.
      I2=IPC(J)+LENC(J)-1
      IF (I2.LT.I1) GO TO 590
      DO 580 II=I1,I2
      IF (IRN(II).NE.IPIV) GO TO 580
      IRN(II)=IRN(I2+1)
      GO TO 590
  580 CONTINUE
  590 IRN(I2+1)=0
  600 CONTINUE
      NZCOL=NZCOL-LENPIV-1
C
C GO DOWN THE PIVOT COLUMN AND FOR EACH ROW WITH A NON-ZERO ADD
C     THE APPROPRIATE MULTIPLE OF THE PIVOT ROW TO IT.
C WE LOOP ON THE NUMBER OF NON-ZEROS IN THE PIVOT COLUMN SINCE
C     MA30L MAY CHANGE ITS ACTUAL POSITION.
C
      NZPC=LENC(JPIV)
      IF (NZPC.EQ.0) GO TO 870
      DO 820 III=1,NZPC
      II=IPC(JPIV)+III-1
      I=IRN(II)
C SEARCH ROW I FOR NON-ZERO TO BE ELIMINATED, CALCULATE MULTIPLIER,
C     AND PLACE IT IN POSITION LENRL+1 IN ITS ROW.
      J1=IPTR(I)+LENRL(I)
      IEND=IPTR(I)+LENR(I)-1
      DO 610 JJ=J1,IEND
      IF (ICN(JJ).NE.JPIV) GO TO 610
C IF PIVOT IS ZERO, REST OF COLUMN IS AND SO MULTIPLIER IS ZERO.
      AU=ZERO
      IF (A(IJPOS).NE.ZERO) AU=-A(JJ)/A(IJPOS)
      A(JJ)=A(J1)
      A(J1)=AU
      ICN(JJ)=ICN(J1)
      ICN(J1)=JPIV
      LENRL(I)=LENRL(I)+1
      GO TO 620
  610 CONTINUE
C GO TO 870 IF PIVOT ROW IS A SINGLETON.
  620 IF (LENPIV.EQ.0) GO TO 820
C NOW PERFORM NECESSARY OPERATIONS ON REST OF NON-PIVOT ROW I.
      ROWI=J1+1
      IOP=0
C IF ALL THE PIVOT ROW CAUSES FILL-IN GO TO 640
      IF (ROWI.GT.IEND) GO TO 640
C PERFORM OPERATIONS ON CURRENT NON-ZEROS IN ROW I.
C INNERMOST LOOP.
      DO 630 JJ=ROWI,IEND
      J=ICN(JJ)
      IF (IQ(J).GT.0) GO TO 630
      IOP=IOP+1
      PIVROW=IJPOS-IQ(J)
      A(JJ)=A(JJ)+AU*A(PIVROW)
      ICN(PIVROW)=-ICN(PIVROW)
  630 CONTINUE
  640 IFILL=LENPIV-IOP
C IF THERE IS NO FILL-IN GO TO 740.
      IF (IFILL.EQ.0) GO TO 740
C NOW FOR THE FILL-IN.
      MINICN=MAX0(MINICN,MOREI+IBEG-1+NZROW+IFILL+LENR(I))
C SEE IF THERE IS ROOM FOR FILL-IN.
C GET MAXIMUM SPACE FOR ROW I IN SITU.
      DO 650 JDIFF=1,IFILL
      JNPOS=IEND+JDIFF
      IF (JNPOS.GT.LICN) GO TO 660
      IF (ICN(JNPOS).NE.0) GO TO 660
  650 CONTINUE
C THERE IS ROOM FOR ALL THE FILL-IN AFTER THE END OF THE ROW SO IT
C     CAN BE LEFT IN SITU.
C NEXT AVAILABLE SPACE FOR FILL-IN.
      IEND=IEND+1
      GO TO 740
C JMORE SPACES FOR FILL-IN ARE REQUIRED IN FRONT OF ROW.
  660 JMORE=IFILL-JDIFF+1
      I1=IPTR(I)
C WE NOW LOOK IN FRONT OF THE ROW TO SEE IF THERE IS SPACE FOR
C     THE REST OF THE FILL-IN.
      DO 670 JDIFF=1,JMORE
      JNPOS=I1-JDIFF
      IF (JNPOS.LT.IACTIV) GO TO 680
      IF (ICN(JNPOS).NE.0) GO TO 690
  670 CONTINUE
  680 JNPOS=I1-JMORE
      GO TO 700
C WHOLE ROW MUST BE MOVED TO THE BEGINNING OF AVAILABLE STORAGE.
  690 JNPOS=IACTIV-LENR(I)-IFILL
C IF THERE IS SPACE IMMEDIATELY AVAILABLE FOR THE SHIFTED ROW GO TO 720.
  700 IF (JNPOS.GE.IBEG) GO TO 720
      CALL MA30LD(A,ICN,IPTR(1),N,IACTIV,ITOP,.TRUE.)
      I1=IPTR(I)
      IEND=I1+LENR(I)-1
      JNPOS=IACTIV-LENR(I)-IFILL
      IF (JNPOS.GE.IBEG) GO TO 720
C NO SPACE AVAILABLE SO TRY TO CREATE SOME BY THROWING AWAY PREVIOUS
C     LU DECOMPOSITION.
      MOREI=MOREI+IBEG-IDISP(1)-LENPIV-1
      IF (LP.NE.0) WRITE(LP,310)
      IFLAG=-5
      IF (ABORT3) GO TO 1030
C KEEP RECORD OF CURRENT PIVOT ROW.
      IBEG=IDISP(1)
      ICN(IBEG)=JPIV
      A(IBEG)=A(IJPOS)
      IJPOS=IBEG
      DO 710 JJ=IJP1,PIVEND
      IBEG=IBEG+1
      A(IBEG)=A(JJ)
  710 ICN(IBEG)=ICN(JJ)
      IJP1=IJPOS+1
      PIVEND=IBEG
      IBEG=IBEG+1
      IF (JNPOS.GE.IBEG) GO TO 720
C THIS STILL DOES NOT GIVE ENOUGH ROOM.
      IFLAG=-4
      GO TO 1030
  720 IACTIV=MIN0(IACTIV,JNPOS)
C MOVE NON-PIVOT ROW I.
      IPTR(I)=JNPOS
      DO 730 JJ=I1,IEND
      A(JNPOS)=A(JJ)
      ICN(JNPOS)=ICN(JJ)
      JNPOS=JNPOS+1
  730 ICN(JJ)=0
C FIRST NEW AVAILABLE SPACE.
      IEND=JNPOS
  740 NZROW=NZROW+IFILL
C INNERMOST FILL-IN LOOP WHICH ALSO RESETS ICN.
      DO 810 JJ=IJP1,PIVEND
      J=ICN(JJ)
      IF (J.LT.0) GO TO 800
      A(IEND)=AU*A(JJ)
      ICN(IEND)=J
      IEND=IEND+1
C
C PUT NEW ENTRY IN COLUMN FILE.
      MINIRN=MAX0(MINIRN,NZCOL+LENC(J)+1)
      JEND=IPC(J)+LENC(J)
      JROOM=NZPC-III+1+LENC(J)
      IF (JEND.GT.LIRN) GO TO 750
      IF (IRN(JEND).EQ.0) GO TO 790
  750 IF (JROOM.LT.DISPC) GO TO 760
C COMPRESS COLUMN FILE TO OBTAIN SPACE FOR NEW COPY OF COLUMN.
      CALL MA30LD(A,IRN,IPC(1),N,DISPC,LIRN,.FALSE.)
      IF (JROOM.LT.DISPC) GO TO 760
      JROOM=DISPC-1
      IF (JROOM.GE.LENC(J)+1) GO TO 760
C COLUMN FILE IS NOT LARGE ENOUGH.
      GO TO 1050
C COPY COLUMN TO BEGINNING OF FILE.
  760 JBEG=IPC(J)
      JEND=IPC(J)+LENC(J)-1
      JZERO=DISPC-1
      DISPC=DISPC-JROOM
      IDISPC=DISPC
      DO 770 II=JBEG,JEND
      IRN(IDISPC)=IRN(II)
      IRN(II)=0
  770 IDISPC=IDISPC+1
      IPC(J)=DISPC
      JEND=IDISPC
      DO 780 II=JEND,JZERO
  780 IRN(II)=0
  790 IRN(JEND)=I
      NZCOL=NZCOL+1
      LENC(J)=LENC(J)+1
C END OF ADJUSTMENT TO COLUMN FILE.
      GO TO 810
C
  800 ICN(JJ)=-J
  810 CONTINUE
      LENR(I)=LENR(I)+IFILL
C END OF SCAN OF PIVOT COLUMN.
  820 CONTINUE
C
C
C REMOVE PIVOT COLUMN FROM COLUMN ORIENTED STORAGE AND UPDATE ROW
C     ORDERING ARRAYS.
      I1=IPC(JPIV)
      I2=IPC(JPIV)+LENC(JPIV)-1
      NZCOL=NZCOL-LENC(JPIV)
      DO 860 II=I1,I2
      I=IRN(II)
      IRN(II)=0
      NZ=LENR(I)-LENRL(I)
      IF (NZ.NE.0) GO TO 830
      LASTR(I)=0
      GO TO 860
  830 IFIR=IFIRST(NZ)
      IFIRST(NZ)=I
      IF (IFIR) 840,855,850
 840  LASTR(I)=IFIR
      NEXTR(I)=0
      GO TO 860
 850  LASTR(I)=LASTR(IFIR)
      NEXTR(I)=IFIR
      LASTR(IFIR)=I
      GO TO 860
 855  LASTR(I)=0
      NEXTR(I)=0
      NZMIN=MIN0(NZMIN,NZ)
 860  CONTINUE
C RESTORE IQ AND NULLIFY U PART OF OLD PIVOT ROW.
  870 IPC(JPIV)=0
      IF (LENPIV.EQ.0) GO TO 930
      NZROW=NZROW-LENPIV
      JVAL=IJP1
      JZER=IPTR(IPIV)
      IPTR(IPIV)=0
      DO 880 JCOUNT=1,LENPIV
      J=ICN(JVAL)
      IQ(J)=ICN(JZER)
      ICN(JZER)=0
      JVAL=JVAL+1
  880 JZER=JZER+1
C ADJUST COLUMN ORDERING ARRAYS.
      DO 920 JJ=IJP1,PIVEND
      J=ICN(JJ)
      NZ=LENC(J)
      IF (NZ.NE.0) GO TO 890
      LASTC(J)=0
      GO TO 920
  890 IFIR=IFIRST(NZ)
      LASTC(J)=0
      IF (IFIR) 900,910,915
 900  IFIRST(NZ)=-J
      IFIR=-IFIR
      LASTC(IFIR)=J
      NEXTC(J)=IFIR
      GO TO 920
 910  IFIRST(NZ)=-J
      NEXTC(J)=0
      NZMIN=MIN0(NZMIN,NZ)
      GO TO 920
 915  LC=-LASTR(IFIR)
      LASTR(IFIR)=-J
      NEXTC(J)=LC
      IF (LC.NE.0) LASTC(LC)=J
  920 CONTINUE
  930 CONTINUE
C ********************************************
C ****    END OF MAIN ELIMINATION LOOP    ****
C ********************************************
C
C RESET IACTIV TO POINT TO THE BEGINNING OF THE NEXT BLOCK.
  940 IF (N.NE.N) IACTIV=IPTR(N+1)
  950 CONTINUE
C
C ********************************************
C ****    END OF DEOMPOSITION OF MATRIX   ****
C ********************************************
C
C
C RUN THROUGH LU DECOMPOSITION CHANGING COLUMN INDICES TO THAT OF NEW
C     ORDER AND PERMUTING LENR AND LENRL ARRAYS ACCORDING TO PIVOT
C     PERMUTATIONS.
      IEND=IBEG-1
      DO 980 JJ=1,IEND
      JOLD=ICN(JJ)
  980 ICN(JJ)=LASTC(JOLD)
      DO 990 II=1,N
      I=LASTR(II)
      NEXTR(I)=LENR(II)
  990 NEXTC(I)=LENRL(II)
      DO 1000 I=1,N
      LENRL(I)=NEXTC(I)
 1000 LENR(I)=NEXTR(I)
C
C UPDATE PERMUTATION ARRAYS IP AND IQ.
      DO 1010 II=1,N
      I=LASTR(II)
      J=LASTC(II)
      NEXTR(I)=IP(II)
 1010 NEXTC(J)=IQ(II)
      DO 1020 I=1,N
      IP(I)=NEXTR(I)
 1020 IQ(I)=NEXTC(I)
      IDISP(2)=IEND
      GO TO 1110
C
C   ***    ERROR RETURNS    ***
 1030 IDISP(2)=IACTIV
      IF (LP.EQ.0) GO TO 1110
      WRITE(LP,1040)
 1040 FORMAT(53H ERROR RETURN FROM MA30LA BECAUSE LICN NOT BIG ENOUGH)
      GO TO 1080
 1050 IF (IFLAG.EQ.-5) IFLAG=-6
      IF (IFLAG.NE.-6) IFLAG=-3
      IDISP(2)=IACTIV
      IF (LP.EQ.0) GO TO 1110
      IF (IFLAG.EQ.-3) WRITE(LP,1060)
      IF (IFLAG.EQ.-6) WRITE(LP,1070)
 1060 FORMAT(53H ERROR RETURN FROM MA30LA BECAUSE LIRN NOT BIG ENOUGH)
 1070 FORMAT(49H ERROR RETURN FROM MA30LA LIRN AND LICN TOO SMALL)
 1080 WRITE(LP,1090) PIVOT
 1090 FORMAT(10H AT STAGE ,I5)
      IF (PIVOT.EQ.0) WRITE(LP,1100) MINIRN
 1100 FORMAT(34H TO CONTINUE SET LIRN TO AT LEAST ,I8)
C
C
 1110 RETURN
C
C  END MA30LA
C
      END
      SUBROUTINE MA30LD(A,ICN,IPTR,N,IACTIV,ITOP,REALS)
C
C  COMPRESS ARRAYS
C
      DOUBLE PRECISION A(ITOP)
CSP       REAL A(ITOP)
      LOGICAL REALS
C
C FOR HANLING OF MORE THAN 32000 NONZEROS WITH INTEGER*2 VERSION CHANGE
C ARRAY IPTR TO STANDARD INTEGER
C
      INTEGER ICN(ITOP),IPTR(N)
CI2       INTEGER*2 ICN(ITOP),IPTR(N)
      COMMON /MA30LF/ IRNCP,ICNCP,IRANK,MINIRN,MINICN
C IACTIV IS THE FIRST POSITION IN ARRAYS A/ICN FROM WHICH THE
C     COMPRESS STARTS.
C ON EXIT IACTIV EQUALS THE POSITION OF THE FIRST ELEMENT IN THE
C     COMPRESSED PART OF A/ICN
      IF (REALS) ICNCP=ICNCP+1
      IF (.NOT.REALS) IRNCP=IRNCP+1
C SET THE FIRST NON-ZERO ELEMENT IN EACH ROW TO THE NEGATIVE OF THE
C     ROW/COL NUMBER AND HOLD THIS ROW/COL INDEX IN THE ROW/COL
C     POINTER.  THIS IS SO THAT THE BEGINNING OF EACH ROW/COL CAN
C     BE RECOGNIZED IN THE SUBSEQUENT SCAN.
      DO 10 J=1,N
      K=IPTR(J)
      IF (K.LT.IACTIV) GO TO 10
      IPTR(J)=ICN(K)
      ICN(K)=-J
   10 CONTINUE
      KN=ITOP+1
      KL=ITOP-IACTIV+1
C GO THROUGH ARRAYS IN REVERSE ORDER COMPRESSING TO THE BACK SO
C     THAT THERE ARE NO ZEROS HELD IN POSITIONS IACTIV TO ITOP IN ICN.
C     RESET FIRST ELEMENT OF EACH ROW/COL AND POINTER ARRAY IPTR.
      DO 30 K=1,KL
      JPOS=ITOP-K+1
      IF (ICN(JPOS).EQ.0) GO TO 30
      KN=KN-1
      IF (REALS) A(KN)=A(JPOS)
      IF (ICN(JPOS).GE.0) GO TO 20
C FIRST NON-ZERO OF ROW/COL HAS BEEN LOCATED
      J=-ICN(JPOS)
      ICN(JPOS)=IPTR(J)
      IPTR(J)=KN
   20 ICN(KN)=ICN(JPOS)
   30 CONTINUE
      IACTIV=KN
      RETURN
      END
      SUBROUTINE MA30LB(N,ICN,A,LICN,LENR,LENRL,IDISP,IP,IQ,W,IW,
     @IFLAG)
C
C  FACTOR SPARSE MATRIX
C
C
C DATE OF LATEST CHANGE: APRIL 27, '82
C
      DOUBLE PRECISION A(LICN),W(N),AU,EPS,ROWMAX,ZERO,ONE,RMIN
CSP       REAL A(LICN),W(N)
      DOUBLE PRECISION DABS,DMAX1
CSP       REAL ABS,AMAX1
      INTEGER IDISP(2),PIVPOS
      LOGICAL ABORT1,ABORT2,ABORT3,STAB
C
C FOR HANLING OF MORE THAN 32000 NONZEROS WITH INTEGER*2 VERSION CHANGE
C ARRAY IW TO STANDARD INTEGER
C
      INTEGER ICN(LICN),LENR(N),LENRL(N),IP(N),IQ(N),IW(N)
CI2       INTEGER*2 ICN(LICN),LENR(N),LENRL(N),IP(N),IQ(N),IW(N)
C
      COMMON /MA30LE/ LP,ABORT1,ABORT2,ABORT3
      COMMON /MA30LG/ EPS,RMIN
C
      DATA ZERO/0.0D0/,ONE/1.0D0/
CSP       DATA ZERO/0.0/,ONE/1.0/
C
      STAB=EPS.LE.ONE
      RMIN=EPS
      ISING=0
      IFLAG=0
C 170 = RETURN...
      IF (N.EQ.1) GO TO 170
      DO 10 I=1,N
   10 W(I)=ZERO
C SET UP POINTERS TO THE BEGINNING OF THE ROWS.
      IW(1)=IDISP(1)
      DO 20 I=2,N
   20 IW(I)=IW(I-1)+LENR(I-1)
C
C   ****   START  OF MAIN LOOP    ****
C AT STEP I, ROW I OF A IS TRANSFORMED TO ROW I OF L/U BY ADDING
C     APPROPRIATE MULTIPLES OF ROWS 1 TO I-1.
C     .... USING ROW-GAUSS ELIMINATION.
      DO 140 I=1,N
C ISTART IS BEGINNING OF ROW I OF A AND ROW I OF L.
      ISTART=IW(I)
C IFIN IS END OF ROW I OF A AND ROW I OF U.
      IFIN=ISTART+LENR(I)-1
C ILEND IS END OF ROW I OF L.
      ILEND=ISTART+LENRL(I)-1
      IF (ISTART.GT.ILEND) GO TO 70
C LOAD ROW I OF A INTO VECTOR W.
      DO 30 JJ=ISTART,IFIN
      J=ICN(JJ)
   30 W(J)=A(JJ)
C
C ADD MULTIPLES OF APPROPRIATE ROWS OF  I TO I-1  TO ROW I.
      DO 50 JJ=ISTART,ILEND
      J=ICN(JJ)
C IPIVJ IS POSITION OF PIVOT IN ROW J.
      IPIVJ=IW(J)+LENRL(J)
C FORM MULTIPLIER AU.
      AU=-W(J)/A(IPIVJ)
      W(J)=AU
C AU * ROW J (U PART) IS ADDED TO ROW I.
      IPIVJ=IPIVJ+1
      JFIN=IW(J)+LENR(J)-1
      IF (IPIVJ.GT.JFIN) GO TO 50
C INNERMOST LOOP.
      DO 40 JAYJAY=IPIVJ,JFIN
      JAY=ICN(JAYJAY)
   40 W(JAY)=W(JAY)+AU*A(JAYJAY)
C
   50 CONTINUE
C RELOAD W BACK INTO A (NOW L/U)
      DO 60 JJ=ISTART,IFIN
      J=ICN(JJ)
      A(JJ)=W(J)
   60 W(J)=ZERO
C WE NOW PERFORM THE STABILITY CHECKS.
   70 PIVPOS=ILEND+1
C MATRIX HAD NON-ZERO PIVOT IN MA30LA AT THIS STAGE.
      IF (PIVPOS.GT.IFIN) GO TO 150
      IF (A(PIVPOS).EQ.ZERO) GO TO 150
      IF (.NOT.STAB) GO TO 140
      ROWMAX=ZERO
      DO 130 JJ=PIVPOS,IFIN
  130 ROWMAX=DMAX1(ROWMAX,DABS(A(JJ)))
CSP   130 ROWMAX=AMAX1(ROWMAX,ABS(A(JJ)))
      IF (DABS(A(PIVPOS))/ROWMAX.GE.RMIN) GO TO 140
CSP       IF (ABS(A(PIVPOS))/ROWMAX.GE.RMIN) GO TO 140
      IFLAG=I
      RMIN=DABS(A(PIVPOS))/ROWMAX
CSP       RMIN=ABS(A(PIVPOS))/ROWMAX
C   ****    END OF MAIN LOOP    ****
  140 CONTINUE
C
      GO TO 170
C   ***   ERROR RETURN   ***
  150 IF (LP.NE.0) WRITE(LP,160) I
  160 FORMAT(53H ERROR RETURN FROM MA30LB SINGULARITY DETECTED IN ROW,
     1I8)
      IFLAG=-I
C
  170 RETURN
C
C  END MA30LB
C
      END
      SUBROUTINE MA30LC(N,ICN,A,LICN,LENR,LENRL,IDISP,IP,IQ,X,W)
C
C  PERFORMS FOR/BACKWARD SUBSTITUTION OF LINEAR SYSTEM
C
C
C DATE OF LATEST CHANGE: APRIL 27, '82
C
      DOUBLE PRECISION A(LICN),X(N),W(N),WII,WI,RESID,ZERO
CSP       REAL A(LICN),X(N),W(N)
      INTEGER IDISP(2)
      INTEGER ICN(LICN),LENR(N),LENRL(N),IP(N),IQ(N)
CI2       INTEGER*2 ICN(LICN),LENR(N),LENRL(N),IP(N),IQ(N)
C
      COMMON /MA30LH/ RESID
C
      DATA ZERO/0.0D0/
CSP       DATA ZERO/0.0/
C THE FINAL VALUE OF RESID IS THE MAXIMUM RESIDUAL FOR AN INCONSISTENT
C     SET OF EQUATIONS.
      RESID=ZERO
C
C WE NOW SOLVE   A * X = B.
C PREORDER VECTOR ... W(I) = X(IP(I))
      DO 10 II=1,N
   10 W(II)=X(IP(II))
C IBLOCK HOLDS THE POSITION OF THE FIRST NON-ZERO IN THE
C     LU DECOMPOSITION (OF THE DIAGONAL BLOCKS).
      IBLOCK=1
C     A PASS THROUGH THIS LOOP
C     PERFORMS FORWARD ELIMINATION USING ROW I OF THE LU
C     DECOMPOSITION.
      DO 120 I=1,N
      IF (LENRL(I).EQ.0) GO TO 50
      WI=W(I)
C FORWARD ELIMINATION PHASE.
C IEND IS THE END OF THE L PART OF ROW I IN THE LU DECOMPOSITION.
      IEND=IBLOCK+LENRL(I)-1
      DO 40 JJ=IBLOCK,IEND
      J=ICN(JJ)
   40 WI=WI+A(JJ)*W(J)
      W(I)=WI
C IBLOCK IS ADJUSTED TO POINT TO THE START OF THE NEXT ROW.
   50 IBLOCK=IBLOCK+LENR(I)
 120  CONTINUE
C BACK SUBSTITUTION PHASE.
C J1 IS POSITION IN A/ICN AFTER END OF A
      J1=IBLOCK
C EACH PASS THROUGH THIS LOOP PERFORMS THE BACK-SUBSTITUTION
C     OPERATIONS FOR A SINGLE ROW,
C     WORKING THROUGH A IN REVERSE ORDER.
      DO 100 III=1,N
      II=N-III+1
C J2 IS END OF ROW II.
      J2=J1-1
C J1 IS BEGINNING OF ROW II.
      J1=J1-LENR(II)
C JPIV IS THE POSITION OF THE PIVOT IN ROW II.
      JPIV=J1+LENRL(II)
      JPIVP1=JPIV+1
C IF ROW  II OF U HAS NO NON-ZEROS GO TO 90.
      IF (J2.LT.JPIVP1) GO TO 90
      WII=W(II)
      DO 80 JJ=JPIVP1,J2
      J=ICN(JJ)
   80 WII=WII-A(JJ)*W(J)
      W(II)=WII
   90 W(II)=W(II)/A(JPIV)
  100 CONTINUE
C
C REORDER SOLUTION VECTOR ... X(I) = W(IQINVERSE(I))
      DO 130 II=1,N
      I=IQ(II)
  130 X(I)=W(II)
      RETURN
C
C  END MA30LC
C
      END
      SUBROUTINE MA30LM (N,NP1,NZLU,ICN,IA,JA,NZ,IMAP,LENR,IP,IQ,IW)
C
C  THIS ROUTINE GENERATES A MAPPING FROM THE ORIGINAL MATRIX TO THE
C  FACTORS
C
C
C DATE OF LATEST CHANGE: APRIL 27, '82
C
C
C FOR HANLING OF MORE THAN 32000 NONZEROS WITH INTEGER*2 VERSION CHANGE
C ARRAY IW TO STANDARD INTEGER
C
      INTEGER IW(N),IQ(N)
CI2       INTEGER*2 IW(N),IQ(N)
      INTEGER ICN(NZLU),IA(NP1),JA(NZ),IMAP(NZ),LENR(N),IP(N)
CI2       INTEGER*2 ICN(NZLU),IA(NP1),JA(NZ),IMAP(NZ),LENR(N),IP(N)
      J1=1
      DO 100 INEW=1,N
      J2=J1+LENR(INEW)-1
      DO 30 JJ=J1,J2
      JNEW=ICN(JJ)
      JOLD=IQ(JNEW)
30    IW(JOLD)=JJ
      IOLD=IP(INEW)
      JAY1=IA(IOLD)
      JAY2=IA(IOLD+1)-1
      DO 40 JJ=JAY1,JAY2
      J=JA(JJ)
      IMAP(JJ)=IW(J)
40    CONTINUE
      J1=J2+1
100   CONTINUE
      RETURN
C
C  END MA30LM
C
      END
